\name{catheter}
\title{Meta-analysis of antibacterial catheter coating }
\usage{data(catheter)}
\alias{catheter}
\description{Data on the effectiveness of silver sulfadiazine coating on
  venous catheters for preventing bacterial colonisation of the catheter
  and bloodstream infection}
\source{Veenstra D et al (1998) "Efficacy of Antiseptic Impregnated
Central Venous Catheters in Preventing Nosocomial Infections: A
Meta-analysis" JAMA 281:261-267}
\format{A data.frame with 8 variables giving information about 16
  controlled trials of antibacterial-coated venous catheters
  \tabular{rl}{
    Name      :  \tab Name of principal author\cr
    n.trt     :  \tab number of coated catheters\cr
    n.ctrl    : \tab number of standard catheters\cr
    col.trt   : \tab number of coated catheters colonised\cr
    \tab by bacteria\cr
    col.ctrl  :\tab number of standard catheters colonised\cr
    \tab by bacteria\cr
    inf.trt   : \tab number of coated catheters resulting in \cr
    \tab bloodstream infection\cr
    inf.ctrl  :\tab number of standard catheters resulting in\cr
    \tab bloodstream infection\cr
    or       :\tab Odds ratio\cr
  }
}
\examples{
library(rmeta)
data(catheter)
a <- meta.MH(n.trt, n.ctrl, col.trt, col.ctrl, data=catheter,
             names=Name, subset=c(13,6,5,3,7,12,4,11,1,8,10,2))
b <- meta.DSL(n.trt, n.ctrl, col.trt, col.ctrl, data=catheter,
              names=Name,subset=c(13,6,5,3,7,12,4,11,1,8,10,2))
a
b
summary(a)
summary(b)
plot(a)
plot(b)
}
\keyword{datasets}

\eof
\name{cochrane}
\alias{cochrane}
\non_function{}
\title{Data for Cochrane Collaboration logo }
\usage{data(cochrane)}
\description{
Data from randomised trials before 1980 of corticosteroid therapy in premature
labour and its effect on neonatal death. 
}
\format{
This data frame contains the following columns:
\describe{
\item{name}{Identifier for the study
}
\item{ev.trt}{
Number of deaths in the treated group
}
\item{n.trt}{
Number in the treated group
}
\item{ev.ctrl}{
Number of deaths in the control group
}
\item{n.ctrl}{
Number in the control group
}
}
}
\details{
This meta-analysis, if done, would likely have resulted in the treatment being
widely used a decade earlier than it was, saving many lives. The graph
is part of the logo of the Cochrane Collaboration, a group aiming to
perform systematic reviews of the entire clinical trial literature.
} \source{
\url{http://www.cochrane.org}
}
\examples{
data(cochrane)
steroid <- meta.MH(n.trt, n.ctrl, ev.trt, ev.ctrl,
                   names=name, data=cochrane)
plot(steroid, col=meta.colors("RoyalBlue"))
}
\keyword{datasets}

\eof
\name{funnelplot}
\alias{funnelplot}
\alias{funnelplot.meta.MH}
\alias{funnelplot.meta.DSL}
\alias{funnelplot.meta.summaries}
\alias{funnelplot.default}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Funnel plot for publication bias}
\description{
  Plots the treatment difference for trials against the size of the
  trial (or other specified variable).  Asymmetry in the plot often
  indicates publication bias.  Generic, with methods for meta-analysis
  objects.
}
\usage{
funnelplot(x,\dots)
funnelplot.default(x, se, size=1/se, summ=NULL,
        xlab="Effect", ylab="Size", colors=meta.colors(),
        conf.level=0.95, plot.conf=FALSE,
        zero=NULL, mirror=FALSE, \dots)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{Treatment difference}
  \item{se}{Standard error of \code{x}}
  \item{size}{Variable for the vertical axis}
  \item{summ}{summary treatment difference}
  \item{xlab}{x-axis label }
  \item{ylab}{y-axis label}
  \item{colors}{list of colors for components of the plot}
  \item{conf.level}{For confidence interval plotting }
  \item{plot.conf}{Plot confidence intervals instead of just points?}
  \item{zero}{location of a null hypothesis line}
  \item{mirror}{Add points reflected around \code{summ}?}
  \item{\dots}{further arguments to be passed from or to methods.}
}
\details{
  With the default value of \code{size} the plot should appear as a
  upwards-pointing funnel shape.  Publication bias often causes one side
  of the funnel to be trimmed near the base.  The \code{mirror} plot
  creates a symmetric funnel by reflecting the plot around the
  \code{summ} value.  In the presence of publication bias the added
  points will separate from the real studies.  
}
\value{
  Used for its side-effect.
}
\author{Thomas Lumley}

\seealso{
  \code{\link{meta.DSL}},
  \code{\link{meta.MH}},
  \code{\link{meta.summaries}},
  \code{\link{metaplot}}
}
\examples{
data(catheter)
a <- meta.MH(n.trt, n.ctrl, col.trt, col.ctrl, data=catheter,
             names=Name, subset=c(13,6,5,3,7,12,4,11,1,8,10,2))
funnelplot(a$logOR, a$selogOR)
funnelplot(a$logOR, a$selogOR,
           plot.conf=TRUE, summ=a$logMH, mirror=TRUE)
funnelplot(a, plot.conf=TRUE)
}
\keyword{hplot}

\eof
\name{meta.DSL}
\title{Random effects (DerSimonian-Laird) meta-analysis}
\usage{
meta.DSL(ntrt, nctrl, ptrt, pctrl, conf.level=0.95,
         names=NULL, data=NULL, subset=NULL, na.action=na.fail,statistic="OR")
\method{summary}{meta.DSL}(object, conf.level=NULL, \dots)
\method{plot}{meta.DSL}(x, summary=TRUE, summlabel="Summary",
             conf.level=NULL, colors=meta.colors(), xlab=NULL,\dots)
}
\alias{meta.DSL}
\alias{summary.meta.DSL}
\alias{print.meta.DSL}
\alias{print.summary.meta.DSL}
\alias{plot.meta.DSL}
%- Also NEED an `\alias' for EACH other function documented here.
\arguments{
 \item{ntrt}{Number of subjects in treated/exposed group}
 \item{nctrl}{Number of subjects in control group }
 \item{ptrt}{Number of events in treated/exposed group}
 \item{pctrl}{Number of events in control group}
 \item{conf.level}{Coverage for confidence intervals}
 \item{names}{names or labels for studies}
 \item{data}{data frame to interpret variables}
 \item{subset}{subset of studies to include}
 \item{na.action}{a function which indicates what should happen when
   the data contain \code{NA}s.  Defaults to \code{\link{na.fail}}.}
 \item{statistic}{"OR" for odds ratio, "RR" for relative risk}
 \item{x,object}{a \code{meta.DSL} object}
 \item{summary}{Plot the summary odds ratio?}
 \item{summlabel}{Label for the summary odds ratio}
 \item{colors}{see \code{\link{meta.colors}}}
 \item{xlab}{x-axis label, default is based on \code{statistic}}
 \item{\dots}{further arguments to be passed from or to methods.}
}
\description{
Computes the individual odds ratios or relative risks, the summary, the random
effects variance, and Woolf's test for heterogeneity. The \code{print}
method gives the summary and test for heterogeneity; the \code{summary}
method also gives all the individual odds ratios and confidence
intervals. Studies with zero or infinite odds ratio are omitted, as
their variance cannot be calculated sensibly.

The \code{plot} method draws a standard meta-analysis plot. The
confidence interval for each study is given by a horizontal line, and
the point estimate is given by a square whose height is inversely
proportional to the standard error of the estimate.  The summary odds
ratio, if requested, is drawn as a diamond with horizontal limits at the
confidence limits and width inversely proportional to its standard
error.
}
\value{
  An object of class \code{meta.DSL} with \code{print}, \code{plot}, \code{funnelplot} and
  \code{summary} methods.
}
\author{Thomas Lumley}

\seealso{\code{\link{plot}},\code{\link{par}},\code{\link{meta.MH}},\code{\link{funnelplot}} }

\examples{
data(catheter)
b <- meta.DSL(n.trt, n.ctrl, col.trt, col.ctrl, data=catheter,
              names=Name, subset=c(13,6,5,3,7,12,4,11,1,8,10,2))
b
summary(b)
plot(b)
e <- meta.DSL(n.trt, n.ctrl, inf.trt, inf.ctrl, data=catheter,
              names=Name, subset=c(13,6,3,12,4,11,1,14,8,10,2))
e
summary(e)
##tasteless
plot(e, colors=meta.colors(summary="green",lines="purple",box="orange"))
}
\keyword{htest}
\keyword{hplot}

\eof
\name{meta.MH}
\title{Fixed effects (Mantel-Haenszel) meta-analysis}
\usage{
meta.MH(ntrt, nctrl, ptrt, pctrl, conf.level=0.95,
        names=NULL, data=NULL, subset=NULL, na.action = na.fail,statistic="OR")
\method{summary}{meta.MH}(object, conf.level=NULL, \dots)
\method{plot}{meta.MH}(x, summary=TRUE, summlabel="Summary",
             conf.level=NULL, colors=meta.colors(),xlab=NULL, \dots)
}
\alias{meta.MH}
\alias{summary.meta.MH}
\alias{print.meta.MH}
\alias{print.summary.meta.MH}
\alias{plot.meta.MH}
%- Also NEED an `\alias' for EACH other function documented here.
\arguments{
  \item{ntrt}{Number of subjects in treated/exposed group}
  \item{nctrl}{Number of subjects in control group }
  \item{ptrt}{Number of events in treated/exposed group}
  \item{pctrl}{Number of events in control group}
  \item{names}{names or labels for studies}
  \item{data}{data frame to interpret variables}
  \item{subset}{subset of studies to include}
  \item{na.action}{a function which indicates what should happen when
    the data contain \code{NA}s.  Defaults to \code{\link{na.fail}}.}
  \item{statistic}{"OR" for odds ratio, "RR" for relative risk}
  \item{x,object}{a \code{meta.MH} object}
  \item{summary}{Plot the summary odds ratio?}
  \item{summlabel}{Label for the summary odds ratio}
  \item{conf.level}{Coverage for confidence intervals}
  \item{colors}{see \code{\link{meta.colors}}}
 \item{xlab}{x-axis label, default is based on \code{statistic}}
  \item{\dots}{further arguments to be passed to or from methods.}
}

\description{
  Computes the individual odds ratio or relative risk, the
  Mantel-Haenszel summary, and Woolf's test for heterogeneity. The
  \code{print} method gives the summary and test for heterogeneity; the
  \code{summary} method also gives all the individual odds ratios and
  confidence intervals.

The \code{plot} method draws a standard meta-analysis plot. The
confidence interval for each study is given by a horizontal line, and
the point estimate is given by a square whose height is inversely
proportional to the standard error of the estimate.  The summary odds
ratio, if requested, is drawn as a diamond with horizontal limits at the
confidence limits and width inversely proportional to its standard
error.
}
\value{
  An object of class \code{meta.MH} with \code{print}, \code{plot}, \code{funnelplot} and
  \code{summary} methods.
}
\references{}
\author{Thomas Lumley}
\note{ There are at least two other ways to do a fixed effects
  meta-analysis of binary data. Peto's method is a computationally
  simpler approximation to the Mantel-Haenszel approach. It is also
  possible to weight the individual odds ratios according to their
  estimated variances.  The Mantel-Haenszel method is superior if there
  are trials with small numbers of events (less than 5 or so in either group)}

\seealso{\code{\link{plot}},\code{\link{par}},\code{\link{meta.DSL}},\code{\link{funnelplot}} }

\examples{
data(catheter)
a <- meta.MH(n.trt, n.ctrl, col.trt, col.ctrl, data=catheter,
             names=Name, subset=c(13,6,5,3,7,12,4,11,1,8,10,2))
a
summary(a)
plot(a)
d <- meta.MH(n.trt, n.ctrl, inf.trt, inf.ctrl, data=catheter,
             names=Name, subset=c(13,6,3,12,4,11,1,14,8,10,2))
d
summary(d)
## plot with par("fg")
plot(d, colors=meta.colors(NULL))
}
\keyword{htest}
\keyword{hplot}

\eof
\name{meta.colors}
\alias{meta.colors}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Control colours in meta-analysis plot}
\description{
 Wrapper function for specifying colours to meta-analysis plots
}
\usage{
meta.colors(all.elements, box="black", lines="gray", summary="black",
            zero="lightgray", mirror="lightblue", text="black",
             axes="black",background=NA)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{all.elements}{if present, overrides other arguments}
  \item{box}{Colour of sample size box }
  \item{lines}{Colour of confidence intervals }
  \item{summary}{Colour of summary estimate}
  \item{zero}{Colour of null hypothesis line}
  \item{mirror}{Colour of reflected points (in \code{\link{funnelplot}})
  }
  \item{text}{Colour of labels}
  \item{axes}{Colour of x-axis and axis labels}
  \item{background}{Background colour.}
}

\value{
 a list of colors
}

\seealso{\code{\link{plot.meta.MH}},\code{\link{plot.meta.DSL}},\code{\link{plot.meta.summaries}},\code{\link{funnelplot}},\code{\link{metaplot}}}

\examples{
data(cochrane)
steroid <- meta.MH(n.trt, n.ctrl, ev.trt, ev.ctrl,
                   names=name, data=cochrane)

## All black, for better photocopying
plot(steroid, col=meta.colors("black"))

## distinguish the summary 
plot(steroid,colors=meta.colors(summary="forestgreen"))

data(catheter)
e <- meta.DSL(n.trt, n.ctrl, inf.trt, inf.ctrl, data=catheter,
              names=Name, subset=c(13,6,3,12,4,11,1,14,8,10,2))

## Truly awful colour scheme to illustrate flexibility
plot(e, colors=meta.colors(summary="green",lines=c("purple","skyblue"),
       box="red",zero="yellow",text=palette(),background="tomato",
       axes="lightgreen"))

## Dark blue background popular for presentations.
plot(e, colors=meta.colors(summary="white",lines="#FFFFF0",
        box="#FFFF50",zero="grey90",text="white",background="darkblue",
        axes="grey90"))}
\keyword{hplot}

\eof
\name{cummeta}
\alias{cummeta}
\alias{cummeta.summaries}
\alias{print.meta.cum}
\alias{plot.meta.cum}
\alias{print.summary.meta.cum}
\alias{summary.meta.cum}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Cumulative meta-analysis of binary data}
\description{
A cumulative meta-analysis plot shows how evidence has accumulated over
time.  The \code{i}th line in the cumulative meta-analysis plot is the
summary produced by a meta-analysis of the first \code{i} trials.
}
\usage{
cummeta(ntrt, nctrl, ptrt, pctrl, conf.level = 0.95, names = NULL, data=
NULL,  subset = NULL, na.action = na.fail, method = c("meta.MH", "meta.DSL"), statistic = "OR")
cummeta.summaries(effects,stderrs, conf.level = 0.95, names = NULL,weights=NULL, data= NULL, subset = NULL, na.action = get(getOption("na.action")), method = c("fixed", "random"), logscale=TRUE)
\method{plot}{meta.cum}(x, conf.level = NULL, colors = meta.colors(), xlab = NULL, 
    summary.line = TRUE, summary.conf = FALSE, main="Cumulative meta-analysis", lwd=1, ...)
\method{summary}{meta.cum}(object ,conf.level=NULL,...)
}
%- maybe also `usage' for other objects documented here.
\arguments{
 \item{ntrt}{Number of subjects in treated/exposed group}
 \item{nctrl}{Number of subjects in control group }
 \item{ptrt}{Number of events in treated/exposed group}
 \item{pctrl}{Number of events in control group}
 \item{effects}{Difference between control and treatment group}
 \item{stderrs}{Standard errors of \code{effects}}
 \item{weights}{Study weights (see \code{\link{meta.summaries}})}
 \item{names}{names or labels for studies} 
 \item{data}{data frame to interpret variables}
 \item{subset}{subset of studies to include}
 \item{na.action}{How to handle missing values}
  \item{method}{Which meta-analysis method to use}
  \item{statistic}{"OR" for odds ratio or "RR" for relative risk. }
  \item{logscale}{The \code{effects} values are the logarithms of actual
    effects (for plotting)}
  \item{x, object}{a \code{meta.cum} object}
  \item{\dots}{other graphical arguments for \code{\link{metaplot}}}
  \item{conf.level}{Coverage for confidence intervals}
  \item{colors}{see \code{\link{meta.colors}}}
  \item{xlab}{X-axis label}
  \item{summary.line}{Plot a vertical line at the final summary value?}
  \item{summary.conf}{Plot vertical lines at the final confidence
    interval limits?}
  \item{main,lwd}{graphical parameters}
}


\value{
  Object of class \code{meta.cum}.
}
\seealso{\code{\link{meta.MH}},\code{\link{meta.DSL}}}
\examples{
data(cochrane)
steroid<-cummeta(n.trt,n.ctrl,ev.trt,ev.ctrl,names=name,data=cochrane,statistic="RR",method="meta.MH")
plot(steroid)
summary(steroid)
data(catheter)
b <- meta.DSL(n.trt, n.ctrl, col.trt, col.ctrl, data=catheter,
              names=Name, subset=c(13,6,5,3,12,4,11,1,8,10,2))
d <- cummeta.summaries(b$logs, b$selogs, names=b$names,
                    method="random", logscale=TRUE)
plot(d,summary.conf=TRUE)
summary(d)
}
\keyword{htest}% at least one, from doc/KEYWORDS
\keyword{hplot}% __ONLY ONE__ keyword per line

\eof
\name{meta.summaries}
\title{Meta-analysis based on effect estimates}
\alias{meta.summaries}
\alias{print.meta.summaries}
\alias{plot.meta.summaries}
\alias{summary.meta.summaries}
\alias{print.summary.meta.summaries}
\description{
  Computes a summary estimate and confidence interval from a collection
  of treatment effect estimates and standard errors.  Allows fixed or 
  random effects, optional quality weights.
}
\usage{
meta.summaries(d, se, method=c("fixed", "random"), weights=NULL,
               logscale=FALSE, names=NULL, data=NULL,
               conf.level=0.95, subset=NULL,na.action=na.fail)
\method{summary}{meta.summaries}(object,conf.level=NULL,\dots)
\method{plot}{meta.summaries}(x,summary=TRUE,summlabel="Summary",
                    conf.level=NULL,colors=meta.colors(),
                    xlab=NULL,logscale=NULL,\dots)
}
\arguments{
  \item{d}{Effect estimates}
  \item{se}{standard errors for \code{d}}
  \item{method}{Standard errors and default weights from fixed or
    random-effects? }
  \item{weights}{Optional weights (eg quality weights)}
  \item{logscale}{Effect is on a log scale? (for plotting) }
  \item{names}{labels for the separate studies }
  \item{data}{optional data frame to find variables in}
  \item{conf.level}{level for confidence intervals }
  \item{subset}{Which studies to use}
  \item{na.action}{a function which indicates what should happen when
    the data contain \code{NA}s.  Defaults to \code{\link{na.fail}}.}
  \item{x,object}{a \code{meta.summaries} object}
  \item{summary}{Plot the summary odds ratio?}
  \item{summlabel}{Label for the summary odds ratio}
  \item{colors}{see \code{\link{meta.colors}}}
  \item{xlab}{label for the effect estimate axis.}
  \item{\dots}{further arguments to be passed to or from methods.}
}
\details{
  The summary estimate is a weighted average. If \code{weights} are
  specified they are used, otherwise the reciprocal of the estimated
  variance is used.

  The estimated variance is the square of \code{se} for a \code{fixed}
  analysis. For a random analysis a heterogeneity variance is estimated
  and added.

  The variance of a weighted average is a weighted average of the
  estimated variances using the squares of the weights. This is the
  square of  the summary standard error.

  With the default weights these are the standard fixed and random
  effects calculations.
}

\value{
  An object of class \code{meta.summaries}, which has
  \code{print},\code{plot},\code{summary} and \code{\link{funnelplot}}
  methods.
}
\author{Thomas Lumley}

\seealso{
  \code{\link{meta.DSL}},
  \code{\link{meta.MH}},
  \code{\link{funnelplot}},
  \code{\link{metaplot}}
}

\examples{
data(catheter)
b <- meta.DSL(n.trt, n.ctrl, col.trt, col.ctrl, data=catheter,
              names=Name, subset=c(13,6,5,3,12,4,11,1,8,10,2))
d <- meta.summaries(b$logs, b$selogs, names=b$names,
                    method="random", logscale=TRUE)
}
\keyword{htest}
\keyword{hplot}

\eof
\name{metaplot}
\alias{metaplot}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Meta-analysis plot (forest plot)}
\description{
  Plot confidence intervals with boxes indicating the sample
  size/precision and optionally a diamond indicating a summary
  confidence interval. This function is usually called by \code{plot}
  methods for meta-analysis objects.
}
\usage{
metaplot(mn, se, nn=NULL, labels=NULL, conf.level=0.95,
         xlab="Odds ratio", ylab="Study Reference",xlim=NULL,
         summn=NULL, sumse=NULL, sumnn=NULL, summlabel="Summary",
         logeffect=FALSE, lwd=2, boxsize=1,
         zero=as.numeric(logeffect), colors=meta.colors(),
         xaxt="s", logticks=TRUE,  ...)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{mn}{point estimates from studies}
  \item{se}{standard errors of \code{mn}}
  \item{nn}{precision: box ares is proportional to this. \code{1/se^2}
    is the default}
  \item{labels}{labels for each interval}
  \item{conf.level}{Confidence level for confidence intervals}
  \item{xlab}{label for the point estimate axis}
  \item{ylab}{label for the axis indexing the different studies}
  \item{xlim}{the range for the x axis.}
  \item{summn}{summary estimate}
  \item{sumse}{standard error of summary estimate}
  \item{sumnn}{precision of summary estimate}
  \item{summlabel}{label for summary estimate }
  \item{logeffect}{\code{TRUE} to display on a log scale }
  \item{lwd}{line width}
  \item{boxsize}{Scale factor for box size}
  \item{zero}{"Null" effect value}
  \item{xaxt}{use \code{"n"} for no x-axis (to add a customised one)}
  \item{logticks}{if \code{TRUE} and \code{logscale}, have tick values
    approximately equally spaced on a log scale}.
  \item{colors}{see \code{\link{meta.colors}}}
  \item{\dots}{Other graphical parameters }
}

\value{
  This function is used for its side-effect.
}

\seealso{
  \code{\link{plot.meta.DSL}},
  \code{\link{plot.meta.MH}},
  \code{\link{plot.meta.summaries}}
}

\examples{
data(catheter)
a <- meta.MH(n.trt, n.ctrl, col.trt, col.ctrl, data=catheter,
             names=Name, subset=c(13,6,5,3,7,12,4,11,1,8,10,2))
metaplot(a$logOR, a$selogOR, nn=a$selogOR^-2, a$names,
         summn=a$logMH, sumse=a$selogMH, sumnn=a$selogMH^-2,
         logeffect=TRUE)
metaplot(a$logOR, a$selogOR, nn=a$selogOR^-2, a$names,
         summn=a$logMH, sumse=a$selogMH, sumnn=a$selogMH^-2,
         logeffect=TRUE,logticks=FALSE)
## angry fruit salad
metaplot(a$logOR, a$selogOR, nn=a$selogOR^-2, a$names,
         summn=a$logMH, sumse=a$selogMH, sumnn=a$selogMH^-2,
         logeffect=TRUE, colors=meta.colors(box="magenta",
             lines="blue", zero="red", summary="orange",
             text="forestgreen"))
}
\keyword{hplot}


\eof
