### Name: weightsAndrews
### Title: Kernel-based HAC Covariance Matrix Estimation
### Aliases: weightsAndrews bwAndrews kernHAC
### Keywords: regression ts

### ** Examples

curve(kweights(x, kernel = "Quadratic", normalize = TRUE),
      from = 0, to = 3.2, xlab = "x", ylab = "k(x)")
curve(kweights(x, kernel = "Bartlett", normalize = TRUE),
      from = 0, to = 3.2, col = 2, add = TRUE)
curve(kweights(x, kernel = "Parzen", normalize = TRUE),
      from = 0, to = 3.2, col = 3, add = TRUE)
curve(kweights(x, kernel = "Tukey", normalize = TRUE),
      from = 0, to = 3.2, col = 4, add = TRUE)
curve(kweights(x, kernel = "Truncated", normalize = TRUE),
      from = 0, to = 3.2, col = 5, add = TRUE)

x <- sin(1:100)
y <- 1 + x + rnorm(100)
fm <- lm(y ~ x)
kernHAC(fm)
vcov(fm)



