% choose parents

\name{chooseparents}

\alias{chooseparents}

\title{
  Choose parent generations
}

\description{
  Choose the best individuals (set-ups) of the given generations
  (batches) as possible parents. Parent selection is generally the next
  step. 
}

\usage{
  chooseparents(struc.ea, n.ind=NULL, gen.parent=NULL)
}

\arguments{
  \item{struc.ea}{An evolutionary algorithm structure}
  \item{n.ind}{Number of individuals (set-ups) present in the new
    generation (batch); this is equal to the number of parents chosen in
    this function. If this argument is not given, the average of the
    number of individuals (set-ups) in the chosen parent generations
    (batches) is taken as default.}
  \item{gen.parent}{A vector containing the numbers of the parent
    generations (batches). As default, the function includes all
    previous calculated generations (batches) for choosing the parents
    of the next generation (batch).} 
}

\value{
  The function returns an evolutionary algorithm object, which is
  actually the same as the input argument \code{struc.ea}, but with one
  generation (batch) added, i.e. the chosen parents:
  \item{genes}{a list containing the genome (parameter set)
    stucture. This is the same as the genome (parameter set) structure
    of in the input (\code{struc.ea$genes}).}
  \item{generations}{a list of structures with information of each
    generation: 
    \describe{
      \item{fit:}{a vector containing the fitnesses of all individuals
	(experimental set-ups) of the generation (batch); this are just
	copies of the fitnesses of the chosen parents.}
      \item{allele:}{a matrix containing the allele-values of all
	individuals (experimental set-ups) of the generation (batch);
	this are just copies of the alleles (parameter values) of the
	chosen parents.} 
      \item{parents:}{a string vector with the numbers of the parent
	generations.}
  }}
}

\note{
  As for all functions in this package, evolutionary terminology is used
  as described in \code{\link{seao.terminology}}. 
}

\references{
}

\author{
  Kurt Sys (\email{kurt.sys@rug.ac.be})
}

\seealso{
  \link{genomestruc}, \link{newgen}, \link{selectparents}

  \link{seao.terminology}
}

\keyword{
  parent
}

\examples{
}
\eof
% crossover

\name{crossover}

\alias{crossover}

\title{
  Perform crossover
}

\description{
  The parameter values are recombined to make new batches. The rate can
  be set, as well as the generation on which this recombination should happen.}
}

\usage{
  crossover(struc.ea, gen=NULL, rate=90)
}

\arguments{
  \item{struc.ea}{An evolutionary algorithm structure}
  \item{gen}{The number of the generation (batch) for which the parents
    have to be chosen. The standard value is the last generation.}
  \item{rate}{The parameter value recombination rate, i.e. the
    percentage individuals which should be recombined.}
}

\details{
}

\value{
  The function returns an evolutionary algorithm object, which is
  actually the same as the input argument \code{struc.ea}, but in which
  the a generation is transformed:
  \item{genes}{a list containing the genome (parameter set)
    stucture. This is the same as the genome (parameter set) structure
    of in the input (\code{struc.ea$genes}).}
  \item{generations}{a list of structures with information of each
    generation: 
    \describe{
      \item{fit:}{a vector containing the fitnesses of all
	individuals. These values are all set to NA, since the fitnesses
	of the new individuals are not known yet.}
      \item{allele:}{a matrix containing the allele-values of all
	individuals (experimental set-ups) of the generation (batch);
	these values are recombined paramter values.} 
      \item{parents:}{a string vector with the numbers of the parent
	generations.}
      \item{selection:}{a list containing the selection base and
	rescaling.}
      \item{crossover:}{the crossover rate; this value is added.}
	
  }}
}

\note{
  As for all functions in this package, evolutionary terminology is used
  as described in \code{\link{seao.terminology}}. 
}

\author{
  Kurt Sys (\email{kurt.sys@rug.ac.be})
}

\seealso{
  \link{genomestruc}, \link{newgen}, \link{chooseparents}, \link{selectparents}
}

\keyword{
  child
  crossover
}

\examples{
}
\eof
% genomestructure

\name{genomestruc}

\alias{genomestruc}

\title{
  Genome structure definition
}

\description{
  Defines the experiment genome (or parameter set) structure.
}

\usage{
  genomestruc(n.genes=NULL)
}

\arguments{
  \item{n.genes}{The number of genes (parameters) of each individual
  (experimental set-up). The number of genes (parameters) will be asked
  if no argument is given.}
}

\value{
  A structure which is the first part of an evolutionary algorithm
  structure.
  \item{genes}{An list of genes (parameters); each gene (parameter)
    itself is a list of: 
    \describe{
      \item{name:}{the name of the gene (parameter)}
      \item{min:}{the minimal value that the gene (parameter) can have}
      \item{max:}{the maximum value that the gene (parameter) can have}
      \item{n.alleles:}{the number of the alleles (parameter values) the
	gene (parameter) can have} 
      \item{names:}{a vector containing the names of all the different
      alleles (parameter values); this is optional and set to NULL if the
      number of names given is not equal to the number of alleles
      (parameter values)}  
    }
  }
  \item{generations}{The second part of an evolutionary algorithm
    structure which contains a list of generations (fitnesses, allele
    values etc); the value is initially NULL.}
}

\note{
  \code{genomestruc} is the actual genome (parameter set) definition
  function. However, if package \code{seao.gui} is also loaded, a graphical
  interface can be called by \code{genomestruc.gui}. The return value of
  both functions is exactly the same, since the former is called by the
  latter.
}

\references{
}

\author{
  Kurt Sys (\email{kurt.sys@rug.ac.be})
}

\seealso{
  \link{newgen}
}

\keyword{
  gene, parameter,
  genome, parameter set,
  genome structure, parameter set structure
}

\examples{
}
\eof
% mutation

\name{mutation}

\alias{mutation}

\title{
  Perform mutation
}

\description{
  Ad random parameter values are selected and changed, giving a uniform
  or normal probability distribution.
}

\usage{
  mutation(struc.ea, gen=NULL, method=list(base="unif", spread=1, rate=15))
}

\arguments{
  \item{struc.ea}{An evolutionary algorithm structure}
  \item{gen}{The number of the generation (batch) for which the parents
    have to be chosen. The standard value is the last generation.}
  \item{method}{Some evolutionary parameters to set. This contains
    whether a uniform ('unif') or normal ('norm') distribution should be
    used, whether the spread value (if this is set to 0, a value of 1 is
    used), and to set the paramater value randomization rate.}
}

\details{
}

\value{
  The function returns an evolutionary algorithm object, which is
  actually the same as the input argument \code{struc.ea}, but in which
  the a generation is transformed:
  \item{genes}{a list containing the genome (parameter set)
    stucture. This is the same as the genome (parameter set) structure
    of in the input (\code{struc.ea$genes}).}
  \item{generations}{a list of structures with information of each
    generation: 
    \describe{
      \item{fit:}{a vector containing the fitnesses of all
	individuals. These values are all set to NA, since the fitnesses
	of the new individuals are not known yet.}
      \item{allele:}{a matrix containing the allele-values of all
	individuals (experimental set-ups) of the generation (batch);
	a portion of these values are randomized paramater values.} 
      \item{parents:}{a string vector with the numbers of the parent
	generations.}
      \item{selection:}{a list containing the selection base and
	rescaling.}
      \item{crossover:}{the crossover rate.}
      \item{mutation:}{a list containing the mutation parameters. This
	value is added.}
	
  }}
}

\note{
  As for all functions in this package, evolutionary terminology is used
  as described in \code{\link{seao.terminology}}. 
}

\author{
  Kurt Sys (\email{kurt.sys@rug.ac.be})
}

\seealso{
  \link{genomestruc}, \link{newgen}, \link{chooseparents},
  \link{selectparents}, \link{crossover}
}

\keyword{
  child
  mutation
}

\examples{
}
\eof
% new generation

\name{newgen}

\alias{newgen}

\title{
  New generation
}

\description{
  Generates a new (random) generation of individuals (experiments) using an
  already defined genomestructure.
}

\usage{
  newgen(struc.ea, n.ind=25, method="random")
}

\arguments{
  \item{struc.ea}{An evolutionary algorithm structure. It must contain
    at least \code{$genes}, which is a list describing the structure of
    the genome (parameter set).}
  \item{n.ind}{The number of individuals one wants to generate. Default
    value is set to 25.}
  \item{method}{This describes the method that must be used the make a
    (random) generation (batch). There are two possibilities,
    i.e. \code{random}, for pure random allele (parameter value)
    generation and \code{maxgenediv}, in which case the diversity per
    gene is maximised. The default value is "random".} 
}

\value{
  The function returns an evolutionary algorithm object:
  \item{genes}{a list containing the genome (parameter set)
    stucture. This is the same as the genome (parameter set) structure
    of in the input (\code{struc.ea$genes}).}
  \item{generations}{a list of structures with information of each
    generation (batch): 
    \describe{
      \item{fit:}{a vector containing the fitnesses of all individuals
	(experimental set-ups).}
      \item{allele:}{a matrix containing the alleles (parameter values of
	all individuals (experimental set-ups).} 
      \item{parents:}{a string vector with the numbers of the parent
	generations (batches). For this function, this is set to a vector with
	values "-1" and the method used ("random" or "maxgenediv")}
  }}
}

\note{
  \code{newgen} is the actual function that calculates the (random)
  alleles of a  new generation. However, if package \code{seao.gui} is
  also loaded, a graphical interface can be called by
  \code{newgen.gui}. The return value of both functions is exactly the
  same, since the former is called by the latter. 

  As for all functions in this package, evolutionary terminology is used
  as described in \code{\link{seao.terminology}}..
}

\references{
}

\author{
  Kurt Sys (\email{kurt.sys@rug.ac.be})
}

\seealso{
  \link{genomestruc}
}

\keyword{
  initial generation
  new generation
}

\examples{
}
\eof
% next generation

\name{nextgen}

\alias{nextgen}

\title{
  Next generation
}

\description{
  Calculates a next generation, i.e. chooses and selects parents and
  performs crossover and mutation.
}

\usage{
  nextgen(struc.ea,
          n.ind=NULL,
          gen.parent=NULL,
          selection=list(base="fit", rescale=0),
          corate=90,
          mutation=list(base="unif", spread=1, rate=15))
}

\arguments{
  \item{struc.ea}{An evolutionary algorithm structure. It must contain
    at least \code{$genes}, which is a list describing the structure of
    the genome (parameter set).}
  \item{n.ind}{The number of individuals one wants to generate. Default
    value is set to 25.}
  \item{gen.parent}{A vector containing the numbers of the parent generations
    (batches). As default, the function includes all previous
    calculated generations (batches) for choosing the parents of
    the next generation (batch).}
  \item{selection}{A list containing the base for selection, and possible
    selection. The base can be either "fit" (standard value) or
    "rank"; rescaling a number, standard value is 0, but 1.5 is a
    value which gives often nice results.}
  \item{corate}{The parameter value recombination rate, i.e. the percentage
    individuals which should be recombined.}
  \item{mutation}{Some evolutionary parameters to set. This contains whether a
    uniform ('unif') or normal ('norm') distribution should be
    used, whether the spread value (if this is set to 0, a value
    of 1 is used), and to set the paramater value randomization
    rate.}  
}

\value{
  The function returns an evolutionary algorithm object:
  \item{genes}{a list containing the genome (parameter set)
    stucture. This is the same as the genome (parameter set) structure
    of in the input (\code{struc.ea$genes}).}
  \item{generations}{a list of structures with information of each
    generation (batch): 
    \describe{
      \item{fit:}{a vector containing the fitnesses of all individuals.
        These values are all set to NA, since the fitnesses of
        the new individuals are not known yet.}
      \item{allele:}{a matrix containing the allele-values of all
        individuals (experimental set-ups) of the new generation
        (batch)}
      \item{parents:}{a string vector with the numbers of the parent
        generations.}
      \item{selection:}{a list containing the selection base and
	rescaling.}
      \item{crossover:}{the crossover rate.}
      \item{mutation:}{a list containing the mutation parameters.}
  }}
}

\note{
  As for all functions in this package, evolutionary terminology is used
  as described in \code{\link{seao.terminology}}..
}

\references{
}

\author{
  Kurt Sys (\email{kurt.sys@rug.ac.be})
}

\seealso{
  \link{genomestruc}
}

\keyword{
  initial generation
  new generation
}

\examples{
}
\eof
% plotevolution.fit

\name{plotevolution.fit}

\alias{plotevolution.fit}

\title{
   Plot the evolution of the fitness of an optimization.
}

\description{
  Makes a plot of the evolution of the fitness. One can choose whether
  the minimum, maximum, average or all fitness is plotted, or if
  boxplots must be used, of if the standard deviation must be
  plotted. Also, the generations to plot can be chosen.
}

\usage{
  plotevolution.fit(struc.ea, gens=NULL, show="average", plot=TRUE, ...)
}

\arguments{
  \item{struc.ea}{An object of type evoutionary algorithms. This
    contains the data to be plotted}
  \item{gens}{A vector containing the generations to plot. The default
    value is NULL, giving all generations present in the optimization.}
  \item{show}{Defines what should be plotted: 'min' for minimum
    fitnesses, 'max' for maximum fitnesses, 'average' for average
    fitnesses, 'all' for all fitnesses, 'box' for boxplots of fitnesses
    per generations and 'stdev' for the standard deviations.}
  \item{plot}{If set to FALSE, the result is not plotted but assigned
    to an object or written to the screen.}
  \item{...}{Arguments to set for plotting. See \link{plot}}
}

\details{
}


\references{
}

\author{
   Kurt Sys (\email{kurt.sys@rug.ac.be})
}

\seealso{
}

\keyword{
  plot, evolution, fitness evolution
}

\examples{
}
\eof
% plotevolution.gene

\name{plotevolution.gene}

\alias{plotevolution.gene}

\title{
   Plot the evolution of the alleles of one gene for an optimization.
}

\description{
  Makes a histogram of the evolution of the alleles of one gene. The
  generations to plot can be chosen.
}

\usage{
  plotevolution.gene(struc.ea,
                     gene=1,
                     gens=NULL,
                     breaks=NULL,
                     main="Gen",
                     cols=NULL,
                     rows=NULL,
                     ...)
}

\arguments{
  \item{struc.ea}{An object of type evoutionary algorithms. This
    contains the data to be plotted}
  \item{gene}{The number of the gene to be plotted.}
  \item{gens}{A vector containing the generations to plot. The default
    value is NULL, giving all generations present in the optimization.}
  \item{breaks}{Where the breaks on each plot should be set. See
    function 'hist' for more information.}
  \item{main}{The main title of the plot.}
  \item{cols}{The number of columns, i.e. the number of histograms on
    one row. If set to NULL, argument 'rows' is checked.}
  \item{rows}{The number of rows, i.e. the number of histogram in one
    column. If 'cols' is set, this argument is omitted. Is both 'cols'
    and 'rows' are set to NULL, there's an automatic calculation of the
    number of rows and columns.}
  \item{...}{Arguments to set for plotting. See \link{plot}}
}

\details{
}


\references{
}

\author{
   Kurt Sys (\email{kurt.sys@rug.ac.be})
}

\seealso{
}

\keyword{
  plot, evolution, gene evolution
}

\examples{
}
\eof
% plotfreq.allele

\name{plotfreq.allele}

\alias{plotfreq.allele}

\title{
   Plot a histogram of the allele frequences.
}

\description{
  Makes a histogram of the allele frequencies of one generation of a certain gene.
}

\usage{
  plotfreq.allele(struc.ea,
                  gene=1,
                  gen=NULL,
                  breaks=NULL,
                  ...)
}

\arguments{
  \item{struc.ea}{An object of type evoutionary algorithms. This
    contains the data to be plotted}
  \item{gene}{The number of the gene to be plotted.}
  \item{gen}{A number pointing to which generation to plot. The default
    value is NULL, resulting in the last generation present in the optimization.}
  \item{breaks}{Where the breaks on each plot should be set. See
    function 'hist' for more information.}
  \item{...}{Arguments to set for making the histogram. See \link{hist}.}
}

\details{
}


\references{
}

\author{
   Kurt Sys (\email{kurt.sys@rug.ac.be})
}

\seealso{
}

\keyword{
  plot, evolution, gene evolution
}

\examples{
}
\eof
% terminology

\name{seao.terminology}

\alias{seao.terminology}

\title{
   Short overview of terminology
}

\description{
   This package uses a terminology which may seem somewhat strange and
   not obvious. The function does actually notting special, it just shows
   a short overview of the terms used in this package)
}

\usage{
  seao.terminology()
}

\arguments{
}

\details{
   This package uses a terminology which may seem somewhat strange and
   not obvious. The reason why this terminology has been used is however
   quite simple: it are genetic (or evolutionary) algoritms so the
   evolutionary terms are used:
   \describe{
      \item{population}{A number of experimental set-ups. This can be one
        generation or a list of several generations.}
      \item{generation}{All experimental set-ups of one experiment. One
        experiment is defined as a number of parallel experimental
        set-ups.}
      \item{individual}{One experimental set-up with own parameter-values.}
      \item{gene}{Parameter that can be changed for each experimental
        setup. It are these parameters that are optimized.}
      \item{allele}{Value of a parameter in an experimental setup.}
      \item{fitness}{The output of each experimental setup, i.e. the
        property you are using for optimizing the parameters.}
   }
}


\references{
}

\author{
   Kurt Sys (\email{kurt.sys@rug.ac.be})
}

\seealso{
}

\keyword{
   terminology
}

\examples{
}
\eof
% selectparents

\name{selectparents}

\alias{selectparents}

\title{
  Select the parents to mate
}

\description{
  Select the parents which are the basis for the next (child)
  generation. The individuals (set-ups) with highest fitness have the
  highest chance to be chosen, so some parents may be chosen a few
  times. 
}

\usage{
  selectparents(struc.ea, gen=NULL,
                method=list(base="fit", rescale=0))
}

\arguments{
  \item{struc.ea}{An evolutionary algorithm structure}
  \item{gen}{The number of the generation (batch) for which the parents
    have to be chosen. The standard value is the last generation.}
  \item{method}{A list containing the base for selection, and possible
    selection. The base can be either "fit" (standard value) or "rank";
    rescaling a number, standard value is 0, but 1.5 is a value which
    gives often nice results.}
}

\details{
  The method is a list of \code{base} and \code{rescale}. \code{base}
  gives which basis should be used for calculating the weights of the
  different individuals:
  \describe{
    \item{"fitness"}{The fitness values are the weights given, before
      rescaling}
    \item{"rank"}{The individuals are ranked from 1 to the number
      of individuals in the generation. The higher the number, the higher
      the fitness of the individual. If two individuals have exactly the
      same fitness, the average of the next and previous ranking is used,
      e.g. imagene that two fitnesses should be at ranking 7 and
      8. However, they have the same value, so they are both set to 7.5
      (in this case, the sum is still 15).}
  }
  In many cases, the difference between the lowest and highest
  weights are very high. This would result in choosing the same
  parent(s) every time. In order to decrease this extreme selection,
  one can rescale the weights. Rescaling is done so that the highest
  fitness is \code{recale} times the average value of the fitnesses.}

  For the selection itself, a roulette-like system is used. The chance
  that a certain numer is chosen is linear correlated with the weight
  (which is either the fitness or ranking value).
}

\value{
  The function returns an evolutionary algorithm object, which is
  actually the same as the input argument \code{struc.ea}, but with new
  individuals (experimental set-ups) and the selection method added in
  the generation (batch) of selection: 
  \item{genes}{a list containing the genome (parameter set)
    stucture. This is the same as the genome (parameter set) structure
    of in the input (\code{struc.ea$genes}).}
  \item{generations}{a list of structures with information of each
    generation: 
    \describe{
      \item{fit:}{a vector containing the fitnesses of all individuals
	(experimental set-ups) of the generation (batch); this are just
	copies of the fitnesses of the selected parents.}
      \item{allele:}{a matrix containing the allele-values of all
	individuals (experimental set-ups) of the generation (batch);
	this are just copies of the alleles (parameter values) of the
	selected parents.} 
      \item{parents:}{a string vector with the numbers of the parent
	generations.}
      \item{selection:}{a list containing the selection base and
	rescaling.}
	
  }}
}

\note{
  As for all functions in this package, evolutionary terminology is used
  as described in \code{\link{seao.terminology}}. 
}

\author{
  Kurt Sys (\email{kurt.sys@rug.ac.be})
}

\seealso{
  \link{genomestruc}, \link{newgen}, \link{chooseparents}
}

\keyword{
  parent
  selection
}

\examples{
}
\eof
