\name{00Intro.setRNG}
\alias{00Intro.setRNG}
\title{setRNG}

\section{Usage}{
   library("setRNG") 
}

\description{
  Programs to set random number generator (and seed) in R and S.}
\section{Introduction}{
This library provides tools to simplify recording and resetting the random 
number generator, to help make monte carlo experiments easily reproducible. 
It uses the R/S tools for setting the seed, but also records and sets
the mechanism for converting uniform numbers to normally distributed numbers.
(It could be extended to other transformations, but I have not done that.)

The setRNG function would typically be called by simulation programs (see
example) to set the 
RNG information if given, and record the RNG information
in all cases. This information can be returned with the result
of the simulation. That way the simulation can always be reproduced if
necessary.
 
The library also implements an approach to random number generation 
which allows the same random experiments to be replicated in S and R.
The functions in the S/ directory allow the R results using 
Wichmann-Hill and Box-Muller to be replicated in S. These were done with 
the aid of an example from B. D. Ripley. (The files in the S/ 
directory of the package are for use with S not R.)
These functions are intended primarily as a way to confirm that simulations and
estimations with simulated data work in 
the same way in both S and R, not as an improved RNG. (It has only been tested
in Splus 3.3) Default and other
RNGs can still be used and are preferred for both speed and 
theoretical reasons. 
}
  

\examples{
is.R()
setRNG(kind="Wichmann-Hill", seed=c(979,1479,1542), normal.kind="Box-Muller")
rnorm(10)

sim <-function(rng=NULL)
 {if(!require("setRNG")) stop("This function requires the setRNG package.")
  if(is.null(rng)) rng <- setRNG() # returns setting so don't skip if NULL
  else        {old.rng <- setRNG(rng);  on.exit(setRNG(old.rng))  }
  x <- list(numbers=rnorm(10))
  x$rng <- rng
  x
 }

z <- sim()
sim()$numbers
sim(rng=getRNG(z))$numbers
z$numbers

}
\keyword{programming}
\keyword{interface}
\keyword{utilities}
\keyword{distribution}


\eof
\name{getRNG}
\alias{getRNG}
\alias{getRNG.default}

\title{get the RND and seed from an object}
\description{
Get the random number generator and seed used to generate an object.
}
\usage{
    getRNG(e=NULL)
    \method{getRNG}{default}(e=NULL)
}
\arguments{
    \item{e}{an object generated by simulation (which stored the RNG 
    information).}
}
\value{The random seed and other random number generation information
   used to generate the object. }
\details{Extract the RNG information used to generate the object. If \code{e}
   is \code{NULL} then \code{getRNG} returns the RNG setting, as 
   returned by \code{setRNG()}. Otherwise,
   the default method assumes the object is a list and the RNG information 
   is in the element \code{rng} or \code{noise\$rng}.
   }
\seealso{
\code{\link{setRNG}},
\code{\link{.Random.seed}}
}
\examples{
\dontrun{
if (require("dse1")) {
  if(is.R()) data("eg1.DSE.data.diff", package="dse1")
  model <- estVARXls(eg1.DSE.data.diff)
  sim <- simulate(model)
  getRNG(sim)
  }
}
}
%\keyword{DSE}
\keyword{ts}
\keyword{programming}
\keyword{utilities}

\eof
\name{random.number.test}
\alias{random.number.test}
\title{Test the random number generator}
\description{Test the random number generator.}
\usage{
    random.number.test()
    }
\arguments{None}
\value{logical}
\details{
    This function checks that the
    RNG is working properly and has not been changed. If the RNG does not return
    values as in previous versions of R then the function executes 
    \code{stop()}. Since changes to the RNG will cause comparisons of 
    simulation results to fail, this is a useful check before investigating more
    complicated problems that may be a result of other "improvements" in your
    simulation or estimation programs.
}
\sideffects{Executes \code{stop()} if the tests fail.}
\seealso{
    \code{\link{set.seed}}
    \code{\link{RNGkind}}
    \code{\link{runif}}
    \code{\link{rnorm}}
    \code{\link{setRNG}}
}
\examples{
  random.number.test()
}
\keyword{programming}
\keyword{utilities}


\eof
\name{setRNG}
\alias{setRNG}
\title{Set the Random Number Generator}
\description{Set the RNG or return information about the setting of the RNG.}
\usage{
    setRNG(kind=NULL, seed=NULL, normal.kind=NULL)
    }
\arguments{None required
    \item{kind}{a character string.}
    \item{seed}{a vector of numbers (depending on kind).}
    \item{normal.kind}{a character string.}
}
\value{The old setting.}
\details{
    Sets the uniform and normal random number generators and the seed.
    The old setting is returned in a format
    which can be used in another call to setRNG. (This would reset to the
    original value.) If no arguments are given the current setting is 
    returned. In R see RNGkind for more details.
}
\sideffects{Sets global variables controlling the uniform and normal random 
    number generators and the global seed.}
\seealso{
    \code{\link{RNGkind}},
    \code{\link{set.seed}},
    \code{\link{runif}},
    \code{\link{rnorm}},
    \code{\link{random.number.test}}
}
\examples{
setRNG(kind="Wichmann-Hill", seed=c(979,1479,1542), normal.kind="Box-Muller")
rnorm(10)
}
\keyword{programming}
\keyword{utilities}


\eof
