### Name: shapefiles
### Title: Read and write ESRI shapefiles
### Aliases: read.shapefile read.shp read.shx read.dbf write.shapefile
###   write.shp write.shx write.dbf calc.header add.xy scaleXY emme2.shp
### Keywords: programming

### ** Examples

## Don't run: 
##D #Read entire shapefile
##D shapefile <- read.shapefile("links")
##D 
##D #Write entire shapefile
##D write.shapefile(shapefile, "temp", T)
##D 
##D #Read shp, shx, or dbf file
##D dbf <- read.dbf("links.dbf")
##D 
##D #Write shp, shx, or dbf file
##D write.dbf(dbf, "links.dbf", T)
##D 
##D #Calculate header (to clean up GeoMedia shapefile exports)
##D shapefile <- calc.header(shapefile)
##D 
##D #Add the X and Y coordinates to the dbf list of the shapefile list object
##D shapefile <- add.xy(shapefile)
##D 
##D #Scale the shapefile by scale.factor
##D shapefile <- scaleXY(shapefile, scale.factor)
##D 
##D #Create an EMME/2 network batch-in file
##D emme2.shp(nodes, links, "d211.in")
## End Don't run



