\name{bookstein2d}
\alias{bookstein2d}
\title{Bookstein's baseline registration for 2D data}
\description{Carries out Bookstein's baseline registration and
calculates a mean shape.  } 
\usage{bookstein2d(A,l1=1,l2=2)}
\arguments{
\item{A}{a k x 2 x n real array, or k x n complex matrix, where 
    k is the number of landmarks, n is the number of observations} 
\item{l1}{an integer : l1 is sent to (-1/2,0) in the registration} 
\item{l2}{an integer : l2 is sent to (1/2,0) in the registration}
}
\value{ 
   A list with components 
\item{k}{no of landmarks}
\item{n}{sample size}
\item{mshape}{Bookstein mean shape with baseline l1, l2} 
\item{bshpv}{the k x n x 2 array of Bookstein shape variables, including 
the baseline} 
}
\references{Dryden, I.L. and Mardia, K.V. (1998) 
Statistical Shape Analysis. Wiley, Chichester. 
Chapter 2. 

Bookstein, F. L. (1986) Size and shape spaces for landmark data in two dimensions 
(with discussion). Statistical Science, 1:181-242. 
} 
\author{Ian Dryden}

\examples{
data(gorf.dat)
data(gorm.dat)

bookf<-bookstein2d(gorf.dat)
bookm<-bookstein2d(gorm.dat)

plotshapes(bookf$mshape,bookm$mshape,joinline=c(1,6,7,8,2,3,4,5,1))
}

\keyword{multivariate}        

\eof
\name{digit3.dat}
\alias{digit3.dat}
\non_function{}
\title{Digit 3 data}
\description{Handwritten digit `3' data. 13 landmarks 
in 2 dimensions, 30 individuals
}
\usage{data(digit3.dat)}
\format{
An array of dimension 6 x 2 x 30
}
\source{
Dryden, I.L. and Mardia, K.V. (1998). 
Statistical Shape Analysis, Wiley, Chichester. p318
}
\references{
http://www.maths.nott.ac.uk/personal/ild/bookdata/digit3.dat

Data from Cath Anderson
}
\examples{
data(digit3.dat)
k<-dim(digit3.dat)[1]
n<-dim(digit3.dat)[3]
digit3.dat[,2,]<- -digit3.dat[,2,]+50
plotshapes(digit3.dat,joinline=c(1:13))
}
\keyword{datasets}


\eof
\name{gorf.dat}
\alias{gorf.dat}
\non_function{}
\title{Female gorilla data}
\description{Female gorilla skull data. 8 landmarks 
in 2 dimensions, 30 individuals
}
\usage{data(gorf.dat)}
\format{
An array of dimension 8 x 2 x 30
}
\source{
Dryden, I.L. and Mardia, K.V. (1998). 
Statistical Shape Analysis, Wiley, Chichester. p317 
}
\references{
http://www.maths.nott.ac.uk/personal/ild/bookdata/gorf.dat

Data from Paul O'Higgins (Hull-York Medical School)
}
\examples{
data(gorf.dat)
plotshapes(gorf.dat)
}
\keyword{datasets}


\eof
\name{gorm.dat}
\alias{gorm.dat}
\non_function{}
\title{Male gorilla data}
\description{Male gorilla skull data. 8 landmarks 
in 2 dimensions, 29 individuals
}
\usage{data(gorm.dat)}
\format{
An array of dimension 8 x 2 x 29
}
\source{
Dryden, I.L. and Mardia, K.V. (1998). 
Statistical Shape Analysis, Wiley, Chichester. p317 
}
\references{
http://www.maths.nott.ac.uk/personal/ild/bookdata/gorm.dat

Data from Paul O'Higgins (Hull-York Medical School)
}
\examples{
data(gorm.dat)
plotshapes(gorm.dat)
}
\keyword{datasets}


\eof
\name{macf.dat}
\alias{macf.dat}
\non_function{}
\title{Female macaque data}
\description{Female macaque skull data. 7 landmarks 
in 3 dimensions, 9 individuals
}
\usage{data(macf.dat)}
\format{
An array of dimension 7 x 3 x 9
}
\source{
Dryden, I.L. and Mardia, K.V. (1998). 
Statistical Shape Analysis, Wiley, Chichester. p16 
}
\references{
Data from Paul O'Higgins (Hull-York Medical School)
}
\examples{
data(macf.dat)
plotshapes(macf.dat)
}
\keyword{datasets}


\eof
\name{macm.dat}
\alias{macm.dat}
\non_function{}
\title{Male macaque data}
\description{Male macaque skull data. 7 landmarks 
in 3 dimensions, 9 individuals
}
\usage{data(macm.dat)}
\format{
An array of dimension 7 x 3 x 9
}
\source{
Dryden, I.L. and Mardia, K.V. (1998). 
Statistical Shape Analysis, Wiley, Chichester. p16
}
\references{
Data from Paul O'Higgins (Hull-York Medical School)
}
\examples{
data(macm.dat)
plotshapes(macm.dat)
}
\keyword{datasets}


\eof
\name{plotshapes}
\alias{plotshapes}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Plot configurations}            
\description{
Plots configurations. Either one or two groups of observations
can be plotted on the same scale. 
}
\usage{
plotshapes(A, B = 0, joinline = c(1, 1),orthproj=c(1,2))
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{A}{k x m x n array, or k x m matrix for first group} 
  \item{B}{k x m x n array, or k x m matrix for 2nd group (can be missing)}
  \item{joinline}{A vector stating which landmarks are joined up by lines,
  e.g. joinline=c(1:n,1) will start at landmark 1, join to 2, ..., join to n, 
  then re-join to landmark 1.}
  \item{orthproj}{A vector stating which two orthogonal projections will be
  used. For example, for m=3 dimensional data: X-Y projection given by c(1,2) 
  (default), X-Z projection given by c(1,3), Y-Z projection given by c(2,3).}
} 
\value{
Just graphical output
}
\author{Ian Dryden}            
\seealso{shapepca,tpsgrid}
\examples{
data(gorf.dat)
data(gorm.dat)
plotshapes(gorf.dat,gorm.dat,joinline=c(1,6,7,8,2,3,4,5,1))

data(macm.dat)
data(macf.dat)
plotshapes(macm.dat,macf.dat)
}
\keyword{hplot}
\keyword{multivariate}

\eof
\name{procGPA}
\alias{procGPA}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Generalised Procrustes analysis}
\description{Generalised Procrustes analysis to register landmark configurations into optimal registration using translation, 
rotation and scaling. Reflection invariance can also be chosen, and registration without scaling is also an option. Also, obtains principal 
components, and some summary statistics. 
}
\usage{
procGPA(x, scale = TRUE, reflect = FALSE, eigen2d = TRUE, 
tol1 = 1e-05, tol2 = tol1, approxtangent = TRUE, proc.output=FALSE, 
distances=TRUE, pcaoutput=TRUE)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{Input k x m x n real array, (or k x n complex 
matrix for m=2 is OK), where k is the number of points, m 
is the number of dimensions, and n is the sample size. }
  \item{scale}{Logical quantity indicating if scaling is required}
  \item{reflect}{Logical quantity indicating if reflection 
  is required}
  \item{eigen2d}{Logical quantity indicating if complex eigenanalysis 
  should be used to calculate Procrustes mean for 2D case when 
  scale=TRUE, reflect=FALSE} 
   \item{tol1}{Tolerance for optimal rotation for the iterative 
algorithm: tolerance on the mean sum of squares 
(divided by size of mean squared) between successive iterations}
  \item{tol2}{tolerance for rescale/rotation step for the iterative 
algorithm: tolerance on the mean sum of squares 
(divided by size of mean squared) between successive iterations}
\item{approxtangent}{Logical quantity indicating if the approximate tangent 
coordinates (Procrustes residuals) should be given if TRUE, or the partial 
tangent coordinates (see tan below) if FALSE}
\item{proc.output}{Logical quantity indicating if printed output during the
iterations of the Procrustes GPA algorithm should be given} 
\item{distances}{Logical quantity indicating if shape distances and sizes 
should be calculated}
\item{pcaoutput}{Logical quantity indicating if PCA should be carried out} 
}
\value{A list with components
\item{k}{no of landmarks}
\item{m}{no of dimensions (m-D dimension configurations)}
\item{n}{sample size}
\item{mshape}{Procrustes mean shape. Note this is unit size if complex 
eigenanalysis used, but on the scale of the data if iterative GPA is used.} 
\item{tan}{If approxtangent=TRUE this is the mk x n matrix of 
Procrustes approximate tangent coordinates $X_i^P$ - Xbar , where Xbar = mean($X_i^P$), which are also known as the 
Procrustes residuals. If approxtangent=FALSE this is 
the km-m x n matrix of partial Procrustes tangent coordinates
with pole given by the preshape of the Procrustes mean}
\item{rotated}{the k x m x n array of full Procrustes 
rotated data} 
\item{pcar}{the columns are eigenvectors (PCs) of the sample 
covariance Sv of tan} 
\item{pcasd}{the square roots of eigenvalues of Sv using tan (s.d.'s of PCs)}
\item{percent}{the percentage of variability explained by the PCs using
tan}
\item{size}{the centroid sizes of the configurations}
\item{scores}{standardised PC scores (each with unit variance) using 
tan} 
\item{rawscores}{raw PC scores using tan} 
\item{rho}{Kendall's Riemannian distance $\rho$ to the mean shape}
\item{rmsrho}{r.m.s. of rho} 
\item{rmsd1}{r.m.s. of full Procrustes distances to the mean shape $d_F$}
}
\references{Dryden, I.L. and Mardia, K.V. (1998). Statistical 
Shape Analysis, Wiley, Chichester. 
 
Goodall, C.R. (1991). Procrustes methods in the statistical analysis 
of shape (with discussion). Journal of the Royal Statistical Society, 
Series B, 53: 285-339. 

Gower, J.C. (1975). Generalized Procrustes analysis, Psychometrika, 40, 33--50. 

Kent, J.T. (1994). The complex Bingham distribution and shape analysis,
Journal of the Royal Statistical Society, Series B, 56, 285-299.

Ten Berge, J.M.F. (1977). Orthogonal Procrustes rotation for two or more 
matrices. Psychometrika, 42, 267-276. }
\author{Ian Dryden, with input from Mohammad Faghihi and Alfred Kume}
\seealso{procOPA,riemdist,shapepca,testmeanshapes}

\examples{

#2D example : female and male Gorillas (cf. Dryden and Mardia, 1998)

data(gorf.dat)
data(gorm.dat)

plotshapes(gorf.dat,gorm.dat)
n1<-dim(gorf.dat)[3]
n2<-dim(gorm.dat)[3]
k<-dim(gorf.dat)[1]
m<-dim(gorf.dat)[2]
gor.dat<-array(0,c(k,2,n1+n2))
gor.dat[,,1:n1]<-gorf.dat
gor.dat[,,(n1+1):(n1+n2)]<-gorm.dat

gor<-procGPA(gor.dat)
shapepca(gor,type="r",mag=3)
shapepca(gor,type="v",mag=3)

gor.gp<-c(rep("f",times=30),rep("m",times=29))
x<-cbind(gor$size,gor$rho,gor$scores[,1:3])
pairs(x,panel=function(x,y) text(x,y,gor.gp),
   label=c("s","rho","score 1","score 2","score 3"))


##########################################################
#3D example

data(macm.dat)
out<-procGPA(macm.dat,scale=FALSE)

par(mfrow=c(2,2))
plot(out$rawscores[,1],out$rawscores[,2],xlab="PC1",ylab="PC2")
title("PC scores")
plot(out$rawscores[,2],out$rawscores[,3],xlab="PC2",ylab="PC3")
plot(out$rawscores[,1],out$rawscores[,3],xlab="PC1",ylab="PC3")
plot(out$size,out$rho,xlab="size",ylab="rho")
title("Size versus shape distance")

}


\keyword{multivariate} 



\eof
\name{procOPA}
\alias{procOPA}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Ordinary Procrustes analysis} 
\description{
Ordinary Procustes analysis : the matching of one configuration to  
another using translation, rotation and (possibly) scale. Reflections 
can also be included if desired. The function matches configuration B 
onto A by least squares.}                      
\usage{
procOPA(A, B, scale = TRUE, reflect = FALSE)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{A}{k x m matrix (or complex k-vector for 2D data), of 
k landmarks in m dimensions. This is the reference figure.} 
  \item{B}{k x m matrix (or complex k-vector for 2D data). This is 
the figure which is to be transformed.} 
  \item{scale}{logical indicating if scaling is required} 
  \item{reflect}{logical indicating if reflection is allowed}
}
\value{
A list with components:          
  \item{R}{The estimated rotation matrix (may be an orthogonal matrix 
if reflection is allowed)} 
  \item{s}{The estimated scale matrix}   
  \item{Ahat}{The centred configuration A}
  \item{Bhat}{The Procrustes registered configuration B}
  \item{OSS}{The ordinary Procrustes sum of squares, which is 
$\|Ahat-Bhat\|^2$}
}
\references{Dryden, I.L. and Mardia, K.V. (1998). Statistical shape 
analysis. Wiley, Chichester.} 
\author{Ian Dryden}             
\seealso{procGPA,riemdist,tpsgrid}
\examples{
data(digit3.dat)

A<-digit3.dat[,,1]
B<-digit3.dat[,,2]
ans<-procOPA(A,B) 
plotshapes(A,B,joinline=1:13)
plotshapes(ans$Ahat,ans$Bhat,joinline=1:13)

#Sooty Mangabey data
data(sooty.dat)
A<-sooty.dat[,,1]   #juvenile
B<-sooty.dat[,,2]   #adult
par(mfrow=c(1,3))
par(pty="s")
plot(A,xlim=c(-2000,3000),ylim=c(-2000,3000),xlab=" ",ylab=" ")
lines(A[c(1:12,1),])
points(B)
lines(B[c(1:12,1),],lty=2)
title("Juvenile (-------) Adult (- - - -)")
#match B onto A
out<-procOPA(A,B)
#rotation angle
print(atan2(out$R[1,2],out$R[1,1])*180/pi)
#scale
print(out$s)
plot(A,xlim=c(-2000,3000),ylim=c(-2000,3000),xlab=" ",ylab=" ")
lines(A[c(1:12,1),])
points(out$Bhat)
lines(out$Bhat[c(1:12,1),],lty=2)
title("Match adult onto juvenile")
#match A onto B
out<-procOPA(B,A)
#rotation angle
print(atan2(out$R[1,2],out$R[1,1])*180/pi)
#scale
print(out$s)
plot(B,xlim=c(-2000,3000),ylim=c(-2000,3000),xlab=" ",ylab=" ")
lines(B[c(1:12,1),],lty=2)
points(out$Bhat)
lines(out$Bhat[c(1:12,1),])
title("Match juvenile onto adult")
}
\keyword{multivariate}

\eof
\name{qcet2.dat}
\alias{qcet2.dat}
\non_function{}
\title{Control T2 mouse vertabrae data}
\description{T2 mouse vertebrae data - control group. 6 landmarks 
in 2 dimensions, 30 individuals
}
\usage{data(qcet2.dat)}
\format{
An array of dimension 6 x 2 x 30
}
\source{
Dryden, I.L. and Mardia, K.V. (1998). 
Statistical Shape Analysis, Wiley, Chichester. p313
}
\references{
http://www.maths.nott.ac.uk/personal/ild/bookdata/qcet2.dat

Data from Paul O'Higgins (Hull-York Medical School) and David Johnson (Leeds)
}
\examples{
data(qcet2.dat)
plotshapes(qcet2.dat)
}
\keyword{datasets}


\eof
\name{qlet2.dat}
\alias{qlet2.dat}
\non_function{}
\title{Large T2 mouse vertabrae data}
\description{T2 mouse vertebrae data - large group. 6 landmarks 
in 2 dimensions, 23 individuals
}
\usage{data(qlet2.dat)}
\format{
An array of dimension 6 x 2 x 23
}
\source{
Dryden, I.L. and Mardia, K.V. (1998). 
Statistical Shape Analysis, Wiley, Chichester. p313
}
\references{
http://www.maths.nott.ac.uk/personal/ild/bookdata/qlet2.dat

Data from Paul O'Higgins (Hull-York Medical School) and David Johnson (Leeds)
}
\examples{
data(qlet2.dat)
plotshapes(qlet2.dat)
}
\keyword{datasets}


\eof
\name{qset2.dat}
\alias{qset2.dat}
\non_function{}
\title{Small T2 mouse vertabrae data}
\description{T2 mouse vertebrae data - small group. 6 landmarks 
in 2 dimensions, 23 individuals
}
\usage{data(qset2.dat)}
\format{
An array of dimension 6 x 2 x 23
}
\source{
Dryden, I.L. and Mardia, K.V. (1998). 
Statistical Shape Analysis, Wiley, Chichester. p313
}
\references{
http://www.maths.nott.ac.uk/personal/ild/bookdata/qset2.dat

Data from Paul O'Higgins (Hull-York Medical School) and David Johnson (Leeds)
}
\examples{
data(qset2.dat)
plotshapes(qset2.dat)
}
\keyword{datasets}


\eof
\name{riemdist}
\alias{riemdist}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Riemannian shape distance} 
\description{Calculates the Riemannian shape distance $\rho$ between two
 configurations}   
\usage{
riemdist(x, y)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{k x m matrix  (or complex k-vector  for 2D data) 
where k = number of landmarks and m = no of dimensions} 
 \item{y}{k x m matrix  (or complex k-vector  for 2D data)} 
}
\value{
  The Riemannian shape distance rho between the two configurations. 
Note 0 <= rho <= pi/2 } 
}
\references{
   Kendall, D. G. (1984). 
   Shape manifolds,  Procrustean metrics and complex
       projective spaces, 
   Bulletin of the  London Mathematical Society, 
   16,
   81-121. 
}
\seealso{procOPA,procGPA}
\examples{
data(gorf.dat)
data(gorm.dat)
gorf<-procGPA(gorf.dat)
gorm<-procGPA(gorm.dat)
rho<-riemdist(gorf$mshape,gorm$mshape)
cat("Riemannian distance between mean shapes is ",rho," \n")
}

\author{Ian Dryden}        
\keyword{multivariate}% __ONLY ONE__ keyword per line

\eof
\name{shapepca}
\alias{shapepca}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Principal components for shape}
\description{
Provides graphical summaries of principal components for shape.
}
\usage{
shapepca(proc, pcno = c(1, 2, 3), type = "r", mag = 1, joinline = c(1, 1))
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{proc}{List given by the output from \code{procGPA()} }
  \item{pcno}{A vector of the PCs to be plotted}
  \item{type}{Options for the types of plot for the $m=2$ planar case: 
   "r" : rows along PCs evaluated at c = -3,0,3 sd's along PC,
  "v" : vectors drawn from mean to +3 sd's along PC,
  "s" : plots along c= -3, -2, -1, 0, 1, 2, 3 superimposed,
  "m" : movie backward and forwards from -3 to +3 sd's along PC,
  "g" : TPS grid from mean to +3 sd's along PC.

 }
  \item{mag}{Magnification of the effect of the PC (scalar multiple of sd's)}
  \item{joinline}{A vector stating which landmarks are joined up by lines, 
  e.g. joinline=c(1:n,1) will start at landmark 1, join to 2, ..., join to n, then 
  re-join to landmark 1.}
}
\details{For $m=3$ the mean and PCs are plotted with orthogonal projections. 
The display is in the type="m" format only at the moment. 
}

\value{
 No value is returned
}
\references{Dryden, I.L. and Mardia, K.V. (1998) Statistical Shape 
Analysis. Wiley, Chichester.}
\author{Ian Dryden}

\seealso{procGPA}

\examples{
#2d example
data(gorf.dat)
data(gorm.dat)

gorf<-procGPA(gorf.dat)
gorm<-procGPA(gorm.dat)
shapepca(gorf,type="r",mag=3)
shapepca(gorf,type="v",mag=3)
shapepca(gorm,type="r",mag=3)
shapepca(gorm,type="v",mag=3)

#3D example
#data(macm.dat)
#out<-procGPA(macm.dat)
#movie
#shapepca(out,pcno=1)
}
\keyword{hplot}
\keyword{multivariate}

\eof
\name{shapes-internal}
\alias{defplotsize2}
\alias{BoxM} 
\alias{Goodall2D} 
\alias{Goodalltest} 
\alias{Hotelling2D} 
\alias{Hotellingtest} 
\alias{I2mat} 
\alias{TPSgrid}
\alias{V} 
\alias{Vinv} 
\alias{Vmat} 
\alias{add} 
\alias{banner1} 
\alias{banner4} 
\alias{bendingenergy} 
\alias{bgpa} 
\alias{bookstein.shpv} 
\alias{bookstein.shpv.complex} 
\alias{cbevec} 
\alias{cbevectors} 
\alias{centroid.size} 
\alias{centroid.size.complex} 
\alias{centroid.size.mD} 
\alias{close1} 
\alias{cnt3} 
\alias{complextoreal} 
\alias{defh} 
\alias{defplotsize} 
\alias{defplotsize3} 
\alias{del} 
\alias{dif} 
\alias{dif.old} 
\alias{dis} 
\alias{dna.dat}
\alias{fJ} 
\alias{fcel} 
\alias{fcnt} 
\alias{fgpa} 
\alias{fgpa.rot} 
\alias{fgpa.singleiteration} 
\alias{fopa} 
\alias{fort.ROTATEANDREFLECT} 
\alias{fort.ROTATION} 
\alias{fort} 
\alias{fos} 
\alias{ftrsq} 
\alias{full.procdist} 
\alias{genpower} 
\alias{goodall2d} 
\alias{goodalltest} 
\alias{graf} 
\alias{hotelling2d} 
\alias{hotellingtest} 
\alias{isodens} 
\alias{isologdens} 
\alias{isomle} 
\alias{isotropy.test} 
\alias{kendall.shpv} 
\alias{linegrid} 
\alias{loglikeiso} 
\alias{loglikeiso2} 
\alias{loneFone} 
\alias{mahpreshapedist} 
\alias{makearray} 
\alias{movie} 
\alias{msh} 
\alias{norm} 
\alias{objfuniso} 
\alias{oneFone} ]
\alias{partial.procdist} 
\alias{partialwarpgrids} 
\alias{partialwarps} 
\alias{plot2rwscores} 
\alias{plot3Ddata} 
\alias{plot3Ddata.static}
\alias{plot3Dmean} 
\alias{plot3Dpca} 
\alias{plotPDM} 
\alias{plotPDM2} 
\alias{plotPDM3} 
\alias{plotPDMbook} 
\alias{plotPDMnoaxis} 
\alias{plotPDMnoaxis3} 
\alias{plotpairscores} 
\alias{plotpca} 
\alias{plotprinwarp} 
\alias{plotproc} 
\alias{plotrelwarp} 
\alias{pointsPDMnoaxis3} 
\alias{prcomp1} 
\alias{preshape} 
\alias{preshape.mD} 
\alias{preshape.mat} 
\alias{preshapetoicon} 
\alias{prinwscoregrids} 
\alias{procdistreflect} 
\alias{procrustes2d} 
\alias{procrustesGPA} 
\alias{procrustesGPA.rot} 
\alias{procrustesgpa} 
\alias{project} 
\alias{read.array} 
\alias{read.in} 
\alias{realtocomplex} 
\alias{reassqpr} 
\alias{relwarps} 
\alias{rgpa} 
\alias{riemdist.complex} 
\alias{riemdist.mD} 
\alias{rotateaxes} 
\alias{sgpa} 
\alias{sh} 
\alias{sigma} 
\alias{sim1} 
\alias{st} 
\alias{tanfigure} 
\alias{tanfigurefull} 
\alias{tanpreshape} 
\alias{tantofigure} 
\alias{tantofigurefull} 
\alias{tantopreshape} 
\alias{vec} 
\title{Internal function(s)}
\description{Internal function(s)}
\keyword{internal}


\eof
\name{sooty.dat}
\alias{sooty.dat}
\non_function{}
\title{Sooty mangabey data}
\description{Sooty mangabey data skull data. 12 landmarks 
in 2 dimensions, 2 individuals (juvenile and adult)
}
\usage{data(sooty.dat)}
\format{
An array of dimension 12 x 2 x 2
}
\source{
Dryden, I.L. and Mardia, K.V. (1998). 
Statistical Shape Analysis, Wiley, Chichester. p17, 42 
}
\references{
Data from Paul O'Higgins (Hull-York Medical School)
}
\examples{
data(sooty.dat)
plotshapes(sooty.dat,joinline=c(1:12,1))
}
\keyword{datasets}


\eof
\name{testmeanshapes}
\alias{testmeanshapes}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Tests for mean shape difference}
\description{
  Carries out Hotelling's $T^2$ or Goodall's $F$ test to examine differences in mean shape
between two independent populations, for $m>=2$ dimensional data. 
The procedure uses complex eigenanalysis for $m=2$ and iterative 
Generalised Procrustes Analysis for $m>2$ dimensions. 
}
\usage{
testmeanshapes(A, B, Hotelling = TRUE, tol1 = 1e-05, tol2 = 1e-05)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{A}{The random sample for group 1: k x m x n1 array of data, where 
k is the number of landmarks, m is dimension and n1 is the sample size}
  \item{B}{The random sample for group 2: k x m x n2 array of data, where 
k is the number of landmarks, m is dimension and n2 is the sample size}
  \item{Hotelling}{Logical. If TRUE then carry out Hotelling's $T^2$ test, 
  if FALSE carry out Goodall's $F$ test}
    \item{tol1}{Tolerance for optimal rotation for the iterative 
algorithm ($m>2$): tolerance on the mean sum of squares between successive iterations 
(depends on scale of objects)}
  \item{tol2}{tolerance for rescale/rotation step for the iterative 
algorithm ($m>2$): tolerance on the Riemannian shape distance 
between successive mean shapes}
}

\value{
  A list with components 
   \item{F}{the F statistic}
   \item{df1 and df2}{degrees of freedom of the F statistic}
   \item{pval}{p-value for the test} 
  \item{Tsq}{the $T^2$ statistic (if Hotelling)}
  \item{T.df1 and T.df2}{degrees of freedom of the $T^2$ statistic (if Hotelling)}
  \item{Tsq.partition}{the $T^2$ statistic partitioned into 
contributions from each of the pooled principal components (if Hotelling)} 
 
  \item{F.partition}{the F statistic partitioned into 
contributions from each of the pooled principal components (if Hotelling)} 
}

\references{Dryden, I.L. and Mardia, K.V. (1998) Statistical Shape Analysis, 
Wiley, Chichester. Chapter 7. 
 
Dryden and Mardia (1993) Multivariate shape analysis. Sankhya A, 55:460-480.

Goodall, C. R. (1991). Procrustes methods in the statistical analysis 
of shape (with discussion). Journal of the Royal Statistical Society, 
Series B, 53: 285-339. 
} 




\author{Ian Dryden}

\seealso{procGPA}

\examples{

#2D example : female and male Gorillas (cf. Dryden and Mardia, 1998)

data(gorf.dat)
data(gorm.dat)

#Hotelling's Tsq test
test1<-testmeanshapes(gorf.dat,gorm.dat)

#Goodall's isotropic test
test2<-testmeanshapes(gorf.dat,gorm.dat,Hotelling=FALSE)

}




\keyword{multivariate}% at least one, from doc/KEYWORDS

\eof
\name{tpsgrid}
\alias{tpsgrid}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Thin-plate spline transformation grids}
\description{Thin-plate spline transformation grids from one planar object
to another. A square grid on the first object is deformed smoothly using a pair of 
thin-plate splines to a curved grid on the second object. 
}
\usage{
tpsgrid(TT, YY, xbegin, ybegin, xwidth, opt, ext, ngrid)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{TT}{First object (source): (k x 2 matrix)}
  \item{YY}{Second object (target): (k x 2 matrix)}
  \item{xbegin}{lowest x value for plot}
  \item{ybegin}{lowest y value for plot}
  \item{xwidth}{width of plot}
  \item{opt}{Option 1: (just deformed grid on YY is displayed), 
  option 2: both grids are displayed}
  \item{ext}{Amount that grid extends over object.}
  \item{ngrid}{Number of grid points: size is ngrid * (ngrid -1)}
}
\details{
Note - only for $m=2$ planar objects
}
\value{
No returned value
}
\references{
Bookstein, F.L. (1989). Principal  warps: thin-plate
       splines and  the decomposition  of  deformations,
       IEEE Transactions on Pattern Analysis and Machine Intelligence,
   11, 567--585. 

Dryden, I.L. and Mardia, K.V. (1998) Statistical Shape 
Analysis. Wiley, Chichester. Chapter 10.
}
\author{Ian Dryden}

\seealso{procGPA}

\examples{
data(gorf.dat)
data(gorm.dat)

#TPS grid with shape change exaggerated (2x)
gorf<-procGPA(gorf.dat)
gorm<-procGPA(gorm.dat)
mag<-2
TT<-gorf$mshape
YY<-gorm$mshape
par(mfrow=c(1,2))
YY<-TT+(YY-TT)*mag
tpsgrid(TT,YY,-0.6,-0.6,1.2,2,0.1,22) 
title("TPS grid: Female mean (left) to Male mean (right)")   

}
\keyword{multivariate}% at least one, from doc/KEYWORDS
\keyword{hplot}

\eof
