\name{ask}
\alias{ask}
\title{
Ask data to be typed on the keyboard.
}
\description{
This function prints a message and prompts the user to type in data  
on the keyboard.
}
\usage{
ask(message="Type in datum")
}
\arguments{
\item{message}{
a character value, normally something describing the required input
}}
\value{
the object typed in.
}
\examples{
\dontrun{n <- ask("sample size")
nv <- ask("vector of sample sizes")
# in the second case, the user could reply eg with `c(5,10,30)'
}}
\keyword{utilities}
% Converted by Sd2Rd version 1.15.

\eof
\name{binning}
\alias{binning}
\title{
Construct frequency table from raw data
}
\description{
Given a vector or a matrix \code{x}, this function constructs a frequency table
associated to appropriate intervals covering the range of \code{x}.
}
\usage{
binning(x, y, breaks, nbins)
}
\arguments{
\item{x, y}{
a vector or a matrix with either one or two columns. 
If \code{x} is a one-dimentional matrix, this is equivalent to a vector.
}
\item{breaks}{
either a vector or a matrix with two columns (depending on the dimension of \code{x}),
assigning the division points of the axis, or the axes in the matrix case.
It must not include \code{Inf},\code{-Inf} or \code{NA}s, and it must span the whole range of 
the \code{x} points.
If \code{breaks} is not given, it is computed by dividing the range of \code{x}
into \code{nbins} intervals for each of the axes.
}
\item{nbins}{
the number of intervals on the \code{x} axis (in the vector case), 
or a vector of two elements with the number of intervals on each
axes of \code{x} (in the matrix case).
If \code{nbins} is not given, a value is computed as \code{round(log(length(x))/log(2)+1)}
or using a similar expression in the matrix case.
}}
\value{
In the vector case, a list is returned containing the following elements:
a vector \code{x} of the midpoints of the bins excluding those with 0 frequecies, 
its associated matrix \code{x.freq} of frequencies, the coodinateds of the 
\code{midpoints}, the division points, and the complete vector of observed 
frequencies \code{freq.table} (including the 0 frequencies), and the vector
\code{breaks} of division points.
In the matrix case, the returned value is a list with the following 
elements: a two-dimensional matrix \code{x} with the coordinates of the
midpoints of the two-dimensional bins excluding those with 0 frequecies, 
its associated matrix \code{x.freq} of frequencies, the coordinates of the 
\code{midpoints}, the matrix \code{breaks} of division points, and the observed 
frequencies \code{freq.table} in full tabular form.
}
\details{
This function is called automatically (under the default settings)
by some of the functions of the \code{sm} library when the sample size is
large, to allow handling of datasets of essentially unlimited size.
Specifically, it is used by \code{sm.density}, \code{sm.regression}, \code{sm.ancova},
\code{sm.binomial} and \code{sm.poisson}.
}
\references{
Bowman, A.W. and Azzalini, A. (1997). 
\emph{Applied Smoothing Techniques for Data Analysis:
the Kernel Approach with S-Plus Illustrations.}
Oxford University Press, Oxford.
}
\seealso{
\code{\link{sm}}, \code{\link{sm.density}}, \code{\link{sm.regression}}, \code{\link{sm.binomial}}, \code{\link{sm.poisson}}, \code{\link{cut}}, \code{\link{table}}
}
\examples{
# example of 1-d use
x  <- rnorm(1000)
xb <- binning(x)
xb <- binning(x, breaks=seq(-4,4,by=0.5))
# example of 2-d use
x <- rnorm(1000)
y <- 2*x + 0.5*rnorm(1000)
x <- cbind(x, y)
xb<- binning(x, nbins=12)
}
\keyword{}
% Converted by Sd2Rd version 1.15.

\eof
\name{cv}
\alias{cv}
\title{
Cross-validation criterion for nonparametric density estimation
}
\description{
This function computes a cross-validatory criterion, based on integrated
squared error, for use in selecting a smoothing parameter in nonparametric
density estimation.
}
\usage{
cv(x, h, \dots)
}
\arguments{
\item{x}{
vector, or two-column matrix, of data.
}
\item{h}{
a smoothing parameter.  In the two-dimensional case this is multiplied
by the standard deviation of each component to produce two smoothing
parameters
}
\item{\dots}{
other optional parameters are passed to the \code{sm.options} function, through
a mechanism which limits their effect only to this call of the function; 
those relevant for this function are the following:
\itemize{
\item{h.weights}{
a vector of weights which multiply the smoothing parameter(s) used in the
kernel function at each observation.
}}}}
\value{
The value of the cross-validatory criterion.
}
\details{
See Section 2.4.3 of the reference below.  The function is called
automatically by \code{hcv} and does not usually need to be called 
independently.
}
\references{
Bowman, A.W. and Azzalini, A. (1997). 
\emph{Applied Smoothing Techniques for Data Analysis: }
\emph{the Kernel Approach with S-Plus Illustrations.}
Oxford University Press, Oxford.
}
\seealso{
\code{\link{hcv}}, \code{\link{hsj}}, \code{\link{hnorm}}, \code{\link{sj}}
}
\examples{
x      <- rnorm(50)
hgrid  <- seq(0.1, 1, length = 10)
cvgrid <- vector("numeric", length = length(hgrid))
for (i in 1:10) cvgrid[i] <- cv(x, hgrid[i])
plot(hgrid, cvgrid, type="l")
}
\keyword{nonparametric}
\keyword{smooth}
% Converted by Sd2Rd version 1.15.

\eof
\name{geyser}
\alias{geyser}
\non_function{}
\usage{data(geyser)}
\title{Old Faithful Geyser Data}
\description{
A version of the eruptions data from the ``Old Faithful'' geyser in Yellowstone
National  Park,  Wyoming. This version comes from
Azzalini and Bowman (1990) and is of continuous measurement from August
1 to August 15, 1985.

Some nocturnal duration measurements were coded as 2, 3 or 4 minutes,
having originally been described as `short', `medium' or `long'.
}
\format{A data frame with 299 observations on 2 variables.
  \tabular{lll}{
    \code{duration}  \tab numeric  \tab Eruption time in mins \cr
    \code{waiting}   \tab numeric  \tab Waiting time to next eruption \cr
  }
}
\seealso{\code{\link{faithful}}}
\references{
  Azzalini, A. and Bowman, A. W. (1990) A look at some
  data on the Old Faithful geyser.  \emph{Applied Statistics}
  \bold{39}, 357--365.
}
\keyword{datasets}

\eof
\name{hcv}
\alias{hcv}
\title{
Cross-validatory choice of smoothing parameter
}
\description{
This function uses the technique of cross-validation to select a smoothing 
parameter suitable for constructing a density estimate or nonparametric 
regression curve in one or two dimensions.
}
\usage{
hcv(x, y = NA, hstart = NA, hend = NA, \dots) 
}
\arguments{
\item{x}{
a vector, or two-column matrix of data.  If \code{y} is missing these are 
observations to be used in the construction of a density estimate.  If
\code{y} is present, these are the covariate values for a nonparametric regression.
}
\item{y}{
a vector of response values for nonparametric regression.
}
\item{hstart}{
the smallest value of the grid points to be used in an initial grid search 
for the value of the smoothing parameter.
}
\item{hend}{
the largest value of the grid points to be used in an initial grid search 
for the value of the smoothing parameter.
}
\item{\dots}{
other optional parameters are passed to the \code{sm.options} function, through
a mechanism which limits their effect only to this call of the function; 
those relevant for this function are the following:
\itemize{
\item{h.weights}{
a vector of weights which multiply the smoothing parameter(s) used in the
kernel function at each observation.
}
\item{ngrid}{
the number of grid points to be used in an initial grid search for the 
value of the smoothing parameter. Default: \code{ngrid=8}.
}
\item{display}{
any character setting other than \code{"none"} will cause the criterion function 
to be plotted over the search grid of smoothing parameters.  The particular
value \code{"log"} will use a log scale for the grid values.
}
\item{add}{
controls whether the plot is added to an existing graph. Default: \code{add=F}.
}}}}
\value{
the value of the smoothing parameter which minimises the cross-validation
criterion over the selected grid.
}
\section{Side Effects}{
If the minimising value is located at the end of the grid of search positions,
or if some values of the cross-validatory criterion cannot be evaluated,
then a warning message is printed.  In these circumstances altering the
values of \code{hstart} and \code{hend} may improve performance.
}
\details{
See Sections 2.4 and 4.5 of the reference below.

The two-dimensional case uses a smoothing parameter derived from a single 
value, scaled by the standard deviation of each component.

This function does not employ a sophisticated algorithm and some adjustment
of the search parameters may be required for different sets of data.
An initial estimate of the value of h which minimises the cross-validatory
criterion is located from a grid search using values which are equally
spaced on a log scale between \code{hstart} and \code{hend}.  A quadratic approximation
is then used to refine this initial estimate.
}
\references{
Bowman, A.W. and Azzalini, A. (1997).
\emph{Applied Smoothing Techniques for Data Analysis: }
\emph{the Kernel Approach with S-Plus Illustrations.}
Oxford University Press, Oxford.
}
\seealso{
\code{\link{cv}}, \code{\link{hsj}}, \code{\link{hnorm}}
}
\examples{
#  Density estimation

x <- rnorm(50)
par(mfrow=c(1,2))
h.cv <- hcv(x, display="lines", ngrid=32)
sm.density(x, h=hcv(x))
par(mfrow=c(1,1))

#  Nonparametric regression

x <- seq(0, 1, length = 50)
y <- rnorm(50, sin(2 * pi * x), 0.2)
par(mfrow=c(1,2))
h.cv <- hcv(x, y, display="lines", ngrid=32)
sm.regression(x, y, h=hcv(x, y))
par(mfrow=c(1,1))
}
\keyword{nonparametric}
\keyword{smooth}
% Converted by Sd2Rd version 1.15.

\eof
\name{hnorm}
\alias{hnorm}
\title{
Normal optimal choice of smoothing parameter in density estimation
}
\description{
This functions evaluates the smoothing parameter which is asymptotically
optimal for estimating a density function when the underlying distribution
is Normal.  Data in one, two or three dimensions can be handled.
}
\usage{
hnorm(x, weights)
}
\arguments{
\item{x}{
a vector, or matrix with two or three columns, containing the data.
}
\item{weights}{
a vector which allows the kernel functions over the observations to take
different weights when they are averaged to produce a density estimate.  This
is useful, in particular, for censored data and to construct an estimate
from binned data. 
}}
\value{
the value of the Normal optimal smoothing parameter.
}
\details{
See Section 2.4.2 of the reference below.
}
\references{
Bowman, A.W. and Azzalini, A. (1997). 
\emph{Applied Smoothing Techniques for Data Analysis: }
\emph{the Kernel Approach with S-Plus Illustrations.}
Oxford University Press, Oxford.
}
\seealso{
\code{\link{hcv}}, \code{\link{hsj}}
}
\examples{
x <- rnorm(50)
hnorm(x)
}
\keyword{nonparametric}
\keyword{smooth}
% Converted by Sd2Rd version 1.15.

\eof
\name{hsj}
\alias{hsj}
\title{
Sheather-Jones choice of smoothing parameter for density estimation
}
\description{
This function uses the Sheather-Jones plug-in method of selecting a
smoothing parameter which is suitable for constructing a density estimate
in the one-dimensional case.
}
\usage{
hsj(x)
}
\arguments{
\item{x}{
a vector of data.
}}
\value{
the value of the smoothing parameter located by the Sheather-Jones method.
}
\details{
See Section 2.4.4 of the reference below.
}
\references{
Bowman, A.W. and Azzalini, A. (1997). \emph{Applied Smoothing Techniques for
Data Analysis: the Kernel Approach with S-Plus Illustrations.}
Oxford University Press, Oxford.
}
\seealso{
\code{\link{hnorm}}, \code{\link{hcv}}
}
\examples{
x <- rnorm(50)
hsj(x)
}
\keyword{nonparametric}
\keyword{smooth}
% Converted by Sd2Rd version 1.15.

\eof
\name{nise}
\alias{nise}
\title{
integrated squared error between a density estimate and a Normal density
}
\description{
This function evaluates the integrated squared error between a density
estimate constructed from a standardised version of the univariate data
\code{y} and a standard normal density function.
}
\usage{
nise(y, hmult=1)
}
\synopsis{
nise(y, ...)
}
\arguments{
\item{y}{
a vector of data.
}
\item{hmult}{
a factor which can be used to multiply the normal optimal smoothing parameter
before construction of the density estimate.
}}
\value{
the integrated squared error.
}
\details{
the data \code{y} are first standardised to have sample mean 0 and sample
variance 1.  The integrated squared error between a density estimate
constructed from these standardised data and a standard normal distribution
is then evaluated.

see Section 2.5 of the reference below.
}
\references{
Bowman, A.W. and Azzalini, A. (1997). \emph{Applied Smoothing Techniques for
Data Analysis: the Kernel Approach with S-Plus Illustrations.}
Oxford University Press, Oxford.
}
\seealso{
\code{\link{nmise}}
}
\examples{
x <- rnorm(100)
nise(x)
}
\keyword{nonparametric}
\keyword{smooth}
% Converted by Sd2Rd version 1.15.

\eof
\name{nmise}
\alias{nmise}
\title{
mean integrated squared error for density estimation with normal data
}
\description{
This function evaluates the mean integrated squared error of a density
estimate which is constructed from data which follow a normal distribution.
}
\usage{
nmise(sd, n, h)
}
\arguments{
\item{sd}{
the standard deviation of the normal distribution from which the data arise.
}
\item{n}{
the sample size of the data.
}
\item{h}{
the smoothing parameter used to construct the density estimate.
}}
\value{
the mean integrated squared error of the density estimate.
}
\details{
see Section 2.4 of the reference below.
}
\references{
Bowman, A.W. and Azzalini, A. (1997). \emph{Applied Smoothing Techniques for
Data Analysis: the Kernel Approach with S-Plus Illustrations.}
Oxford University Press, Oxford.
}
\seealso{
\code{\link{nise}}
}
\examples{
x  <- rnorm(50)
sd <- sqrt(var(x))
n  <- length(x)
h  <- seq(0.1, 2, length=32)
plot(h, nmise(sd, n, h), type = "l")
}
\keyword{nonparametric}
\keyword{smooth}
% Converted by Sd2Rd version 1.15.

\eof
\name{nnbr}
\alias{nnbr}
\title{
nearest neighbour distances from data in one or two dimensions
}
\description{
This function calculates the \code{k} nearest neighbour distance from each
value in \code{x} to the remainder of the data.  In two dimensions, Euclidean
distance is used after standardising the data to have unit variance in
each component.
}
\usage{
nnbr(x, k)
}
\arguments{
\item{x}{
the vector, or two-column matrix, of data.
}
\item{k}{
the required order of nearest neighbour.
}}
\value{
the vector of nearest neighbour distances.
}
\details{
see Section 1.7.1 of the reference below.
}
\references{
Bowman, A.W. and Azzalini, A. (1997). \emph{Applied Smoothing Techniques for
Data Analysis: the Kernel Approach with S-Plus Illustrations.}
Oxford University Press, Oxford.
}
\seealso{
none.
}
\examples{
x  <- rnorm(50)
hw <- nnbr(x, 10)
hw <- hw/exp(mean(log(hw)))
sm.density(x, h.weights=hw)
}
\keyword{nonparametric}
\keyword{smooth}
% Converted by Sd2Rd version 1.15.

\eof
\name{pause}
\alias{pause}
\title{
Pause before continuing execution  
}
\description{
If a program produces several plots, isertion of \code{pause()} between
two plots suspends execution until the <Enter> key is pressed, to
allow inspection of the current plot.
}
\usage{
pause()
}
\keyword{misc}
% Converted by Sd2Rd version 1.15.

\eof
\name{provide.data}
\alias{provide.data}
\title{
Making data available as data.frame
}
\description{
This is a utility function, widely used in the scripts acconpanying
the book described below.
The function provides access to the dataset identified by \code{name}.
For flexibility, the datasets are provided in ASCII form, with the name
of each variable listed in the first row of the file.
This function reads the files and makes the data available as a data frame.
}
\usage{
provide.data(data, path, options = list())
}
\arguments{
\item{data}{
name of the data to be loaded and attached as \code{data.frame}
}
\item{path}{
the path where the data and its documentation should be searched for,
The default value is an appropriate sub-directory of the \code{sm} package. 
}
\item{options}{
  A list of options.  The one used is \code{describe}, a
  logical flag.  If \code{describe=TRUE} (default), a documentation file
  of the data is searched and printed, if available.
}}
\value{
none
}
\section{Side Effects}{
messages are printed on the command window, describing  progress of
the operation. If \code{describe=TRUE} and a documentation file exists, this
is printed on the command windows or another windows, depending on
the type of platform where the program is executed.
}
\details{
the data file is assumed to be called \code{data}.dat and the documentation
file describing the data (if present) is assumed to be called \code{data}.doc.
If the \code{data.frame} is already attached, it is re-attached in the second
position of the \code{search} list. 


To set \code{describe=F} for the rest of the current session,  use 
\code{sm.options(describe=F)}


The function can very easily be adapted to play a similar role for
other packages.
}
\references{
Bowman, A.W. and Azzalini, A. (1997). 
\emph{Applied Smoothing Techniques for Data Analysis: }
\emph{the Kernel Approach with S-Plus Illustrations.}
Oxford University Press, Oxford.
}
\seealso{
\code{\link{data.frame}}, \code{\link{attach}}, \code{\link{sm}}, \code{\link{sm.options}}
}
\examples{
provide.data(birth)
}
\keyword{utilities}
% Converted by Sd2Rd version 1.15.

\eof
\name{sig.trace}
\alias{sig.trace}
\title{
A significance trace for a hypothesis test
}
\description{
This function creates a significance trace for a hypothesis test based
on a nonparametric smoothing procedure.  The p-value of the test is
plotted against a range of smoothing parameters.
}
\usage{
sig.trace(expn, hvec, display="lines")
}
\synopsis{
sig.trace(expn, hvec, ...)
}
\arguments{
\item{expn}{
an S-Plus expression which should define the hypothesis test to be
performed, with the value of the smoothing parameter \code{h} omitted from
the function call.
}
\item{hvec}{
a vector of smoothing parameters for which the test will be performed.
}
\item{display}{
any character setting other than \code{"none"} will cause the significance
trace to be plotted.
}}
\value{
a list containing vectors with the smoothing parameters and p-values.
}
\section{Side Effects}{
If the largest p-value is greater than 0.05 then a horizontal line at
0.05 will be superimposed on any plot, for reference.
}
\details{
see Section 5.2 of the reference below.


Only tests involving a univariate smoothing parameter may be used.
}
\references{
Bowman, A.W. and Azzalini, A. (1997). \emph{Applied Smoothing Techniques for
Data Analysis: the Kernel Approach with S-Plus Illustrations.}
Oxford University Press, Oxford.
}
\seealso{
none.
}
\examples{
x <- runif(50, 0, 1)
y <- 5*x^2 + rnorm(50)
sig.trace(sm.regression(x, y, model = "linear", display="none"), 
        hvec = seq(0.05, 0.3, length = 10))
}
\keyword{nonparametric}
\keyword{smooth}
% Converted by Sd2Rd version 1.15.

\eof
\name{sj}
\alias{sj}
\title{
Sheather-Jones criterion for nonparametric density estimation
}
\description{
This function computes a criterion associated with the Sheather-Jones
plug-in method of selecting a smoothing parameter in nonparametric
density estimation.  The selected smoothing parameter is identified
by the point at which this criterion takes the value 0.
}
\usage{
sj(x, h)
}
\arguments{
\item{x}{
a vector of data.
}
\item{h}{
a value of smoothing parameter.
}}
\value{
The value of the Sheather-Jones criterion.
}
\details{
see Section 2.4.4 of the reference below.  The function is called
automatically by \code{hsj} and does not usually need to be called 
independently.
}
\references{
Bowman, A.W. and Azzalini, A. (1997). \emph{Applied Smoothing Techniques for
Data Analysis: the Kernel Approach with S-Plus Illustrations.}
Oxford University Press, Oxford.
}
\seealso{
\code{\link{cv}}, \code{\link{hcv}}, \code{\link{hsj}}, \code{\link{hnorm}}
}
\examples{
x      <- rnorm(50)
hgrid  <- seq(0.1, 1, length = 10)
sjgrid <- vector("numeric", length = length(hgrid))
for (i in 1:10) sjgrid[i] <- sj(x, hgrid[i])
plot(hgrid, sjgrid, type="l")
abline(0, 0, lty=2)
}
\keyword{nonparametric}
\keyword{smooth}
% Converted by Sd2Rd version 1.15.

\eof
\name{sm-internal}
\alias{addplot}
\alias{attach.frame}
\alias{box1.}
\alias{box2.}
\alias{britmap}
\alias{change}
\alias{circle}
\alias{coord2.}
\alias{hidplot}
\alias{incphi}
\alias{inctheta}
\alias{normdens.band}
\alias{np.contour.plot.3d.}
\alias{p.quad.moment}
\alias{plot.regression}
\alias{plot2}
\alias{plot2d}
\alias{print.graph}
\alias{replace.na}
\alias{sm.glm}
\alias{sm.imageplot}
\alias{sm.persplot}
\alias{sm.sigma}
\alias{sm.sigweight}
\alias{sm.sliceplot}
\alias{sm.weight}
\alias{sm.weight2}
\alias{smplot.density}
\alias{type}
\alias{wmean}
\alias{wvar}
\alias{isInteger}
\alias{isMatrix}
\title{Internal sm functions}
\description{
 Internal \code{sm} functions
}
\usage{
addplot(d, f, theta, phi)
attach.frame(data, name, ...)
box1.(theta = pi/6, phi = pi/6, sc, col = par("col"), axes.lim = sc)
box2.(theta = pi/6, phi = pi/6, sc, labels = c("", "", ""),
    col = par("col"), cex = 9/10, axes.lim = sc)
britmap()
change(th, ph)
circle(r)
coord2.(x, y, z, theta, phi, sc)
hidplot(invis, theta, phi)
incphi(ph, inc)
inctheta(th, inc)
isInteger(x)
isMatrix(x)
normdens.band(x, h, weights = rep(1, length(x)), options = list())
np.contour.plot.3d.(coord, data = matrix(), shadow = TRUE, gridsize = 20,
    numpts = 3, xmin = NA, xmax = NA, ymin = NA, ymax = NA, zmin = NA,
    zmax = NA, xlab = NA, ylab = NA, zlab = NA, theta = pi/4,
    phi = pi/4, colour = FALSE, title.colour = 3, label.colour = 3,
    axes.colour = 6, plot.colour = "blue", shadow.colour = "cyan",
    cex = NA)
p.quad.moment(A, Sigma, tobs, ndevs)
plot.regression(x, y, design.mat, h, r, model, weights, rawdata = list(),
    options = list(), ...)
plot2(latitude2, longitude2, theta, phi)
plot2d(d, f, theta, phi)
print.graph(file, ...)
replace.na(List, comp, value)
sm.glm(x, y, family, h, eval.points, start, offset)
sm.imageplot(x, y, h, weights, rawdata, options = list())
sm.persplot(x, y, h = hnorm(cbind(x, y), weights), weights, rawdata = list(),
    options = opt)
sm.sigma(x, y, rawdata, weights = rep(1, length(y)), diff.ord = 2)
sm.sigweight(x, weights = rep(1, length(x)), ...)
sm.sliceplot(x, y, h, weights, rawdata = list(), options = list())
sm.weight(x, eval.points, h, cross = FALSE, weights = rep(1, n), options)
sm.weight2(x, eval.points, h, cross = FALSE, weights = rep(1, nrow(x)),
    options = list())
smplot.density(x, h, weights = rep(1, length(x)), rawdata = list(x = x),
    options = list())
type(descr = "", x, digits = 4)
wmean(x, w)
wvar(x, w)
}
\details{
  These are not to be called by the user.
}
\keyword{internal}

\eof
\name{sm}
\alias{sm}
\title{
The library sm: summary information
}
\description{
This library implements nonparametric smoothing methods described 
in the book of Bowman & Azzalini (1997)
}
\section{Main Features}{
The functions in the library use kernel methods to construct nonparametric 
estimates of density functions and regression curves in a variety of
settings, and to perform some inferential operations.

Specifically, density estimates can be performed for 1-, 2- and 3-dimensional  
data. Nonparametric regresion for continuous data can be constructed with
one or two covariates, and a variety of goodness-of-fit test for linear models
can be carried out. Many other data types can be handled; these include
survival data, time series, count and binomial data. 
}
\section{Functions}{
The main functions are \code{sm.density} and \code{sm.regression}; other
functions intended for direct access by the user are: \code{binning},
\code{sm.ancova}, \code{sm.autoregression}, \code{sm.binomial},
\code{sm.binomial.bootstrap}, \code{sm.poisson}, \code{sm.poisson.bootstrap},
\code{sm.options}, \code{sm.rm}, \code{sm.script}, \code{sm.sphere}, \code{sm.survival},
\code{sm.ts.pdf}.  There are undocumented functions which are called by the
above ones.
}
\details{
Missing data are allowed; they are simply removed, togeter with
the associated variates from the same case, if any.

Datasets of arbitrary size can be handled by the current version of  
\code{sm.density},  \code{sm.regression} and \code{sm.ancova}, using binning operations.
}
\section{REquirements}{
The library has been tested on S-plus 3.x, 4.0, 5.1
}
\section{Version}{
You are using version 2 (November 2000). 
The most recent version of the library can be obtained from either of 
the WWW pages:
\url{http://www.stats.gla.ac.uk/~adrian/sm}
\url{http://www.stat.unipd.it/~azzalini/Book\_sm}
}
\section{Manual}{
There is no manual except for on-line documentation.
The book by Bowman and Azzalini (1997) provides more detailed and 
background information.
Algorithmic aspects of the software are discussed by Bowman & Azzalini (2001).
Differences between the first version  of the library and the current one are 
summarized in the file \code{history.txt} which is distributed with the library.
}
\author{
Adrian Bowman (Dept Statistics, University of Glasgow, UK) and
Adelchi Azzalini (Dept Statistical Sciences, University of Padua, Italy).
Please send comments, error reports, etc. to the authors via the
abovementioned WWW page.
}
\section{Acknowledgements}{
Important contributions to prototype versions of functions for some specific 
techniques included here were made by a succession of students; these
include Stuart Young, Eileen Wright, Peter Foster, Angela Diblasi, 
Mitchum Bock and Adrian Hines. We are grateful for all these interactions.
These preliminary version have been subsequently re-written for inclusion
in the public release of the library, with the exception of the functions 
for three-dimensional density estimation, written by Stuart Young.
We also thank Luca Scrucca for useful remarks and Brian Ripley for substantial 
help in the production of  installation files, leading to much improved 
versions with respect to our original ones, and for tools to produce the 
MS-windows version starting from the Unix one.
}
\references{
Bowman, A.W. and Azzalini, A. (1997).
\emph{Applied Smoothing Techniques for Data Analysis: }
\emph{the Kernel Approach with S-Plus Illustrations.}
Oxford University Press, Oxford.

Bowman, A.W. and Azzalini, A. (2001).
Computational aspects of nonparametric smoothing, 
with illustrations from the \code{sm} library.
To appear.
}
\section{Licence}{
This library and its documentation are usable under the terms of the "GNU 
General Public License", a copy of which is distributed with the package.
}
\keyword{nonparametric}
\keyword{smooth}
% Converted by Sd2Rd version 1.15.

\eof
\name{sm.ancova}
\alias{sm.ancova}
\title{
Nonparametric analysis of covariance
}
\description{
This function allows a set of nonparametric regression curves to be
compared, both graphically and formally in a hypothesis test.  A reference
model, used to define the null hypothesis, may be either equality or 
parallelism.
}
\usage{
sm.ancova(x, y, group, h, model="none", band=TRUE, test=TRUE,
          h.alpha=2 * diff(range(x))/length(x),
          weights = as.integer(rep(1, length(x))), \dots)
}
\arguments{
\item{x}{
a vector of covariate values.
}
\item{y}{
a vector of response values.
}
\item{group}{
a vector of group indicators.
}
\item{h}{
the smoothing parameter to be used in the construction of each of the
regression curves.
}
\item{model}{
a character variable which defines the reference model.  The values
\code{"none"}, \code{"equal"} and \code{"parallel"} are possible.
}
\item{band}{
a logical flag controlling the production of a reference band for the 
reference model.  A band will be produced only in the case of two groups.
}
\item{test}{
a logical flag controlling the production of a formal test, using the 
reference model as the null hypothesis.
}
\item{h.alpha}{
the value of the smoothing parameter used when estimating the vertical
separations of the curves under the parallelism model.
}
\item{weights}{
case weights.
}
\item{\dots}{
other optional parameters are passed to the \code{sm.options} function, through
a mechanism which limits their effect only to this call of the function; 
those relevant for this function are the following:
\itemize{
\item{display}{
any character setting other than \code{"none"} will cause a plot of the curves,
distinguished by line type, to be produced.
}
\item{ngrid}{
the size of the grid used to plot the curves.
}
\item{eval.points}{
a vector of points at which reference bands will be evaluated.
}
\item{xlab}{
the label attached to the x-axis.
}
\item{ylab}{
the label attached to the y-axis.
}}}}
\value{
a list containing an estimate of the error standard deviation and, where
appropriate, a p-value and reference model.  If the parallelism model has
been selected then a vector of estimates of the vertical separations of the 
underlying regression curves is also returned.
}
\section{Side Effects}{
a plot on the current graphical device is produced, unless \code{display="none"}
}
\details{
see Sections 6.4 and 6.5 of the book by Bowman \& Azzalini, and
the papers by Young \& Bowman listed below.
This function is a developed version of code originally written by Stuart Young.
}
\references{
Bowman, A.W. and Azzalini, A. (1997). 
\emph{Applied Smoothing Techniques for Data Analysis: }
\emph{the Kernel Approach with S-Plus Illustrations.}
Oxford University Press, Oxford.


Young, S.G. and Bowman, A.W. (1995).  
Nonparametric analysis of covariance.  
\emph{Biometrics}
\bold{51}, 920--931.


Bowman, A.W. and Young, S.G. (1996).  
Graphical comparison of nonparametric curves.  
\emph{Applied Statistics}
\bold{45}, 83--98.
}
\seealso{
\code{\link{sm.regression}}, \code{\link{sm.density.compare}}, \code{\link{sm.options}}
}
\examples{
x <- runif(50, 0, 1)
y <- 4*sin(6*x) + rnorm(50)
g <- rbinom(50, 1, 0.5)
sm.ancova(x, y, g, h = 0.15, model = "equal")
}
\keyword{nonparametric}
\keyword{smooth}
% Converted by Sd2Rd version 1.15.

\eof
\name{sm.autoregression}
\alias{sm.autoregression}
\title{
Nonparametric estimation of the autoregression function
}
\description{
This function estimates nonparametrically the autoregression function
(conditional mean given the past values) of a time series \code{x},
assumed to be stationary.
}
\usage{
sm.autoregression(x, h=hnorm(x), d=1, maxlag=d, lags, se=FALSE, ask=TRUE)
}
\arguments{
\item{x}{
vector containing the time series values.
}
\item{h}{
the bandwidth used for kernel smoothing.
}
\item{d}{
number of past observations used for conditioning; it must be 1
(default value) or 2.
}
\item{maxlag}{
maximum of the lagged values to be considered (default value is \code{d}).
}
\item{lags}{
if \code{d==1}, this is a vector containing the lags considered for conditioning;
if \code{d==2}, this is a matrix with two columns, whose rows contains pair of
values considered for conditioning.
}
\item{se}{
if \code{se==T}, pointwise confidence bands are computed of approximate level 95\%.
}
\item{ask}{
if \code{ask==TRUE}, the program pauses after each plot until <Enter> is pressed.
}
}
\value{
a list with the outcome of the final estimation (corresponding to
the last value or pairs of values of lags), as returned by \code{sm.regression}.
}
\section{Side Effects}{
graphical output is producved on the current device.
}
\details{
see Section 7.3 of the reference below.
}
\references{
Bowman, A.W. and Azzalini, A. (1997). 
\emph{Applied Smoothing Techniques for Data Analysis: }
\emph{the Kernel Approach with S-Plus Illustrations.}
Oxford University Press, Oxford.
}
\seealso{
\code{\link{sm.regression}}, \code{\link{sm.ts.pdf}}
}
\examples{
library(ts)
data(lynx)
sm.autoregression(log(lynx), maxlag=3, se=TRUE)
sm.autoregression(log(lynx), lags=cbind(2:3,4:5))
}
\keyword{nonparametric}
\keyword{smooth}
\keyword{ts}
% Converted by Sd2Rd version 1.15.

\eof
\name{sm.binomial}
\alias{sm.binomial}
\title{
Nonparametric logistic regression
}
\description{
This function estimates the regression curve using the local likelihood
approach for a vector of binomial observations and an associated vector
of covariate values.
}
\usage{
sm.binomial(x, y, N = rep(1, length(y)), h, \dots)
}
\arguments{
\item{x}{
vector of the covariate values
}
\item{y}{
vector of the response values; they must be nonnegative integers not larger
than those of \code{N}.
}
\item{h}{
the smoothing parameter; it must be positive.
}
\item{N}{
a vector containing the binomial denominators.
If missing, it is assumed to contain all 1's.
}
\item{\dots}{
  other optional parameters are passed to the \code{sm.options}
  function, through a mechanism which limits their effect only to this
  call of the function; those relevant for this function are the following:
\itemize{
\item{add}{
if graphical output is produced, this parameter controls whether a 
new plot is created, or graphical output is added to the existing one.
Default: \code{add=F}.
}
\item{col}{
colour used for plotting curves and points. Default: \code{col=1}.
}
\item{display}{
controls the type of graphical output; possible values are
\code{"estimate"} (default), \code{"se"}, \code{"none"}.
}
\item{eval.points}{
the vector of points on the \code{x} axis where the regression must be
estimated. If the parameter \code{eval.points} is not given, this vector
is chosen to be formed by \code{ngrid} equally spaced points between
\code{min(x)} and `max(x)}.
}
\item{nbins}{
The number of bins used when binning operation is performed.
If \code{nbins=0}, binning is not performed; if \code{nbins=NA} (default),
binning is switched on when the number of design points exceeds 100.
See the documentation of \code{binning} for more details.
}
\item{ngrid}{
the number of points where the regression curve must be estimated
(only used if \code{eval.points} is not given). Default: \code{ngrid=25}.
}
\item{pch}{
plotting character of the raw observed frequency. Default: \code{pch=1}.
}
\item{xlab}{
label of the x-axis. Default is the name of \code{x} object.
}
\item{ylab}{
label of the y-axis. Default is \code{Pr\{<name.of.y>\}}.
}}}}
\value{
A list containing vectors with the evaluation points, the corresponding
probability estimates, the linear predictors, the upper and lower points
of the variability bands (on the probability scale) and the standard
errors on the linear predictor scale.
}
\section{Side Effects}{
graphical output will be produced, depending on the value of the
\code{display} parameter.
}
\details{
see Sections 3.4 and 5.4 of the reference below.
}
\references{
Bowman, A.W. and Azzalini, A. (1997). 
\emph{Applied Smoothing Techniques for Data Analysis: }
\emph{the Kernel Approach with S-Plus Illustrations.}
Oxford University Press, Oxford.
}
\seealso{
\code{\link{sm.binomial.bootstrap}}, \code{\link{sm.poisson}},  \code{\link{sm.options}}, \code{\link{glm}}, \code{\link{binning}}
}
\examples{\dontrun{
# the next example assumes that all binomial denominators are 1's
sm.binomial(dose, failure, h=0.5)
# in the next example, (some of) the dose levels are replicated 
sm.binomial(dose, failure, n.trials, h=0.5)
}}
\keyword{nonparametric}
\keyword{smooth}
\keyword{models}
% Converted by Sd2Rd version 1.15.



\eof
\name{sm.binomial.bootstrap}
\alias{sm.binomial.bootstrap}
\title{
Bootstrap goodness-of-fit test for a logistic regression model. 
}
\description{
This function is associated with \code{sm.logit} for the underlying fitting
procedure.
It performs a Pseudo-Likelihood Ratio Test for the goodness-of-fit of
a standard parametric logistic regression of specified \code{degree} in the
covariate \code{x}.
}
\usage{
sm.binomial.bootstrap(x, y, N=rep(1, length(x)), h, nboot=99, 
                      degree=1, \dots)
}
\synopsis{
sm.binomial.bootstrap(x, y, N = rep(1, length(x)), h, nboot = 99, degree = 1,
    fixed.disp = FALSE, family = binomial(logit), ...)
}
\arguments{
\item{x}{
vector of the covariate values
}
\item{y}{
vector of the response values; they must be nonnegative integers.
}
\item{h}{
the smoothing parameter; it must be positive.
}
\item{N}{
a vector containing the binomial denominators.
If missing, it is assumed to contain all 1's.
}
\item{nboot}{
number of bootstrap samples (default=100).
}
\item{degree}{
specifies the degree of the fitted polynomial in \code{x} on the logit scale
(default=1).
}
\item{\dots}{
additional parameters passed to \code{\link{sm.binomial}}.
}}
\value{
a list containing the observed value of the Pseudo-Likelihood Ratio Test
statistic, its observed p-value as estimated via the bootstrap method,
and the vector of estimated dispersion parameters when this value is not 
forced to be 1.
}
\section{Side Effects}{
Graphical output representing the bootstrap samples is produced on 
the current graphical device. 
The estimated dispersion parameter, the value of the test statistic
and the observed significance level are printed.
}
\details{
see Section 5.4 of the reference below.
}
\references{
Bowman, A.W. and Azzalini, A. (1997). 
\emph{Applied Smoothing Techniques for Data Analysis: }
\emph{the Kernel Approach with S-Plus Illustrations.}
Oxford University Press, Oxford.
}
\seealso{
\code{\link{sm.binomial}}, \code{\link{sm.poisson.bootstrap}}
}
\examples{
\dontrun{sm.binomial.bootstrap(concentration, dead, N, 0.5, nboot=50)}
}
\keyword{nonparametric}
\keyword{smooth}
\keyword{htest}
\keyword{models}
% Converted by Sd2Rd version 1.15.

\eof
\name{sm.density}
\alias{sm.density}
\alias{sm.density.1d}
\alias{sm.density.2d}
\alias{sm.density.3d}
\alias{sm.density.eval.1d}
\alias{sm.density.eval.2d}
\alias{sm.density.positive.1d}
\alias{sm.density.positive.2d}
\alias{sm.density.positive.grid}

\title{
Nonparametric density estimation in one, two or three dimensions.
}
\description{
This function creates a density estimate from data in one, two or three
dimensions.  In one dimension, an interactive panel can be activated
to control the smoothing parameter, in two dimensions a variety of
graphical displays can be selected, and in three dimensions a contour
surface can be plotted.  A number of other features of the construction
of the estimate, and of its display, can be controlled.
}
\usage{
sm.density(x, h, model = "none", weights=rep(1,nobs), \dots)
}
\arguments{
\item{x}{
a vector, or a matrix with two or three columns, containing the data.
}
\item{h}{
a vector of length one, two or three, defining the smoothing parameter.
A normal kernel function is used and \code{h} is its standard deviation.
If this parameter is omitted, a normal optimal smoothing parameter is used.
}
\item{model}{
This argument applies only with one-dimensional data.  Its default value
is \code{"none"}.  If it is set to \code{"Normal"} (or indeed any value other than
\code{"none"}) then a reference band, indicating where a density estimate is 
likely to lie when the data are normally distributed, will be superimposed 
on any plot.
}
\item{weights}{
a vector which allows the kernel functions over the observations to take
different weights when they are averaged to produce a density estimate.
Use of this parameter is incompatible with binning; hence \code{nbins} must 
then be set to 0 or left at its default value \code{NA}.
This argument does not apply with three-dimensional data.
}
\item{\dots}{
other optional parameters are passed to the \code{sm.options} function, through
a mechanism which limits their effect only to this call of the function; 
those relevant for this function are the following:
\itemize{
\item{hmult}{
a factor which can be used to multiply the normal smoothing parameter
before construction of the density estimate.
}
\item{h.weights}{
a vector of weights which multiply the smoothing parameter used in the
kernel function at each observation.  This argument does not apply with 
three-dimensional data.
}
\item{band}{
a logical value which controls whether the reference band appears on the plot.
Its default value is \code{TRUE}.  
This argument applies only with one-dimensional data.
}
\item{add}{
a logical value which controls whether the density estimate is added to
the current plot.  Its default value is \code{FALSE}, which creates a new plot.
This argument applies only with one-dimensional data.
}
\item{lty}{
the line type used to plot the density estimate.  This argument applies only 
with one-dimensional data.
}
\item{display}{
This argument applies only with one- or two-dimensional data.  The setting
\code{"none"} will prevent any graphical output from being produced.  In one
dimensions, the default setting \code{"estimate"} will produce the density
estimate, while the setting \code{"se"} will in addition produce a variability
band, showing the variability, but not the bias, of the estimate.  In two
dimensions, the default setting \code{"persp"} will produce a perspective plot
of the density estimate, while the settings \code{"slice"} and \code{"image"} will
produce slice (contour) or image plots.
}
\item{props}{
a vector defining the proportions of the data to be included within each
contour in a slice plot, from two-dimensional data, or a contour surface
plot, from three-dimensional data.  In the three-dimensional case only
the first element of the vector will be used.  This argument does not apply 
to one-dimensional data.  
}
\item{xlab}{
the label attached to the x-axis.
}
\item{ylab}{
the label attached to the y-axis.
}
\item{zlab}{
the label attached to the z-axis (three-dimensional plots only)
}
\item{xlim}{
the range of the horizontal axis of the plot.  This argument does not apply
with three-dimensional data.
}
\item{ylim}{
the range of the vertical axis of the plot.  This argument does not apply 
with three-dimensional data.
}
\item{yht}{
the upper limit of the vertical axis in a plot of a one-dimensional density
estimate.  The lower limit is always set to 0.  This argument does not apply 
with two- or three-dimensional data.           
}
\item{nbins}{
The number of bins used in one-dimensional binning operations;
in two-dimensional cases, \code{nbins} refers to the number of bins 
formed along each axis. Bins with 0 observed frequencies are ignored.
If \code{nbins=0}, binning is not performed; if \code{nbins=NA} (default),
binning is switched on when the number of observations divided by
the number of dimensions exceeds 500.
}
\item{ngrid}{
the number of points in the regular grid used to plot the estimate.
For two- and three-dimensional data, \code{ngrid} refers to the number of points
along the axis in each dimension. 
Default: 100, 50 and 20 for 1-, 2- and 3-dimensional data, respectively.
}
\item{eval.points}{
the points at which the density estimate should be evaluated, for the
values returned in the result of the function.  This should be a vector
for one-dimensional data and a two-column matrix for two-dimensional data.
This argument does not apply with three-dimensional data.
}
\item{panel}{
a logical value which controls the appearance of a panel display, in the
case of one- or two-dimensional data.  The panel can be used to alter the
value of the smoothing parameter.  For one-dimensional data it can also
launch an animation, and superimpose a normal reference band.  This argument 
does not apply with three-dimensional data.
}
\item{positive}{
a logical value which indicates whether the data should be assumed to take
positive values only.  When this argument is set to \code{TRUE}, a log
transformation
is applied to the data before construction of a density estimate.  The result
is transformed back to the original scale.  This argument does not apply with 
three-dimensional data.
}
\item{delta}{
a value which will be added to the data before they are log transformed in
the procedure to handle positive data.  The value of \code{delta} is used only
when \code{positive} takes the value \code{TRUE}.  The default value is
the smallest value
observed in each dimension.  This argument does not apply with 
three-dimensional data.
}
\item{theta}{
the horizontal rotation (in radians) of the contour plot of the density
estimate from three-dimensional data.  The default value is \eqn{\pi/4}{pi/4}.
}
\item{phi}{
the vertical rotation (in radians) of the contour plot of the density
estimate from three-dimensional data.  The default value is \eqn{\pi/4}{pi/4}.
}}}}
\value{
a list containing the values of the density estimate at the evaluation points,
the standard error of the estimate, the upper and lower ends of a variability 
band, the smoothing parameter, the smoothing parameter weights and the kernel 
weights.  Less information is supplied when the smoothing parameter weights
or kernel weights are not all 1, or when \code{positive} is set to \code{TRUE}.
}
\section{Side Effects}{
a plot on the current graphical device is produced, unless \code{display="none"}.
}
\details{
see Chapters 1, 2 and 6 of the reference below.
The code for drawing contours of a three-dimensional density estimate has 
been amended from an original function written by Stuart Young.
}
\references{
Bowman, A.W. and Azzalini, A. (1997). 
\emph{Applied Smoothing Techniques for Data Analysis: }
\emph{the Kernel Approach with S-Plus Illustrations.}
Oxford University Press, Oxford.
}
\seealso{
\code{\link{hnorm}}, \code{\link{hsj}}, \code{\link{hcv}}, \code{\link{nise}}, \code{\link{nmise}}, \code{\link{sm}}, \code{\link{sm.sphere}}, \code{\link{sm.regression}},
\code{\link{sm.options}}
}
\examples{
#  A one-dimensional example
y <- rnorm(50)
sm.density(y, model = "Normal")


#  A two-dimensional example
y <- cbind(rnorm(50), rnorm(50))
sm.density(y, display = "image")


#  A three-dimensional example
y <- cbind(rnorm(50), rnorm(50), rnorm(50))
sm.density(y)
}
\keyword{nonparametric}
\keyword{smooth}
% Converted by Sd2Rd version 1.15.

\eof
\name{sm.density.compare}
\alias{sm.density.compare}
\title{
Comparison of univariate density estimates
}
\description{
This function allows a set of univariate density estimates to be
compared, both graphically and formally in a bootstrap hypothesis test of 
equality.
}
\usage{
sm.density.compare(x, group, h=NA, model="none", test=TRUE,
                   nboot=100, monitor=TRUE, \dots)
}
\arguments{
\item{x}{
a vector of data.
}
\item{group}{
a vector of group labels.
}
\item{h}{
the smoothing parameter to be used in the construction of each density
estimate.  Notice that the same smoothing parameter is used for each group.
If this value is omitted, the mean of the normal optimal values for the
different groups is used.
}
\item{model}{
the default value is \code{"none"} which restricts comparison to plotting only.
The alternative value \code{"equal"} can produce a bootstrap hypothesis test
of equality and the display of an appropriate reference band.
}
\item{test}{
a logical flag controlling the production of a bootstrap test of equality.
}
\item{nboot}{
the number of bootstrap simulations.
}
\item{monitor}{
a logical flag controlling the printing of the iteration numbers during the
bootstrap test.
}
\item{\dots}{
additional \code{sm.options} or graphical parameters.
}}
\value{
When \code{model} is set to \code{"none"}, nothing is returned.  When
\code{"model"} is set to \code{"equal"}, a list containing the smoothing
parameter and the p-value of the test is returned.  When \code{band}
takes the value \code{TRUE}, and there are only two groups to compare, the list
contains in addition the upper and lower end-points of the reference
band for equality.
}
\section{Side Effects}{
none.
}
\details{
see Section 6.2 of the reference below.
}
\references{
Bowman, A.W. and Azzalini, A. (1997). \emph{Applied Smoothing Techniques for
Data Analysis: the Kernel Approach with S-Plus Illustrations.}
Oxford University Press, Oxford.
}
\seealso{
\code{\link{sm.density}}, \code{\link{sm.ancova}}
}
\examples{
y <- rnorm(100)
g <- rep(1:2, rep(50,2))
sm.density.compare(y, g, model="equal")
}
\keyword{nonparametric}
\keyword{smooth}
% Converted by Sd2Rd version 1.15.

\eof
\name{sm.options}
\alias{sm.options}
\title{
Set or return options of sm library
}
\description{
Provides a means to control the behaviour of the \code{sm} library
such as the colour of the plotted lines, the size of the grid in 2-D
estimation, the set of evaluations points, and many others.
}
\usage{
sm.options(\dots)
}
\arguments{
\item{\dots}{
a list may be given as the only argument, or a vector of
character strings given as the only argument, or any number of 
arguments may be in the \code{name=value} form , or no argument at all may be given.
See the Value and Side Effects sections for explanation.

Setting of some argument will remain in effect until the end of the current 
S-plus session, unless overwritten by a subsequent call. In addition, they 
can be added as optional parameters of call to specific functions of the \code{sm} 
library; in this case, their effect is limited  to that function call. 
See the documentation of specific functions for the list of options 
which are recognised by that function.
\itemize{
\item{add}{
a logical value which controls whether the density estimate is added to
the current plot.  Its default value is \code{FALSE}, which creates a new plot.
This argument applies only with one-dimensional data.
}
\item{band}{
a logical value which controls whether the reference band appears on the plot. 
This argument applies only with one-dimensional data.  Default: \code{band=FALSE}.
}
\item{col}{
The colour used for plotting observed points and estimated curves.
Default: \code{col=1}.
}
\item{delta}{
a value which will be added to the data before they are log transformed in
the procedure to handle positive data.  The value of \code{delta} is used only
when \code{positive} takes the value \code{TRUE}.  The default value is the smallest value
observed in each dimension.  This argument does not apply with 
three-dimensional data. Default: \code{delta=NA} 
}
\item{describe}{
This affectcs the behaviour of \code{sm.script} and \code{provide.data}. 
If \code{describe=TRUE} (default), a data documentation file is printed. 
}
\item{diff.ord}{
an integer defining the degree of differencing to be applied in the
esimtation process.  When this argument is set to 1, the method of Rice,
based on the squared differences of pairs of neighbouring observations,
is used.  When the argument is set to 2 (deafult), the method of Gasser, 
Sroka and Jennen-Steinmetz, based on differences between each observation 
and a linear interplotation from its two neighbours, is used.
}
\item{display}{
This argument applies only with one- or two-dimensional data.  
The setting \code{"none"} will prevent any graphical output from being produced.  
In one dimension, the default setting \code{"estimate"} will produce the density
estimate, while the setting \code{"se"} will in addition produce a variability
band, showing the variability, but not the bias, of the estimate.  In two
dimensions, the default setting \code{"persp"} will produce a perspective plot
of the density estimate, while the settings \code{"slice"} and \code{"image"} will
produce slice (contour) or image plots.
}
\item{eval.points}{
the points at which the density or the regression curve or surface estimate 
should be evaluated, for the values returned in the result of the function.  
This should be a vector for one-dimensional data and a two-column matrix 
for two-dimensional data. 
This argument does not apply with three-dimensional data.
}
\item{eye.mult}{
a vector of length 3 defining the eye position for the perspective plot
in the two covariate case.  The interpretation of this argument is similar
to the argument \code{eye} in the \code{persp} function.  Here the argument
is automatically scaled to adjust for the different axis scalings.
}
\item{h.weights}{
a vector of weights which multiply the smoothing parameter used in the
kernel function at each observation.  This argument does not apply with 
three-dimensional data. Default: \code{h.weights=1}.
}
\item{hmult}{
a factor which can be used to multiply the normal smoothing parameter
before construction of the density estimate. Default: \code{h.mult=1}.
}
\item{hull}{
a logical value which controls whether the estimate is evaluated and plotted
only on grid points which fall within the convex hull of the data.  When
this argument is set to \code{FALSE}, evaluation and plotting take place at all grid 
points where the contribution from at least one kernel function is 
non-negligible.  Both of these settings ensure that the estimate is not 
evaluated at points where there are no observations nearby.  This argument 
applies only to the case of two covariates.
}
\item{lty}{
the line type used to plot the estimate.  This argument applies only with 
one covariate.
}
\item{nbins}{
The number of bins used in one-dimensional binning operations;
in two-dimensional cases, \code{nbins} refers to the number of bins 
formed along each axis. Bins with 0 observed frequencies are ignored.
If \code{nbins=0}, binning is not performed; if \code{nbins=NA} (default),
binning is switched on when the number of observations exceeds
a certain threshold, which depends on the function.
}
\item{ngrid}{
The number of points in the regular grid used to plot the estimate.
For two- and three-dimensional data, \code{ngrid} refers to the number of points
along the axis in each dimension.
The same parameter is also used by a few other functions which perform some
form of search (e.g. \code{hcv}).
}
\item{panel}{
a logical value which controls the appearance of a panel display, in the
case of one- or two-dimensional data.  The panel can be used to alter the
value of the smoothing parameter.  For one-dimensional data it can also
launch an animation, and superimpose a normal reference band.  This argument 
does not apply with three-dimensional data.
}
\item{pch}{
the standard plottig charater identfier for data plotting. Default: \code{pch=1}.
}
\item{phi}{
the vertical rotation (in radians) of the contour plot of the density
estimate from three-dimensional data.  The default value is \eqn{\pi/4}{pi/4}.
}
\item{poly.index}{
an integer defining local constant (0) or local linear (1) smoothing.
(default value is 1)
}
\item{positive}{
a logical value which indicates whether the data should be assumed to take
positive values only.  When this argument is set to \code{TRUE}, a log transformation
is applied to the data before construction of a density estimate.  The result
is transformed back to the original scale.  This argument does not apply with 
three-dimensional data. Default: \code{positive=FALSE}.
}
\item{props}{
a vector defining the proportions of the data to be included within each
contour in a slice plot, from two-dimensional data, or a contour surface
plot, from three-dimensional data.  In the three-dimensional case only
the first element of the vector will be used.  This argument does not apply 
to one-dimensional data.  Default is \code{c(75,50,25)}.
}
\item{rugplot}{
Logical flag which regulates whetehr a rugplot is superimposed to the
density estimate, in the univariate case. Dafault: \code{rugplot=TRUE}.
}
\item{test}{
a logical flag controlling the production of a formal test, using the 
reference model as the null hypothesis. Defaul: \code{test=TRUE}.
}
\item{theta}{
the horizontal rotation (in radians) of the contour plot of the density
estimate from three-dimensional data.  The default value is \eqn{\pi/4}{pi/4}.
}
\item{xlab}{
the label attached to the x-axis.
}
\item{xlim}{
the range of the horizontal axis of the plot.  This argument does not apply
with three-dimensional data.
}
\item{yht}{
the upper limit of the vertical axis in a plot of a one-dimensional density
estimate.  The lower limit is always set to 0.  This argument does not apply 
with two- or three-dimensional data.
}
\item{ylab}{
the label attached to the y-axis. 
}
\item{ylim}{
the range of the vertical axis of the plot.  This argument does not apply 
with three-dimensional data.
}
\item{zlab}{
the label attached to the z-axis (three-dimensional plots only)
}}}}
\value{
a list with  the updated values of the parameters; if the argument list
is not empty, the returned list is invisible.
}
\details{
the parameter values set via a call to this function will remain in effect
for the rest of the session, affecting the subsequent behaviour of the other 
functions of the \code{sm} library for which the given parameters are relevant.

This offers the possibility of customizing the functioning of the \code{sm}
library, for instance by insertions of approriate calls to \code{sm.options}
in \code{.First}. However, assignements of \code{sm.options} are done at frame 0,
hence this must be done using a call as shown in the example below.
}
\examples{
\dontrun{sm.options(poly.index=0)
# subsequent regression estimations will be performed using local means
# instead of local regression
#
sm.options(describe=F)  
# turns off typing documentation files of data loaded by `sm.script'
# (works from command-line)
# 
assign(".sm.Options", sm.options(describe = FALSE), envir=.GlobalEnv)
# this line can be inserted in `.First' for permanent customisation
}}
\keyword{nonparametric}
\keyword{smooth}
% Converted by Sd2Rd version 1.15.

\eof
\name{sm.poisson}
\alias{sm.poisson}
\title{
Nonparametric Poisson regression
}
\description{
This function estimates the regression curve using the local likelihood
approach for a vector of Poisson observations and an associated vector
of covariate values.
}
\usage{
sm.poisson(x, y, h, \dots)
}
\arguments{
\item{x}{
vector of the covariate values
}
\item{y}{
vector of the response values; they must be nonnegative integers.
}
\item{h}{
the smoothing parameter; it must be positive.
}
\item{\dots}{
other optional parameters are passed to the \code{sm.options} function, through
a mechanism which limits their effect only to this call of the function; 
those relevant for this function are the following:
\itemize{
\item{add}{
if graphical output is produced, this parameter controls whether a 
new plot is created, or graphical output is added to the existing one.
}
\item{col}{
colour used for plotting curves and points. Default: \code{col=1}.
}
\item{display}{
controls the type of graphical output; possible values are
\code{"estimate"} (default), \code{"se"}, \code{"none"}.
}
\item{eval.points}{
the vector of points on the \code{x} axis where the regression must be
estimated. If the parameter \code{eval.points} is not given, this vector
is chosen to be formed by \code{ngrid} equally spaced points between
\code{min(x)} and \code{max(x)}.
}
\item{nbins}{
The number of bins used when binning operation is performed.
If \code{nbins=0}, binning is not performed; if \code{nbins=NA} (default),
binning is switched on when the number of design points exceeds 100.
}
\item{ngrid}{
the number of points where the regression curve must be estimated
(only used if \code{eval.points} is not given). Default: \code{ngrid=25}.
}
\item{pch }{
plotting character of the raw observed frequency. Default: \code{pch=1}.
}
\item{xlab}{
label of the x-axis. Default is the name of \code{x} object.
}
\item{ylab}{
label of the y-axis .Default is the name of \code{y} object.
}}}}
\value{
A list containing vectors with the evaluation points, the corresponding
probability estimates, the linear predictors, the upper and lower points
of the variability bands  and the standard errors on the linear predictor 
scale.
}
\section{Side Effects}{
graphical output will be produced, depending on the value of the
\code{display} parameter.
}
\details{
see Sections 3.4 and 5.4 of the reference below.
}
\references{
Bowman, A.W. and Azzalini, A. (1997).
\emph{Applied Smoothing Techniques for Data Analysis: }
\emph{the Kernel Approach with S-Plus Illustrations.}
Oxford University Press, Oxford.
}
\seealso{
\code{\link{sm.binomial}}, \code{\link{sm.binomial.bootstrap}}, \code{\link{binning}}, \code{\link{glm}}
}
\examples{
\dontrun{sm.poisson(exposure.time, N.events, 0.5, display="se")}
}
\keyword{nonparametric}
\keyword{smooth}
% Converted by Sd2Rd version 1.15.

\eof
\name{sm.poisson.bootstrap}
\alias{sm.poisson.bootstrap}
\title{
Bootstrap goodness-of-fit test for a Poisson regression model
}
\description{
This function is associated with \code{sm.poisson} for the underlying fitting
procedure.
It performs a Pseudo-Likelihood Ratio Test for the goodness-of-fit of
a standard parametric Poisson regression of specified \code{degree} in the
covariate \code{x}.
}
\usage{
sm.poisson.bootstrap(x, y, h, nboot=100, degree=1, \dots)
}
\synopsis{
sm.poisson.bootstrap(x, y, h, nboot = 99, degree = 1,
                     fixed.disp = FALSE, intercept = TRUE,
                     family = poisson(link = log), ...)
}
\arguments{
\item{x}{
vector of the covariate values
}
\item{y}{
vector of the response values; they must be nonnegative integers.
}
\item{h}{
the smoothing parameter; it must be positive.
}
\item{nboot}{
number of bootstrap samples (default=100).
}
\item{degree}{
specifies the degree of the fitted polynomial in \code{x} on the logit scale
(default=1).
}
\item{\dots}{
additional parameters passed to \code{\link{sm.poisson}}.
}}
\value{
a list containing the observed value of the Pseudo-Likelihood Ratio Test
statistic, its observed p-value as estimated via the bootstrap method,
and the vector of estimated dispersion parameters when this value is not 
forced to be 1.
}
\section{Side Effects}{
Graphical output representing the bootstrap samples is produced on 
the current graphical device. 
The estimated dispersion parameter, the value of the test statistic
and the observed significance level are printed.
}
\details{
see Section 5.4 of the reference below.
}
\references{
Bowman, A.W. and Azzalini, A. (1997). 
\emph{Applied Smoothing Techniques for Data Analysis: }
\emph{the Kernel Approach with S-Plus Illustrations.}
Oxford University Press, Oxford.
}
\seealso{
\code{\link{sm.poisson}}, \code{\link{sm.binomial.bootstrap}}
}
\examples{
## takes a while: extend sm.script(muscle)
provide.data(muscle, options=list(describe=FALSE))
TypeI <- TypeI.P + TypeI.R + TypeI.B
sm.poisson.bootstrap(log(TypeI), TypeII, h = 0.5)
}
\keyword{nonparametric}
\keyword{smooth}
\keyword{htest}
\keyword{models}

\eof
\name{sm.regression}
\alias{sm.regression}
\alias{sm.regression.1d}
\alias{sm.regression.2d}
\alias{sm.regression.eval.1d}
\alias{sm.regression.eval.2d}
\alias{sm.regression.test}
\title{
Nonparametric regression with one or two covariates.
}
\description{
This function creates a nonparametric regression estimate from data 
consisting of a single response variable and one or two covariates.
With one covariate, an interactive panel can be activated
to control the smoothing parameter.  In two dimensions a perspective
plot of the estimated regression surface is produced.  A number of other 
features of the construction of the estimate, and of its display, can be 
controlled.
}
\usage{
sm.regression(x, y, h, design.mat = NA, model = "none", test = TRUE, 
              weights = rep(1, nobs), \dots)
}
\arguments{
\item{x}{
a vector, or two-column matrix, of covariate values.
}
\item{y}{
a vector of reponses.
}
\item{h}{
a vector of length 1 or 2 giving the smoothing parameter.  A normal kernel
function is used and \code{h} is its standard deviation.
}
\item{design.mat}{
the design matrix used to produce \code{y} when these are assumed to be the 
residuals from a linear model.  
}
\item{model}{
a character variable which defines a reference model.  The values
\code{"none"}, \code{"no effect"} and \code{"linear"} are possible.
}
\item{test}{
a logical flag controlling the production of a formal test, using the 
reference model as the null hypothesis.
}
\item{weights}{
a vector which allows the kernel functions associated with the observations 
to take different weights.  This is useful, in particular, when different
observations have different precisions.  This argument applies only to the
case of one covariate.
Use of this parameter is incompatible with binning; hence \code{nbins} must 
then be set to 0 or left at its default value \code{NA}.
}
\item{\dots}{
other optional parameters are passed to the \code{sm.options} function, through
a mechanism which limits their effect only to this call of the function; 
those relevant for this function are the following:
\itemize{
\item{display}{
The setting \code{"none"} will prevent any graphical output from being produced.
With one covariate, the default setting \code{"lines"} will produce the density
estimate, while the setting \code{"se"} will in addition produce a variability
band, showing the variability, but not the bias, of the estimate.  In two
dimensions, the default setting \code{"persp"} will produce a perspective plot
of the estimate.
}
\item{hmult}{
a factor which can be used to multiply the smoothing parameter
before construction of the nonparametric regression estimate.
}
\item{h.weights}{
a vector of weights which multiply the smoothing parameter used in the
kernel function at each observation. 
}
\item{poly.index}{
an integer defining local constant (0) or local linear (1) smoothing.
}
\item{band}{
a logical flag controlling the production of a reference band for the 
reference model.  A band will be produced only when there is a single
covariate and two groups.
}
\item{add}{
a logical value which controls whether the estimate is added to
the current plot.  Its default value is \code{F}, which creates a new plot.
This argument applies only with one covariate.
}
\item{ngrid}{
the number of points in the regular grid used to plot the estimate.
With two covariates, \code{ngrid} refers to the number of points
along the axis in each dimension.
Default:  50 and 20 for 1-, 2-dimensional data, respectively.
}
\item{eval.points}{
the points at which the estimate should be evaluated, for the
values returned in the result of the function.  This should be a vector
for one covariate and a two-column matrix for two covariates.
}
\item{xlab}{
the label attached to the x-axis.
}
\item{ylab}{
the label attached to the y-axis.
}
\item{zlab}{
the label attached to the z-axis (two covariate case only).
}
\item{hull}{
a logical value which controls whether the estimate is evaluated and plotted
only on grid points which fall within the convex hull of the data.  When
this argument is set to \code{FALSE}, evaluation and plotting take place at all grid 
points where the contribution from at least one kernel function is 
non-negligible.  Both of these settings ensure that the estimate is not 
evaluated at points where there are no observations nearby.  This argument 
applies only to the case of two covariates.
}
\item{panel}{
a logical value which controls the appearance of a panel display, in the
case of one covariate.  The panel can be used to alter the value of the 
smoothing parameter and in particular it can launch an animation.
}
\item{lty}{
the line type used to plot the estimate.  This argument applies only with 
one covariate.
}
\item{col}{
an integer defining the colour used to plot the estimate.  This argument 
applies only with one covariate.
}
\item{eye.mult}{
a vector of length 3 defining the eye position for the perspective plot
in the two covariate case.  The interpretation of this argument is similar
to the argument \code{eye} in the \code{persp} function.  Here the argument
is automatically scaled to adjust for the different axis scalings.
}}}}
\value{
a list containing the values of the estimate at the evaluation points,
the smoothing parameter and the smoothing parameter weights.  If a reference
model has been specified and \code{test} set to \code{T}, then the p-value of the test
is also returned.  When there is only one covariate, the weights associated
with different obserations, an estimate of the error standard deviation and 
the standard error of the estimate are also returned.  If a reference model 
has been specified, this standard error refers to the comparison between 
the estimate and the reference model, and the values defining the reference 
model are also returned.
}
\section{Side Effects}{
a plot on the current graphical device is produced, unless \code{display="none"}.
}
\details{
see Chapters 3, 4 and 5 of the reference below.
}
\references{
Bowman, A.W. and Azzalini, A. (1997). 
\emph{Applied Smoothing Techniques for Data Analysis: }
\emph{the Kernel Approach with S-Plus Illustrations.}
Oxford University Press, Oxford.
}
\seealso{
\code{\link{hcv}}, \code{\link{sm}}, \code{\link{sm.ancova}}, \code{\link{sm.binomial}}, \code{\link{sm.poisson}}, \code{\link{sm.regression.autocor}},
\code{\link{sm.survival}}, \code{\link{sm.options}}
}
\examples{
#  An example with one covariate
x <- runif(100,-2, 2)
y <- x^2 + rnorm(50)
sm.regression(x, y, h=0.5)


#  An example with one covariate
x <- cbind(runif(100,-2, 2), runif(100,-2, 2))
y <- x[,1]^2 + x[,2]^2 + rnorm(50)
sm.regression(x, y, h=c(1,1))
}
\keyword{nonparametric}
\keyword{regression}
\keyword{smooth}
% Converted by Sd2Rd version 1.15.

\eof
\name{sm.regression.autocor}
\alias{sm.regression.autocor}
\title{
Nonparametric regression with autocorrelated errors
}
\description{
This function estimates nonparametrically the regression function
of \code{y} on \code{x} when the error terms are serially correlated.
}
\usage{
sm.regression.autocor(x=1:n, y, h.first, minh, maxh, method="direct", \dots)
}
\arguments{
\item{y}{
vector of the response values
}
\item{h.first}{
the smoothing parameter used for the initial smoothing stage.
}
\item{x}{
vector of the covariate values; if unset, it is assumed to be \code{1:length(y)}.
}
\item{minh}{
the minimum value of the interval where the optimal smoothing parameter
is searched for (default is 0.5).
}
\item{maxh}{
the maximum value of the interval where the optimal smoothing parameter
is searched for (default is 10).
}
\item{method}{
character value which specifies the optimality criterium adopted;
possible values are \code{"no.cor"}, \code{"direct"} (default), and \code{"indirect"}.
}
\item{\dots}{
other optional parameters are passed to the \code{sm.options} function, through
a mechanism which limits their effect only to this call of the function; 
those relevant for this function are the following:
\itemize{
\item{ngrid}{
the number of points to be considered in \code{(minh,maxh)}. Default: \code{ngrid=15}.
}
\item{display}{
if this is not equal to \code{"none"}, graphical output is produced on the
current graphical device.
}}}}
\value{
a list as returned from sm.regression called with the new value of
smoothing parameter, with an additional term \code{$aux} added which contains
the initial value \code{h.first}, the estimated curve using \code{h.first}, 
the autocorrelation function of the residuals from the initial fit, 
and the residuals.
}
\section{Side Effects}{
a new suggested value for \code{h} is printed; also, if the parameter \code{display}
is not equal to \code{"none"}, graphical output is produced on the current 
graphical device.
}
\details{
see Section 7.5 of the reference below.
}
\references{
Bowman, A.W. and Azzalini, A. (1997). 
\emph{Applied Smoothing Techniques for Data Analysis: }
\emph{the Kernel Approach with S-Plus Illustrations.}
Oxford University Press, Oxford.
}
\seealso{
\code{\link{sm.regression}}, \code{\link{sm.autoregression}}
}
\keyword{nonparametric}
\keyword{smooth}
\keyword{regression}
% Converted by Sd2Rd version 1.15.

\eof
\name{sm.rm}
\alias{sm.rm}
\title{
Nonparametric analysis of repeated measurements data
}
\description{
This function estimates nonparametrically the mean profile from a matrix
\code{y} which is assumed to contain repeated measurements (i.e. longitudinal
data) from a set of individuals.
}
\usage{
sm.rm(Time, y, minh=0.1, maxh=2, optimize=FALSE,
      rice.display=FALSE, \dots)
}
\arguments{
\item{y}{
matrix containing the values of the response variable, with rows associated 
to individuals and columns associated to observation times.
}
\item{Time}{
a vector containing the observation times of the response variable, assumed 
to be the same for all individuals of matrix \code{y}. 
If \code{Time} is not given, this is assumed to be \code{1:ncol(y)}.
}
\item{minh}{
the mimimum value of the interval where the optimal value of the smoothing
parameter is seached according to the modified Rice criterion.
See reference below for details.
}
\item{maxh}{
the maximum value of the above interval.
}
\item{optimize}{
  Logical value, default is \code{optimize=FALSE}. If
  \code{optimize=TRUE}, then a full 
  optimization is performed after searching the interval \code{(minh,maxh)}
  using the optimizer \code{optim}.
}
\item{rice.display}{
  If this set to \code{TRUE} (default is \code{FALSE}), a plot is
  produced of the curve 
  representing the modified Rice criterion for bandwidth selection. 
  See reference below for details.
}
\item{\dots}{
  other optional parameters are passed to the \code{sm.options}
  function, through a mechanism which limits their effect only to this
  call of the function; those relevant for this function are the following:
  \itemize{
    \item{add}{
      logical value, default is \code{add=FALSE}. If \code{add=TRUE} and
      display is not set to \code{"none"}, then graphical output added
      to the existing plot, rather than starting a new one.
    }
    \item{display}{
      character value controlling the amount of graphical output of the estimated 
      regression curve. It has the same meaning as in \code{sm.regression}. 
      Default value is \code{display="lines"}.
    }
    \item{ngrid}{
      the number of divisions of the above interval to be considered. 
      Default: \code{ngrid=20}.
    }
    \item{poly.index}{
      overall degree  of  locally-fitted  polynomial, as used by
      \code{sm.regression}. Default: \code{ngrid=1}.
}}}}
\value{
a list containing the returned value produced by \code{sm.regression} when 
smoothing the mean response value at each given observation time, 
with an extra component \code{$aux} added to the list.
This additional component  is a list itself containing the mean value at each 
observation time, the residual variance of the residuals from the estimated 
regression curve,  the autocorrelation function of the residuals, and 
the value \code{h} of the chosen smoothing parameter. 
}
\section{Side Effects}{
if the parameter display is not set to \code{"none"}, a plot of the estimated 
regression curve is produced; 
other aspects are controlled by the optional parameters (\code{\dots}). 
If \code{rice.display=TRUE}, a plot of the modified Rice criterion is shown.
}
\details{
see Section 7.4 of the reference below.
}
\references{
Bowman, A.W. and Azzalini, A. (1997). 
\emph{Applied Smoothing Techniques for Data Analysis: }
\emph{the Kernel Approach with S-Plus Illustrations.}
Oxford University Press, Oxford.
}
\seealso{
\code{\link{sm.regression}}, \code{\link{sm.regression.autocor}}, \code{\link{optim}}
}
\examples{
provide.data(citrate, options=list(describe=FALSE))
provide.data(dogs, options=list(describe=FALSE))
a <- sm.rm(y=citrate, display.rice=TRUE)
#
Time <- seq(1,13,by=2)
gr1  <- as.matrix(dogs[dogs$Group==1,2:8])
plot(c(1,13), c(3,6),xlab="time", ylab="potassium", type="n") 
sm1  <- sm.rm(Time, gr1, display="se", add=TRUE)
}
\keyword{nonparametric}
\keyword{smooth}
% Converted by Sd2Rd version 1.15.

\eof
\name{sm.script}
\alias{sm.script}
\title{
Running a script associated to the sm library
}
\description{
This is a utility function to run scripts, usually those associated 
to the book described below. 
}
\usage{
sm.script(name, path)
}
\arguments{
\item{name}{
the name of the file containing the code; a \code{.q} suffix will be appended
to the name. If \code{name} is missing, a list of the scripts associated to
the \code{sm} library will be displayed.
}
\item{path}{
the name of the path where to look for the script. If \code{path} is missing,
it is assumed to be the appropriate location for the scripts of the \code{sm}
library.
}}
\details{
This utility allows to reproduce easily the illustrations of the refernce 
below, since each of them is associated to an available script.
}
\references{
Bowman, A.W. and Azzalini, A. (1997). 
\emph{Applied Smoothing Techniques for Data Analysis: }
\emph{the Kernel Approach with S-Plus Illustrations.}
Oxford University Press, Oxford.
}
\seealso{
\code{\link{sm}},
}
\examples{
sm.script()
sm.script(speed)
}
\keyword{utilities}
% Converted by Sd2Rd version 1.15.

\eof
\name{sm.sphere}
\alias{sm.sphere}
\alias{latlines}
\alias{longlines}
\alias{latlines.e}
\alias{longlines.e}
\alias{sphdraw}
\alias{sphimage}
\title{
Nonparametric density estimation for spherical data.
}
\description{
This function creates a density estimate from data which can be viewed
as lying on the surface of a sphere.  Directional data form a principal
example.  The data are displayed in spherical form and a density estimate
may be superimposed.  The angle of view may be altered.  An interactive 
panel is available to control some features of the estimate and the display.
Only modest amounts of data may be used.  The limit will depend on the
memory available.
}
\usage{
sm.sphere(lat, long, kappa = 20, hidden=FALSE, sphim=FALSE,
          addpoints=FALSE, \dots)
}
\synopsis{
sm.sphere(lat, long, kappa = 20, hidden = FALSE, sphim = FALSE,
          addpoints = FALSE, ...)
}
\arguments{
  \item{lat}{
    a vector giving the latitude component of the data in degrees from the 
    equator.
  }
  \item{long}{
    a vector giving the longitude component of the data in degrees east.
  }
  \item{kappa}{
    the smoothing parameter used to construct the density estimate.  The kernel
    function is a Fisher distribution and \code{kappa} is its scale parameter.
    Larger values of \code{kappa} will produce smaller amounts of smoothing.
  }
  \item{hidden}{
    a logical value which, when set to \code{TRUE}, will display the points which lie
    on the rear side of the displayed sphere.  This argument will be ignored
    if \code{sphim} is set to \code{TRUE}.
  }
  \item{sphim}{
    a logical value which controls whether a density estimate is constructed
    and displayed on the sphere in image form.
  }
  \item{addpoints}{
    a logical value which controls whether the data points are added to the
    plot of the density estimate.
  }
  \item{\dots}{
    arguments for \code{\link{sm.options}}.
  }
}
\value{
a list containing the value of the smoothing parameter and the rotation 
angles of the displayed plot.
}
\section{Side Effects}{
none.
}
\details{
see Section 1.5 of the reference below.
}
\references{
Bowman, A.W. and Azzalini, A. (1997). \emph{Applied Smoothing Techniques for
Data Analysis: the Kernel Approach with S-Plus Illustrations.}
Oxford University Press, Oxford.
}
\seealso{
\code{\link{sm.density}}
}
\examples{
lat  <- rnorm(50, 10, 15)
long <- c(rnorm(25, 300, 15), rnorm(25, 240, 15))
par(mfrow=c(1,2))
sm.sphere(lat, long)
sm.sphere(lat, long, sphim=TRUE, kappa=15)
par(mfrow=c(1,1))
}
\keyword{nonparametric}
\keyword{smooth}
% Converted by Sd2Rd version 1.15.

\eof
\name{sm.survival}
\alias{sm.survival}
\title{
Nonparametric regression with survival data.
}
\description{
This function creates a smooth, nonparametric estimate of the quantile
of the distribution of survival data as a function of a single covariate.
A weighted Kaplan-Meier survivor function is obtained by smoothing across 
the covariate scale.  A small amount of smoothing is then also applied across 
the survival time scale in order to achieve a smooth estimate of the quantile.
}
\usage{
sm.survival(x, y, status, h , hv = 0.05, p = 0.5, status.code = 1, \dots)
}
\arguments{
\item{x}{
a vector of covariate values.
}
\item{y}{
a vector of survival times.
}
\item{status}{
an indicator of a complete survival time or a censored value.  The value of
\code{status.code} defines a complete survival time.
}
\item{h}{
the smoothing parameter applied to the covariate scale.  A normal kernel
function is used and \code{h} is its standard deviation.
}
\item{hv}{
a smoothing parameter applied to the weighted Kaplan-Meier functions derived
from the smoothing procedure in the covariate scale.  This ensures that
a smooth estimate is obtained.
}
\item{p}{
the quantile to be estimated at each covariate value.
}
\item{status.code}{
the value of \code{status} which defines a complete survival time.
}
\item{\dots}{
other optional parameters are passed to the \code{sm.options} function, through
a mechanism which limits their effect only to this call of the function; 
those relevant for this function are the following:
\itemize{
\item{eval.points}{
the points at which the estimate will be evaluated.
}
\item{ngrid}{
the number of points in a regular grid over the covariate scale at which
the estimate will be evaluated, if \code{eval.points} is set to \code{NA}.
Default: \code{ngrid=50}.
}
\item{display}{
The setting \code{"none"} will prevent any graphical output from being produced.  
The default setting \code{"lines"} (or indeed any other value) will produce a
plot of the data and estimate.
}
\item{xlab}{
the label attached to the x-axis.
}
\item{ylab}{
the label attached to the y-axis.
}
\item{lty}{
the line type used to plot the estimate.
}
\item{add}{
a logical value which controls whether the estimate is added to
the current plot.  Its default value is \code{FALSE}, which creates a new plot.
}}}}
\value{
a list containing the values of the estimate at the evaluation points
and the values of the smoothing parameters for the covariate and survival
time scales.
}
\section{Side Effects}{
none.
}
\details{
see Section 3.5 of the reference below.
}
\references{
Bowman, A.W. and Azzalini, A. (1997). 
\emph{Applied Smoothing Techniques for Data Analysis: }
\emph{the Kernel Approach with S-Plus Illustrations.}
Oxford University Press, Oxford.
}
\seealso{
\code{\link{sm.regression}}, \code{\link{sm.options}}
}
\examples{
x <- runif(50, 0, 10)
y <- rexp(50, 2)
z <- rexp(50, 1)
status <- rep(1, 50)
status[z<y] <- 0
y <- pmin(z, y)
sm.survival(x, y, status, h=2)
}
\keyword{nonparametric}
\keyword{smooth}
\keyword{survival}
% Converted by Sd2Rd version 1.15.

\eof
\name{sm.ts.pdf}
\alias{sm.ts.pdf}
\title{
Nonparametric density estimation of stationary time series data
}
\description{
This function estimates the density function of a time series \code{x},
assumed to be stationary. The univariate marginal density is estimated
in all cases; bivariate densities of pairs of lagged values are estimated
depending on the parameter \code{lags}.
}
\usage{
sm.ts.pdf(x, h = hnorm(x), lags, maxlag=1, ask=TRUE)
}
\arguments{
\item{x}{
a vector containing a time series
}
\item{h}{
bandwidth
}
\item{lags}{
  for each value, \code{k} say, in the vector \code{lags} a density
  estimate is produced
  of the joint distribution of the pair \code{(x(t-k),x(t))}.
}
\item{maxlag}{
  if \code{lags} is not given, it is assigned the value \code{1:maxlag}
  (default=1).
}
\item{ask}{
  if \code{ask=TRUE}, the program pauses after each plot, until <Enter>
  is pressed.
}
\item{\dots}{
additional graphical parameters
}}
\value{
a list of two elements, containing the outcome of the estimation of 
the marginal density and the last bivariate density, as produced by 
\code{sm.density}.
}
\section{Side Effects}{
plots are produced on the current graphical device.
}
\details{
see Section 7.2 of the reference below.
}
\references{
Bowman, A.W. and Azzalini, A. (1997). \emph{Applied Smoothing Techniques for
Data Analysis: the Kernel Approach with S-Plus Illustrations.}
Oxford University Press, Oxford.
}
\seealso{
\code{\link{sm.density}}, \code{\link{sm.autoregression}}
}
\examples{
data(geyser)
a <- sm.ts.pdf(geyser$duration,lags=1:2)
}
\keyword{nonparametric}
\keyword{smooth}
\keyword{ts}
% Converted by Sd2Rd version 1.15.

\eof
