### Name: sm.density
### Title: Nonparametric density estimation in one, two or three
###   dimensions.
### Aliases: sm.density sm.density.1d sm.density.2d sm.density.3d
###   sm.density.eval.1d sm.density.eval.2d sm.density.positive.1d
###   sm.density.positive.2d sm.density.positive.grid
### Keywords: nonparametric smooth

### ** Examples

#  A one-dimensional example
y <- rnorm(50)
sm.density(y, model = "Normal")

#  A two-dimensional example
y <- cbind(rnorm(50), rnorm(50))
sm.density(y, display = "image")

#  A three-dimensional example
y <- cbind(rnorm(50), rnorm(50), rnorm(50))
sm.density(y)



