\name{MouseArray}
\alias{MouseArray}
\alias{mouse1}
\alias{mouse2}
\alias{mouse3}
\alias{mouse4}
\alias{mouse5}
\alias{mouse6}
\alias{mouse.gnames}

\title{Mouse Gene Expression Data from cDNA microarray}

\description{
"MouseArray" consists of 6 different outputs from a cDNA microarray
slide.  The first 3 data (mouse1, mouse2 and mouse3) represent control
hybridization and the other 3 data (mouse4, mouse5 and mouse6)
represent treatment hybridizations.  We have also included vector character
strings representing gene names. 
}

\usage{data(MouseArray)}

\note{For the time being, we are providing a cut-down version of the
  full data set with only partial sets of genes included.  These are
  mainly included to demonstrate the use of the functions in this library.
}

\source{Callow, M. J., Dudoit, S., Gong, E. L., Speed, T. P and Rubin,
  E. M.,  Microarray expression profiling identifies genes with altered 
expression in HDL deficient mice, submitted}

\keyword{datasets}



\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:18:12.
% Do NOT modify this file, instead modify the source (sma/R/Rmisc.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{id2image}

\alias{id2image}
\alias{image2id}
 
\title{Converting an id tag to a Set of Image Coordinates and Vice Versa}

\description{
 The function \code{id2image} converts an id tag of a gene supplied
 by a user into a set of image coordinates regarding the location of
 the gene being 
 considered. Conversion of image coordinates to an id tag is performed
 by \code{image2id}.
}

\usage{
id2image(X, layout)
image2id(x, layout)
}

\arguments{
 \item{X}{an integer value representing the id of a particular gene}
 \item{layout}{}
 \item{x}{a vector of 4 integer elements which make up the image
   coordinates of the gene.}
}
\details{
The image coordinates of a gene correspond to the gene's grid row and
grid column position within a slide, and the gene's row and column
position within a grid.  
}

\value{
  \code{id2image} returns a vector of 4 integer elements which is
  the set of image coordinates. 
  \code{image2id} returns an integer value which is the gene's id tag.
}

\author{Yee Hwa Yang, \email{yeehwa@stat.berkeley.edu}}

\seealso{\code{\link{MouseArray}}}

\examples{data(MouseArray)
# mouse.setup <- init.grid()

id2image(1024, mouse.setup)
## You will see: [1]  1 3 11 16
## the grid in which gene 1024 can be found, is in row 1, column 3
## and the gene is located in row 11, column 16 of this particular grid.
 
image2id(c(2,4,6,8), mouse.setup)
## You will see: [1] 2906
## the gene located in row 6, column 8 in the grid that is in row 2 and
## column 4 is the 2906th gene of the data set.  
}


\keyword{attribute}
%\keyword{image, id}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:17:34.
% Do NOT modify this file, instead modify the source (sma/R/Rinit.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


\name{init.addinfo}

\alias{init.addinfo}

\title{Adding Information to a Data Structure for Multi-slide
Microarray Experiments} 

\description{
  Interactive function which adds other information generated from the
  output of image analysis software for microarrays to the existing 
  data structure created using  \code{\link{init.data}}.  
}

\usage{
init.addinfo(batch, attri, dataname=NULL, ...)
}

\arguments{
  \item{batch}{Character string, this refers to the name of a
  collection of experiments.} 
  \item{attri}{Character string, the name of the information to be
    included in the data structure.  For example, from the output of
    \tt{Spot}, this argument can be "area", "signal to noise" etc.
    In other words, these are the column headings from the raw data set.}
   \item{dataname}{A name of your experimental data.  By default it's
      named "batch.exp" where batch is the name of the collection of
      experiments you are interested in.}
   \item{...}{Other arguments}
  }

\value{
 List containing the following component:
  
  \item{R}{contains the raw red intensities, R.}
  \item{G}{contains the raw green intensities, G.}
  \item{Rb}{contains the background red intensities, Rb.}
  \item{Gb}{contains the background green intensities, Gb.}
  as well as information from other users selected columns information.
}

\author{
  Yee Hwa Yang, \email{yeehwa@stat.berkeley.edu} \cr
  Natalie Roberts \email{nroberts@wehi.edu.au}
}

\examples{
## mouse.data <- init.addinfo("mouse", "area")
}

\section{Warning}{The code in the example is not directly executable as
  it draws upon a particular set of data. This data may be downloaded from
\url{http://www.stat.berkeley.edu/users/terry/zarray/Software/smacode.html}
and when loaded appropriately into the user's directory, this example  
should be executable in its current form. }   

%\keyword{microarray, quality information.}

\keyword{manip}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:17:34.
% Do NOT modify this file, instead modify the source (sma/R/Rinit.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{init.ctl.index}
\alias{init.ctl.index}
\title{Generates co-ordinates of spots.}
\description{
Generates the 4 co-ordinates of any spots.
}
\usage{
init.ctl.index(grows, gcols, srows, scols)
}
\arguments{
  \item{grows}{The row index of the grid.}
  \item{gcols}{The column index of the grid.}
  \item{srows}{The row index of the spot within the its grid.}
  \item{scols}{The column index of the spot within the its grid.}
}

\value{
  a matrix in which each row contains a vector of 4 integer elements
  which make up the image coordinates of a gene.
}

\examples{
   x <- init.ctl.index(1:4, 1:4, 1:2, 15:20)
## Generates the 4 co-ordinates index to spots in the first 2 rows,
## columns 15 to 20 of every print-tips groups.
}
\keyword{manip}

\author{Yee Hwa Yang, \email{yeehwa@stat.berkeley.edu}}

\note{Sorry: No help files yet}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:17:34.
% Do NOT modify this file, instead modify the source (sma/R/Rinit.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


\name{init.data}

\alias{init.data}

\title{Creating a Data Structure for Multi-slide Microarray Experiments}

\description{
Interactive function which creates a data structure for multi-slide
microarray experiments.  The data structure is a list of
matrices. For each spotted DNA sequence, the list stores raw red and
green signal intensities as well as red and green background
intensities. The function also allows the user to add data to an
existing structure. 
}

\usage{
init.data()
}

\arguments{
None.
}

\value{
  List containing the following components:
  \item{R}{contains the raw red intensities, R.}
  \item{G}{contains the raw green intensities, G.}
  \item{Rb}{contains the background red intensities, Rb.}
  \item{Gb}{contains the background green intensities, Gb.}
}

\author{
  Yee Hwa Yang, \email{yeehwa@stat.berkeley.edu} \cr
  Sandrine Dudoit, \email{sandrine@stat.berkeley.edu}
}

\examples{
## mouse.data <- init.data()

## Here is what you should see:
## Are you creating a new data matrix or adding new array data
## to a prexisting data matrix? 
## Enter "n" for creating and "a" for adding new array data: n
## Do the names of all your datasets have the following format: 
## prefix1, prefix2, prefix3?, ... Here prefix can be any name, 
## but the suffixes must be integers 1,2, ..., # of arrays. 
## Enter "y" for yes, "n" for no: y
## Enter the prefix:mouse
## Enter the number of arrays to be processed:6
## Enter the name of Cy3 raw data: Gmean
## Enter the name of Cy3 background: morphG
## Enter the name of Cy5 raw data: Rmean
## Enter the name of Cy5 background: morphR
## Finished creating new dataset.
}

\keyword{attribute}
%\keyword{microarray.}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:17:34.
% Do NOT modify this file, instead modify the source (sma/R/Rinit.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{init.grid}

\alias{init.grid}

\title{
Initialization of Grid Parameters}

\description{
Interactive function for specifying the dimensions of the spot
matrix and the grid matrix. These parameters depend on the printing
layout of the array, and are used for the within print-tip group
normalization implemented in \code{\link{stat.ma}} and the spatial
representation of spot statistics in \code{\link{plot.spatial}}. 
}

\usage{
init.grid()
}

\arguments{
None.
}

\value{list containing the following components
\item{nspot.r}{ the number of rows of spots per grid;}
\item{nspot.c}{ the number of columns of spots per grid;}
\item{ngrid.r}{ the number of rows of grids per image;}
\item{ngrid.c}{ the number of columns of grids per image.}
}

\references{
Spot manual.
}

\seealso{
\code{\link{plot.mva}}, \code{\link{plot.spatial}},
\code{\link{stat.ma}}, \code{\link{list}}. 
}


\author{
  Yee Hwa Yang, \email{yeehwa@stat.berkeley.edu} \cr
  Sandrine Dudoit, \email{sandrine@stat.berkeley.edu}
}

\examples{
data(MouseArray)
# mouse.setup <- init.grid()

## Here is what you should see:
# Enter number of rows of grids per image (ngrid.r): 4
# Enter number of columns of grids per image (ngrid.c): 4
# Enter number of rows of spots per grid (nspot.r): 19  
# Enter number of columns of spots per grid (nspot.c): 21
# Initialization complete
}

\keyword{misc}
%\keyword{microarray, grid.}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:17:34.
% Do NOT modify this file, instead modify the source (sma/R/Rinit.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


\name{init.names}

\alias{init.name.exp}
\alias{init.show.exp}

\title{Set and Read the Names of Experimental Data.}
\description{
  `init.name.exp' creates a look-up table which contains the names of the
  experimental data files and the corresponding object names in R. \cr
  `init.show.exp' displays the look-up table created by
  \code{init.name.exp}.
}

\usage{
init.name.exp(Robject=FALSE)
init.show.exp(batch)
}

\arguments{
 \item{Robject}{if TRUE, the function generates a matrix of characters.
   Otherwise, this matrix is written to a file.}
 \item{batch}{Character string, this refers to the name of a
 collection of experiments.}  
} 

\value{
  \code{init.show.exp} returns a list containing the following components:
  \item{Name in R}{the object names in R;}
  \item{Filename}{the experimental data filenames, including the full
    path name for each file.} 
}
\references{Spot manual
\url{http://www.cmis.csiro.au/iap/Spot/spotmanual.htm}}
  
\author{Yee Hwa Yang, \email{yeehwa@stat.berkeley.edu}}


\examples{
## init.name.exp() ## To create the look-up table.

## This is what you should see:
## Are you creating a new batch.exp file or adding new data names
## to a prexisting batch.exp file? 
## Enter "n" for creating  and "a" for adding new data names: n
## Enter the batch name for the new .exp file: mouse1
## Enter the number of names of files to be entered: 2
##  Enter the R name of your  1 th dataset: m1
##  Enter the actual file name including the full path name for m1 ?
##  ~/path/image1.data 
##  Enter the R name of your  2 th dataset: m2
##  Enter the actual file name including the full path name for m2 ?
##  ~/path/image2.data 
## Finished adding names to .exp file.
## NULL

## View the look-up table.
## init.show.exp("mouse1") 
## 
##    Name in R           Filename
## 1        m1    ~/path/image1.data
## 2        m2    ~/path/image2.data
}

\keyword{attribute}
%\keyword{filename}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:17:34.
% Do NOT modify this file, instead modify the source (sma/R/Rinit.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


\name{init.read.exp}
\alias{init.read.exp}

\title{Reads the Output of the Computed Statistics}

\description{
  Function displays the 30 measurements computed by the program Spot for
  each gene in the slide being considered.} 

\usage{
init.read.exp(batch, imageid, sep="\t", header=TRUE, ...)}

\arguments{
 \item{batch}{batch name of the experiment}
 \item{imageid}{integer value; the index of the slide which is considered}
 \item{sep}{the field separator character; the columns of the file
 will be separated by this character.} 
 \item{header}{a logical value indicating whether the file contains the
   names of the variables as its first line.}
 \item{\dots}{graphical parameters may also be supplied as arguments to
   the function (see \code{\link{par}}).}
}

\value{
  A matrix containing the 30 columns of computed measurements,
  corresponding to the rows of different genes in the specified
  slide. \cr Details regarding these measurements can be found at
  \url{http://www.cmis.csiro.au/iap/Spot/spotoutput.htm}.}

\references{Spot manual
\url{http://www.cmis.csiro.au/iap/Spot/spotmanual.htm}}.
} 

\author{Yee Hwa Yang, \email{yeehwa@stat.berkeley.edu}}

\examples{
## apoa1.info <- init.read.exp("apoa1", 1) ## obtains the matrix
## of 30 measurements for all the genes spotted on slide 1 of the MouseArray
## experiment.}

\section{Warning}{The code in the example is not directly executable as
  it draws upon a particular set of data. This data may be downloaded from
  \url{http://www.stat.berkeley.edu/users/terry/zarray/Software/smacode.html}
and when loaded appropriately into the user's directory, this
example should be executable in its current form.} 

\keyword{file}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:18:12.
% Do NOT modify this file, instead modify the source (sma/R/Rmisc.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{is.odd}
\alias{is.odd}
\alias{is.even}

\title{ Determining if a Value is Odd or Even }
\description{
A logical flag which determines if a value supplied by the user is
odd or even. 
}
\usage{
is.odd(x)
is.even(x)
}

\arguments{
 \item{x}{integer value}
}

}
\value{Logical vectors \code{TRUE} or \code{FALSE} are returned
  depending on whether the value is odd or even.

}

\author{ Jessica Mar }

\examples{
is.odd(4)
## FALSE
is.even(100)
## TRUE
}

\keyword{logic}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:18:19.
% Do NOT modify this file, instead modify the source (sma/R/Rna.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{na}

\alias{log.na}
\alias{sum.na}
\alias{mean.na}
\alias{var.na}
\alias{cor.na}
\alias{quantile.na}
\alias{length.na}
\alias{order.na}
\alias{scale.na}
\alias{prod.na}

\title{Basic Statistical Functions for Handling Missing Values}

\description{
Basic statistical functions for handling missing values or NA. \cr 
In \code{log.na}, \code{sum.na}, \code{mean.na} and \code{var.na},
\code{quantile.na}, \code{length.na}, missing values are omitted
from the calculation. \cr 
The function \code{cor.na} calls \code{cor} with the argument
\code{use="pairwise.complete.obs"}. \cr 
The function \code{order.na} only handles vector arguments and not
lists.  However, it gives the option of omitting the NAs
(\code{na.last=NA}), of placing the NAs at the start of the ordered
vector (\code{na.last=F}) or at the end (\code{na.last=T}). \cr 
The function \code{scale.na} is a modified version of
\code{\link{scale}} which allows NAs in the variance calculation. If
\code{scale = T}, the function \code{f} in \code{scale.na} uses
\code{var.na} to perform the variance calculation.
The function \code{prod.na} is similar to the \code{\link{prod}}
function with \code{na.rm=TRUE}. This function returns the product of
all the values present in its arguments, omitting any missing values.
}

\author{
  Yee Hwa Yang, \email{yeehwa@stat.berkeley.edu} \cr
  Sandrine Dudoit, \email{sandrine@stat.berkeley.edu}
}

\seealso{\code{\link{log}}, \code{\link{sum}}, \code{\link{mean}},
  \code{\link{var}}, \code{\link{cor}}, \code{\link{order}},
  \code{\link{scale}}, \code{link{prod}}.}

\keyword{log, sum, mean, variance, correlation, order, scale,
product, missing values, NA.} 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
\name{plot.bayesian}
\alias{plot.bayesian}

\title{Plots lodscore vs effect estimate (the output of stat.bayesian() or stat.bay.est()).}
\description{
  This function plots the results of stat.bayesian() or stat.bay.est()
  highlighting genes meeting userspecified criteria.
}
\usage{
plot.bayesian(x=NULL, Mbar=x$Xprep$Mbar, lods=x$lods, 
type="t", spec=50, ch=NULL, col="black",...)
}

\arguments{
  \item{x}{output from stat.bayesian() or stat.bay.est()}
  \item{Mbar}{Effect estimate for each gene.}
  \item{lods}{Posterior lodsratio for each gene.}
  \item{type}{Type of criteria for highlighting genes (see details).}
  \item{spec}{Specifies cutoff etc. depending on \code{type}.}
  \item{ch}{Character with which to selected highlight genes. (Default
    is the gene index.)}
  \item{col}{Colour of highlighted genes. (Default is black.)}
  \item{\dots}{Additional graphical parameters}
}

\details{
  If type='t', plot.bayesian() highlights the top spec genes.
  If type='c', plot.bayesian() highlights the genes with lods>=spec.
  If type='i', plot.bayesian() highlights the genes with indecies
  specified in spec.
}

\author{ Ingrid Lnnstedt \email{ingrid@math.uu.se} \cr}

\seealso{ \code{\link{stat.bayesian}},\code{\link{stat.bay.est}}}

\examples{
data(MouseArray)
## mouse.setup <- init.grid() 
## mouse.data <- init.data() ## see \emph{init.data} 
## mouse.lratio <- stat.ma(mouse.data, mouse.setup)
mouse.bayesian<-stat.bayesian(M=mouse.lratio$M)

plot.bayesian(mouse.bayesian)
plot.bayesian(mouse.bayesian,type='c',spec=0,col='blue')
plot.bayesian(mouse.bayesian,type='i',spec=c(1000,2000),col='green')
plot.bayesian(mouse.bayesian,type='i',spec=1:length(mouse.bayesian$lods))

}

\keyword{hplot}
%\keyword{ microarray, bayesian, lodsratio}






\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:18:16.
% Do NOT modify this file, instead modify the source (sma/R/Rmva.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{plot.confband.lines}

\alias{plot.confband.lines}

\title{Adding Lines Satisfying a Confidence Criterion to the Current M
  vs A Plot}

\description{
  This function adds 2 lines outlining the pointwise (intensity
  dependent) confidence band on the M vs A plot.  The lines are drawn
  such that a prespecified proportion of points are outside the 2
  confidence curves.
  The type of line may be specified as well as other parameters.}

\usage{
plot.confband.lines(x, M, crit1=0.025, crit2=crit1, nclass=10, ...)
}

\arguments{
 \item{x}{a vector giving the x-coordinates of the points in the scatter
          plot. In the microarray context, this could be a vector of
          average log intensities, ie A} 

 \item{M}{a vector giving the y-coordinates of the points in the scatter
   plot. In the microarray context, this could be a vector of log
   intensity ratios.} 
	
 \item{crit1}{The proportion of points less than the lower confidence
   curve.  This takes a decimal value between 0 and 1. }
 \item{crit2}{The proportion of points greater than the upper confidence
   curve.  By default, this has the same value as "crit1".}
 \item{nclass}{A single number giving the approximate number of
 intensity depedent groups to consider.} 
 \item{\dots}{graphical parameters may also be supplied as arguments
 to the function (see  \code{\link{par}}).}        
}

\value{
  Lines are added to the current plot.
}

\note{
  An M vs A plot must be constructed \bold{prior} to the execution
  of this function.} 

\seealso{ \code{\link{plot.mva}}, \code{\link{stat.ma}},
  \code{\link{lines}}, \code{\link{matlines}},
  \code{\link{plot.confband.text}}, \code{\link{plot.confband.points}} .
}

\examples{data(MouseArray)
## mouse.setup <- init.grid
## mouse.data <- init.data

## To display an M vs A plot of the data 
plot.mva(mouse.data, mouse.setup) 

## Calculate M and A values 
mouse.lratio <- stat.ma(mouse.data, mouse.setup)

## To add default upper and lower confidence curves line to the M vs A plot
plot.confband.lines(mouse.lratio$A, mouse.lratio$M) 
}

%\keyword{microarray, point-wise confidence band.}

\keyword{aplot}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:18:16.
% Do NOT modify this file, instead modify the source (sma/R/Rmva.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{plot.confband.points}

\alias{plot.confband.points}

\title{Highlights a Set of Points on the Current M vs A Plot}

\description{
  This function highlights a prespecified proportion of extreme points
  on the M vs A plots. 
}

\usage{
plot.confband.points(x, M, crit1=0.025, crit2=crit1, nclass=10, col.ex, ...)
}

\arguments{
 \item{x}{a vector giving the x-coordinates of the points in the scatter
          plot. In the microarray context, this could be a vector of
          average log intensities. ie A} 

 \item{M}{a vector giving the y-coordinates of the points in the scatter
   plot. In the microarray context, this could be a vector of log
   intensity ratios.} 
	
 \item{crit1}{The number of points to be highlighted on the M vs A plot.
   If crit1 < 1, the crit1*100\% spots with the smallest M values
   will be highlighted. If crit1 >= 1, the crit spots with the
   smallest M values are highlighted.}  
 \item{crit2}{Similar to "crit1".   If crit2 < 1, the crit2*100\%
 spots with the largest M values will be highlighted. If crit2 >= 1,
 the crit2 spots with the smallest M values are highlighted.}  
 \item{nclass}{A single number giving the approximate number of
   intensity depedent groups to consider.}
 \item{col.ex}{A color for extreme points}
 \item{\dots}{graphical parameters may also be supplied as arguments
 to the function (see \code{\link{par}}).}        
}

\value{
  Points are added to the current plot.
}


\seealso{\code{\link{plot.mva}}, \code{\link{stat.ma}},
  \code{\link{lines}}, \code{\link{matlines}},
  \code{\link{plot.confband.text}}, \code{\link{plot.confband.lines}} .
}

\note{An M vs A plot must be constructed \bold{prior} to the
execution of this function.} 

\examples{data(MouseArray)
## mouse.setup <- init.grid()
## mouse.data <- init.data()

plot.mva(mouse.data, mouse.setup) ## an M vs A plot 

mouse.lratio <- stat.ma(mouse.data, mouse.setup)

plot.confband.points(mouse.lratio$A, mouse.lratio$M)

## 2.5\% of the spots with the smallest and largest M values are
## highlighted on the M vs A plot. 
}

\keyword{aplot}

%\keyword{microarray, point-wise confidence band.}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:18:16.
% Do NOT modify this file, instead modify the source (sma/R/Rmva.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{plot.confband.text}

\alias{plot.confband.text}

\title{Add Selected Text to an M vs A Plot}
  
\description{`text' draws the strings given in the vector `labs' at the
  coordinates given by `M' and `A'}

\usage{
plot.confband.text(x, M, crit1=0.025, crit2=crit1, nclass=10,
labs=NULL, output=FALSE, ...)  
}

\arguments{
 \item{x}{a vector giving the x-coordinates of the points in the scatter
          plot. In the microarray context, this could be a vector of
          average log intensities. ie A} 
 
 \item{M}{a vector giving the y-coordinates of the points in the scatter
   plot. In the microarray context, this could be a vector of log
   intensity ratios.} 
	
 \item{crit1}{The number of points to be highlighted on the M vs A plot.
   If crit1 < 1, the crit1*100\% spots with the smallest M values
   will be highlighted. If crit1 >= 1, the crit spots  with the
   smallest M values are highlighted.}  
 \item{crit2}{Similar to "crit1".   If crit2 < 1, the crit2*100\%
 spots with the largest M values will be highlighted. If crit2 >= 1,
 the crit2 spots with the largest M values are highlighted.}  
 \item{nclass}{A single number giving the approximate number of
 intensity depedent groups to consider.} 
 \item{labs}{ one or more character strings or expressions specifying the
   text to be written.  If this string is not specified, by
   default the index of the vector `M' will be used.}
 \item{output}{logical, defaulting to `FALSE'. If `TRUE' a vector
   containning the index to the vector `M' that are  
   highlighted.} 
 \item{\dots}{graphical parameters may also be supplied as arguments
 to the function (see \code{\link{par}}).}        
}

\note{An M vs A plot must be constructed \bold{prior} to the execution of this function.}

\examples{data(MouseArray)
## mouse.setup <- init.grid()
## mouse.data <- init.data()

plot.mva(mouse.data, mouse.setup) ## an M vs A plot

mouse.lratio <- stat.ma(mouse.data, mouse.setup)

plot.confband.text(mouse.lratio$A, mouse.lratio$M)
## 2.5\% of the spots with the largest and smallest M values are
## highlighted on the M vs A plot, and each spot is assigned the
## default label of its corresponding index value. 
}

\seealso{ \code{\link{plot.mva}}, \code{\link{stat.ma}},
  \code{\link{lines}}, \code{\link{matlines}},
  \code{\link{plot.confband.lines}}, \code{\link{plot.confband.points}} .
}

\keyword{aplot}
%\keyword{microarray, point-wise confidence band.}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:17:46.
% Do NOT modify this file, instead modify the source (sma/R/Rdisc.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{plot.cor}

\alias{plot.cor}

\title{Red and Green Color Image of Correlation Matrix}

\description{
This function produces a red and green color image of a correlation
matrix using an RGB color specification. Increasingly positive
correlations are represented with reds of increasing intensity, and
increasingly negative correlations are represented with greens of
increasing intensity.  
}

\usage{
plot.cor(x, new=FALSE, nrgcols=50, labels=FALSE, labcols=1, title="", ...)
}

\arguments{
 \item{x}{a matrix of numerical values.}
 \item{new}{If \code{new=F}, \code{X} must already be a correlation
 matrix. If \code{new=T}, the correlation matrix for the columns of
 \code{X} is computed and displayed in the image.} 
 \item{nrgcols}{the number of colors (>= 1) to be used in the red
 and green palette.} 
 \item{labels}{vector of character strings to be placed at the
 tickpoints, labels for the columns of \code{X}.} 
 \item{labcols}{colors to be used for the labels of the columns of
 \code{X}. \code{labcols} can have either length 1, in which case
 all the labels are displayed using the same color, or the same
 length as \code{labels}, in which case a color is specified for the
 label of each column of \code{X}.} 
 \item{title}{character string, overall title for the plot.}
 \item{\dots}{graphical parameters may also be supplied as arguments to
          the function (see \code{\link{par}}). For comparison purposes, 
 it is good to set \code{zlim=c(-1,1)}.}
}
}


\author{
  Sandrine Dudoit, \email{sandrine@stat.berkeley.edu}
}

\seealso{\code{\link{plot.mat}},\code{\link{rgcolors.func}},
\code{\link{cor.na}}, \code{\link{cor}}, \code{\link{image}},
\code{\link{rgb}}.} 


%\keyword{Microarray, correlation matrix, image.}

\keyword{hplot}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:17:46.
% Do NOT modify this file, instead modify the source (sma/R/Rdisc.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{plot.mat}

\alias{plot.mat}

\title{Red and Green Color Image of Data Matrix}

\description{This function produces a red and green color image of a
data matrix using an RGB color specification. Larger entries are
represented with reds of increasing intensity, and smaller entries
are represented with greens of increasing intensity.  
}

\usage{
plot.mat(x, nrgcols=50, rlabels=FALSE, clabels=FALSE, rcols=1, ccols=1, title="",...)
}

%- maybe also `usage' for other objects documented here.

\arguments{
 \item{x}{a matrix of numbers.}
 \item{nrgcols}{the number of colors (>= 1) to be used in the red
 and green palette.} 
 \item{rlabels}{vector of character strings to be placed at the row
 tickpoints, labels for the rows of \code{X}.} 
 \item{clabels}{vector of character strings to be placed at the
 column tickpoints, labels for the columns of \code{X}.} 
 \item{rcols}{colors to be used for the labels of the rows of
 \code{X}. \code{rcols} can have either length 1, in which case
 all the labels are displayed using the same color, or the same
 length as \code{rlabels}, in which case a color is specified for the
 label of each row of \code{X}.} 
 \item{ccols}{colors to be used for the labels of the columns of
 \code{X}. \code{ccols} can have either length 1, in which case
 all the labels are displayed using the same color, or the same
 length as \code{clabels}, in which case a color is specified for the
 label of each column of \code{X}.} 
 \item{title}{character string, overall title for the plot.}
 \item{\dots}{graphical parameters may also be supplied as arguments  to
          the function (see \code{\link{par}}).  E.g. \code{zlim=c(-3,3)}}
}

%\references{ ~put references to the literature/web site here ~ }


\author{
  Sandrine Dudoit, \email{sandrine@stat.berkeley.edu}
}

\seealso{\code{\link{plot.cor}}, \code{\link{rgcolors.func}},
\code{\link{cor.na}}, \code{\link{cor}}, \code{\link{image}},
\code{\link{rgb}}.} 

\examples{
data(MouseArray)
##mouse.setup <- init.grid()
##mouse.data <- init.data() ## see \emph{init.data}
mouse.lratio <- stat.ma(mouse.data, mouse.setup)

## Looking at log ratios of mouse1
plot.mat(spatial.func(mouse.lratio$M[,1], mouse.setup))
}

\keyword{hplot}

%\keyword{Microarray, image of data matrix.} 


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:18:16.
% Do NOT modify this file, instead modify the source (sma/R/Rmva.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{plot.mva}

\alias{plot.mva}
  
\title{M vs. A Plot}

\description{
For a single slide, this function produces a scatter plot of log
intensity ratios \eqn{M = log_2(R/G)} versus average log intensities
\eqn{A = log_2 \sqrt{RG}}{A = log_2(R*G)/2}, where R and G represent
the fluorescence intensities in the red and green channels
respectively. 
}

\usage{
plot.mva(x, layout, norm="p", pout=TRUE, image.id=1, extra.type="tci",
crit1=0.025,crit2=crit1, nclass=10, labs=NULL, plot.type="n",
col.ex=NULL,pch=".", ...) 
}

\arguments{
  \item{x}{A list with at least 4 elements.  Each element of the list
    being a matrix with p rows for p genes and n columns for n slides. 
    The first element 'R' contains the raw red intensities,
    the second element 'G' contains the raw green intensities,
    the third element 'Rb' contains the background red intensities and
    the 4th element 'Gb' contains the background green intensities.
    This data structure can be generated by an interactive function
    \code{\link{init.data}}.}  

  \item{layout}{a list specifying the dimensions of the spot matrix
  and the grid matrix.  This can be generated by calling
  \code{\link{init.grid}}.} 

  \item{norm}{character string, one of "n", "m", "l", "p" or "s".  This
    argument  specifies the type of normalization method to be
    performed: "n" no normalization between the 2 channels; "m"
    \code{\link{median}} normalization, which sets the median of log
    intensity ratios to zero; "l" global \code{\link{lowess}}
    normalization; "p" print-tip group lowess normalization and "s"
    scaled print-tip group lowess normalization.} 
  
  \item{pout}{if TRUE, an M vs. A plot will be produced.  Otherwise, the
    function returns the normalized log intensity ratios M and the mean
    log intensities A for each gene.} 
  
  \item{image.id}{integer value; the index of the slide which is considered.}

  \item{extra.type}{a character string, one of "t", "p", "tci","pci" or
    "lci".  This argument specifies the type of plot to be drawn.  The
    possible types are: \cr
    * "t" for text, \cr
    * "p" for points, \cr
    * "tci" for highlighting a certain proportion of extreme `M' values
    by text,\cr
    * "pci" for highlighting a certain proportion of extreme `M' values
    by points,\cr
    * "lci" for including 2 intensity dependent lines where a 
    prespecified proportion of points have more extreme `M' values. 
  }
  \item{crit1}{The number of points to be highlighted on the M vs A
    plot.  If crit1 < 1, the crit1*100\% spots with the smallest M
    values will be highlighted. If crit1 >= 1, the crit spots 
   with the smallest M values are highlighted.} 
 \item{crit2}{Similar to "crit1".   If crit2 < 1, the crit2*100\% spots
   with the largest M values will be highlighted. If crit2 >= 1, the
   crit2 spots with the smallest M values are highlighted.}
 \item{nclass}{A single number giving the approximate number of
   intensity dependent groups to consider.}
 \item{labs}{one or more character strings or expressions specifying the
   text to be written.  If this string is not specified, by
   default the index of the vector `M' will be used.}
 \item{plot.type}{a character string, this argument is either "n", "r"
   or "b".  The different number of plots to be included are:\cr
   * "n" for normalised M vs A plot, \cr
   * "r" for unnormalised M vs A plot, and \cr 
   * "b" both unnormalised and normalised M vs A plots.
  }
 \item{col.ex}{The colour used for the highlighting extreme points,
   lines or text.}
 \item{pch}{The plotting character for points}
 \item{\dots}{graphical parameters may also be supplied as arguments to the
    function (see \code{\link{par}}).  }
}

\value{A plot is created on the current graphics device.  The top
plot is based on unnormalized log ratios and the bottom plot is
based on normalized log ratios.} 

\details{M vs. A plots tend to be more revealing than their log R
vs. log G counterparts in terms of identifying spot artifacts and
detecting intensity dependent patterns in the log ratios. They are
also very useful for normalization.} 

\references{S. Dudoit, Y. H. Yang, M. J. Callow, and T. P. Speed. Statistical
methods for identifying differentially expressed genes in replicated
cDNA microarray experiments (Statistics, UC Berkeley, Tech Report \#
578).}

\author{
  Yee Hwa Yang, \email{yeehwa@stat.berkeley.edu} \cr
  Sandrine Dudoit, \email{sandrine@stat.berkeley.edu} \cr
  Natalie Roberts, \email{nroberts@wehi.edu.au}
}

\seealso{\code{\link{ma.func}}, \code{\link{plot.smooth.line}},
\code{\link{stat.ma}}, \code{\link{lowess}}, \code{\link{plot}}.} 

\examples{
data(MouseArray)
# mouse.setup <- init.grid()
# mouse.data <- init.data() ## see \emph{init.data}
mouse.lratio <- stat.ma(mouse.data, mouse.setup)

## Look at the normalized second data sets in the list using points to
## highlight large positive or large negative ratios.
plot.mva(mouse.data, mouse.setup, norm="l", 2, extra.type="pci",
plot.type="n") 

## Look at the both unnormalized and normalized first data sets in the
## list using text to highlight large positive or negative ratios.
## plot.mva(mouse.data, mouse.setup, norm="l", 2, extra.type="tci", plot.type="b") 
}     

%\keyword{microarray}

\keyword{hplot}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%




\eof
\name{plot.print.tip.lowess}

\alias{plot.print.tip.lowess}
  
\title{M vs. A Plot with print tip lowess lines}

\description{
For a single slide, this function produces a scatter plot of log
intensity ratios \eqn{M = log_2(R/G)} versus average log intensities
\eqn{A = log_2 \sqrt{RG}}{A = log_2(R*G)/2}, where R and G represent
the fluorescence intensities in the red and green channels
respectively. Superimposed on this plot are individual lowess
smootherlines, one for each pin group.
}

\usage{
plot.print.tip.lowess(x, layout, norm="n", image.id=1,palette = rainbow(layout$ngrid.r*layout$ngrid.c), lty.palette = rep(1,layout$ngrid.r*layout$ngrid.c),...)
}

\arguments{
  \item{x}{A list with at least 4 elements.  Each element of the list
    being a matrix with p rows for p genes and n columns for n slides. 
    The first element 'R' contains the raw red intensities,
    the second element 'G' contains the raw green intensities,
    the third element 'Rb' contains the background red intensities and
    the 4th element 'Gb' contains the background green intensities.
    This data structure can be generated by an interactive function
    \code{\link{init.data}}.}  

  \item{layout}{a list specifying the dimensions of the spot matrix
  and the grid matrix.  This can be generated by calling
  \code{\link{init.grid}}.} 

  \item{norm}{character string, one of "n", "m", "l", "p" or "s".  This
    argument  specifies the type of normalization method to be
    performed: "n" no normalization between the 2 channels; "m"
    \code{\link{median}} normalization, which sets the median of log
    intensity ratios to zero; "l" global \code{\link{lowess}}
    normalization; "p" print-tip group lowess normalization and "s"
    scaled print-tip group lowess normalization.} 
    
  \item{image.id}{integer value; the index of the slide which is considered.}
  \item{palette}{Vector of color values to color each of the print tip
    lowess lines}
  \item{lty.palette}{A vector of line types for each of the print tip
    lowess lines}
  \item{\dots}{graphical parameters may also be supplied as arguments to the
    function (see \code{\link{par}}).  }
}

\value{A plot is created on the current graphics device.  The top
plot is based on unnormalized log ratios and the bottom plot is
based on normalized log ratios.} 

\details{M vs. A plots tend to be more revealing than their log R
vs. log G counterparts in terms of identifying spot artifacts and
detecting intensity dependent patterns in the log ratios. They are
also very useful for normalization.} 

\references{S. Dudoit, Y. H. Yang, M. J. Callow, and T. P. Speed. Statistical
methods for identifying differentially expressed genes in replicated
cDNA microarray experiments (Statistics, UC Berkeley, Tech Report \#
578).}

\author{
	Ben Bolstad \email{bolstad@stat.berkeley.edu}
}

\seealso{\code{\link{ma.func}}, \code{\link{plot.smooth.line}},
\code{\link{stat.ma}}, \code{\link{lowess}}, \code{\link{plot}}.} 

\examples{
data(MouseArray)
# mouse.setup <- init.grid()
# mouse.data <- init.data() ## see \emph{init.data}
plot.print.tip.lowess(mouse.data,mouse.setup)
}     

%\keyword{microarray}

\keyword{hplot}





\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:27:18.
% Do NOT modify this file, instead modify the source (sma/R/Rplot.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{plot.qq}

\alias{plot.qq}

\title{ Histogram and Normal Quantile-Quantile plot}

\description{Produces a histogram and a normal Quantile-Quantile plot
of the data. The points corresponding to genes with statistics
less/greater than a user defined threshold are highlighted. The
histogram and Q-Q plots are displayed on the same page. 
}

\usage{
plot.qq(x, name, low=-5, high=5,...)
}

\arguments{

 \item{x}{a numeric vector containing the statistics whose histogram
 and Q-Q plot will be produced. Missing values (NAs) are allowed.}

 \item{name}{title for the plots.}

 \item{low}{lower threshold: points with statistic < low are colored
 in green.}

 \item{high}{upper threshold: points with statistic > high are
   colored in red.}
 \item{\dots}{additional graphical parameters}
} 

\references{Chambers, J. M., Cleveland, W. S., Kleiner, B. and
Tukey, P. A. (1983). Graphical Methods for Data Analysis. Wadsworth,
Belmont, California. 
 
Hoaglin, D. C., Mosteller, F. and Tukey, J.  W., editors
 (1983). Understanding Robust and Exploratory Data Analysis. Wiley,
 New York.         
}

\author{
  Sandrine Dudoit, \email{sandrine@stat.berkeley.edu} \cr
  Yee Hwa Yang, \email{yeehwa@stat.berkeley.edu} 
}

\seealso{\code{\link{plot.spatial}}, \code{\link{plot.t2}},
\code{\link{stat.t2}}, \code{\link{hist}}, \code{\link{qqnorm}}.} 

\examples{
data(MouseArray)
## mouse.setup <- init.grid()
## mouse.data <- init.data() ## see \emph{init.data}
## mouse.lratio <- stat.ma(mouse.data, mouse.setup)

## Calculation of t-statistics
## cl <- c(rep(1,3), rep(2,3))
## mouse.t2 <- stat.t2(mouse.lratio, cl)

## Diagnostic plots
plot.qq(mouse.t2$t, "Mouse")
}     

\keyword{hplot}
%\keyword{microarray, histogram, qqplot.}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:27:18.
% Do NOT modify this file, instead modify the source (sma/R/Rplot.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{plot.qqline}

\alias{plot.qqline}

\title{Add Line Going Through the Quantiles of a Q-Q Plot}

\description{
This function adds a line to a quantile-quantile plot which passes
through user defined quantiles. This function is similar to, but
more general than, \code{\link{qqline}} because the reference
distribution need not be the standard normal distribution and the
quantiles need not be the first and third quartiles. \cr 
Graphical parameters may be given as arguments to \code{plot.qqline}. 
}

\usage{
plot.qqline(x, y, a=0.25, ...)
}

\arguments{
\item{x}{the reference (first) sample for the Q-Q plot, for a normal Q-Q
  plot this would be the quantiles of a N(0,1) random sample.}
\item{y}{the data.}
\item{a}{a number between 0 and 1. A line is drawn which connects the
  \code{a} and \code{1-a} quantile points. The default line passes
  through the first and third quantiles.}
 \item{\dots}{graphical parameters may also be supplied as arguments
 to the function (see \code{\link{par}}).} 
}

\seealso{\code{\link{qqplot}}, \code{\link{qqnorm}}, \code{\link{qqline}}.  }

\examples{
data(MouseArray)
# mouse.setup <- init.grid()
# mouse.data <- init.data() ## see \emph{init.data}
# mouse.lratio <- stat.ma(mouse.data, mouse.setup)

## Calculation of t-statistics
## cl <- c(rep(1,3), rep(2,3))
## mouse.t2 <- stat.t2(mouse.lratio, cl)

## Diagnostic plots
plot.qq(mouse.t2$t, "Mouse")

## Using the QQline function
q <- quantile(rnorm(1000))
plot.qqline(q, mouse.t2$t)
}    


\keyword{aplot}

%\keyword{Q-Q plots, quartiles}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:27:18.
% Do NOT modify this file, instead modify the source (sma/R/Rplot.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{plot.scale.box}
\alias{plot.scale.box}

\title{Box plots for microarray}
\description{
Produce box-and-whisker plot(s) of the given (grouped) values.
}
\usage{
plot.scale.box(x, layout, x.names=NULL, ...)
}

\arguments{
  \item{x}{a vector or a matrix.}
  \item{layout}{ a list specifying the dimensions of the spot matrix
   and the grid matrix.  This can be generated by calling
   \code{\link{init.grid}}.}
  \item{x.names}{group labels which will be printed under each boxplot.}
  \item{\dots}{further arguments to the default boxplot method and graphical
    parameters may also be passed as arguments, see \code{\link{par}}.}
}
\details{
  If x is a vector, this function will produce n boxplots where n is
  number of print-tips groups.   If x is a matrix, this function will
  produce n boxplots where n is number of columns in the matrix.  
}

\author{Yee Hwa Yang, \email{yeehwa@stat.berkeley.edu}}

\seealso{\code{\link{boxplot}}, \code{\link{bxp}}}

\examples{
     data(MouseArray)
     # mouse.setup <- init.grid() 
     # mouse.data <- init.data() ## see \emph{init.data} 
     mouse.lratio <- stat.ma(mouse.data, mouse.setup)
     ## Producing boxplots for different print-tips groups.
     plot.scale.box(mouse.lratio$M[,1], mouse.setup)
     ## Producing boxplots for different slides.
     plot.scale.box(mouse.lratio$M)
}

\keyword{hplot}
%\keyword{boxplots, microarray}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
\name{plot.single.slide}

\alias{plot.single.slide}
  
\title{M vs. A Plot}

\description{
For a single slide, this function produces a scatter plot of log
intensity ratios \eqn{M = log_2(R/G)} versus average log intensities
\eqn{A = log_2 \sqrt{RG}}{A = log_2(R*G)/2}, where R and G represent
the fluorescence intensities in the red and green channels
respectively, with the addition of coloured lines indicating the
cutoffs given by each of the three single slide methods.
}

\usage{
plot.single.slide(x,layout,norm="p",image.id=1,...)
}

\arguments{
  \item{x}{A list with at least 4 elements.  Each element of the list
    being a matrix with p rows for p genes and n columns for n slides. 
    The first element 'R' contains the raw red intensities,
    the second element 'G' contains the raw green intensities,
    the third element 'Rb' contains the background red intensities and
    the 4th element 'Gb' contains the background green intensities.
    This data structure can be generated by an interactive function
    \code{\link{init.data}}.}  

  \item{layout}{a list specifying the dimensions of the spot matrix
  and the grid matrix.  This can be generated by calling
  \code{\link{init.grid}}.} 

  \item{norm}{character string, one of "n", "m", "l", "p" or "s".  This
    argument  specifies the type of normalization method to be
    performed: "n" no normalization between the 2 channels; "m"
    \code{\link{median}} normalization, which sets the median of log
    intensity ratios to zero; "l" global \code{\link{lowess}}
    normalization; "p" print-tip group lowess normalization and "s"
    scaled print-tip group lowess normalization.} 
    
  \item{image.id}{integer value; the index of the slide which is
    considered.}
  \item{\dots}{additional graphical parameters}
}

\value{A plot is created on the current graphics device.  The plot is
an M vs A plot with lines indicating cuttoff for the three single
slide methods} 

\details{Plots an M vs A plot with results from each of the three single
slide methods, the methods of Newton, Sapir-Churchill and Chen,
indicated by colored lines. Solid black lines correspond to Newtons
method at 1:1, 1:10 and 1:100 log odds, note that the points are
colored red and green depending on where they fall according to this
method. Dashed lines are Chens method at the 95\% and 99\% confidence
levels. Dotted lines are Sapir-Churchil method at 95\% and 99\%
posterior probabilites.} 

\author{
  Ben Bolstad, \email{bolstad@stat.berkeley.edu}
}

\seealso{\code{\link{stat.Chen}}, \code{\link{stat.ChurSap}},
\code{\link{stat.Chen}}} 

\examples{
data(MouseArray)
# mouse.setup <- init.grid()
# mouse.data <- init.data() ## see \emph{init.data}
plot.single.slide(mouse.data, mouse.setup, norm="p", image.id=3)
}     

%\keyword{microarray}

\keyword{hplot}





\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:18:16.
% Do NOT modify this file, instead modify the source (sma/R/Rmva.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{plot.smooth.line}

\alias{plot.smooth.line}

\title{Adding Lowess Lines to Current Plot}

\description{
 This function adds a \code{\link{lowess}} line to the current
 plot.  The  type of line can be specified as well as other
 parameters.} 

\usage{
plot.smooth.line(x, M, f=0.1, ...)
}

\arguments{
 \item{x}{a vector giving the x-coordinates of the points in the scatter
          plot. In the microarray context, this could be a vector of
          average log intensities. ie A} 

 \item{M}{a vector giving the y-coordinates of the points in the scatter
          plot. In the microarray context, this could be a vector of
          log intensity ratios.} 

 \item{f}{the smoother span. This gives the proportion of points in the
          plot which influence the smoothness at each value. Larger
	  values give greater smoothness. } 

\item{\dots}{graphical parameters may also be supplied as arguments
to the function (see \code{\link{par}}).}        
}

\value{
 lines are added to the current plot.
}

\note{An M vs A plot must be constructed \bold{prior} to the execution of this function.}

\references{ Chambers, J. M., Cleveland, W. S., Kleiner, B. and Tukey,
P. A. (1983). Graphical Methods for Data Analysis. Wadsworth, Belmont,
California. }

\seealso{ \code{\link{plot.mva}}, \code{\link{stat.ma}},
\code{\link{lines}}, \code{\link{lowess}}, \code{\link{smooth}}. 
}

\examples{
data(MouseArray)
## mouse.setup <- init.grid()
## mouse.data <- init.data()

plot.mva(mouse.data, mouse.setup)
plot.smooth.line(mouse.lratio$A, mouse.lratio$M)
}

\keyword{aplot}

%\keyword{microarray, lowess.}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:18:34.
% Do NOT modify this file, instead modify the source (sma/R/Rspatial.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{plot.spatial}

\alias{plot.spatial}
\alias{draw.image.func}
\alias{spatial.func}

\title{Spatial Representation of Microarray Spot Statistics}


\description{Creates an image of shades
of gray or colors, that represents the values of a statistic for each
spot on the array. The statistic can be a log intensity ratio, quality
information such as spot size or shape, or a t-statistic. This function
can be used to explore whether there are any spatial effects in the data.
}

\usage{
plot.spatial(x, layout, crit1=0.05, crit2=crit1, ...)
}

\arguments{
\item{x}{a numerical vector. This vector can contain any spot 
statistics, such
as log intensity ratios, spot sizes or shapes, or t-statistics.} 

\item{layout}{a list specifying the dimensions of the spot matrix
and the grid matrix. This can be generated by calling 
\code{\link{init.grid}}.}

\item{crit1}{the number of values from x to be displayed on the image. 
If crit1 < 1, the crit1*100\% spots with the largest x values are displayed.
If crit1 >= 1, the crit1 spots with the largest x values are displayed.}    

\item{crit2}{the number of values from x to be displayed on the
image. If crit2 < 1, the crit2*100\% spots with the largest x values
are displayed. If crit2 >= 1, the crit2 spots with the largest x
values are displayed.}    

\item{\dots}{graphical parameters may also be supplied as arguments 
to the function (see \code{\link{par}}).} 
}

\value{
An image is created on the current graphics device.
}

\details{The values that didn't meet the criteria are not shown on the image.
The image follows the layout of an actual microarray slide with the
top left corner representing the spot (1,1,1,1).}



\note{\code{\link{draw.image.func}} and \code{\link{spatial.func}}
 are called by \code{\link{plot.spatial}} and are not typically 
used on their own.}

\author{
 Yee Hwa Yang, \email{yeehwa@stat.berkeley.edu} \cr
 Sandrine Dudoit, \email{sandrine@stat.berkeley.edu}}

\seealso{\code{\link{draw.image.func}}, \code{\link{init.grid}}, 
\code{\link{spatial.func}}, \code{\link{image}}.} 

\examples{
data(MouseArray)
# mouse.setup <- init.grid()
# mouse.data <- init.data() ## see \emph{init.data}

mouse.lratio <- stat.ma(mouse.data, mouse.setup)
plot.spatial(mouse.lratio$M[,1], mouse.setup) ## default 85% cutoff

# Looking for areas where the spots are not quite circular
plot.spatial(mouse1[,"shape"], mouse.setup, crit1=0.1)
}   

\keyword{hplot}

%\keyword{microarray, spatial.}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:27:18.
% Do NOT modify this file, instead modify the source (sma/R/Rplot.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{plot.svb}

\alias{plot.svb}
\alias{svb.func}

\title{Plot of Signal vs. Background}

\description{
Produces a scatter plot of background corrected signal intensities
and background intensities.
}

\usage{
plot.svb(x, channel="R", image.id=1, S.isbgcor=FALSE, ...)
}

\arguments{
  \item{x}{a numeric list of signal and background intensities, can
  be raw or background corrected data.}   

 \item{channel}{the specific channel to which the intensities to be
   considered, correspond to, that is, either red or green. The default
   channel is red.}

 \item{image.id}{integer value; the index of the slide which is considered}

 \item{S.isbgcor}{logical flag, equal to TRUE if the signal intensities in
   x contain background corrected signal intensities instead of raw
   signal intensities. By default this is set to FALSE.}

 \item{\dots}{graphical parameters may also be supplied as arguments
 to the function (see \code{\link{par}}).} 

}

\value{a plot is created on the current graphics device.}

\author{
  Yee Hwa Yang, \email{yeehwa@stat.berkeley.edu} \cr
  Sandrine Dudoit, \email{sandrine@stat.berkeley.edu} \cr
  Jessica Mar}
}
  \seealso{\code{\link{plot}}.} 

\examples{
data(MouseArray)
# mouse.setup <- init.grid()
# mouse.data <- init.data() ## see \emph{init.data}

plot.svb(mouse.data, "green", 3) 
## thiscreates a plot of the signal versus background intensities 
## for the green channel, using data collected from the third slide. 
}

\keyword{hplot}

%\keyword{microarray, background}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:27:18.
% Do NOT modify this file, instead modify the source (sma/R/Rplot.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{plot.t2}

\alias{plot.t2}

\title{Diagnostic Plots for Two-Sample t-statistics}

\description{
Plots of two-sample t-statistics, |t-numerator| and
t-denominator against average A, and plot of |t-numerator| against
t-denominator. For each spot on a given slide, \eqn{A = log_2
\sqrt{RG}}{A = log_2(R*G)/2}, where (R,G) denotes the red and green
fluorescence intensity pair. Points with t-statistics exceeding user
defined thresholds are highlighted. 
} 

\usage{
plot.t2(x, main.title="T plots", low=-5, high=5,...)
}

\arguments{

 \item{x}{output from the function \code{\link{stat.t2}}.}

 \item{main.title}{title for the plot.}

 \item{low}{lower threshold for t-statistic: points with t<low are
 colored in green.} 

 \item{high}{upper threshold for t-statistic: points with t>high are
   colored in red.}
 \item{\dots}{additional graphical parameters}
}

\author{
  Sandrine Dudoit, \email{sandrine@stat.berkeley.edu} \cr
  Yee Hwa Yang, \email{yeehwa@stat.berkeley.edu} 
}
\seealso{\code{\link{stat.t2}}, \code{\link{t2stat.func}},
\code{\link{plot}}, \code{\link{t.test}}.} 

\examples{
data(MouseArray)
# mouse.setup <- init.grid()
# mouse.data <- init.data() ## see \emph{init.data}
# mouse.lratio <- stat.ma(mouse.data, mouse.setup)

## Calculation of t-statistics
## cl <- c(rep(1,3), rep(2,3))
## mouse.t2 <- stat.t2(mouse.lratio, cl)

## Diagnostic plots
plot.t2(mouse.t2, "Mouse")
}    

%\keyword{microarray, ttest.}

\keyword{hplot}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:17:34.
% Do NOT modify this file, instead modify the source (sma/R/Rinit.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Actually RDoc not used here.


\name{read.genepix}

\alias{read.genepix}

\title{Reading in Data Generated by the Image Analysis Package GenePix.}

\description{
Reads in a data file in table format and creates a data frame
with the same number of rows as there are lines in the
 file, and the same number of columns as there are fields
 in the file.\cr
 `read.genepix' reads in the data file generated by the software
 "GenePix".
}

\usage{
read.genepix(name, dir = ".", sep = "\t", header = TRUE, skip = 26, gpname = c("Block", "Col", "Row", "Name", "ID", "X","Y", "Dia", "Rmed", "Rmean", "RSD", "Rbmed", "Rbmean", "RbSD", "Rb1SD", "Rb2SD", "Rbsat","Gmed", "Gmean", "GSD", "Gbmed", "Gbmean", "GbSD", "Gb1SD", "Gb2SD", "Gbsat", "ratiomed", "ratiomean", "medratio", "meanratio", "ratiosd", "Rratio", "RegR2", "FPixels", "BPixels", "summed", "summean", "logratio", "Rmedc", "Gmedc", "Rmeanc", "Gmedc", "flags"),...) 
}

\arguments{
 \item{name}{character string naming the data file from which to read the
data. }
 \item{dir}{character string naming the directory that contains the
 data file.} 

 \item{sep}{the field separator (single  character),  often  "\t"  for
   tab delimited fields.  If omitted,  any  amount  of white space
   (blanks or tabs) can separate the fields.  To read  fixed  format
   files, make  sep  a  numeric vector giving the initial columns of
   the fields. } 

 \item{header}{logical flag: if TRUE, then the first line of the
   file is used as the variable names of the resulting data frame. }

 \item{skip}{the number of lines of the data file to skip before beginning
   to read data.}

 \item{gpname}{A vector of column names. SOme of the column names from
   genepix contain non standard characters, so useful to redefine to
   something R likes to use. Also newer versions of genepix have more columns}

 \item{\dots}{parameters for read.table may also be supplied as arguments to
   the function (see  \code{\link{read.table}}).  }
}

\value{as in \code{\link{read.table}}, a data frame
(\code{\link{data.frame}}) containing a representation of the data
in the file.  
}

\seealso{\code{\link{read.table}}, \code{\link{data.frame}},
\code{\link{read.spot}}.} 

%\keyword{microarray, GenePix.}

\keyword{file}


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:17:34.
% Do NOT modify this file, instead modify the source (sma/R/Rinit.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{read.spot}

\alias{read.spot}

\title{Reading in Data Generated by the Image Analysis Package Spot}

\description{
Reads in a data file in table format and creates a data frame with the
same number of rows as there are lines in the file, and the same number
of columns as there are fields in the file.\cr
`read.spot': reads in the data file generated by the microarray image
 extraction library Spot. 
}

\usage{
read.spot(name, dir=".", sep="\t", header=TRUE, ...)
}

\arguments{
 \item{name}{character string naming the data file from which to read the
data. }

 \item{dir}{character string naming the directory that contains the data
   file. The default setting is the current directory.}

 \item{sep}{the field separator (single character), often "\t"  for
 tab delimited fields.  If omitted,  any amount of white space
 (blanks or tabs) can separate the fields.  To read fixed format
 files, make  sep  a numeric vector giving the initial columns of
 the fields. } 

 \item{header}{logical flag: if TRUE, then the first line of the
 file is used as the variable names of the resulting data frame. }

 \item{\dots}{parameters for read.table may also be supplied as arguments to
 the function (see  \code{\link{read.table}}).  }
}

\value{as in \code{\link{read.table}}, a data frame
(\code{\link{data.frame}}) containing a representation of the data
in the file.  
}

\seealso{\code{\link{read.table}}, \code{\link{data.frame}},
  \code{\link{write.spot}}, \code{\link{read.genepix}}.}

\examples{

## write.spot(mouse.array, 1, "mouse")
## mouse1 <- read.spot("mouse.1.spot")
}

\keyword{file}
%\keyword{microarray, Spot, GenePix.}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:17:46.
% Do NOT modify this file, instead modify the source (sma/R/Rdisc.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

                           
\name{rgcolors.func}

\alias{rgcolors.func}

\title{Red and Green Color Specification}

\description{
This function creates a vector of n ``contiguous'' colors,
corresponding to n intensities (between 0 and 1) of the red, green
and blue primaries, with the blue intensities set to zero. The
values returned by \code{rgcolors.func} can be used with a
\code{col=} specification in graphics functions or in
\code{\link{par}}.  
}

\usage{
rgcolors.func(n=50)
}

\arguments{
 \item{n}{the number of colors (>= 1) to be used in the red and
 green palette. } 

}
\value{a character vector of color names. Colors are specified
directly in terms of their RGB components with a string of the form
"\#RRGGBB", where each of the pairs RR, GG, BB consist of two
hexadecimal digits giving a value in the range 00 to FF. 
 }


\author{
  Sandrine Dudoit, \email{sandrine@stat.berkeley.edu} \cr
  Jane Fridlyand, \email{janef@stat.berkeley.edu}
}

\seealso{\code{\link{plot.cor}}, \code{\link{plot.mat}},
\code{\link{colors}}, \code{\link{rgb}}, \code{\link{image}}.} 

\examples{
rgcolors.func(n=5)
## The following vector is returned:
## "#00FF00" "#40BF00" "#808000" "#BF4000" "#FF0000"
}


\keyword{color}
%\keyword{Microarray, RGB image.}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
\name{internal functions}
 
\alias{mouse.lratio}
\alias{mouse.data}
\alias{mouse.setup}
\alias{cl}
\alias{mouse.t2}
\alias{c.min}                
\alias{chen.poly}             
\alias{chur.norm.func}      
\alias{dc.min}                
\alias{in.func}               
\alias{lods.func}             
\alias{nploglikderiv}         
\alias{sq.func}               
\alias{stat.ChurSap.ma}       
\alias{va.func}            
\alias{chen.func.rotate}   
\alias{chen.plot.rotate}  
\alias{chur.M.to.e.func}   
\alias{chur.em.func}    
\alias{chur.pdf}           
\alias{chur.wrapper.func}
\alias{func.em}            
\alias{givelim}    
\alias{lf.func}            
\alias{lod2}       
\alias{newton.plot.rotate}
\alias{nploglik}     
\alias{setup.bayesian}    
\alias{sq2.func}           
\alias{stat.Chen.ma}  
\alias{stat.Newton.ma}     
\alias{va2.func}    
\alias{c.func}
\alias{c.func.est}
\alias{lods.func.est}
\alias{ls.variance}

\title{Internal sma functions}
 
\description{Internal sma functions}
 
\details{These are not to be called by the user.}

\keyword{methods}

\eof
\name{stat.Chen}
\alias{stat.Chen}

\title{Apply Chen's single slide method}

\description{
Applies Chens single slide method. 
}


\usage{
stat.Chen(RG,layout,norm="p",image.id=1,pout=TRUE)
}

\arguments{
  \item{RG}{
    a list with 4 elements, each represents a matrix with p rows for p
    genes and n columns for n slides. \cr
    The first element "R" contains the raw red intensities from slide
    i=1,...,n .\cr
    Similarly, the second element "G" contains the raw green
    intensities. \cr
    The third element "Rb"  contains the background red intensities and \cr
    the fourth element "Gb" contains the  background green intensities.\cr
    This list structure can be generated by the interactive function
    \code{\link{init.data}}. }
  
  \item{layout}{a list specifying the dimensions of the spot matrix and the grid
    matrix.  This can be generated by calling \code{\link{init.grid}}.}

  \item{image.id}{Specifies image to which Chen's method will be applied.}

  \item{norm}{Character string, one of "n", "m", "l", "p" or "s".  This
    argument specifies the type of normalization method to be performed:
    "n" no normalization between the 2 channels; "m"
    \code{\link{median}} normalization, which sets the median of log
    intensity ratios to zero; "l" global \code{\link{lowess}}
    normalization; "p" print-tip group lowess normalization and "s"
    scaled print-tip group lowess normalization. The default method is
    set to print-tip normalization.}

  \item{pout}{if TRUE, an M vs. A plot will be produced with limits due
    to Chen 95\% and 99\%. If FALSE, returns upper and lower bounds at
	       95\% and 99\% levels.}
    
}


\value{
  List containing the following components:

  \item{lower01}{The lower limit of 99\% confidence interval}
  \item{upper01}{The upper limit of 99\% confidence interval}
  \item{lower05}{The lower limit of 95\% confidence interval}
  \item{upper05}{The upper limit of 95\% confidence interval}

}

\references{
  Chen, Y., E.R. Dougherty, and M.L. Bittner. Ratio-based decisions and
  the quantitative analysis of cDNA microarray images. Journal of
  Biomedical Optics , Volume 2 (4), 364-374, 1997. (1997)

}


\author{
  Ben Bolstad, \email{bolstad@stat.berkeley.edu}
}

\seealso{\code{\link{stat.ChurSap}},\code{\link{stat.Newton}}}

\examples{
data(MouseArray)
##mouse.setup <- init.grid() 
##mouse.data <- init.data() ## see \emph{init.data}
stat.Chen(mouse.data,mouse.setup,image.id=3)
}

\keyword{models}

%\keyword{microarray, Chen}






\eof
\name{stat.ChurSap}
\alias{stat.ChurSap}


\title{Apply Sapir and Churchills single slide method}

\description{
Applies Sapirs and Churchills single slide method. 
}


\usage{
stat.ChurSap(RG,layout,pp=0.95,norm="p", pout=TRUE, image.id=1,...)

}

\arguments{
  \item{RG}{
    a list with 4 elements, each represents a matrix with p rows for p
    genes and n columns for n slides. \cr
    The first element "R" contains the raw red intensities from slide
    i=1,...,n .\cr
    Similarly, the second element "G" contains the raw green
    intensities. \cr
    The third element "Rb"  contains the background red intensities and \cr
    the fourth element "Gb" contains the  background green intensities.\cr
    This list structure can be generated by the interactive function
    \code{\link{init.data}}. }
  
  \item{layout}{a list specifying the dimensions of the spot matrix and the grid
    matrix.  This can be generated by calling \code{\link{init.grid}}.}

  \item{pp}{Posterior probability of being differentially
  expressed. Defaults to 0.95}
  
  \item{image.id}{Specifies image to which Chen's method will be applied.}

  \item{norm}{Character string, one of "n", "m", "l", "p" or "s".  This
    argument specifies the type of normalization method to be performed:
    "n" no normalization between the 2 channels; "m"
    \code{\link{median}} normalization, which sets the median of log
    intensity ratios to zero; "l" global \code{\link{lowess}}
    normalization; "p" print-tip group lowess normalization and "s"
    scaled print-tip group lowess normalization. The default method is
    set to print-tip normalization.}

  \item{pout}{if TRUE, an M vs. A plot will be produced with limits due
    to Churchill and Sapir at the specified posterior probability level. If FALSE, return a list with pertinant information}
  \item{\dots}{additional graphical parameters}
}


\value{
  List containing the following components:

  \item{limits}{the positive value of the limit at the posterior
  probability value of pp}
  \item{theta}{parameters estimated by EM algorithm, specifically a
    mixing proportion and a variance}
  \item{pp}{Posterior probabilities of being differentially expressed
  given observed data for each gene.}

}

\references{
  Sapir and Churchill(2000), Estimating the posterior probability of
  differential gene expression from microarray data . \url{http://www.jax.org/research/churchill/}
}

\author{
  Ben Bolstad, \email{bolstad@stat.berkeley.edu}
}

\seealso{\code{\link{stat.Chen}},\code{\link{stat.Newton}}}

\examples{
data(MouseArray)
##mouse.setup <- init.grid() 
##mouse.data <- init.data() ## see \emph{init.data}
stat.ChurSap(mouse.data,mouse.setup,pp=0.95,image.id=3)
}

%\keyword{microarray, Churchill, Sapir}
\keyword{models}

\eof
\name{stat.Newton}
\alias{stat.Newton}

\title{Apply Newtons single slide method}

\description{
Applies Newtons single slide method. 
}


\usage{
stat.Newton(RG,layout,norm="p", image.id=1,pout=TRUE)

}

\arguments{
  \item{RG}{
    a list with 4 elements, each represents a matrix with p rows for p
    genes and n columns for n slides. \cr
    The first element "R" contains the raw red intensities from slide
    i=1,...,n .\cr
    Similarly, the second element "G" contains the raw green
    intensities. \cr
    The third element "Rb"  contains the background red intensities and \cr
    the fourth element "Gb" contains the  background green intensities.\cr
    This list structure can be generated by the interactive function
    \code{\link{init.data}}. }
  
  \item{layout}{a list specifying the dimensions of the spot matrix and the grid
    matrix.  This can be generated by calling \code{\link{init.grid}}.}

  \item{norm}{Character string, one of "n", "m", "l", "p" or "s".  This
    argument specifies the type of normalization method to be performed:
    "n" no normalization between the 2 channels; "m"
    \code{\link{median}} normalization, which sets the median of log
    intensity ratios to zero; "l" global \code{\link{lowess}}
    normalization; "p" print-tip group lowess normalization and "s"
    scaled print-tip group lowess normalization. The default method is
    set to print-tip normalization.}

 \item{image.id}{Specifies image to which Chen's method will be applied.}
  
  \item{pout}{if TRUE, an M vs. A plot will be produced with limits due
    to Newton, Specifically limits at the 1:1, 1:10 and 1:100 log odds ratio. If FALSE, return a list with pertinant information}
    
}


\value{
  List containing the following components:

  \item{theta}{parameters estimated by EM algorithm}
  \item{lod}{Log odds ratio of being differentially expressed for each gene}

}

\references{
  Newton, M.N., C.M. Kendziorski, C.S. Richmond, F.R. Blattner, and
  K.W. Tsui . On differential variability of expression ratios:
  Improving statistical inference about gene expression changes from
  microarray data. Technical Report 139, Department of Biostatistics and
  Medical Informatics, UW Madison, 1999. \url{http://www.stat.wisc.edu/~newton/papers/abstracts/btr139a.html}
}

\author{
  Ben Bolstad, \email{bolstad@stat.berkeley.edu}
}

\seealso{\code{\link{stat.Chen}},\code{\link{stat.ChurSap}}}

\examples{
data(MouseArray)
##mouse.setup <- init.grid() 
##mouse.data <- init.data() ## see \emph{init.data}
stat.Newton(mouse.data,mouse.setup,image.id=3)
}

\keyword{models}


\eof
\name{stat.bay.est}
\alias{stat.bay.est}

\title{Calculates an Odds Ratio for Each Gene in a Multi-slide Microarray Experiment. }
\description{This function takes independent, sufficient estimates of
  the effect and its variance for each gene in a multi-slide microarray experiment
and returns an odds ratio for each gene: log( Pr(the gene is
differentially expressed) / Pr(the gene is not differentially expressed)
). The parameter estimates of the Bayesian model used, as well as some
data structures which are useful when presenting the lodscore
graphically are also in the output.}

\usage{
stat.bay.est(M=NULL, Xprep=NULL, para=list(p = 0.01, v = NULL, a = NULL, c = NULL))
}

\arguments{
  \item{M}{Matrix of (normalized) log expression ratios
    \eqn{M = log_2 (R/G)} (E.g. output from stat.ma())}
  \item{Xprep}{A list containing the effect estimates and variances for
    the genes, as well as some constants needed for the odds ratio} 
  \item{para}{Estimates of the parameters used in the Bayesian
    calculations. (These are calculated only if not
    already supplied as input. See details!)}
}

%#para	are the hyperparameters needed for the calculation of lods
%#	can be produced by stat.bay.est
%#	are estimated from Xprep

%#Mbar=effect estimates for all genes (#genes x 1)
%#Vest=estimates of sigma^2 (effect variances) for all genes (#genes x 1)
%#k=constant s th Mbar~N(.,sigma^2/k) for all genes (1 x 1)
%#f=degrees of freedom for Vest (1 x 1)
\details{
  Xprep and para are optional input, but they are always in the
  output. If Xprep is supplied as input, M is unnecessary
  input. If Xprep is not supplied, stat.bay.est assumes the experiment
  consists of ncol(M) microarray slides all measuring the same effect
  (which will be stimated by Mbar). A subset of the parameters in para can be specified in the
  input, allowing the function to estimate only the others.

  Xprep is a list containing
  
  \item{Mbar}{effect estimates for all genes (\#genes x 1)}
  \item{Vest}{estimates of sigma\^2 (effect variances) for all genes (\#genes x 1)}
  \item{k}{constant so that Mbar~N(.,sigma\^2/k) for all genes (1 x 1)}
  \item{f}{degrees of freedom for Vest (1 x 1)}

  para is a list of parameters common to all genes containing

  \item{p}{Probability that a random gene is differentially
    expressed. Default is 0.01.}
  \item{v,a}{Parameters in the prior for the variance such that a*k/(2*sigma\^2) ~Gamma(v,1)}
  \item{c}{Parameter in the prior for the mean expression ratio.}
}

\value{
  A list of
 
  \item{Xprep}{Some data structures useful in graphical
    presentation. See details!} 
  \item{para}{Estimates of the parameters used in the Bayesian
    calculations. See details!}
  \item{lods}{The log odds ratio for each gene.}
}

\references{I. Lnnstedt and T. P. Speed.  Replicated Microarray Data.
  Statistical Sinica, Accepted, see http://www.stat.berkeley.edu/users/terry/zarray/Html/papersindex.html}

\author{ Ingrid Lnnstedt \email{ingrid@math.uu.se} \cr}

\seealso{\code{\link{stat.bayesian}},\code{\link{plot.bayesian}}}

\examples{
data(MouseArray)
## mouse.setup <- init.grid() 
## mouse.data <- init.data() ## see \emph{init.data} 
## mouse.lratio <- stat.ma(mouse.data, mouse.setup)

mouse.bayesian<-stat.bay.est(M=mouse.lratio$M)
plot(mouse.bayesian$Xprep$Mbar, mouse.bayesian$lods)

#alternatively

mouse.est<-apply(mouse.lratio$M,1,mean.na)
mouse.Vest<-apply(mouse.lratio$M,1,var.na)
n<-ncol(mouse.lratio$M)
k<-n
f<-n-1
mouse.Xprep<-list(Mbar=mouse.est,Vest=mouse.Vest,k=k,f=f)

mouse.bayest<-stat.bay.est(Xprep=mouse.Xprep)
plot(mouse.bayest$Xprep$Mbar, mouse.bayest$lods)

}


\keyword{models}
%\keyword{microarray, bayesian, lodsratio}









\eof
\name{stat.bayesian}
\alias{stat.bayesian}

\title{Calculates an Odds Ratio of Each Gene in a Multi-slide microarray
Experiment}
\description{
This function takes the normalized expression estimates from a
multi-slide microarray experiment (M-values output
by stat.ma) and returns an odds ratio for each gene: log( Pr(the gene is
differentially expressed) / Pr(the gene is not differentially expressed)
). The parameter estimates of the Bayesian model used, as well as some
data structures which are useful when presenting the lodscore
graphically are also in the output.}

\usage{
	stat.bayesian(M=NULL, nb=NULL, nw=1, Xprep=NULL, 
	para=list(p = 0.01, v = NULL, a = NULL, c = NULL, k = NULL))
}

\arguments{
  \item{M}{Matrix of (normalized) log expression ratios
    \eqn{M = log_2 (R/G)} (E.g. output from stat.ma())}
  \item{nb}{Number of slides containing spots for a gene (common for all
  genes). Unnecessary argument if nw=1.}
  \item{nw}{Number of spots for a gene within each slide (common to all
    genes).Default is 1.}
  \item{Xprep}{Some data structures useful in graphical
    presentation. (This is calculated only if not already supplied as
    input. See details!)} 
  \item{para}{Estimates of the parameters used in the Bayesian
    calculations. (These are calculated only if not
    already supplied as input. See details!)}
}

\details{

  Xprep and para are optional input, but they are always in the
  output. If Xprep is supplied as input, M, nb and nw are unnecessary
  input. A subset of the parameters in para can be specified in the
  input, allowing the function to estimate only the others.

  Xprep is a list containing
  
  \item{nb}{Number of slides containing spots for a gene (common to all
  genes).}
  \item{nw}{Number of spots for a gene within each slide (common to all genes).}
  \item{Mbar}{Overalll means for each gene.}
  \item{SSB}{Sum of squares between slides for each gene.}
  \item{SSB}{Sum of squares within slides for each gene.}

  para is a list of parameters common to all genes containing

  \item{p}{Probability that a random gene is differentially
    expressed. Default is 0.01.}
  \item{v,a}{Parameters in the prior for the variance. If the observed
    sums of squares between slides are MSB, then v and a is such that
    (nb*a/(2MSB)~Gamma(v,1))}
  \item{c}{Parameter in the prior for the mean expression ratio.}
  \item{k}{An approximate ratio of the variances between to within slides,
    only needed when both nw>1 and nb>1}

}

\value{
  
  A list of
 
  \item{Xprep}{Some data structures useful in graphical
    presentation. See details!} 
  \item{para}{Estimates of the parameters used in the Bayesian
    calculations. See details!}
  \item{lods}{The log odds ratio for each gene.}
}


\author{
    Ingrid Lnnstedt \email{ingrid@math.uu.se} \cr
    Yee Hwa Yang, \email{yeehwa@stat.berkeley.edu} \cr
}

\seealso{\code{\link{plot.bayesian}}}

\examples{
data(MouseArray)
## mouse.setup <- init.grid() 
## mouse.data <- init.data() ## see \emph{init.data} 
mouse.lratio <- stat.ma(mouse.data, mouse.setup)

mouse.bayesian<-stat.bayesian(M=mouse.lratio$M)
plot(mouse.bayesian$Xprep$Mbar, mouse.bayesian$lods)

}

\keyword{models}

%\keyword{microarray, bayesian, lodsratio}

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:17:46.
% Do NOT modify this file, instead modify the source (sma/R/Rdisc.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{stat.bwss}

\alias{stat.bwss}


\title{Between and Within Group Sum of Squares Calculation}

\description{This function computes the between and within group sum
of squares for each row of a matrix which may have NAs. 
}

\usage{
stat.bwss(x, cl)
}

\arguments{
 \item{x}{a matrix, NAs allowed. In the microarray context, the rows
 of \code{X} could correspond to genes and the columns to different
 hybridizations.} 
 \item{cl}{column labels, must be consecutive integers.} 
}

\value{
List containing the following components
  \item{wn}{matrix with class sizes for each row of \code{X};}
  \item{BW}{vector of BSS/WSS for each row of \code{X};}
  \item{BSS}{between group sum of squares for each row of \code{X};}
  \item{WSS}{within group sum of squares for each row of \code{X};}
  \item{TSS}{total sum of squares for each row of \code{X};}
  \item{tvar}{variance for each row of \code{X}.}
}

\references{S. Dudoit, J. Fridlyand, and T. P. Speed. Comparison of
Discrimination Methods for the Classification of Tumors Using Gene
Expression Data. June 2000. (Statistics, UC Berkeley,  Tech Report \#
576). }

\author{
  Sandrine Dudoit, \email{sandrine@stat.berkeley.edu}  \cr
  Jane Fridlyand, \email{janef@stat.berkeley.edu}
}

\seealso{\code{\link{var.na}}, \code{\link{var}}, \code{\link{apply}}.}


\keyword{models}

%\keyword{Microarray, BSS, WSS, sum of squares.}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:17:46.
% Do NOT modify this file, instead modify the source (sma/R/Rdisc.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{stat.diag.da}

\alias{stat.diag.da}

\title{Diagonal Discriminant Analysis}

\description{
This function implements a simple Gaussian maximum likelihood
discriminant rule, for diagonal class covariance matrices.  
}

\usage{
stat.diag.da(ls, cll, ts, pool=1)
}

\arguments{
 \item{ls}{learning set data matrix, with rows corresponding to
cases (i.e., mRNA samples) and columns to predictor variables 
(i.e., genes).} 
 \item{cll}{class labels for learning set, must be consecutive integers.}
 \item{ts}{test set data matrix, with rows corresponding to cases
and columns to predictor variables.} 
 \item{pool}{logical flag. If \code{pool=1}, the covariance matrices
are assumed to be constant across classes and the discriminant rule
is linear in the data. If \code{pool=0}, the covariance matrices may
vary across classes and the discriminant rule is quadratic in the
data.} 
} 

\value{
 List containing the following components 
  \item{pred}{vector of class predictions for the test set.}
}

\references{
S. Dudoit, J. Fridlyand, and T. P. Speed. Comparison of
Discrimination Methods for the Classification of Tumors Using Gene 
Expression Data. June 2000. (Statistics, UC Berkeley, Tech Report \#576).}

\author{
  Sandrine Dudoit, \email{sandrine@stat.berkeley.edu} \cr
  Jane Fridlyand, \email{janef@stat.berkeley.edu}
}

%\seealso{ ~~objects to SEE ALSO as \code{\link{~~fun~~}}, ~~~ }

\keyword{models}

%\keyword{Microarray, discriminant analysis, maximum likelihood, classification.}


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-11-08 :05:09.
% Do NOT modify this file, instead modify the source (Rarray.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{stat.gnames}

\alias{stat.gnames}

\title{Sort Genes According to the Value of a Statistic}

\description{
Lists genes and corresponding statistics in decreasing order of the
statistics. This function applies to any type of statistic, including
log ratios, one and two-sample t-statistics, and F-statistics. Missing
values are ignored, as in \code{\link{sort}(..., na.last=NA)}. 
}

\usage{
stat.gnames(x, gnames, crit=0.05)
}

\arguments{
 \item{x}{a numeric vector containing the statistics for each
 gene. Missing values (NAs) are allowed. }
 
\item{gnames}{a character vector containing the gene names.}

 \item{crit}{specifies the number of genes to be returned. If crit <
 1, the crit*100\% genes with the largest x values are listed. If crit
 >= 1, the crit genes with the largest x values are listed. }
}

\value{
List containing the following components 
  \item{gnames}{gene names sorted in decreasing order of the
 statistics in x.}
 \item{t}{statistics sorted in decreasing order.}
}

\author{
  Yee Hwa Yang, \email{yeehwa@stat.berkeley.edu} \cr
  Sandrine Dudoit, \email{sandrine@stat.berkeley.edu} }

\seealso{\code{\link{stat.t2}}, \code{\link{order}}, \code{\link{sort}}.}

\examples{
## Calculating log ratio and performing a t test.
data(MouseArray)
## mouse.setup <- init.grid()
## mouse.data <- init.data() ## see \emph{init.data}
mouse.lratio <- stat.ma(mouse.data, mouse.setup)
cl <- c(rep(1,3), rep(2,3))
mouse.t2 <- stat.t2(mouse.lratio, cl)

## Looking at gene names
## Finding the top 10 t-statistics
stat.gnames(abs(mouse.t2$t), mouse.gnames, crit=10)

## Finding the top 1% of t-statistics
stat.gnames(abs(mouse.t2$t), mouse.gnames, crit=0.01)

## Finding the 10 extreme M values in the first slide
stat.gnames(abs(mouse.lratio$M[, 1]), mouse.gnames, crit=10)
}

\keyword{misc}
%\keyword{microarray.}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-11-08 :05:09.
% Do NOT modify this file, instead modify the source (Rarray.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{stat.ma}

\alias{stat.ma}
\alias{ma.func}
\alias{norm.l.func}
\alias{norm.pin.func}
\alias{norm.scale.func}

\title{Calculation of log Intensity Ratios and Average log Intensities}

\description{
Computes the log intensity ratio \eqn{M = log_2 (R/G)} and the mean log
intensity \eqn{A = log_2 \sqrt{RG}}{A = log_2(R*G)/2}, where R and G
represent the fluorescence
intensities in the red and green channels, respectively. Logarithms base
2 are used instead of natural or decimal logarithms as intensities are
typically integers between 1 and \eqn{2^{16}}. The log intensity
ratios M are normalized using one of the five available methods. 
}

\usage{
stat.ma(RG, layout, norm="p", pout=FALSE, ...)
}

\arguments{
  \item{RG}{
    a list with 4 elements, each represents a matrix with p rows for p
    genes and n columns for n slides. \cr
    The first element "R" contains the raw red intensities from slide
    i=1,...,n .\cr
    Similarly, the second element "G" contains the raw green
    intensities. \cr
    The third element "Rb"  contains the background red intensities and \cr
    the fourth element "Gb" contains the  background green intensities.\cr
    This list structure can be generated by the interactive function
    \code{\link{init.data}}. }
  
  \item{layout}{a list specifying the dimensions of the spot matrix
  and the grid  
    matrix.  This can be generated by calling \code{\link{init.grid}}.}

  \item{norm}{Character string, one of "n", "m", "l", "p" or "s".  This
    argument specifies the type of normalization method to be performed:
    "n" no normalization between the 2 channels; "m"
    \code{\link{median}} normalization, which sets the median of log
    intensity ratios to zero; "l" global \code{\link{lowess}}
    normalization; "p" print-tip group lowess normalization and "s"
    scaled print-tip group lowess normalization. The default method is
    set to print-tip normalization.}

  \item{pout}{if TRUE, an M vs. A plot will be produced. Otherwise,
  a matrix of log intensity ratios and average log intensities is
  return.  By default pout is set to FALSE.  The option pout='TURE'
  is not yet implemented.}

  \item{\dots}{other parameters used in \code{\link{ma.func}}. }
}

\value{
  List containing the following components:
  
  \item{M}{Matrix of log expression ratios \eqn{M = log_2 (R/G)}}
  \item{A}{Matrix of average log intensities \eqn{A = log_2
      \sqrt{RG}}{A = log_2(R*G)/2}}
  For the matrix in each of the components, rows correspond to genes
  and columns correspond to different hybridizations, that is
  different slides.  
}

\references{S. Dudoit, Y. H. Yang, M. J. Callow, and T. P. Speed. Statistical
methods for identifying differentially expressed genes in replicated
cDNA microarray experiments (Statistics, UC Berkeley, Tech Report \# 578).  }

\note{\code{\link{ma.func}}, \code{\link{norm.l.func}},
  \code{\link{norm.scale.func}} and \code{\link{norm.pin.func}} are called by \code{\link{stat.ma}} and are not typically used on their own.}

\author{
  Yee Hwa Yang, \email{yeehwa@stat.berkeley.edu} \cr
  Sandrine Dudoit, \email{sandrine@stat.berkeley.edu} \cr
  Natalie Roberts, \email{nroberts@wehi.edu.au}
}

\seealso{\code{\link{ma.func}}, \code{\link{norm.l.func}},
  \code{\link{norm.pin.func}}, \code{\link{norm.scale.func}}, \code{\link{plot.mva}}, \code{\link{lowess}}.}

\examples{
data(MouseArray)
## mouse.setup <- init.grid() 
## mouse.data <- init.data() ## see \emph{init.data} 
mouse.lratio <- stat.ma(mouse.data, mouse.setup)
}

%\keyword{microarray, log ratio.}
\keyword{datagen}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-11-08 :05:09.
% Do NOT modify this file, instead modify the source (Rarray.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{stat.norm.exp}
\alias{stat.norm.exp}
\title{Normalization of log Intensity Ratios across slides / experiments.}

\description{
Performs scale normalization across slides (experiments)}
}

\usage{
stat.norm.exp(X)
}

\arguments{
  \item{X}{X is a matrix of log intensity ratios \eqn{M=\log_2 (R/G)}
  The rows of X correspond to genes and columns correspond to different 
  hybridizations, that is different slides (experiments).} 
}

\value{
  A matrix of normalized log intensity ratios across different slides. 
  For the matrix in each of the components, rows correspond to genes
  and columns correspond to different hybridizations, that is different 
  slides.  This methods scale the matrix such that each column has the 
  same median absolute deviation.
}

\references{Y. H. Yang, S. Dudoit, P. Luu and T. P. Speed. 
 Normalization for cDNA Microarray Data. (Statistics, UC Berkeley, 
 Tech Report \# 589).  } 

\author{
  Yee Hwa Yang, \email{yeehwa@stat.berkeley.edu} \cr
}

\seealso{\code{\link{ma.func}}, \code{\link{norm.l.func}},
  \code{\link{norm.pin.func}}, \code{\link{norm.scale.func}}, \code{\link{plot.mva}}, \code{\link{lowess}}.}

\examples{
data(MouseArray)
## mouse.setup <- init.grid() 
## mouse.data <- init.data() ## see \emph{init.data} 
mouse.lratio <- stat.ma(mouse.data, mouse.setup)
mouse.norm.lratio <- stat.norm.exp(mouse.lratio$M)
}

\keyword{manip}
%\keyword{microarray, log ratio, normalization.}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:18:09.
% Do NOT modify this file, instead modify the source (sma/R/RTtest.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{stat.t2}

\alias{stat.t2}
\alias{t2stat.func}

\title{Two-sample t-statistics}

\description{
Computes two-sample t-statistics for each gene in a multi-slide
microarray experiment. 
}

\usage{
stat.t2(X, cl, x.ratio=FALSE, var.equal=TRUE, ...)
}

\arguments{
 \item{X}{if x.ratio=F, X is a list containing two components.  The
 first component is a matrix of log intensity ratios
 \eqn{M=\log_2 (R/G)} and the second component is the 
  average log intensities \eqn{A = log_2 \sqrt{RG}}{A =
  log_2(R*G)/2}, such as the output 
  from \code{\link{stat.ma}}. If x.ratio=T, X is a matrix of log
  expression ratios only.   The rows of X correspond to genes and 
  columns correspond to different hybridizations, that is different
  slides.}  

 \item{cl}{vector of class labels. Must consist of integers 1 and 2.}

 \item{x.ratio}{logical flag: if TRUE, the matrix X contains only
 log intensity ratios, if FALSE, X is a list containing two
 components.  The first component is a matrix of log expression
 ratios and the second component contains average log
 intensities A.}

 \item{var.equal}{logical flag: if TRUE, the variances of the class
 1 and class 2 parent populations are assumed equal.} 

 \item{\dots}{other parameters used in \code{\link{t.test}}. }
}

\value{
List containing the following components

  \item{t}{the two-sample t-statistic for each gene;}

  \item{Num }{the numerator of the t-statistic for each gene, with
names attribute "Num";}

  \item{Denominator}{the denominator of the t-statistic for each gene, with
names attribute "Den";}

  \item{n1}{number of class 1 observations used to calculate the
  t-statistic for each gene;}

  \item{n2}{number of class 2 observations used to calculate the
    t-statistics for each gene;}   

    \item{Average A}{if x.ratio=F, the average across all
    hybridizations of \eqn{A = log_2 \sqrt{RG}}{A = log_2(R*G)/2}, 
with names attribute "A.bar", if x.ratio=T, NULL is returned.}
}

\references{ D. Freedman, R. Pisani, and
R. Purves. (1998). Statistics, 3rd ed. NewYork: W.W. Norton.} 

 
\note{\code{\link{t2stat.func}} is called by \code{\link{stat.t2}}
and is not typically used on its own.}         

\author{
  Sandrine Dudoit, \email{sandrine@stat.berkeley.edu} \cr
  Yee Hwa Yang, \email{yeehwa@stat.berkeley.edu} 
}
  
\seealso{\code{\link{t2stat.func}}, \code{\link{plot.t2}},
\code{\link{plot.qq}}, \code{\link{t.test}}.} 

\examples{
data(MouseArray)
## mouse.setup <- init.grid()
## mouse.data <- init.data() ## see \emph{init.data}
## mouse.lratio <- stat.ma(mouse.data, mouse.setup)
cl <- c(rep(1,3), rep(2,3))
mouse.t2 <- stat.t2(mouse.lratio, cl)
}


\keyword{htest}
%\keyword{T-test.}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:17:34.
% Do NOT modify this file, instead modify the source (sma/R/Rinit.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{write.spot}

\alias{write.spot}

\title{Writing in Data Generated by the Image Analysis Package Spot}
\description{
  Function writes in a data file in a tab delimited table format.
  }

\usage{
write.spot(x, imageid, batch="output")
}

\arguments{
 \item{x}{the object to be written, typically a data frame. If not, it
   is attempted to create one from it.}
 \item{imageid}{integer value; the index of the slide which is
   considered}
 \item{batch}{character string, this refers to the name of a collection
   of experiments. The default batch name is "output".}
}
\details{
  This function writes the data in for each imageid, assigning each file
  the filename which takes the default form of "output".imageid.spot. The
  column names of x are written along with x in the table format
}

\references{ Spot manual \url{
  http://www.cmis.csiro.au/iap/Spot/spotmanual.htm}}

\author{ Jessica Mar }

\seealso{ \code{\link{write.table}}} %, \code{\link{init.read.spot}} }}

\examples{## Setting up the data
## library(Spot)
## SetParameters("mouse")
## Here is what you should see:
## Enter number of rows of grids per image (ngrid.r): 4
## Enter number of columns of grids per image (ngrid.c): 4
## Enter number of rows of spots per grid (nspot.r): 19
## Enter number of columns of spots per grid (nspot.c): 21
## Enter top/bottom translation tolerance, default is 50 (tolerance.r): 20
## Enter left/right translation, default is 50 (tolerance.c): 30
## Initialization complete

##Inputting Image Data 
## SetImages("mouse")
## Combining the red and green channels for the first slide
## mouse.array <- Spots("mouse", 1)

## Calling the function to write the data in
## write.spot(mouse.array, 1, "mouse")
}

\keyword{file}
%\keyword{microarray, Spot, Genepix.} 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
