sn.2logL.profile             package:sn             R Documentation

_P_r_o_f_i_l_e _t_w_i_c_e _l_o_g_l_i_k_e_l_i_h_o_o_d _f_o_r _s_k_e_w-_n_o_r_m_a_l _m_o_d_e_l_s

_D_e_s_c_r_i_p_t_i_o_n:

     Computation and plot of 1-dimensional and 2-dimensional profile
     2*loglikelihood for skew-normal regression models.

_U_s_a_g_e:

     sn.2logL.profile(X=matrix(rep(1, n)), y,
         param.range=c(sqrt(var(y)) * c(2/3, 3/2), -0.95, 0.95),
         use.cp=TRUE, npts=31 %/% d, plot.it=TRUE, ...)

_A_r_g_u_m_e_n_t_s:

       y: a numeric vector. Missing values ('NA's) are not allowed. 

       X: a matrix of explanatory variables; must have 'col(X)' equal
          to 'length(y). Missing values (`NA's) are not allowed. If 'X'
          is missing, a one-comun matrix of 1's is created. 

param.range: a numeric vector of length either 2 or 4. If the length is
          2, the dimensional paramter 'd' is set to 1, and a
          1-dimensional profile is computed and plotted, for the shape
          or skewness parameter (depending on the parametrization
          adopted; see below); in this case the two value represent the
          minimum and maximum value for the range of the parameter. If
          the length of 'param.range' is 4, the first two values
          determine the range of the scale parameter, the last two give
          the range of the shape (or skewness) parameter; in this case,
          'd=2'. 

  use.cp: logical value which selects the parametrization adopted. If
          'use.cp=TRUE' (default value), the centred parametrization is
          used, otherwise the direct parametrization is adopted. 

    npts: number of points (in the scalar case) or grid size (in the
          2-dimensional case). 

 plot.it: logical value which determines if plotting takes place;
          default is 'T'. 

     ...: any additional parameter is passed to 'sn.em'. 

_D_e_t_a_i_l_s:

     Likelihood maximization is performed by 'sn.em'.

     See the reference below for explanation of the two possible
     parametrizations.

_V_a_l_u_e:

     A list containing the following components

  param1: vectors of the parameters values where the function has been
          evaluated. If 'd=2', the second vector contains 'NA's. 

param.names: a character vector of two elements with the names of the
          'param1' and 'param2'. 

   2logL: a vector or a matrix which represents twice the profile
          loglikelihood; this is in the "relative" version, i.e.
          setting the maximum value to be 0. 

 maximum: a numeric value with the maximum which has been subtracted to
          obtain the "relative" version of '2logL'. 

_S_i_d_e _E_f_f_e_c_t_s:

     If 'plot.it=TRUE', a plot of the profile twice relative
     loglikeliood is produced on a graphical device.

_R_e_f_e_r_e_n_c_e_s:

     Azzalini, A. and Capitanio, A. (1999). Statistical applications of
     the multivariate skew-normal distribution. _J.Roy.Statist.Soc. B_
     *61*, 579-602.

_S_e_e _A_l_s_o:

     'sn.em', 'sn.mle'

_E_x_a_m_p_l_e_s:

     data(ais)
     attach(ais)
     a <- sn.2logL.profile(y=bmi)
     a <- sn.2logL.profile(y=bmi, use.cp=FALSE, param.range=c(3,6,1,5))
     a <- sn.2logL.profile(X=cbind(1,lbm), y=bmi, param.range=c(0,0.9),
             npts=50)
     #
     data(frontier)
     a <- sn.2logL.profile(y=frontier, param.range=c(0.8,1.6,10,30),
             use.cp=FALSE, npts=11)

