st.2logL.profile             package:sn             R Documentation

_P_r_o_f_i_l_e _t_w_i_c_e _l_o_g_l_i_k_e_l_i_h_o_o_d _f_o_r _s_k_e_w-_t _m_o_d_e_l_s

_D_e_s_c_r_i_p_t_i_o_n:

     Computation and plot of 1-dimensional and 2-dimensional profile
     (negative) twice log-likelihood function for skew-t regression
     models.

_U_s_a_g_e:

     st.2logL.profile(X=matrix(rep(1, n)), y, freq, trace=FALSE,
               fixed.comp = c(ncol(X)+2, ncol(X)+3), 
               fixed.values = cbind(c(-4,4), log(c(1,25))),
               npts=30/length(fixed.comp), plot.it=TRUE, ...)

_A_r_g_u_m_e_n_t_s:

       X: a matrix of explanatory variables; must have 'col(X)' equal
          to 'length(y)'. Missing values ('NA') are not allowed. If 'X'
          is missing, a one-column matrix of 1's is created. 

       y: a numeric vector. Missing values ('NA's) are not allowed. 

    freq: a vector of weights. If missing, a vector of 1's is created;
          otherwise it must have the same number of rows of 'y'. 

   trace: logical value which controls printing of the algorithm
          convergence. If 'trace=TRUE', details are printed. Default
          value is 'FALSE'. 

fixed.comp: a vector containing the subset of the parameters for which
          the profile log-likelihood function is required; it can be of
          length 1 or 2. The set of components of the parameters are
          'beta, log(omega),  alpha, log(df)', where 'beta' represents
          the regression parameters and has 'ncol(X)' components. 

fixed.values: a numeric vector of values or a matrix with two columns,
          giving the range spanned by the selected parameters.  

    npts: number of points on each parameter interval for which the
          function must be evaluated. 

 plot.it: logical value; if 'plot.it=TRUE' (default value) a graphical
          display is produced. 

     ...: graphical parameter passed to 'plot' or 'contour', depending
          on whether 'lenght(fixed.comp)' is 1 or 2. 

_V_a_l_u_e:

     A list containing the following components: 

    call: the matched call. 

  param1: vector of values of the first parameters values where the
          function  has been evaluated.  

  param2: vectors of the parameters values where the function has been
          evaluated.  If 'length(fixed.comp)=1', the second vector
          contains 'NA's. 

deviance: a vector or a matrix which represents twice the negative
          relative  profile loglikelihood; this is in the "relative"
          version, i.e. setting the maximum value to be 0. 

max.logL: a numeric value with the maximum which has been added to
          obtain the "relative" version of 'deviance'. 

    best: a list with the output of 'optim' at the best evaluated
          point, that is the one with higher log-likelihood.  

_S_i_d_e _E_f_f_e_c_t_s:

     If 'plot.it=TRUE', a plot of the profile twice relative
     loglikeliood is produced on a graphical device.  If
     'length(fixed.comp)=1', a plot of the `deviance' is produced as a
     function of the chosen parameter component. If
     'length(fixed.comp)=2', a contour plot is produced whose contour
     lines correspond to confidence regions of approximate probability
     levels 'c(0.25, 0.5,  0.75, 0.90,0.95, 0.99)'.

_B_a_c_k_g_r_o_u_n_d:

     The family of skew-t distributions is an extension of the
     Student's t family, via the introduction of a 'shape' parameter
     which regulates skewness; when 'shape=0', the skew-t distribution
     reduces to the usual t distribution. A multivariate version of the
     distribution exists. See the reference below for additional
     information.

_R_e_f_e_r_e_n_c_e_s:

     Azzalini, A. and Capitanio, A. (2002). Distributions generated by
     perturbation of symmetry  with emphasis on a multivariate skew _t_
     distribution. Submitted to _J.Roy. Statist. Soc._

_S_e_e _A_l_s_o:

     'st.mle', 'sn.2logL.profile'

_E_x_a_m_p_l_e_s:

     data(ais,package)
     attach(ais)
     a <- st.2logL.profile(y=bmi, xlab="alpha", ylab="log(df)")
     a <- st.2logL.profile(y=bmi, fixed.comp=4, fixed.values=log(c(1,25)))
     a <- st.2logL.profile(X=cbind(1,lbm), y=bmi, fixed.comp=5,  
              fixed.values=log(c(5,25)), xlab="log(df)", npts=50)
     a <- st.2logL.profile(X=cbind(1,Ht), y=Wt, fixed.comp=c(4,5),
              fixed.values=cbind(c(-1,5), log(c(2,25))),
              xlab="alpha", ylab="log(df)")

