### Name: mst.mle
### Title: Maximum likelihood estimation for a (multivariate) skew-t
###   distribution
### Aliases: mst.mle st.mle
### Keywords: distribution regression

### ** Examples

data(ais)
attach(ais)
M <- model.matrix(~lbm+sex)
b <- sn.mle(M, bmi)
# 
b <- mst.mle(y=cbind(Ht,Wt))
#
# a multivariate regression case:
a <- mst.mle(X=cbind(1,Ht,Wt), y=bmi, control=list(x.tol=1e-6))
#
# refine the previous outcome
a1 <- mst.mle(X=cbind(1,Ht,Wt), y=bmi, control=list(x.tol=1e-9), start=a$dp)



