### Name: lnam
### Title: Fit a Linear Network Autocorrelation Model
### Aliases: lnam coef.lnam se.lnam
### Keywords: regression multivariate

### ** Examples

#Construct a simple, random example:
w1<-rgraph(100)               #Draw the AR matrix
w2<-rgraph(100)               #Draw the MA matrix
x<-matrix(rnorm(100*5),100,5) #Draw some covariates
r1<-0.2                       #Set the model parameters
r2<-0.1
sigma<-0.1
beta<-rnorm(5)
#Assemble y from its components:
nu<-rnorm(100,0,sigma)          #Draw the disturbances
e<-qr.solve(diag(100)-r2*w2,nu) #Draw the effective errors
y<-qr.solve(diag(100)-r1*w1,x%*%beta+e)  #Compute y

#Now, fit the autocorrelation model:
fit<-lnam(y,x,w1,w2)
summary(fit)
plot(fit)



