### Name: api
### Title: Student performance in California schools
### Aliases: api apipop apiclus1 apiclus2 apistrat
### Keywords: datasets

### ** Examples

library(survey)
data(api)
mean(apipop$api00)
sum(apipop$enroll)

#stratified sample
dstrat<-svydesign(id=~1,strata=~stype, weights=~pw, data=apistrat, fpc=~fpc)
summary(dstrat)
svymean(~api00, dstrat)
svytotal(~enroll, dstrat)

# one-stage cluster sample
dclus1<-svydesign(id=~dnum, weights=~pw, data=apiclus1, fpc=~fpc)
summary(dclus1)
svymean(~api00, dclus1)
svytotal(~enroll, dclus1)

# two-stage cluster sample
dclus2<-svydesign(id=~dnum+snum, weights=~pw, data=apiclus2)
summary(dclus2)
svymean(~api00, dclus2)
svytotal(~enroll, dclus2)

# convert to replicate weights
rclus1<-as.svrepdesign(dclus1)
summary(rclus1)
svrepmean(~api00, rclus1)
svreptotal(~enroll, rclus1)

# post-stratify on school type
pop.types<-xtabs(~stype, data=apipop)

rclus1p<-postStratify(rclus1, ~stype, pop.types)
summary(rclus1p)
svrepmean(~api00, rclus1p)
svreptotal(~enroll, rclus1p)




