### Name: svytable
### Title: Contingency tables for survey data
### Aliases: svreptable svytable svychisq summary.svytable
###   print.summary.svytable summary.svreptable
### Keywords: survey category htest

### ** Examples

  data(api)
  xtabs(~sch.wide+stype, data=apipop)

  dclus1<-svydesign(id=~dnum, weights=~pw, data=apiclus1, fpc=~fpc)
  summary(dclus1)

  svytable(~sch.wide+stype, dclus1)
  svychisq(~sch.wide+stype, dclus1)
  svychisq(~sch.wide+stype, dclus1, statistic="Chisq")
 svychisq(~sch.wide+stype, dclus1, statistic="adjWald")

  rclus1 <- as.svrepdesign(dclus1)
  svreptable(~sch.wide+stype, rclus1, round=TRUE)




