### Name: svyglm
### Title: Survey-weighted generalised linear models.
### Aliases: svyglm svrepglm print.svyglm summary.svyglm summary.svrepglm
###   print.summary.svyglm vcov.svyglm residuals.svyglm residuals.svrepglm
###   coef.svyglm extractAIC.svyglm extractAIC.svrepglm logLik.svyglm
###   logLik.svrepglm
### Keywords: regression survey

### ** Examples


  data(api)

  glm(api00~ell+meals+mobility, data=apipop)

  dstrat<-svydesign(id=~1,strata=~stype, weights=~pw, data=apistrat, fpc=~fpc)
  dclus2<-svydesign(id=~dnum+snum, weights=~pw, data=apiclus2)
  rstrat<-as.svrepdesign(dstrat)
  rclus2<-as.svrepdesign(dclus2)

  summary(svyglm(api00~ell+meals+mobility, design=dstrat))
  summary(svyglm(api00~ell+meals+mobility, design=dclus2))
  summary(svrepglm(api00~ell+meals+mobility, design=rstrat))
  summary(svrepglm(api00~ell+meals+mobility, design=rclus2))

  ## use quasibinomial, quasipoisson to avoid warning messages
  summary(svyglm(sch.wide~ell+meals+mobility, design=dstrat, family=quasibinomial()))

 


