\name{balanced.overlap}
\alias{balanced.overlap}
\alias{balanced.separated}
\alias{unbalanced.separated}
\alias{mixture.data}
\docType{data}
\title{simple examples for svmpath}
\description{
Datasets for illustrating the svmpath function, that can be plotted
while its running
}
\usage{data(svmpath)}
\format{
In each case a list with a component \code{x} (t column matrix) and a
component \code{y} (vector of +1/-1 values)
"Balanced" refers to whether the number of +1s is the same as the -1s.
"Overlap" indicates whether the classes are linearly separable.
\code{mixture.data} is a balanced dataset with 100 observations in
each class. The others are smaller with between 10-12 obs total.}
\references{The paper \url{http://www-stat.stanford.edu/~hastie/Papers/svmpath.pdf}, as well
as the talk \url{http://www-stat.stanford.edu/~hastie/TALKS/svmpathtalk.pdf}.
}
\examples{
data(svmpath)
attach(balanced.overlap)
svmpath(x,y,trace=TRUE,plot=TRUE)
detach(2)
}
\keyword{datasets}

\eof
\name{predict.svmpath}
\alias{predict.svmpath}
\title{Make predictions from a svmpath object}
\description{
  Provide a value for \code{lambda}, and produce the fitted lagrange \code{alpha}
  values. Provide values for \code{x}, and get fitted function values or
  class labels.
}
\usage{
predict.svmpath(object, newx, lambda, type = c("function", "class", "alpha"),...)
}
\arguments{
  \item{object}{fitted \code{svmpath} object}
  \item{newx}{values of \code{x} at which prediction are wanted. This is a
    matrix with observations per row}
  \item{lambda}{the value of the regularization parameter. Note that
    \code{lambda} is equivalent to 1/C for the usual parametrization of
    a SVM}
  \item{type}{type of prediction, with default \code{"function"}. For
    \code{type="alpha"} the  \code{newx} argument is not required}
  \item{...}{Generic compatibility}
}
\details{
This implementation of the SVM uses a parameterization that is slightly
different but equivalent to the usual (Vapnik) SVM. Here
\eqn{\lambda=1/C}{lambda=1/C}.
The Lagrange multipliers are related via
\eqn{\alpha^*_i=\alpha_i/\lambda}{\alphastar = alpha/lambda}, where
\eqn{\alpha^*_i}{alphastar} is the usual multiplier, and
\eqn{\alpha_i}{alpha} our multiplier. Note that if \code{alpha=0}, that
observation is right of the elbow; \code{alpha=1}, left of the elbow;
\code{0<alpha<1} on the elbow. The latter two cases are all support
points.
}
\value{
  In each case, the desired prediction.
}
\references{The paper \url{http://www-stat.stanford.edu/~hastie/Papers/svmpath.pdf}, as well
as the talk \url{http://www-stat.stanford.edu/~hastie/TALKS/svmpathtalk.pdf}.
}
\author{Trevor Hastie}

\seealso{coef.svmpath, svmpath}
\examples{
data(svmpath)
attach(balanced.overlap)
fit <- svmpath(x,y,trace=TRUE,plot=TRUE)
predict(fit, lambda=1,type="alpha")
predict(fit, x, lambda=.9)
detach(2)
}
\keyword{regression}

\eof
\name{print.svmpath}
\alias{print.svmpath}
\title{Print a summary of the SVM path}
\description{
print a summary of the fitted svmpath object
}
\usage{
print.svmpath(x, digits, ...)
}
\arguments{
  \item{x}{object to be printed}
  \item{digits}{number of significant digits (default 6)}
  \item{...}{additional arguments to the generic print function}
  }
\value{
  For each step taken by the algorithm, one or more lines are printed.
  The step is described in terms of the observation number involved, a
  coded version of what happened, such as "L->E" meaning "from the Left
  set" to the "Elbow". Initially all the sets are empty. It gives the
  margin (sum of the xi), the size of the elbow, and the training error.}
\references{The paper \url{http://www-stat.stanford.edu/~hastie/Papers/svmpath.pdf}, as well
as the talk \url{http://www-stat.stanford.edu/~hastie/TALKS/svmpathtalk.pdf}.
}
\author{Trevor Hastie}

\seealso{coef.svmpath, svmpath, predict.svmpath}
\examples{
data(svmpath)
attach(balanced.overlap)
fit <- svmpath(x,y,trace=TRUE,plot=TRUE)
print(fit)
detach(2)
}
\keyword{regression}

\eof
\name{radial.kernel}
\alias{radial.kernel}
\alias{poly.kernel}
\title{compute the kernel matrix for svmpath}
\description{
compute the kernel matrix for svmpath
}
\usage{
radial.kernel(x, y=x, param.kernel = 1)
poly.kernel(x, y=x, param.kernel = 1)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{an n x p matrix of features}
  \item{y}{an m x p matrix of features (if omitted, it defaults to \code{x})}
  \item{param.kernel}{the parameter(s) for the kernel. For this radial
    kernel, the parameter is known in the fields as "gamma". For the
    polynomial kernel, it is the "degree"}
}
\details{
For the radial kernel, this computes the function \eqn{\exp(-\gamma||x-y||^2)}{exp(-g||x-y||^2)} for each pair of rows x,y
from the input matrices. Here g is param.kernel.
For the polynomial kernel, it computes \eqn{(xy^T+1)^d}{(xy'+1)^d}, where d is \code{param.kernel}.
}
\value{
An n x m matrix.}
\references{The paper \url{http://www-stat.stanford.edu/~hastie/Papers/svmpath.pdf}, as well
as the talk \url{http://www-stat.stanford.edu/~hastie/TALKS/svmpathtalk.pdf}.
}
\author{Trevor Hastie}

\seealso{svmpath}
\examples{
data(svmpath)
attach(balanced.overlap)
fit<-svmpath(x,y,kernel=radial.kernel)
detach(2)
}
\keyword{regression}

\eof
\name{summary.svmpath}
\alias{summary.svmpath}
\title{produce a summary of an svmpath object}
\description{
printing an svmpath object can produce a lot of lines. The summary
methods gives a more concise description by picking out a subset of the
steps
}
\usage{
summary.svmpath(object, nsteps = 5, digits = 6, ...)
}
\arguments{
  \item{object}{the \code{svmpath} object}
  \item{nsteps}{usually omitted, but can be changed to get longer
    summaries}
  \item{digits}{number of significant digits}
  \item{...}{additional arguments to the generic summary function}
}
\details{
Uses the \code{pretty} function to extract the approximately the desired
number of steps. Always includes the first and last step.
}
\value{
returns a dataframe with the steps, value of lambda, training error,
size of elbow, number of support points, and the sum of the overlaps}
\references{The paper \url{http://www-stat.stanford.edu/~hastie/Papers/svmpath.pdf}, as well
as the talk \url{http://www-stat.stanford.edu/~hastie/TALKS/svmpathtalk.pdf}.
}
\author{Trevor Hastie}
\seealso{coef.svmpath, svmpath, predict.svmpath, print.svmpath}
\examples{
data(svmpath)
attach(balanced.overlap)
fit <- svmpath(x,y,trace=TRUE,plot=TRUE)
summary(fit)
detach(2)
}
\keyword{regression}

\eof
\name{svmpath-internal}
\title{svm internal functions}
 \alias{.First.lib}               
 \alias{Balanced.Initialization}  
 \alias{coef.svmpath}             
 \alias{DowndateKstar}
 \alias{enlist}                   
 \alias{get.svmstep}              
 \alias{modulus}                  
 \alias{OptInit.alpha}            
 \alias{PrintPath}                
 \alias{SnapPath}                 
 \alias{SolveKstar}               
 \alias{StatPath}                 
 \alias{Unbalanced.Initialization}
 \alias{UpdateKstar}
 \description{Internal svmpath functions}
 \author{Trevor Hastie}
 \keyword{internal}
 

\eof
\name{svmpath}
\alias{svmpath}
\title{Fit the entire regularization path for a 2-class SVM}
\description{
  The SVM has a regularization or cost parameter C, which controls the
amount by which points overlap their soft margins. Typically either a
default large value for C is chosen (allowing minimal overlap),
or else a few values are compared
using a valication set. This algorithm computes the entire
regularization path (i.e. for all possible values of C for which the
solution changes), with a cost a small (~3)  multiple of the cost of fitting a
single model.
}
\usage{
svmpath(x, y, K, kernel.function = poly.kernel, param.kernel = 1, trace, plot.it, linear.plot, eps = 1e-10, Nmoves = 3 * n, digits = 6, lambda.min = 1e-04, ...)
}
\arguments{
  \item{x}{the data matrix (n x p) with n rows (observations) on p
    variables (columns)}
  \item{y}{The {-1,+1} valued response variable.}
  \item{K}{a n x n kernel matrix, with default value \code{K= kernel.function(x, x)}}
  \item{kernel.function}{This is a user-defined function. Provided are
    \code{poly.kernel} (the default, with parameter set to default to a
    linear kernel) and \code{radial.kernel}}
  \item{param.kernel}{parameter(s) of the kernels}
  \item{trace}{if \code{TRUE}, a progress report is printed as the
    algorithm runs; default is \code{FALSE}}
  \item{plot.it}{a flag indicating whether a plot should be produced
    (default \code{FALSE}; only usable with \code{p=2}}
  \item{linear.plot}{if \code{TRUE}, the plotting routine exploits the
    knowledge that the solution is linear; otherwise a contour algorithm
  is used. The default is \code{missing(kernel)} (i.e. \code{TRUE} if a
  default linear kernel is used}
  \item{eps}{a small machine number which is used to identify minimal
    step sizes}
  \item{Nmoves}{the maximum number of moves}
  \item{digits}{the number of digits in the printout}
  \item{lambda.min}{The smallest value of \code{lambda = 1/C}; default
    is \code{lambda=10e-4}, or \code{C=10000}}
  \item{...}{additional arguments to some of the functions called by svmpath}
}
\details{
  The algorithm used in \code{svmpath()} is described in detail in
  "The Entire Regularization Path for the Support Vector Machine" by
  Hastie, Rosset, Tibshirani and Zhu (2004). It exploits the fact that
  the "hinge" loss-function is piecewise linear, and the penalty term is
  quadratic. This means that in the dual space, the lagrange multipliers
  will be pieceise linear (c.f. \code{lars}).
  }
\value{
a "svmpath" object is returned, for which there are print, summary, coef
and predict methods.}
\references{The paper \url{http://www-stat.stanford.edu/~hastie/Papers/svmpath.pdf}, as well
as the talk \url{http://www-stat.stanford.edu/~hastie/TALKS/svmpathtalk.pdf}.
}
\author{Trevor Hastie}
\note{This algorithm does not use updating to solve the "elbow"
  linear equations. This is possible, since the elbow changes by a small
  number of points at a time. Future version of the software will do
  this. The author has encountered numerical problems with early
  attempts at this.}
\section{Warning}{Currently the algorithm can get into machine errors if
  \code{epsilon} is too small, or if \code{lambda.min} is too
  small. Increasing either from their defaults should make the problems
  go away, by terminating the algorithm slightly early.}
\seealso{print, coef, summary, predict, and FilmPath}
\examples{
data(svmpath)
attach(balanced.overlap)
svmpath(x,y,trace=TRUE,plot=TRUE)
detach(2)
\dontrun{svmpath(x,y,kernel=radial.kernel,param.kernel=.8)}
}
\keyword{regression}

\eof
