### Name: hausman.systemfit
### Title: Hausman's Test
### Aliases: hausman.systemfit
### Keywords: models

### ** Examples

## Not run: library( systemfit )

data( kmenta )
attach( kmenta )
demand <- q ~ p + d
supply <- q ~ p + f + a
inst <- ~ d + f + a
labels <- list( "demand", "supply" )
system <- list( demand, supply )

## perform the estimation and report the results for the whoel system
fit2sls <- systemfit( "2SLS", system, labels, inst)
fit3sls <- systemfit( "3SLS", system, labels, inst)

## perform the hausman test on the first equation
h <- hausman.systemfit( fit2sls, fit3sls )
pval <- pchisq( h, dim( fit3sls$bcov )[1] )

print( h )
print( pval )




