### Name: lrtest.systemfit
### Title: Likelihood Ratio test for Equation Systems
### Aliases: lrtest.systemfit
### Keywords: models

### ** Examples

## Not run: library( systemfit )
data( kmenta )
demand <- q ~ p + d
supply <- q ~ p + f + a
labels <- list( "demand", "supply" )
system <- list( demand, supply )

## unconstrained SUR estimation
fitsur <- systemfit("SUR", system, labels, data=kmenta )
print( fitsur )

## SUR estimation with 2 restrictions
Rrestr <- matrix(0,2,7)
qrestr <- matrix(0,2,1)
Rrestr[1,3] <-  1
Rrestr[1,7] <- -1
Rrestr[2,2] <- -1
Rrestr[2,5] <-  1
qrestr[2,1] <-  0.5
fitsur2 <- systemfit("SUR", system, labels, data=kmenta,
                      R.restr=Rrestr, q.restr=qrestr )
print( fitsur2 )

## perform LR-test
lrtest.systemfit( fitsur2, fitsur )



