### Name: prediction.systemfit
### Title: Predictions from Equation System Estimation
### Aliases: prediction.systemfit
### Keywords: models

### ** Examples

## Not run: library( systemfit )
data( kmenta )
demand <- q ~ p + d
supply <- q ~ p + f + a
labels <- list( "demand", "supply" )
system <- list( demand, supply )

## OLS estimation
fitols <- systemfit("OLS", system, labels, data=kmenta )
print( fitols )

## calculate predicted values and limits
pred <- prediction.systemfit( fitols )
print( pred[[2]]$prediction.limits )



