### Name: systemfit
### Title: Equation System Estimation
### Aliases: systemfit
### Keywords: models regression

### ** Examples

## Not run: library( systemfit )
data( kmenta )
demand <- q ~ p + d
supply <- q ~ p + f + a
labels <- list( "demand", "supply" )
system <- list( demand, supply )

## OLS estimation
fitols <- systemfit("OLS", system, labels, data=kmenta )
print( fitols )

## OLS estimation with 2 restrictions
Rrestr <- matrix(0,2,7)
qrestr <- matrix(0,2,1)
Rrestr[1,3] <-  1
Rrestr[1,7] <- -1
Rrestr[2,2] <- -1
Rrestr[2,5] <-  1
qrestr[2,1] <-  0.5
fitols2 <- systemfit("OLS", system, labels, data=kmenta,
                      R.restr=Rrestr, q.restr=qrestr )
print( fitols2 )

## iterated SUR estimation
fitsur <- systemfit("SUR", system, labels, data=kmenta, maxit=100 )
print( fitsur )

## 2SLS estimation
inst <- ~ d + f + a
fit2sls <- systemfit( "2SLS", system, labels, inst, kmenta )
print( fit2sls )

## 2SLS estimation with different instruments in each equation
inst1 <- ~ d + f
inst2 <- ~ d + f + a
instlist <- list( inst1, inst2 )
fit2sls2 <- systemfit( "2SLS", system, labels, instlist, kmenta )
print( fit2sls2 )

## 3SLS estimation with GMM-3SLS formula
inst <- ~ d + f + a
fit3sls <- systemfit( "3SLS", system, labels, inst, kmenta, formula3sls="GMM" )
print( fit3sls )




