### Name: fixed.n
### Title: Optimal second stage sampling fractions, subject to fixed sample
###   sizes at the first and second stage
### Aliases: fixed.n
### Keywords: design

### ** Examples

## Not run: 
##D This example of computing second stage sampling fractions subject
##D to a fixed total second-stage sample size uses the CASS data 
##D (Reilly, 1996). Once the TWOSTAGE library has been attached,
##D this data can be made available by:
## End(Not run)
data(cass1)

## Not run: and a detailed description of the data can be obtained by 

help (cass1) 

## Not run: In this example, we suppose that the CASS registry only has available
##D the mortality(Y) and sex(Z) for the 8096 "first-stage" subjects. The pilot
##D data consists of 25 observations from each (Y,Z) stratum, where the sizes of
##D the strata are (see Reilly 1996):
##D         Y       Z       N
##D         0       0       6666
##D         0       1       1228
##D         1       0       144
##D         1       1       58
##D We wish to use this pilot information to compute the optimal design to 
##D minimise the variance of the sex coefficient in a logistic model 
##D with Sex and Age as predictors . Assume that we wish to sample a total
##D of 1000 subjects at the second stage.
##D 
##D The following commands give the output below:
## End(Not run)

data(cass1)
y=cass1[,1]     #--- the response variable is mortality
z=cass1[,3]     #--- the auxiliary variable is sex
x=cass1[,2:3] #--- the variables in the model are sex and age

# run CODING function to see in which order we should enter n1
coding(x=x,y=y,z=z)     
#supplying the first stage sample sizes
n1=c(6666, 1228, 144, 58)
 
# variable to be optimised (in our case sex)
fixed.n(x=x,y=y,z=z,n1=n1,var="sex",n2=1000)

## Not run: 
##D will give us the following output 
##D [1] "please run coding function to see the order in which you"
##D [1] "must supply the first-stage sample sizes or prevalences"
##D [1] " Type ?coding for details!"
##D [1] "For calls requiring n1 or prev as input, use the following order"
##D      ylevel z new.z n2
##D [1,]      0 0     0 25
##D [2,]      0 1     1 25
##D [3,]      1 0     0 25
##D [4,]      1 1     1 25
##D [1] "Check sample sizes/prevalences"
##D $design
##D      ylevel zlevel   n1 n2   prop samp.2nd
##D [1,]      0      0 6666 25 0.1128      752
##D [2,]      0      1 1228 25 0.0375       46
##D [3,]      1      0  144 25 1.0000      144
##D [4,]      1      1   58 25 1.0000       58
##D 
##D $se
##D                   [,1]
##D (Intercept) 0.55496070
##D age         0.00956422
##D sex         0.16472156
## End(Not run)



