### Name: ms.nprev
### Title: Logistic regression of two-stage data using second stage sample
###   and first stage sample sizes or proportions (prevalences) as input
### Aliases: ms.nprev
### Keywords: regression

### ** Examples

## Not run: As an illustrative example, we use the CASS pilot data,"cass1"
##D from Reilly (1996)
##D 
##D Use 
## End(Not run)
data(cass1)        #to load the data
## Not run: and
help(cass1)        #for details

## Not run: The first-stage sample sizes are:
##D 
##D         Y       Z       n
##D         0       0       6666
##D         0       1       1228
##D         1       0       144
##D         1       1       58      
##D 
##D An analysis of the pilot data using Mean Score
## End(Not run)

# supply the first stage sample sizes in the correct order
n1=c(6666, 1228, 144, 58)
ms.nprev(y=cass1[,1], x=cass1[,2:3],z=cass1[,3],n1=n1)

## Not run: gives the results:
##D 
##D [1] "please run coding function to see the order in which you"
##D [1] "must supply the first-stage sample sizes or prevalences"
##D [1] " Type ?coding for details!"
##D [1] "For calls requiring n1 or prev as input, use the following order"
##D      ylevel z new.z n2
##D [1,]      0 0     0 25
##D [2,]      0 1     1 25
##D [3,]      1 0     0 25
##D [4,]      1 1     1 25
##D [1] "Check sample sizes/prevalences"
##D $table
##D      ylevel zlevel   n1 n2
##D [1,]      0      0 6666 25
##D [2,]      0      1 1228 25
##D [3,]      1      0  144 25
##D [4,]      1      1   58 25
##D 
##D $parameters
##D                     est         se         z       pvalue
##D (Intercept) -5.06286163 1.46495235 -3.455991 0.0005482743
##D age          0.02166536 0.02584049  0.838427 0.4017909402
##D sex          0.67381300 0.21807878  3.089769 0.0020031236
## End(Not run)

## Not run: 
##D Note that the Mean Score algorithm produces smaller 
##D standard errors of estimates than the complete-case
##D analysis, due to the additional information in the
##D incomplete cases.
## End(Not run)



