### Name: precision
### Title: Optimal sampling design for 2-stage studies with fixed precision
### Aliases: precision
### Keywords: design

### ** Examples


## Not run: 
##D This example uses the same CASS dataset (cass2) which is used
##D in the example of the "budget" function. The data are in the
##D cass2 matrix, which can be loaded using
## End(Not run)

data(cass2)
## Not run: and a description of the dataset can be seen using

help(cass2)

## Not run: 
##D In our example below, we use sex and weight as auxiliary variables. 
##D The commands below will calculate the sampling design which will achieve a 
##D variance of 0.0472 for the coefficient of SEX subject to 
##D minimising the study cost. We assume a first-stage cost of  1/unit
##D and second-stage cost of  0.5/unit,
## End(Not run)

data(cass2) 
y=cass2[,1]                  #response variable
z=cass2[,10]             #auxiliary variable
x=cass2[,c(2,4:9)]       #predictor variables in the model

# run CODING function to see in which order we should enter prevalences
coding(x=x,y=y,z=z)     

# supplying the prevalence (from Table 5, Reilly 1996)
prev=c(0.0197823937,0.1339020772,0.6698813056,0.0544015826,
+ 0.0503214639,0.0467359050,0.0009891197,0.0040801187,0.0127349159,
+ 0.0022255193,0.0032146390,0.0017309594)

# optimise SEX coefficient
precision(x=x,y=y,z=z,var="sex",prev=prev,prc=0.0472,c1=1,c2=0.5)

## Not run: This will give us the following output:
##D 
##D [1] "please run coding function to see the order in which you"
##D [1] "must supply the first-stage sample sizes or prevalences"
##D [1] " Type ?coding for details!"
##D [1] "For calls requiring n1 or prev as input, use the following order"
##D       ylevel z new.z n2
##D  [1,]      0 1     1 10
##D  [2,]      0 2     2 10
##D  [3,]      0 3     3 10
##D  [4,]      0 4     4 10
##D  [5,]      0 5     5 10
##D  [6,]      0 6     6 10
##D  [7,]      1 1     1  8
##D  [8,]      1 2     2 10
##D  [9,]      1 3     3 10
##D [10,]      1 4     4 10
##D [11,]      1 5     5 10
##D [12,]      1 6     6 10
##D [1] "Check sample sizes/prevalences"
##D $n
##D [1] 9165
##D 
##D $design
##D       ylevel zlevel         prev n2   prop samp.2nd
##D  [1,]      0      1 0.0197823937 10 0.5230       95
##D  [2,]      0      2 0.1339020772 10 0.2841      349
##D  [3,]      0      3 0.6698813056 10 0.0726      446
##D  [4,]      0      4 0.0544015826 10 0.4488      224
##D  [5,]      0      5 0.0503214639 10 0.2480      114
##D  [6,]      0      6 0.0467359050 10 0.4922      211
##D  [7,]      1      1 0.0009891197  8 1.0000        9
##D  [8,]      1      2 0.0040801187 10 1.0000       37
##D  [9,]      1      3 0.0127349159 10 1.0000      117
##D [10,]      1      4 0.0022255193 10 1.0000       20
##D [11,]      1      5 0.0032146390 10 1.0000       29
##D [12,]      1      6 0.0017309594 10 1.0000       16
##D 
##D $cost
##D [1] 9998
##D 
##D $var
##D                     [,1]
##D (Intercept) 1.424664e+00
##D sex         4.719827e-02
##D weight      4.514397e-05
##D age         2.128650e-04
##D angina      6.044365e-02
##D chf         5.935923e-03
##D lve         1.014436e-04
##D surg        3.236426e-02 
##D 
##D CHECK: 
##D Note that the minimum cost obtained is the same as our budget
##D in the fixed budget problem (10,000), and all the solutions are 
##D the same except for rounding error. 
## End(Not run)



