\name{CookRLF.varobj}
\alias{CookRLF.varobj}
\title{Plot of
Cook's Distances and Reduction Lack of Fit}
\description{
Produces a plot of
Cook's Distances and Lack of Fit for a variogram object.}
\usage{
CookRLF.varobj(v)
}
\arguments{
  \item{v}{A variogram object}
}
\details{
A plot is created on the current graphics device with Reduction in Lack of Fit
on the horizontal axis and Cook's Distances on the vertical
axis.

After the plot is created,
the cursor changes to a cross and points can be identified by left
mouse clicks. When there are no further points to be identified,
the identification can be ended by a right mouse click.
}
%\value{
%  ~Describe the value returned
%  If it is a LIST, use
%  \item{comp1 }{Description of `comp1'}
%  \item{comp2 }{Description of `comp2'}
%  ...
%}
%\references{ ~put references to the literature/web site here ~ }
\author{Ernst  Glatzer}
%\note{ ~~further notes~~ }

\seealso{\code{\link{PlotDiag.varobj}}}

\examples{
data(tulln)
CookRLF.varobj(vs50)
}
\keyword{dynamic}
\eof
\name{PlotDiag.varobj}
\alias{PlotDiag.varobj}
\title{Diagnostic Plots for Variograms}
\description{ Produces diagnostic plots for a variogram object. }
\usage{ PlotDiag.varobj(v, region = 0, xyi = 0, zmv = 0) }
\arguments{
  \item{v}{A variogram object}
  \item{region}{a n by 2 matrix of vertices of a polygon,
    which represents the region of interest.}
  \item{xyi}{the index of the pair of observations, which shall be
    marked in the plots.}
  \item{zmv}{the value of \code{zmv}= determines which values will be
plotted as third dimension (via circles with radius corresponding
to the value) in the map view. The following values are possible:
\describe{
  \item[0] no third dimension,
  \item[1] values of the original observations,
  \item[2] Cook's distances,
  \item[3] reduction in lack of fit.
}
}
}
\details{
Four plots are created on the current graphics device.

These plots are a map
    view, a square root cloud with the fitted model, a leave-one-out plot and a plot of decorrelated residuals.
    If the argument \code{region} is given, this region is plotted as a polygon in the map view. If the argument
    \code{xyi} is given, the corresponding pair of observations is marked as a blue and a red point in the map view and
    connected by a magenta line. Furthermore all the points in the square root cloud, which contain the first (second)
    observation in the pair are marked blue (red). The one point that contains both observations of the selected pair
    is marked magenta. The points in the leave-one-out plot are marked analogously.
}
\value{
  No value is returned. The function is called for its side
  effects, i.e. creating plots.
}
%\references{ ~put references to the literature/web site here ~ }
\author{Ernst  Glatzer}
%\note{ ~~further notes~~ }

\seealso{\code{\link{interact.varobj}}}

\examples{
data(tulln)
PlotDiag.varobj(vs50,region=tu1)
PlotDiag.varobj(vs50,region=tu1,xyi=144)
}
\keyword{dynamic}
\eof
\name{QQDecorr.varobj}
\alias{QQDecorr.varobj}
\title{QQ-Plot of Decorrelated Residuals}
\description{
Produces a qq-plot
of decorrelated residuals for a variogram object.
}
\usage{
QQDecorr.varobj(v)
}
\arguments{
  \item{v}{A variogram object }
}
\details{
A plot is created on the current graphics device with
quantiles of the normal distribution on the horizontal axis and
ordered values of the decorrelated residuals on the vertical
axis.

A straight red line marks the expected curve of this plot.
Additionally approximate confidence bounds for 10\% significance
are given.
}
%\value{
%  ~Describe the value returned
%  If it is a LIST, use
%  \item{comp1 }{Description of `comp1'}
%  \item{comp2 }{Description of `comp2'}
%  ...
%}
%\references{ ~put references to the literature/web site here ~ }
\author{Ernst  Glatzer}
%\note{ ~~further notes~~ }

\seealso{\code{\link{PlotDiag.varobj}}}

\examples{
data(tulln)
QQDecorr.varobj(vs50)
}
\keyword{dynamic}
\eof
\name{QQVarcloud.varobj}
\alias{QQVarcloud.varobj}
\title{QQ-Plot of Variogram Cloud Entries}
\description{
Produces a qq-plot
of variogram cloud entries for a variogram object.
}
\usage{
QQVarcloud.varobj(v)
}
\arguments{
  \item{v}{A variogram object}
}
\details{
A plot is created on the current graphics device with
quantiles of the chi-square distribution on the horizontal axis
and ordered values of $\frac{(Z(s)-Z(s'))^2}{\gamma(s-s')}$ on the
vertical axis.

A straight red line marks the expected curve of this plot.
Additionally approximate confidence bounds for 10\% significance
are given.
}
%\value{
%  ~Describe the value returned
%  If it is a LIST, use
%  \item{comp1 }{Description of `comp1'}
%  \item{comp2 }{Description of `comp2'}
%  ...
%}
%\references{ ~put references to the literature/web site here ~ }
\author{Ernst  Glatzer}
%\note{ ~~further notes~~ }

\seealso{\code{\link{PlotDiag.varobj}}}

\examples{
data(tulln)
QQVarcloud.varobj(vs50)
}
\keyword{dynamic}
\eof
\name{interact.varobj}
\alias{interact.varobj}
\title{Interactive Identification of Points in a Variogram Diagnostics
Plot}
\description{
Initiates selection of points in a Variogram Diagnostics Plot.
}
\usage{
interact.varobj(v, region = 0, g = "s", pchi = 0.05, zmv = 0)
}
\arguments{
  \item{v}{A variogram object}
  \item{region}{a n by 2 matrix of vertices of a polygon,
    which represents the region of interest.}
  \item{g}{the type of interaction with the following options:
  \describe{
  \item[l] selection of a point in the leave-one-out plot.
  \item[m] selection of one or two points in the map view. After selection of one point the
            selection process can be stopped by a right mouse click.
  \item[n] selection of a polygon region in the map view. This can
            be done by left clicking on the vertices of the polygon and
            stopping by a right mouse click.
  \item[s] selection of a point in the studentized square root
            cloud.
  \item[t] selection of a polygon region in the studentized square root
            cloud. This can
            be done by left clicking on the vertices of the polygon and
            stopping by a right mouse click.
  \item[x] selection of all points in the studentized square root
            cloud outside an approximate confidence bound with significance level given by \code{pchi}.
}
}
  \item{pchi}{the significance level of the confidence bounds, if option
\code{g="x"} is given.}
  \item{zmv}{the value of \code{zmv} determines which values will be
ploted as third dimension (via circles with radius corresponding
to the value) in the map view. The following values are possible:
  \describe{
  \item[0] no third dimension,
  \item[1] values of the original observations,
  \item[2] Cook's distances,
  \item[3] reduction in lack of fit.
}
}
}
\details{
  Before the call of this function a diagnostic plot must be
created by a call to the function \code{PlotDiag.varobj}.

If one point in the map view is selected, this point is marked
blue and the index of this observation is printed near the point.
All corresponding points in the square root cloud and the
leave-one-out plot are marked blue.

If two points in the map view (or one point in the square root
cloud or in the leave-one-out plot) are selected, this pair of
points is joined by a magenta line and the corresponding point in
the square root cloud is marked magenta. One of the selected
points in the map view and all corresponding points in the square
root cloud and the leave-one-out plot are marked blue. The other
selected point in the map view and all corresponding points in the
square root cloud and the leave-one-out plot are marked red.

If a region is selected in the map view, all possible pairs of
points within the region are joined by magenta lines and for each
pair the corresponding point in the square root cloud is marked
magenta.

If a region in the square root cloud is selected, all points
within that region are marked magenta and all corresponding pairs
of points in the map view are joined by magenta lines.

If option \code{g="x"} is selected, all points in the square root
cloud outside the chosen confidence bound are marked magenta and
all corresponding pairs of points in the map view are joined by
magenta lines.
}
\value{
 the index of the selected pair of observations.
}
%\references{ ~put references to the literature/web site here ~ }
\author{Ernst  Glatzer}
%\note{ ~~further notes~~ }

\seealso{\code{\link{PlotDiag.varobj}}}

\examples{
data(tulln)
PlotDiag.varobj(vs50,region=tu1)
% interact.varobj(vs50,region=tu1,g='s')
}
\keyword{dynamic}
\eof
\name{tulln}
\alias{tulln}
\alias{tu1}
\alias{vs50}
\non_function{}

\title{Data on Chlorid concentrations in the Sdliche Tullnerfeld}

\description{
The \code{tulln} dataset contains a variogram object and a matrix
with the coordinates of the vertices of a polygonal region.

}

\format{
  This dataset consists of a variogram object and a matrix.
  }

\details{
The variogram model used is a spherical model.
}

\source{
 Glatzer, E and Mueller, W.G. (2002).
}

\references{
  Glatzer, E and Mueller, W.G. (2002).
}


\usage{
data(tulln)
}
\keyword{datasets}
\eof
\name{vardiag-internal}
\alias{estvar}
\alias{ficorr}
\alias{ftc}
\alias{ftg}
\alias{fth}
\alias{fts}
\alias{gamsph}
\alias{gamsph1}
\alias{gamsph2}
\alias{gamsph3}
\alias{hyperg}
\alias{print.varobj}

\title{Internal vardiag functions}

\description{
Internal functions for package vardiag.
}

\usage{
estvar(h0, y, iter = 50, tolerance = 2e-04, trace = 1, th0 = rbind(0, 1, 1))
ficorr(r)
ftc(th, y, h1, w1)
ftg(th, y, h1, cv1)
fth(th, y, h1, w1 = 1)
fts(th, y, h1, cv1)
gamsph(h, th = rbind(1, 1, 1))
gamsph1(h, th = rbind(1, 1, 1))
gamsph2(h, th = rbind(1, 1, 1))
gamsph3(h, th = rbind(1, 1, 1))
hyperg(r)
print.varobj(x, ...)
}

\arguments{
  \item{...}{}
  \item{cv1}{}
  \item{h}{}
  \item{h0}{}
  \item{h1}{}
  \item{iter}{}
  \item{r}{}
  \item{th}{}
  \item{th0}{}
  \item{tolerance}{}
  \item{trace}{}
  \item{w1}{}
  \item{x}{}
  \item{y}{}
}

\details{
These functions are not intended to be called by the user.
}

\author{Ernst Glatzer}

\keyword{misc}
\eof
\name{varobj}
\alias{varobj}
\title{Function for variogram fitting}
\description{
This function fits a variogram model to spatial data and calculates some statistics.
}
\usage{
varobj(m, iter = 50, tolerance = 2e-04, trace = 1, loo = F)
}
\arguments{
  \item{m}{n by 3 matrix with spatial data}
  \item{iter}{this argument is put forward to the optimization routine}
  \item{tolerance}{this argument is put forward to the optimization routine}
  \item{trace}{if set to values higher than 1 some debug messages are given}
  \item{loo}{if set to TRUE, leave-one-out residuals are clculated}
}
\details{
  Only spherical variogram models are fitted.
}
\value{
  a variogram object
}
%\references{ ~put references to the literature/web site here ~ }
\author{Ernst  Glatzer}
%\note{ ~~further notes~~ }

\seealso{\code{\link{PlotDiag.varobj}}}

\examples{
data(tulln)
}
\keyword{spatial}
\eof
