### Name: ternaryplot
### Title: Ternary diagram
### Aliases: ternaryplot
### Keywords: hplot

### ** Examples

data(Arthritis)

## Build table by crossing Treatment and Sex
tab <- as.table(xtabs(~ I(Sex:Treatment) + Improved, data = Arthritis))

## Mark groups
col <- c("red", "red", "blue", "blue")
pch <- c(1, 19, 1, 19)

## plot
ternaryplot(
            tab,
            col = col,
            pch = pch,
            prop.size = TRUE,
            bg = "lightgray",
            grid.color = "white",
            labels.color = "white",
            main = "Arthritits Treatment Data"
           )
## legend
legend(0.7, 0.8,
       c("GROUP", rownames(tab)),
       pch = c(NA, pch),
       col = c(NA, col)
      )

data(Lifeboats)
attach(Lifeboats)
ternaryplot(
  Lifeboats[,4:6],
  pch = ifelse(side=="Port", 1, 19),
  col = ifelse(side=="Port", "red", "blue"),
  id  = ifelse(men/total > 0.1, as.character(boat), NA),
  prop.size = 2,
  dimnames.position = "edge",
  main = "Lifeboats on Titanic"
)
legend(
  0.8, 0.9,
  legend = c("SIDE", "Port", "Starboard"),
  pch = c(NA, 1, 19),
  col = c("black", "red", "blue"),
)

data(Hitters)
attach(Hitters)
colors <- c("black","red","green","blue","red","black","blue")
pch <- substr(levels(Positions), 1, 1)
ternaryplot(
  Hitters[,2:4],
  pch = as.character(Positions),
  col = colors[as.numeric(Positions)],
  main = "Baseball Hitters Data"
)
legend(
  0.8, 0.9,
  legend = c("POSITION(S)", levels(Positions)),
  pch = c("", pch),
  col = c(NA, colors)
)



