Ord.plot                 package:vcd                 R Documentation

_O_r_d _p_l_o_t_s

_D_e_s_c_r_i_p_t_i_o_n:

     Ord plots for diagnosing discrete distributions.

_U_s_a_g_e:

     Ord.plot(obj, legend = TRUE, estimate = TRUE, tol = 0.1, type = NULL,
              ylim = NULL, xlab = "Number of occurrences",
              ylab = "Frequency ratio", main = "Ord plot", ...)
     Ord.estimate(x, type = NULL, tol = 0.1)

_A_r_g_u_m_e_n_t_s:

     obj: either a vector of counts, a 1-way table of frequencies of
          counts or a data frame or matrix with frequencies in the
          first column and the corresponding counts in the second
          column.

  legend: logical. Should a legend be plotted?.

estimate: logical. Should the distribution and its parameters be
          estimated from the data? See details.

     tol: tolerance for estimating the distribution. See details.

    type: a character string indicating the distribution, must be one
          of '"poisson"', '"binomial"', '"nbinomial"' or '"log-series"'
          or 'NULL'. In the latter case the distribution is estimated
          from the data. See details.

    ylim: limits for the y axis.

    xlab: a label for the x axis.

    ylab: a label for the y axis.

    main: a title for the plot.

     ...: further arguments passed to 'plot'.

       x: a vector giving intercept and slope for the (fitted) line in
          the Ord plot.

_D_e_t_a_i_l_s:

     The Ord plot plots the number of occurrences against a certain
     frequency ratio (see Friendly (2000) for details) and should give
     a straight line if the data comes from a poisson, binomial,
     negative binomial or log-series distribution. The intercept and
     slope of this straight line conveys information about the
     underlying distribution.

     'Ord.plot' fits a usual OLS line (black) and a weighted OLS line
     (red). From the coefficients of the latter the distribution is
     estimated by 'Ord.estimate' as described in Table 2.10 in Friendly
     (2000). To judge whether a coefficient is positive or negative a
     tolerance given by 'tol' is used. If none of the distributions
     fits well, no parameters are estimated. Be careful with the
     conclusions from 'Ord.estimate' as it implements just some simple
     heuristics!

_V_a_l_u_e:

     a vector giving the intercept and slope of the weighted OLS line.

_A_u_t_h_o_r(_s):

     Achim Zeileis

_R_e_f_e_r_e_n_c_e_s:

     J. K. Ord (1967), Graphical methods for a class of discrete
     distributions, _Journal of the Royal Statistical Society_, *A
     130*, 232-238.

     Michael Friendly (2000), _Visualizing Categorical Data_. SAS
     Institute, Cary, NC.

_E_x_a_m_p_l_e_s:

     ## Simulated data examples:
     dummy <- rnbinom(1000, size = 1.5, prob = 0.8)
     Ord.plot(dummy)

     ## Real data examples:
     data(HorseKicks)
     data(Federalist)
     data(Butterfly)
     data(WomenQueue)
     par(mfrow = c(2,2))
     Ord.plot(HorseKicks, main = "Death by horse kicks")
     Ord.plot(Federalist, main = "Instances of 'may' in Federalist papers")
     Ord.plot(Butterfly, main = "Butterfly species collected in Malaya")
     Ord.plot(WomenQueue, main = "Women in queues of length 10")
     par(mfrow = c(1,1))

