\name{Arthritis}
\alias{Arthritis}
\docType{data}
\title{Arthritis Treatment Data}
\description{
Data from Koch & Edwards (1988) from a double-blind clinical trial
investigating a new treatment for rheumatoid arthritis.
}

\usage{data(Arthritis)}

\format{A data frame with 84 observations and 5 variables.
  \describe{
    \item{ID}{patient ID,}
    \item{Treatment}{factor indicating treatment (Placebo, Treated),}
    \item{Sex}{factor indicating sex (Female, Male),}
    \item{Age}{age of patient,}
    \item{Improved}{ordered factor indicating treatment outcome (None, Some, Marked).}
  }
}

\references{
G. Koch & S. Edwards (1988), Clinical efficiency trials with categorical
data. In K. E. Peace (ed.), \emph{Biopharmaceutical Statistics for Drug Development},
403-451. Marcel Dekker, New York.

M. Friendly (2000),
\emph{Visualizing Categorical Data}. SAS Institute, Cary, NC.
}

\source{Michael Friendly (2000), Visualizing Categorical Data:
\url{http://hotspur.psych.yorku.ca/ftp/sas/vcd/catdata/arthrit.sas}}

\examples{
data(Arthritis)
attach(Arthritis)
ftable(table(Treatment, Sex, Improved))
}

\keyword{datasets}

\eof
\name{Baseball}
\alias{Baseball}
\docType{data}
\title{Baseball}
\description{
Baseball data.
}

\usage{data(Baseball)}
\format{A data frame with 322 observations and 25 variables.
  \describe{
    \item{name1}{player's first name.}
    \item{name2}{player's last name.}
    \item{atbat86}{times at Bat: number of official plate appearances by a hitter. It counts as an official at-bat as long as the batter does not walk, sacrifice,
          get hit by a pitch or reach base due to catcher's interference.}
    \item{hits86}{hits.}
    \item{homer86}{homeruns.}
    \item{runs86}{the number of runs scored by a player. A run is scored by an offensive player who advances from batter to runner and touches
          first, second, third and home base in that order without being put out.}
    \item{rbi86}{Runs Batted In: A hitter earns a run batted in when he drives in a run via a hit, walk, sacrifice (bunt or fly) fielder's choice, hit- batsman or
          on an error (when the official scorer rules that the run would have scored anyway).}
    \item{walks86}{A ``walk'' (or ``base on balls'') is an award of first base granted to a batter who receives four pitches outside the strike zone.}
    \item{years}{Years in the Major Leagues. Seems to count all years a player has actually played in the Major Leagues, not necessarily consectutive.}
    \item{atbat}{career times at bat.}
    \item{hits}{career hits.}
    \item{homeruns}{career homeruns.}
    \item{runs}{career runs.}
    \item{rbi}{career runs batted in.}
    \item{walks}{career walks.}
    \item{league86}{player's league.}
    \item{div86}{player's division.}
    \item{team86}{player's team.}
    \item{posit86}{player's position (see \code{\link{Hitters}}).}
    \item{outs86}{number of putouts (see \code{\link{Hitters}})}
    \item{assist86}{number of assists (see \code{\link{Hitters}})}
    \item{error86}{number of assists (see \code{\link{Hitters}})}
    \item{sal87}{annary salary on opening day (in \$1000).}
    \item{league87}{league in 1987.}
    \item{team87}{team in 1987.}
  }
}

\references{
M. Friendly (2000),
\emph{Visualizing Categorical Data}. SAS Institute, Cary, NC.
}

\source{SAS System for Statistical Graphics, First Edition, P. A2.3}

\examples{
data(Baseball)
}

\keyword{datasets}

\eof
\name{Bundesliga}
\alias{Bundesliga}
\docType{data}
\title{Ergebnisse der Fussball-Bundesliga}
\description{
Results from the first German soccer league in the years
1995/6 and 2001/2.
}

\usage{data(Bundesliga)}
\format{A data frame with 612 observations and 6 variables.
  \describe{
    \item{HomeTeam}{character. Name of the home team,}
    \item{AwayTeam}{character. Name of the away team,}
    \item{HomeGoals}{number of goals scored by the home team,}
    \item{AwayGoals}{number of goals scored by the away team,}
    \item{Round}{day of the game,}
    \item{Year}{year in which the season started.}
  }
}

\details{The data for the season 1995/6 is taken from Knorr-Held (1999),
the data for the season 2001/2 was collected by Achim Zeileis.
}

\references{
Leonhard Knorr-Held (1999), Dynamic rating of sports teams.
SFB 386 ``Statistical Analysis of Discrete Structures'',
Discussion paper \bold{98}.
}

\source{SFB 386 ``Statistical Analysis of Discrete Structures''
\url{http://www.stat.uni-muenchen.de/service/datenarchiv/bundesliga/bundesliga.html}}

\seealso{\code{\link{UKSoccer}}}

\examples{
data(Bundesliga)

## independence of home and away goals
tore95 <- xtabs(~ HomeGoals + AwayGoals, data = Bundesliga, subset = Year == 1995)
tore95
mosaicplot(tore95, shade = TRUE)

## number of goals per game poisson distributed?
ntore1 <- xtabs(~ HomeGoals, data = Bundesliga, subset = Year == 1995)
ntore2 <- xtabs(~ AwayGoals, data = Bundesliga, subset = Year == 1995)
ntore3 <- table(apply(subset(Bundesliga, Year == 1995)[,3:4], 1, sum))

gf1 <- goodfit(ntore1)
gf2 <- goodfit(ntore2)
gf3 <- goodfit(ntore3)

summary(gf1)
summary(gf2)
summary(gf3)
plot(gf1)
plot(gf2)
plot(gf3)

Ord.plot(ntore1)
distplot(ntore1)
}

\keyword{datasets}

\eof
\name{Butterfly}
\alias{Butterfly}
\docType{data}
\title{Butterfly Species in Malaya}
\description{
Data from Fisher et al. (1943) giving the number of tokens found
for each of 501 species of butterflies collected in Malaya.
}

\usage{data(Butterfly)}

\format{A 1-way table giving the number of tokens for
        501 species of butterflies. The variable and its levels are
  \tabular{rll}{
    No \tab Name \tab Levels \cr
    1 \tab nTokens \tab 0, 1, ..., 24 \cr
  }
}

\references{
R. A. Fisher, A. S. Corbet, C. B. Williams (1943), The relation between
the number of species and the number of individuals, \emph{Journal
of Animal Ecology}, \bold{12}, 42-58.

M. Friendly (2000),
\emph{Visualizing Categorical Data}. SAS Institute, Cary, NC.
}

\source{Michael Friendly (2000), Visualizing Categorical Data, pp. 21-22.}

\examples{
data(Butterfly)
Ord.plot(Butterfly)
}

\keyword{datasets}

\eof
\name{CoalMiners}
\alias{CoalMiners}
\docType{data}
\title{Breathlessness and Wheeze in Coal Miners}
\description{
Data from Ashford & Snowden (1970) given by Agresti (1990) on the
association between two pulmonary conditions, breathlessness and
wheeze, in a large sample of coal miners.
}

\usage{data(CoalMiners)}

\format{A 3-dimensional array resulting from cross-tabulating
  variables for 16,330 coal miners. The variables and their levels are as
  follows:

  \tabular{rll}{
    No \tab Name \tab Levels \cr
    1 \tab Wheeze \tab W, NoW \cr
    2 \tab Breathlessness \tab B, NoB \cr
    3 \tab Age \tab 25-29, 30-34, \dots, 60-64
  }
}

\references{
A. Agresti (1990), \emph{Categorical Data Analysis}. Wiley-Interscience, New York.

J. R. Ashford & R. D. Snowdon (1970), Multivariate probit analysis,
\emph{Biometrics}, \bold{26}, 535-546.

M. Friendly (2000),
\emph{Visualizing Categorical Data}. SAS Institute, Cary, NC.
}

\source{Michael Friendly (2000), Visualizing Categorical Data, p. 82-83, 319-322.
}

\examples{
data(CoalMiners)

## Fourfold display, both margins equated
fourfoldplot(CoalMiners, mfcol = c(2,4))

## Log Odds Ratio Plot
summary(l <- oddsratio(CoalMiners))
g <- seq(25, 60, by = 5)
plot(l,
     xlab = "Age Group",
     main = "Breathlessness and Wheeze in Coal Miners")
m <- lm(l ~ g + I(g^2))
lines(fitted(m), col = "red")

## Fourfold display, strata equated
fourfoldplot(CoalMiners, std = "ind.max", mfcol = c(2,4))
}

\keyword{datasets}

\eof
\name{Employment}
\alias{Employment}
\docType{data}
\title{Employment Status}
\description{
Data from a 1974 Danish study given by Anderson (1991) on the
employees who had been laid off. The workers are classified by
their employment status on 1975-01-01, the cause of their layoff
and the length of employment before they were laid off.
}

\usage{data(Employment)}

\format{A 3-dimensional array resulting from cross-tabulating
  variables for 1314 employees. The variables and their levels are as
  follows:

  \tabular{rll}{
    No \tab Name \tab Levels \cr
    1 \tab EmploymentStatus \tab NewJob, Unemployed \cr
    2 \tab EmploymentLength \tab <1Mo, 1-3Mo, 3-12Mo, 1-2Yr, 2-5Yr, >5Yr \cr
    3 \tab LayoffCause \tab Closure, Replaced
  }
}

\references{
E. B. Anderson (1991), \emph{Statistical Analysis of Categorical Data}. Springer-Verlag, Berlin.

M. Friendly (2000),
\emph{Visualizing Categorical Data}. SAS Institute, Cary, NC.
}

\source{Michael Friendly (2000), Visualizing Categorical Data, p. 126-129.
}

\examples{
data(Employment)

## Employment Status ##
mosaicplot(Employment, shade = TRUE,
           margin = ~ LayoffCause*EmploymentLength + EmploymentStatus,
	   main = "Layoff*EmployLength + EmployStatus")


mosaicplot(Employment, shade = TRUE,
           margin = ~ LayoffCause*EmploymentLength + LayoffCause*EmploymentStatus,
	   main = "Layoff*EmployLength + Layoff*EmployStatus")

par(mfrow=c(1,2))

## Closure ##
mosaicplot(Employment[,,1], shade = TRUE, main = "Layoff: Closure")

## Replaced ##
mosaicplot(Employment[,,2], shade = TRUE, main = "Layoff : Replaced")

par(mfrow=c(1,1))
}

\keyword{datasets}

\eof
\name{Federalist}
\alias{Federalist}
\docType{data}
\title{`May' in Federalist Papers}
\description{
Data from Mosteller & Wallace (1984) investigating the use
of certain keywords (`may' in this data set) to identify
the author of 12 disputed `Federalist Papers' by Alexander
Hamilton, John Jay and James Madison.
}

\usage{data(Federalist)}

\format{A 1-way table giving the number of occurrences
        of `may' in 262 blocks of text. The variable and its levels are
  \tabular{rll}{
    No \tab Name \tab Levels \cr
    1 \tab nMay \tab 0, 1, ..., 6 \cr
  }
}


\references{
F. Mosteller & D. L. Wallace (1984), \emph{Applied Bayesian and Classical
Inference: The Case of the Federalist Papers}. Springer-Verlag, New York, NY.

M. Friendly (2000),
\emph{Visualizing Categorical Data}. SAS Institute, Cary, NC.
}

\source{Michael Friendly (2000), Visualizing Categorical Data, p. 19.}

\examples{
data(Federalist)
gf <- goodfit(Federalist, type = "nbinomial")
summary(gf)
plot(gf)
}

\keyword{datasets}

\eof
\name{Hitters}
\alias{Hitters}
\docType{data}
\title{Hitters}
\description{
This data set is deduced from the \code{\link{Baseball}} fielding data set:
fielding performance basically includes the numbers of Errors, Putouts and Assists
made by each player. In order to reduce the number of observations, the
data has been compressed by calculating the mean number of errors,
putouts and assists for each team and for only 6 positions (1B, 2B, 3B, C,
OF, SS and UT). In addition, each of these three variables has been
scaled to a common range by dividing each variable by the maximum of the variable.
}

\usage{data(Hitters)}
\format{A data frame with 154 observations and 4 variables.
  \describe{
    \item{Positions}{factor indicating the field position (1B=first
      baseman, 2B=second baseman, 3B=third baseman, C=catcher,
      OF=outfielder, SS=Short Stop, UT=Utility Players),}
    \item{Putouts}{occur when a fielder causes an oppsing player to be
      tagged or fored out,}
    \item{Assists}{are credited to other fielders involved in making
      that putout, and}
    \item{Errors}{count the errors made by a player.}
  }
}

\references{
M. Friendly (2000),
\emph{Visualizing Categorical Data}. SAS Institute, Cary, NC.
}

\source{SAS System for Statistical Graphics, First Edition, P. A2.3}

\examples{
data(Hitters)
attach(Hitters)

colors <- c("black","red","green","blue","red","black","blue")
pch <- substr(levels(Positions), 1, 1)
ternaryplot(
            Hitters[,2:4],
            pch = as.character(Positions),
            col = colors[as.numeric(Positions)],
            main = "Baseball Hitters Data"
            )
legend(
       0.7, 0.85,
       legend = c("POSITION(S)", levels(Positions)),
       pch = c("", pch),
       col = c(NA, colors)
       )

  detach(Hitters)
}

\keyword{datasets}




\eof
\name{HorseKicks}
\alias{HorseKicks}
\docType{data}
\title{Death by Horse Kicks}
\description{
Data from von Bortkiewicz (1898), given by
Andrews & Herzberg (1985), on number of deaths
by horse or mule kicks in 10 (of 14 reported) corps of
the Prussian army. 4 corps were not considered by
Fisher (1925) as they had a different organization.
}

\usage{data(HorseKicks)}

\format{A 1-way table giving the number of deaths
        in 200 corps-years. The variable and its levels are
  \tabular{rll}{
    No \tab Name \tab Levels \cr
    1 \tab nDeaths \tab 0, 1, ..., 4 \cr
  }
}


\references{
D. F. Andrews & A. M. Herzberg (1985), \emph{Data: A Collection of Problems
from Many Fields for the Student and Research Worker}. Springer-Verlag,
New York, NY.

R. A. Fisher (1925), \emph{Statistical Methods for Research Workers}.
Oliver & Boyd, London.

L. von Bortkiewicz (1898), \emph{Das Gesetz der kleinen Zahlen}. Teubner, Leipzig.

M. Friendly (2000),
\emph{Visualizing Categorical Data}. SAS Institute, Cary, NC.
}

\source{Michael Friendly (2000), Visualizing Categorical Data, p. 18.}

\seealso{\code{\link{VonBort}}}

\examples{
data(HorseKicks)
gf <- goodfit(HorseKicks)
summary(gf)
plot(gf)
}

\keyword{datasets}

\eof
\name{Kappa}
\alias{Kappa}
\alias{print.Kappa}
\alias{summary.Kappa}
\alias{print.summary.Kappa}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Cohen's Kappa and weighted Kappa}
\description{
  Computes two agreement rates: Cohen's kappa and weighted kappa, and
  confidence bands.
}
\usage{
Kappa(x, weights = c("Equal-Spacing", "Fleiss-Cohen"), conf.level = 0.95)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{a confusion matrix.}
  \item{weights}{either one of the two options or a user-specified
    matrix with same dimensions as \code{x}.}
  \item{conf.level}{level for the confidence intervals.}
}
\details{
  Cohen's kappa is the diagonal sum of the (possibly weighted) relative frequencies,
  corrected for expected values and standardized by its maximum value.
  The equal-spacing weights are defined by \eqn{1 - abs(i - j) / (r -
    1)}, r number of colums/rows, and the Fleiss-Cohen weights by
  \eqn{1 - abs(i - j)^2 / (r - 1)^2}. The latter ones attach greater
  importance to near disagreements.
}
\value{
  An object of class \code{kappa} with three components:
  \item{Kappa}{Kappa statistic, along with Approximate Standard Error
    (ASE) and 95\% confidence bounds.}
  \item{Kappa.Weighted}{idem for the weighted kappa.}
  \item{Weights}{weight matrix used.}
}
\references{
    \item Cohen, Jacob (1960): A coefficient of agreement for nominal
    scales. Educational and Psychological Measurement.
    \item Everitt, B.S. (1968): Moments of statistics kappa and weighted
    kappa. The British Journal of Mathematical and Statistical Psychology.
}
\author{David Meyer\cr
\email{david.meyer@ci.tuwien.ac.at}}
\seealso{\code{\link{agreementplot}}}
\examples{
data(SexualFun)
Kappa(SexualFun)
}
\keyword{category}% at least one, from doc/KEYWORDS

\eof
\name{Lifeboats}
\alias{Lifeboats}
\docType{data}
\title{Lifeboats on the Titanic}
\description{
Data from Mersey (1912) about the 18 (out of 20) lifeboats launched
before the sinking of the S. S. Titanic.
}

\usage{data(Lifeboats)}

\format{A data frame with 18 observations and 8 variables.
  \describe{
    \item{launch}{launch time in \code{"POSIXt"} format,}
    \item{side}{factor. Side of the boat,}
    \item{boat}{factor indicating the boat,}
    \item{crew}{number of male crew members on board,}
    \item{men}{number of men on board,}
    \item{women}{number of women (including female crew) on board,}
    \item{total}{total number of passengers,}
    \item{cap}{capacity of the boat.}
  }
}

\references{
L. Mersey (1912), Report on the loss of the ``Titanic'' (S. S.).
Parliamentary command paper 6452.

M. Friendly (2000),
\emph{Visualizing Categorical Data}. SAS Institute, Cary, NC.
}

\source{Michael Friendly (2000), Visualizing Categorical Data:
\url{http://hotspur.psych.yorku.ca/ftp/sas/vcd/catdata/lifeboat.sas}}

\examples{
data(Lifeboats)
attach(Lifeboats)
ternaryplot(
  Lifeboats[,4:6],
  pch = ifelse(side=="Port", 1, 19),
  col = ifelse(side=="Port", "red", "blue"),
  id  = ifelse(men/total > 0.1, as.character(boat), NA),
  prop.size = 2,
  dimnames.position = "edge",
  main = "Lifeboats on the Titanic"
)
legend(
  0.7, 0.8,
  legend = c("SIDE", "Port", "Starboard"),
  pch = c(NA, 1, 19),
  col = c("black", "red", "blue"),
)
}

\keyword{datasets}

\eof
\name{MSPatients}
\alias{MSPatients}
\docType{data}
\title{Diagnosis of Multiple Sclerosis}
\description{
Data from Westlund & Kurland (1953) on the diagnosis of multiple sclerosis (MS):
two samples of patients, one from Winnipeg and one from New Orleans, were
each rated by two neurologists (one from each city) in four diagnostic
categories.
}

\usage{data(MSPatients)}

\format{A 3-dimensional array resulting from cross-tabulating 218
  observations on 3 variables.  The variables and their levels are as
  follows:

  \tabular{rll}{
    No \tab Name \tab Levels \cr
    1 \tab New Orleans Neurologist \tab Certain, Probable, Possible, Doubtful \cr
    2 \tab Winnipeg Neurologist \tab Certain, Probable, Possible, Doubtful \cr
    3 \tab Patients \tab Winnipeg, New Orleans
  }
}

\references{
K. B. Westlund & L. T. Kurland (1953), Studies on multiple sclerosis in
Winnipeg, Manitoba and New Orleans, Lousiana, \emph{American Journal of
Hygiene}, \bold{57}, 380-396.

M. Friendly (2000),
\emph{Visualizing Categorical Data}. SAS Institute, Cary, NC.
}

\source{Michael Friendly (2000), Visualizing Categorical Data:
\url{http://hotspur.psych.yorku.ca/ftp/sas/vcd/catdata/msdiag.sas}}

\examples{
data(MSPatients)

par(mfrow = c(1,2))
agreementplot(t(MSPatients[,,1]), main = "Winnipeg Patients")
agreementplot(t(MSPatients[,,2]), main = "New Orleans Patients")
par(mfrow = c(1,1))
}

\keyword{datasets}

\eof
\name{Ord.plot}
\alias{Ord.plot}
\alias{Ord.estimate}
\title{Ord plots}
\description{
Ord plots for diagnosing discrete distributions.
}
\usage{
Ord.plot(obj, legend = TRUE, estimate = TRUE, tol = 0.1, type = NULL,
         ylim = NULL, xlab = "Number of occurrences",
	 ylab = "Frequency ratio", main = "Ord plot", ...)
Ord.estimate(x, type = NULL, tol = 0.1)
}
\arguments{
  \item{obj}{either a vector of counts, a 1-way table of frequencies
    of counts or a data frame or matrix with frequencies
    in the first column and the corresponding counts in the
    second column.}
  \item{legend}{logical. Should a legend be plotted?.}
  \item{estimate}{logical. Should the distribution and its parameters
    be estimated from the data? See details.}
  \item{tol}{tolerance for estimating the distribution. See details.}
  \item{type}{a character string indicating the distribution, must be
    one of \code{"poisson"}, \code{"binomial"}, \code{"nbinomial"}
    or \code{"log-series"} or \code{NULL}. In the latter case the
    distribution is estimated from the data. See details.}
  \item{ylim}{limits for the y axis.}
  \item{xlab}{a label for the x axis.}
  \item{ylab}{a label for the y axis.}
  \item{main}{a title for the plot.}
  \item{...}{further arguments passed to \code{\link{plot}}.}
  \item{x}{a vector giving intercept and slope for the (fitted)
    line in the Ord plot.}

}
\details{
The Ord plot plots the number of occurrences against a certain
frequency ratio (see Friendly (2000) for details) and
should give a straight line if the data comes from
a poisson, binomial, negative binomial or log-series distribution. The
intercept and slope of this straight line conveys information about
the underlying distribution.

\code{Ord.plot} fits a usual OLS line (black) and a weighted OLS line
(red). From the coefficients of the latter the distribution is
estimated by \code{Ord.estimate} as described in Table 2.10 in Friendly
(2000). To judge whether a coefficient is positive or negative a
tolerance given by \code{tol} is used. If none of the distributions
fits well, no parameters are estimated. Be careful with the conclusions
from \code{Ord.estimate} as it implements just some simple heuristics!
}
\value{a vector giving the intercept and slope of the weighted OLS line.}
\author{
  Achim Zeileis
}
\references{
J. K. Ord (1967), Graphical methods for a class of discrete distributions,
\emph{Journal of the Royal Statistical Society}, \bold{A 130}, 232-238.

Michael Friendly (2000),
\emph{Visualizing Categorical Data}. SAS Institute, Cary, NC.
}
\examples{
## Simulated data examples:
dummy <- rnbinom(1000, size = 1.5, prob = 0.8)
Ord.plot(dummy)

## Real data examples:
data(HorseKicks)
data(Federalist)
data(Butterfly)
data(WomenQueue)
par(mfrow = c(2,2))
Ord.plot(HorseKicks, main = "Death by horse kicks")
Ord.plot(Federalist, main = "Instances of 'may' in Federalist papers")
Ord.plot(Butterfly, main = "Butterfly species collected in Malaya")
Ord.plot(WomenQueue, main = "Women in queues of length 10")
par(mfrow = c(1,1))
}
\keyword{category}

\eof
\name{PreSex}
\alias{PreSex}
\docType{data}
\title{Pre-marital Sex and Divorce}
\description{
Data from Thornes & Collard (1979), reported in Gilbert (1981),
on pre- and extra-marital sex and divorce.
}

\usage{data(PreSex)}

\format{A 4-dimensional array resulting from cross-tabulating 1036
  observations on 4 variables.  The variables and their levels are as
  follows:

  \tabular{rll}{
    No \tab Name \tab Levels \cr
    1 \tab MaritalStatus \tab Divorced, Married \cr
    2 \tab ExtramaritalSex \tab Yes, No \cr
    3 \tab PremaritalSex \tab Yes, No \cr
    4 \tab Gender \tab Women, Men
  }
}

\references{
G. N. Gilbert (1981), \emph{Modelling Society: An Introduction
to Loglinear Analysis for Social Researchers}. Allen and Unwin,
London.

B. Thornes & J. Collard (1979), \emph{Who Divorces?}. Routledge
& Kegan, London.

M. Friendly (2000),
\emph{Visualizing Categorical Data}. SAS Institute, Cary, NC.
}

\source{Michael Friendly (2000), Visualizing Categorical Data:
\url{http://hotspur.psych.yorku.ca/ftp/sas/vcd/catdata/marital.sas}}

\examples{
data(PreSex)

par(mfrow=c(1,2))
## Mosaic display for Gender and Premarital Sexual Expirience
## (Gender Pre)
mosaicplot(margin.table(PreSex,c(3,4)), shade = TRUE,
           clegend = FALSE, main = "Gender and Premarital Sex")
## (Gender Pre)(Extra)
mosaicplot(margin.table(PreSex,c(2,3,4)), shade = TRUE, clegend = FALSE,
           margin = ~Gender*PremaritalSex + ExtramaritalSex ,
	   main = "PreMaritalSex*Gender +Sex")
par(mfrow=c(1,1))

## (Gender Pre Extra)(Marital)
mosaicplot(PreSex, shade = TRUE, margin = ~Gender*PremaritalSex*ExtramaritalSex + MaritalStatus,
           clegend = FALSE, main = "PreMarital*ExtraMarital + MaritalStatus")

## (GPE)(PEM)
mosaicplot(PreSex, shade = TRUE,
           margin = ~Gender*PremaritalSex*ExtramaritalSex + MaritalStatus*PremaritalSex*ExtramaritalSex,
	   clegend = FALSE, main = "G*P*E + P*E*M")
}

\keyword{datasets}

\eof
\name{RepVict}
\alias{RepVict}
\docType{data}
\title{Repeat Victimization}
\description{
Data from Reiss (1980) given by Fienberg (1980) about
instances of repeat victimization for households in the U.S.
National Crime Survey.
}

\usage{data(RepVict)}

\format{A 2-dimensional array resulting from cross-tabulating
  victimization. The variables and their levels are as
  follows:

  \tabular{rll}{
    No \tab Name \tab Levels \cr
    1 \tab First Victimization \tab Rape, Assault, Robbery, Pickpocket,
       Personal Larcency, Burglary, Household Larcency, Auto Theft \cr
    2 \tab Second Victimization \tab Rape, Assault, Robbery, Pickpocket,
       Personal Larcency, Burglary, Household Larcency, Auto Theft
  }
}

\references{
S. E. Fienberg (1980), \emph{The Analysis of Cross-Classified Catgegorical
Data}, MIT Press, Cambridge, 2nd edition.

A. J. J. Reiss (1980), Victim proneness by type of crime in repeat
victimization. In S. E. Fienberg & A. J. J. Reiss (eds.),
\emph{Indicators of Crime and Criminal Justice}. U.S. Government
Printing Office, Washington, DC.

M. Friendly (2000),
\emph{Visualizing Categorical Data}. SAS Institute, Cary, NC.
}

\source{Michael Friendly (2000), Visualizing Categorical Data, p. 113.
}

\examples{
data(RepVict)

mosaicplot(RepVict[-c(4,7),-c(4,7)], shade = TRUE, main = "Repeat Victimization Data")
}

\keyword{datasets}

\eof
\name{Saxony}
\alias{Saxony}
\docType{data}
\title{Families in Saxony}
\description{
Data from Geissler, cited in Sokal & Rholf (1969) and Lindsey (1995)
on sex distributions in families in Saxony in the 19th century.
}

\usage{data(Saxony)}

\format{A 1-way table giving the number of male children in 6115 families
        of size 12. The variable and its levels are
  \tabular{rll}{
    No \tab Name \tab Levels \cr
    1 \tab nMales \tab 0, 1, ..., 12 \cr
  }
}

\references{
J. K. Lindsey (1995), \emph{Analysis of Frequency and Count Data}.
Oxford University Press, Oxford, UK.

R. R. Sokal & F. J. Rholf (1969), \emph{Biometry. The Principles and
Practice of Statistics}. W. H. Freeman, San Francisco, CA.

M. Friendly (2000),
\emph{Visualizing Categorical Data}. SAS Institute, Cary, NC.
}

\source{Michael Friendly (2000), Visualizing Categorical Data, pp. 40-42.}

\examples{
data(Saxony)
gf <- goodfit(Saxony, type = "binomial")
summary(gf)
plot(gf)
}

\keyword{datasets}

\eof
\name{SexualFun}
\alias{SexualFun}
\docType{data}
\title{Sex Is Fun}
\description{
Data from Hout et al. (1987) given by Agresti (1990) summarizing
the responses of married couples to the questionnaire item:
Sex is fun for me and my partner: (a) never or occasionally,
(b) fairly often, (c) very often, (d) almost always.
}

\usage{data(SexualFun)}

\format{A 2-dimensional array resulting from cross-tabulating the ratings
  of 91 married couples.  The variables and their levels are as
  follows:

  \tabular{rll}{
    No \tab Name \tab Levels \cr
    1 \tab Husband \tab Never Fun, Fairly Often, Very Often, Always Fun \cr
    2 \tab Wife \tab Never Fun, Fairly Often, Very Often, Always Fun
  }
}

\references{
A. Agresti (1990), \emph{Categorical Data Analysis}. Wiley-Interscience, New York.

M. Hout, O. D. Duncan, M. E. Sobel (1987), Association and heterogeneity:
Structural models of similarities and differences, \emph{Sociological
Methodology}, \bold{17}, 145-184.

M. Friendly (2000),
\emph{Visualizing Categorical Data}. SAS Institute, Cary, NC.
}

\source{Michael Friendly (2000), Visualizing Categorical Data, p. 91.
}

\examples{
data(SexualFun)

## Kappa statistics
Kappa(SexualFun)

## Agreement Chart
agreementplot(t(SexualFun), weights = 1)
## Partial Agreement Chart and B-Statistics
agreementplot(t(SexualFun), xlab = "Husband's Rating",
              ylab = "Wife's Rating", main = "Husband's and Wife's Sexual Fun")
}

\keyword{datasets}

\eof
\name{SpaceShuttle}
\alias{SpaceShuttle}
\docType{data}
\title{Space Shuttle O-ring failures}
\description{
Data from Dalal et al. (1989) about O-ring failures in the
NASA space shuttle progam. The damage index comes from a
discussion of the data by Tufte (1997).
}

\usage{data(SpaceShuttle)}
\format{A data frame with 24 observations and 6 variables.
  \describe{
    \item{FlightNumber}{Number of space shuttle flight,}
    \item{Temperature}{temperature during start (in degrees F),}
    \item{Pressure}{pressure,}
    \item{Fail}{did any O-ring failures occur? (no, yes),}
    \item{nFailures}{how many (of six) 0-rings failed?,}
    \item{Damage}{damage index.}
  }
}

\references{
S. Dalal, E. B. Fowlkes, B. Hoadly (1989), Risk analysis of the space
shuttle: Pre-Challenger prediction of failure, \emph{Journal of the
American Statistical Association}, \bold{84}, 945-957.

E. R. Tufte (1997), \emph{Visual Explanations: Images and Quantities,
Evidence and Narrative}. Graphics Press, Cheshire, CT.

M. Friendly (2000),
\emph{Visualizing Categorical Data}. SAS Institute, Cary, NC.
}

\source{Michael Friendly (2000), Visualizing Categorical Data:
\url{http://hotspur.psych.yorku.ca/ftp/sas/vcd/catdata/orings.sas}}

\examples{
data(SpaceShuttle)
plot(nFailures/6 ~ Temperature, xlim = c(30, 81), data = SpaceShuttle,
     ylim = c(0,1), main = "NASA Space Shuttle O-Ring Failures",
     ylab = "Estimated failure probability", pch = 19, col = 4)
fm <- glm(cbind(nFailures, 6 - nFailures) ~ Temperature, data = SpaceShuttle,
          family = binomial)
lines(30:81, predict(fm, data.frame(Temperature = 30:81), type = "re"), lwd = 2)
abline(v = 31, lty = 3)
}

\keyword{datasets}

\eof
\name{Suicide}
\alias{Suicide}
\docType{data}
\title{Suicide Rates in Germany}
\description{
Data from Heuer (1979) on suicide rates in West Germany
classified by age, sex, and method of suicide.
}

\usage{data(Suicide)}
\format{A data frame with 306 observations and 6 variables.
  \describe{
    \item{Freq}{frequency of suicides,}
    \item{sex}{factor indicating sex (male, female),}
    \item{method}{factor indicating method used,}
    \item{age}{age (rounded),}
    \item{age.group}{factor. Age classified into 5 groups,}
    \item{method2}{factor indicating method used (same
      as \code{method} but some levels are merged).}
  }
}

\references{
J. Heuer (1979), \emph{Selbstmord bei Kindern und Jugendlichen}.
Ernst Klett Verlag, Stuttgart.

M. Friendly (2000),
\emph{Visualizing Categorical Data}. SAS Institute, Cary, NC.
}

\source{Michael Friendly (2000), Visualizing Categorical Data:
\url{http://hotspur.psych.yorku.ca/ftp/sas/vcd/catdata/suicide.sas}}

\examples{
data(Suicide)
ftable(xtabs(Freq ~ sex + method2 + age.group, data = Suicide))
}

\keyword{datasets}

\eof
\name{UKSoccer}
\alias{UKSoccer}
\docType{data}
\title{UK Soccer Scores}
\description{
Data from Lee (1997), on the goals scored by Home and Away teams
in the Premier Football Leage, 1995/6 season.
}

\usage{data(UKSoccer)}

\format{A 2-dimensional array resulting from cross-tabulating the number
  of goals scored in 380 games.  The variables and their levels are as
  follows:

  \tabular{rll}{
    No \tab Name \tab Levels \cr
    1 \tab Home \tab 0, 1, \dots, 4 \cr
    2 \tab Away \tab 0, 1, \dots, 4
  }
}

\references{
A. J. Lee (1997), Modelling scores in the Premier League: Is Manchester
United really the best?, \emph{Chance}, \bold{10}(1), 15-19.

M. Friendly (2000),
\emph{Visualizing Categorical Data}. SAS Institute, Cary, NC.
}

\source{Michael Friendly (2000), Visualizing Categorical Data, p. 27.
}

\seealso{\code{\link{Bundesliga}}}

\examples{
data(UKSoccer)

mosaicplot(UKSoccer, shade = TRUE, main = "UK Soccer Scores")
}

\keyword{datasets}

\eof
\name{VisualAcuity}
\alias{VisualAcuity}
\docType{data}
\title{Visual Acuity in Left and Right Eyes}
\description{
Data from Kendall & Stuart (1961) on unaided vision among 3,242 men
and 7,477 women, all aged 30-39 and employed in the U.K. Royal
Ordnance factories 1943-1946.
}

\usage{data(VisualAcuity)}
\format{A data frame with 32 observations and 4 variables.
  \describe{
    \item{Freq}{frequency of visual acuity measurements,}
    \item{right}{visual acuity on right eye,}
    \item{left}{visual acuity on left eye,}
    \item{gender}{factor indicating gender of patient.}
  }
}

\references{
M. G. Kendall & A. Stuart (1961), \emph{The Advanced Theory of Statistics},
Vol. 2. Griffin, London.

M. Friendly (2000),
\emph{Visualizing Categorical Data}. SAS Institute, Cary, NC.
}

\source{Michael Friendly (2000), Visualizing Categorical Data:
\url{http://hotspur.psych.yorku.ca/ftp/sas/vcd/catdata/vision.sas}}

\examples{
data(VisualAcuity)
ftable(xtabs(Freq ~ gender + left + right, data = VisualAcuity))
}

\keyword{datasets}

\eof
\name{VonBort}
\alias{VonBort}
\docType{data}
\title{Von Bortkiewicz Horse Kicks Data}
\description{
Data from von Bortkiewicz (1898), given by
Andrews & Herzberg (1985), on number of deaths
by horse or mule kicks in 14 corps of
the Prussian army.
}

\usage{data(VonBort)}
\format{A data frame with 280 observations and 4 variables.
  \describe{
    \item{deaths}{number of deaths,}
    \item{year}{year of the deaths,}
    \item{corps}{factor indicating the corps,}
    \item{fisher}{factor indicating whether the corresponding
      corps was considered by Fisher (1925) or not.}
  }
}

\references{
D. F. Andrews & A. M. Herzberg (1985), \emph{Data: A Collection of Problems
from Many Fields for the Student and Research Worker}. Springer-Verlag,
New York, NY.

R. A. Fisher (1925), \emph{Statistical Methods for Research Workers}.
Oliver & Boyd, London.

L. von Bortkiewicz (1898), \emph{Das Gesetz der kleinen Zahlen}. Teubner, Leipzig.

M. Friendly (2000),
\emph{Visualizing Categorical Data}. SAS Institute, Cary, NC.
}

\source{Michael Friendly (2000), Visualizing Categorical Data:
\url{http://hotspur.psych.yorku.ca/ftp/sas/vcd/catdata/vonbort.sas}}

\seealso{\code{\link{HorseKicks}}}

\examples{
data(VonBort)
## HorseKicks data
xtabs(~ deaths, data = VonBort, subset = fisher == "yes")
}

\keyword{datasets}

\eof
\name{WeldonDice}
\alias{WeldonDice}
\docType{data}
\title{Weldon's Dice Data}
\description{
Data from Pearson (1900) about the frequency of 5s and 6s in throws
of 12 dice. Weldon tossed the dice 26,306 times and reported his
results in a letter to Francis Galton on 1894-02-02.
}

\usage{data(WeldonDice)}

\format{A 1-way table giving the frequency of a 5 or a 6 in
        26,306 throws of 12 dice where 10 indicates `10 or more' 5s or 6s.
        The variable and its levels are
  \tabular{rll}{
    No \tab Name \tab Levels \cr
    1 \tab n56 \tab 0, 1, ..., 10 \cr
  }
}


\references{
K. Pearson (1900), On the criterion that a given system of deviations from
the probable in the case of a correlated system of variables is such that
it can be reasonably supposed to have arisen by random sampling,
\emph{Philosophical Magazine}, \bold{50} (5th series), 157-175.

M. Friendly (2000),
\emph{Visualizing Categorical Data}. SAS Institute, Cary, NC.
}

\source{Michael Friendly (2000), Visualizing Categorical Data, pp. 20-21.}

\examples{
data(WeldonDice)
gf <- goodfit(WeldonDice, type = "binomial")
summary(gf)
plot(gf)
}

\keyword{datasets}

\eof
\name{WomenQueue}
\alias{WomenQueue}
\docType{data}
\title{Women in Queues}
\description{
Data from Jinkinson & Slater (1981) and Hoaglin & Tukey (1985)
reporting the frequency distribution of females in 100 queues of
length 10 in a London Underground station.
}

\usage{data(WomenQueue)}

\format{A 1-way table giving the number of women
        in 100 queues of length 10. The variable and its levels are
  \tabular{rll}{
    No \tab Name \tab Levels \cr
    1 \tab nWomen \tab 0, 1, ..., 10 \cr
  }
}


\references{
D. C. Hoaglin & J. W. Tukey (1985), Checking the shape of discrete distributions.
In D. C. Hoaglin, F. Mosteller, J. W. Tukey (eds.), \emph{Exploring Data Tables,
Trends and Shapes}, chapter 9. John Wiley & Sons, New York.

R. A. Jinkinson & M. Slater (1981), Critical discussion of a graphical method
for identifying discrete distributions, \emph{The Statistician}, \bold{30},
239-248.

M. Friendly (2000),
\emph{Visualizing Categorical Data}. SAS Institute, Cary, NC.
}

\source{Michael Friendly (2000), Visualizing Categorical Data, pp. 19-20.}

\examples{
data(WomenQueue)
gf <- goodfit(WomenQueue, type = "binomial")
summary(gf)
plot(gf)
}

\keyword{datasets}

\eof
\name{agreementplot.default}
\alias{agreementplot}
\alias{agreementplot.default}
\alias{agreementplot.formula}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Bangdiwala's Observer Agreement Chart}
\description{
  Representation of a k x k confusion matrix, where the
  observed and expected diagonal elements are represented by superposed
  black and white rectangles, respectively. The function also computes
  a statistic measuring the strength of agreement (relation of respective
  area sums).
}
\usage{
\method{agreementplot}{default}(x, reverse.y = TRUE, main = "Agreement Chart",
              weights = c(1, 1 - 1/(ncol(x) - 1)^2), cex.main = 2, cex.lab = 1.5,
              xlab = names(dimnames(x))[2], ylab = names(dimnames(x))[1], ...)
\method{agreementplot}{formula}(formula, data = NULL, ..., subset)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{a confusion matrix, i.e. a table with equal-sized dimensions.}
  \item{reverse.y}{if \code{TRUE}, the y axis is reversed (i.e., the
    rectangles' positions correspond to the contingency table).}
  \item{main}{user-specified main title.}
  \item{weights}{vector of weights for successive larger observed areas, used
    in the agreement strength statistic, and also for the shading. The
    first element should be 1.}
  \item{cex.main}{font size of title.}
  \item{cex.lab}{font size of labels.}
  \item{xlab, ylab}{labels of x- and y-axis.}
  \item{formula}{a formula, such as \code{y ~ x}. For details, see \code{xtabs}.}
  \item{data}{a data.frame (or list), or a contingency table from which the
          variables in `formula' should be taken.}
  \item{subset}{an optional vector specifying a subset of observations to be
    used for plotting.}
  \item{\dots}{further graphics parameters (see \code{par}).}
}
\details{
  Weights can be specified to allow for partial agreement, taking into
  account contributions from off-diagonal cells. A weight vector of
  length 1 means strict agreement only, each additional element
  increases the maximum number of disagreement steps.
}
\value{
  Invisibly returned, a list with components
  \item{Bangdiwala}{the unweighted agreement strength statistic}
  \item{Bangdiwala.Weighted}{the weighted statistic}
  \item{weights}{the weigtht vector used.}
}
\references{
Michael Friendly (2000),
\emph{Visualizing Categorical Data}. SAS Institute, Cary, NC.
}
\author{
  David Meyer\cr
  \email{david.meyer@ci.tuwien.ac.at}
}

\examples{
data(SexualFun)
agreementplot(t(SexualFun))

data(MSPatients)
## Enlarge plot manually or use sth. like: X11(width = 12)!
par(mfrow = c(1,2))
agreementplot(t(MSPatients[,,1]), main = "Winnipeg Patients")
agreementplot(t(MSPatients[,,2]), main = "New Orleans Patients")
par(mfrow = c(1,1))
}
\keyword{category}% at least one, from doc/KEYWORDS
\keyword{hplot}% __ONLY ONE__ keyword per line

\eof
\name{assoc.stats}
\alias{assoc.stats}
\alias{summary.assoc.stats}
\alias{print.assoc.stats}
\alias{print.summary.assoc.stats}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Association Statistics}
\description{
  Computes the Chi-Square test, the Likelihood Ratio Chi-Square test,
  the phi-coefficient, the the contingency coefficient and Cramer's V.
}
\usage{
assoc.stats(x)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{a rxc-table.}
}
\value{
  A list with components:
  \item{chisq.tests}{a 2x3 table with the chisquare statistics.}
  \item{phi}{The phi-coefficient.}
  \item{cont}{The  contingency coefficient.}
  \item{cramer}{Cramer's V.}
}
\references{
Michael Friendly (2000), \emph{Visualizing Categorical Data}. SAS Institute, Cary, NC.
}
\author{
  David Meyer\cr
  \email{david.meyer@ci.tuwien.ac.at}
}
\examples{
data(Arthritis)
tab <- xtabs(~Improved + Treatment, data = Arthritis)
summary(assoc.stats(tab))
}
\keyword{category}% at least one, from doc/KEYWORDS

\eof
\name{barplot}
\alias{barplot}
\alias{barplot.default}
\title{Bar Plots}
\usage{
\method{barplot}{default}(height, width = 1, space = NULL,
        names.arg = NULL, legend.text = NULL, beside = FALSE,
        horiz = FALSE, density = NULL, angle = 45,
        col = heat.colors(NR), border = par("fg"),
        main = NULL, sub = NULL, xlab = NULL, ylab = NULL,
        xlim = NULL, ylim = NULL, xpd = TRUE,
        axes = TRUE, axisnames = TRUE,
        cex.axis = par("cex.axis"), cex.names = par("cex.axis"),
        inside = TRUE, plot = TRUE, shift = 0, \dots)
}
\arguments{
  \item{height}{either a vector or matrix of values describing the
    bars which make up the plot.  If \code{height} is a vector, the
    plot consists of a sequence of rectangular bars with heights
    given by the values in the vector.  If \code{height} is a matrix
    and \code{beside} is \code{FALSE} then each bar of the plot
    corresponds to a column of \code{height}, with the values in the
    column giving the heights of stacked ``sub-bars'' making up the
    bar.  If \code{height} is a matrix and \code{beside} is
    \code{TRUE}, then the values in each column are juxtaposed
    rather than stacked.}
  \item{width}{optional vector of bar widths. Re-cycled to length the
    number of bars drawn.  Specifying a single value will no visible
    effect unless \code{xlim} is specified.}
  \item{space}{the amount of space (as a fraction of the average bar
    width) left before each bar.  May be given as a single number or
    one number per bar.  If \code{height} is a matrix and
    \code{beside} is \code{TRUE}, \code{space} may be specified by
    two numbers, where the first is the space between bars in the
    same group, and the second the space between the groups.  If not
    given explicitly, it defaults to \code{c(0,1)} if \code{height}
    is a matrix and \code{beside} is \code{TRUE}, and to 0.2
    otherwise.}
  \item{names.arg}{a vector of names to be plotted below each bar or
    group of bars.  If this argument is omitted, then the names are
    taken from the \code{names} attribute of \code{height} if this
    is a vector, or the column names if it is a matrix.}
  \item{legend.text}{a vector of text used to construct a legend for
    the plot, or a logical indicating whether a legend should be
    included.  This is only useful when \code{height} is a matrix.
    In that case given legend labels should correspond to the rows of
    \code{height}; if \code{legend.text} is true, the row names of
    \code{height} will be used as labels if they are non-null.}
  \item{beside}{a logical value.  If \code{FALSE}, the columns of
    \code{height} are portrayed as stacked bars, and if \code{TRUE}
    the columns are portrayed as juxtaposed bars.}
  \item{horiz}{a logical value.  If \code{FALSE}, the bars are drawn
    vertically with the first bar to the left.  If \code{TRUE}, the
    bars are drawn horizontally with the first at the bottom.}
  \item{density}{a vector giving the the density of shading lines, in
    lines per inch, for the bars or bar components.
    The default value of \code{NULL} means that no shading lines
    are drawn. Non-positive values of \code{density} also inhibit the
    drawing of shading lines.}
  \item{angle}{the slope of shading lines, given as an angle in
    degrees (counter-clockwise), for the bars or bar components.}
  \item{col}{a vector of colors for the bars or bar components.}
  \item{border}{the color to be used for the border of the bars.}
  \item{main,sub}{overall and sub title for the plot.}
  \item{xlab}{a label for the x axis.}
  \item{ylab}{a label for the y axis.}
  \item{xlim}{limits for the x axis.}
  \item{ylim}{limits for the y axis.}
  \item{xpd}{logical. Should bars be allowed to go outside region?}
  \item{axes}{logical.  If \code{TRUE}, a vertical (or horizontal, if
    \code{horiz} is true) axis is drawn.}
  \item{axisnames}{logical.  If \code{TRUE}, and if there are
    \code{names.arg} (see above), the
    other axis is drawn (with \code{lty=0}) and labeled.}
  \item{cex.axis}{expansion factor for numeric axis labels.}
  \item{cex.names}{expansion factor for names.}
  \item{inside}{logical.  If \code{TRUE}, the lines which  divide
    adjacent bars will be drawn.}
  \item{plot}{logical.  If \code{FALSE}, nothing is plotted.}
  \item{shift}{a vector indicating how much the bars should be
    shifted from the x axis.}
  \item{\dots}{further graphical parameters (\code{\link{par}}) are
    passed to \code{\link{plot.window}()}, \code{\link{title}()} and
    \code{\link{axis}}.}
}
\description{
  Creates a bar plot with vertical or horizontal bars.
}
\details{
  This is a generic function, it currently only has a default method.
  A formula interface may be added eventually.
}
\value{
  A numeric vector (or matrix, when \code{beside = TRUE}), say
  \code{mp}, giving the coordinates of \emph{all} the bar midpoints
  drawn, useful for adding to the graph.

  If \code{beside} is true, use \code{colMeans(mp)} for the
  midpoints of each \emph{group} of bars, see example.
}
\seealso{
  \code{\link{plot}(\dots, type="h")}, \code{\link{dotchart}},
  \code{\link{hist}}.
}
\examples{
tN <- table(Ni <- rpois(100, lambda=5))
r <- barplot(tN, col='gray')
#- type = "h" plotting *is* `bar'plot
lines(r, tN, type='h', col='red', lwd=2)

barplot(tN, space = 1.5, axisnames=FALSE,
        sub = "barplot(..., space= 1.5, axisnames = FALSE)")

data(VADeaths, package = "base")
barplot(VADeaths, plot = FALSE)
barplot(VADeaths, plot = FALSE, beside = TRUE)

mp <- barplot(VADeaths) # default
tot <- colMeans(VADeaths)
text(mp, tot + 3, format(tot), xpd = TRUE, col = "blue")
barplot(VADeaths, beside = TRUE,
        col = c("lightblue", "mistyrose", "lightcyan",
                "lavender", "cornsilk"),
        legend = rownames(VADeaths), ylim = c(0, 100))
title(main = "Death Rates in Virginia", font.main = 4)

hh <- t(VADeaths)[, 5:1]
mybarcol <- "gray20"
mp <- barplot(hh, beside = TRUE,
        col = c("lightblue", "mistyrose",
                "lightcyan", "lavender"),
        legend = colnames(VADeaths), ylim= c(0,100),
        main = "Death Rates in Virginia", font.main = 4,
        sub = "Faked upper 2*sigma error bars", col.sub = mybarcol,
        cex.names = 1.5)
segments(mp, hh, mp, hh + 2*sqrt(1000*hh/100), col = mybarcol, lwd = 1.5)
stopifnot(dim(mp) == dim(hh))# corresponding matrices
mtext(side = 1, at = colMeans(mp), line = -2,
      text = paste("Mean", formatC(colMeans(hh))), col = "red")

# Bar shading example
barplot(VADeaths, angle = 15+10*1:5, density = 20, col = "black", 
        legend = rownames(VADeaths))
title(main = list("Death Rates in Virginia", font = 4))
}
\keyword{hplot}

\eof
\name{distplot}
\alias{distplot}
\title{Diagnostic distribution plots}
\description{
Diagnostic distribution plots: poissonness, binomialness and
negative bionomialness plots.
}
\usage{
distplot(obj, type = c("poisson", "binomial", "nbinomial"),
         size = NULL, lambda = NULL, legend = TRUE, ylim = NULL,
         line.col = 2, conf.int = TRUE, conf.level = 0.95, main = NULL,
	 xlab = "Number of occurrences", ylab = "Distribution metameter", ...)
}
\arguments{
  \item{obj}{either a vector of counts, a 1-way table of frequencies
    of counts or a data frame or matrix with frequencies
    in the first column and the corresponding counts in the
    second column.}
  \item{type}{a character string indicating the distribution.}
  \item{size}{the size argument for the binomial distribution, only
    required if \code{type} is \code{"binomial"}. If set to \code{NULL},
    \code{size} is taken to be the maximum count.}
  \item{lambda}{parameter of the poisson distribution. If type is
    \code{"poisson"} and \code{lambda} is specified a leveled
    poissonness plot is produced.}
  \item{legend}{logical. Should a legend be plotted?.}
  \item{ylim}{limits for the y axis.}
  \item{line.col}{color for fitted line.}
  \item{conf.int}{logical. Should confidence intervals be plotted?.}
  \item{conf.level}{confidence level for confidence intervals.}
  \item{main}{a title for the plot.}
  \item{xlab}{a label for the x axis.}
  \item{ylab}{a label for the y axis.}
  \item{...}{further arguments passed to \code{\link{plot}}.}
}
\details{
\code{distplot} plots the number of occurrences (counts) against the
distribution metameter of the specified distribution. If
the distribution fits the data, the plot should show a
straight line. See Friendly (2000) for details.
}
\author{
  Achim Zeileis
}
\references{
D. C. Hoaglin (1980), A poissonness plot, \emph{The American
Statistican}, \bold{34}, 146-149.

D. C. Hoaglin & J. W. Tukey (1985), Checking the shape of discrete
distributions. In D. C. Hoaglin, F. Mosteller, J. W. Tukey (eds.),
\emph{Exploring Data Tables, Trends and Shapes}, chapter 9. John
Wiley & Sons, New York.

Michael Friendly (2000),
\emph{Visualizing Categorical Data}. SAS Institute, Cary, NC.
}
\examples{
## Simulated data examples:
dummy <- rnbinom(1000, size = 1.5, prob = 0.8)
distplot(dummy, type = "nbinomial")

## Real data examples:
data(HorseKicks)
data(Federalist)
data(Saxony)
distplot(HorseKicks, type = "poisson")
distplot(HorseKicks, type = "poisson", lambda = 0.61)
distplot(Federalist, type = "poisson")
distplot(Federalist, type = "nbinomial")
distplot(Saxony, type = "binomial", size = 12)
}
\keyword{category}

\eof
\name{expected}
\alias{expected}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Expected Frequencies Table}
\description{
Computes table of expected frequencies from a n-way table.
}
\usage{
expected(x, frequency = c("absolute", "relative"))
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{a table.}
  \item{frequency}{indicates, if absolute or relative frequencies should
  be computed.}
}
\value{
  A table with either absolute or relative frequencies.
}
\author{
  David Meyer\cr
  \email{david.meyer@ci.tuwien.ac.at}
}
\examples{
data(MSPatients)
expected(MSPatients)
expected(MSPatients, frequency = "relative")
}
\keyword{category}% at least one, from doc/KEYWORDS
\keyword{array}% __ONLY ONE__ keyword per line

\eof
\name{fourfoldplot}
\alias{fourfoldplot}
\title{Fourfold Plots}
\description{
  Creates an (extended) fourfold display of a 2 by 2 by \eqn{k} contingency table on
  the current graphics device, allowing for the visual inspection of the
  association between two dichotomous variables in one or several
  populations (strata).
}
\usage{
fourfoldplot(x, color = c("#99CCFF","#6699CC","#FF5050","#6060A0", "#FF0000", "#000080"),
             conf.level = 0.95, std = c("margins", "ind.max", "all.max"),
             margin = c(1, 2), space = 0.2, main = NULL,
             mfrow = NULL, mfcol = NULL, extended = TRUE, ticks = 0.2,
             p.adjust.method = p.adjust.methods)
}
\arguments{
  \item{x}{a 2 by 2 by \eqn{k} contingency table in array form, or as a
    2 by 2 matrix if \eqn{k} is 1.}
  \item{color}{a vector of length 6 specifying the colors to use for the
    smaller and larger diagonals of each 2 by 2 table. The first pair
    is used for the standard (non-extended) plots, the other two
    for the extended version: the second/third pair is used for tables with
    non-significant/significant logoddsratios, respectively, the latter
    being visualized in brighter colors.}
  \item{conf.level}{confidence level used for the confidence rings on
    the odds ratios.  Must be a single nonnegative number less than 1;
    if set to 0, confidence rings are suppressed.}
  \item{std}{a character string specifying how to standardize the table.
    Must be one of \code{"margins"}, \code{"ind.max"}, or
    \code{"all.max"}, and can be abbreviated by the initial letter.
    If set to \code{"margins"}, each 2 by 2 table is standardized to
    equate the margins specified by \code{margin} while preserving the
    odds ratio.  If \code{"ind.max"} or \code{"all.max"}, the tables are
    either individually or simultaneously standardized to a maximal cell
    frequency of 1.}
  \item{margin}{a numeric vector with the margins to equate.  Must be
    one of \code{1}, \code{2}, or \code{c(1, 2)} (the default), which
    corresponds to standardizing the row, column, or both margins in
    each 2 by 2 table.
    Only used if \code{std} equals \code{"margins"}.}
  \item{space}{the amount of space (as a fraction of the maximal radius
    of the quarter circles) used for the row and column lebals.}
  \item{main}{character string for the fourfold title.}
  \item{mfrow}{a numeric vector of the form \code{c(nr, nc)}, indicating
    that the displays for the 2 by 2 tables should be arranged in an
    \code{nr} by \code{nc} layout, filled by rows.}
  \item{mfcol}{a numeric vector of the form \code{c(nr, nc)}, indicating
    that the displays for the 2 by 2 tables should be arranged in an
    \code{nr} by \code{nc} layout, filled by columns.}
  \item{extended}{if \code{TRUE}, extended plots are plotted,
    i.e. colors are brighter for significant logoddsratios, and ticks
    are plotted for pies with positive logodds.}
  \item{ticks}{the length of the ticks. If set to 0, no ticks are
    plotted.}
  \item{p.adjust.method}{method to be used for p-value adjustments for
    multistratum-plots. The p-values are used for the ``visual''
    significance tests of the oddsratios.}
}
\details{
  The fourfold display is designed for the display of 2 by 2 by \eqn{k}
  tables.

  Following suitable standardization, the cell frequencies
  \eqn{f_{ij}}{f[i,j]} of each 2 by 2 table are shown as a quarter
  circle whose radius is proportional to
  \eqn{\sqrt{f_{ij}}}{sqrt(f[i,j])} so that its area is proportional to
  the cell frequency.  An association (odds ratio different from 1)
  between the binary row and column variables is indicated by the
  tendency of diagonally opposite cells in one direction to differ in
  size from those in the other direction; color is used to show this
  direction.  Confidence rings for the odds ratio allow a visual test of
  the null of no association; the rings for adjacent quadrants overlap
  iff the observed counts are consistent with the null hypothesis.

  Typically, the number \eqn{k} corresponds to the number of levels of a
  stratifying variable, and it is of interest to see whether the
  association is homogeneous across strata.  The fourfold display
  visualizes the pattern of association.  Note that the confidence rings
  for the individual odds ratios are not adjusted for multiple testing.
}
\references{
M. Friendly (1994), A fourfold display for 2 by 2 by \eqn{k} tables.
Technical Report 217, York University, Psychology Department,
\url{http://www.math.yorku.ca/SCS/Papers/4fold/4fold.ps.gz}.

M. Friendly (2000),
\emph{Visualizing Categorical Data}. SAS Institute, Cary, NC.
}
\seealso{
  \code{\link{mosaicplot}}
}
\examples{
data(UCBAdmissions)
## Use the Berkeley admission data as in Friendly (1995).
x <- aperm(UCBAdmissions, c(2, 1, 3))
dimnames(x)[[2]] <- c("Yes", "No")
names(dimnames(x)) <- c("Sex", "Admit?", "Department")
ftable(x)

## Fourfold display of data aggregated over departments, with
## frequencies standardized to equate the margins for admission
## and sex.
## Figure 1 in Friendly (1994).
fourfoldplot(margin.table(x, c(1, 2)))

## Fourfold display of x, with frequencies in each table
## standardized to equate the margins for admission and sex.
## Figure 2 in Friendly (1994).
fourfoldplot(x)

## Fourfold display of x, with frequencies in each table
## standardized to equate the margins for admission. but not
## for sex.
## Figure 3 in Friendly (1994).
fourfoldplot(x, margin = 2)
}
\keyword{hplot}

\eof
\name{goodfit}
\alias{goodfit}
\alias{summary.goodfit}
\alias{plot.goodfit}
\alias{predict.goodfit}
\alias{fitted.goodfit}
\alias{print.goodfit}
\title{Goodness-of-fit tests for discrete data}
\description{
Fits a discrete (count data) distribution for goodness-of-fit tests.
}
\usage{
goodfit(obj, type = c("poisson", "binomial", "nbinomial"),
        method = c("ML", "MinChisq"), par = NULL)
\method{predict}{goodfit}(object, newcount = NULL, type = c("response", "prob"), \dots)
}
\arguments{
  \item{obj}{either a vector of counts, a 1-way table of frequencies
    of counts or a data frame or matrix with frequencies
    in the first column and the corresponding counts in the
    second column.}
  \item{type}{a character string indicating which distribution should be fit
    (for \code{goodfit}) or  indicating the type of prediction (fitted response
    or probabilities in \code{predict}) respectively.}
  \item{method}{a character string indicating whether the distribution should
    be fit via ML (Maximum Likelihood) or Minimum Chi-squared.}
  \item{par}{a named list giving the distribution parameters (named as in the
    corresponding density function), if set to \code{NULL}, the default,
    the parameters are estimated. If the paramater \code{size} is not specified
    if \code{type} is \code{"binomial"} it is taken to be the maximum count.}
  \item{object}{an object of class \code{"goodfit"}.}
  \item{newcount}{a vector of counts. By default the counts stored in \code{object}
    are used, i.e. the fitted values are computed. These can also be
    extracted by \code{fitted(object)}.}
  \item{\dots}{\emph{currently not used}.}
}
\details{\code{goodfit} essentially computes the fitted values of a
discrete distribution (either poisson, binomial or negative binomial)
to the count data given in \code{obj}. If the parameters are not specified
they are estimated by either by ML or Minimum Chi-squared.
\code{par} should a named list specifying the parameters \code{lambda}
for \code{"poisson"} and \code{prob} and \code{size} for \code{"binomial"}
or \code{"nbinomial"} respectively. If for \code{"binomial"} \code{size} is
not specified it is not estimated but taken as the maximum count.

The corresponding Pearson Chi-squared or likelihood
ratio statistic respectively is computed and given with their $p$ values by the
\code{summary} method. The
\code{plot} method produces a \code{link{rootogram}} of the
observed and fitted values.
}
\value{
  A list of class \code{"goodfit"} with elements:
  \item{observed}{observed frequencies,}
  \item{count}{corresponding counts,}
  \item{fitted}{expected frequencies (fitted by ML),}
  \item{type}{a character string indicating the distribution fitted,}
  \item{method}{a character string indicating the fitting method (can
    be either \code{"ML"}, \code{"MinChisq"} or \code{"fixed"} if the
    parameters were specified),}
  \item{df}{degrees of freedom,}
  \item{par}{a named list of the (estimated) distribution parameters.}
}
\author{
  Achim Zeileis
}
\references{
M. Friendly (2000),
\emph{Visualizing Categorical Data}. SAS Institute, Cary, NC.
}
\examples{
## Simulated data examples:
dummy <- rnbinom(200, size = 1.5, prob = 0.8)
gf <- goodfit(dummy, type = "nbinomial", method = "MinChisq")
summary(gf)
plot(gf)

dummy <- rbinom(100, size = 6, prob = 0.5)
gf1 <- goodfit(dummy, type = "binomial", par = list(size = 6))
gf2 <- goodfit(dummy, type = "binomial", par = list(prob = 0.6, size = 6))
summary(gf1)
plot(gf1)
summary(gf2)
plot(gf2)

## Real data examples:
data(HorseKicks)
HK.fit <- goodfit(HorseKicks)
summary(HK.fit)
plot(HK.fit)

data(Federalist)
F.fit <- goodfit(Federalist, type = "nbinomial")
summary(F.fit)
plot(F.fit)
}
\keyword{category}

\eof
\name{mar.table}
\alias{mar.table}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Table with marginal sums.}
\description{
  Adds row and column sums to a two-way table.
}
\usage{
mar.table(x)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{a two-way table.}
}
\value{
  A table with added total column and total row.
}
\author{
  David Meyer\cr
  \email{david.meyer@ci.tuwien.ac.at}
}
\examples{
data(SexualFun)
mar.table(SexualFun)
}
\keyword{category}% at least one, from doc/KEYWORDS




\eof
\name{mosaicpairs}
\alias{mosaicpairs}
\alias{mosaicpairs.default}
\alias{mosaicpairs.formula}
\title{Mosaic Matrices}
\description{Plots matrices of mosaics.}
\usage{
\method{mosaicpairs}{default}(x, main = deparse(substitute(x)),
            xlab = NULL, ylab = NULL, labels, \dots,
            type = c("pairwise", "total", "conditional", "joint"),
            shade = TRUE, oma = NULL, cex.labels = NULL, label.pos = 0.5,
	    font.labels = 1, gap = 1)
\method{mosaicpairs}{formula}(formula, data = NULL, \dots, main, subset)
}
\arguments{
  \item{x}{a contingency table in array form, with optional category
    labels specified in the \code{dimnames(x)} attribute.  The table is
    best created by the \code{table()} command.}
  \item{main}{character string for the mosaic title.}
  \item{xlab,ylab}{x- and y-axis labels used for the plot; by default,
    the first and second element of \code{names(dimnames(X))} (i.e., the
    name of the first and second variable in \code{X}).}
  \item{labels}{the names of the variables.}
  \item{\dots}{further parameters (\emph{currently not used}).}
  \item{type}{a character string indicating the type of mosaic matrix,
    see details for more information.}
  \item{shade}{a logical indicating whether to produce extended mosaic
    plots, or a numeric vector of at most 5 distinct positive numbers
    giving the absolute values of the cut points for the residuals.  By
    default, \code{shade} is \code{TRUE}.  Using \code{shade = TRUE} cuts absolute values at 2 and
    4.}
  \item{oma}{A vector of the form c(bottom, left, top, right) giving the
    size of the outer margins in lines of text.}
  \item{cex.labels, font.labels}{graphics parameters for the text panel.}
  \item{label.pos}{y position of labels in the text panel.}
  \item{gap}{distance between subplots, in margin lines.}
  \item{formula}{a formula, such as \code{y ~ x}.}
  \item{data}{a data.frame (or list), or a contingency table from which
    the variables in \code{formula} should be taken.}
  \item{subset}{an optional vector specifying a subset of observations
    to be used for plotting.}
}
\details{
  \code{mosaicpairs()} plots a matrix of pairwise mosaic plots, four
  independence types are distinguished:
  \code{"pairwise"}, \code{"total"}, \code{"conditional"} and \code{"joint"}.
  The pairwise mosaic matrix shows bivariate marginal relations, collapsed over
  all other variables. The total independence mosaic matrix shows mosaic plots
  for mutual independence, i.e. for marginal and conditional independence
  among all pairs of variables. The conditional independence mosaic matrix shows
  mosaic plots for marginal independence given all other variables. The
  joint independence mosaic matrix shows mosaic plots for joint independence of all pairs of
  variables from the others.
}

\references{
M. Friendly (2000),
\emph{Visualizing Categorical Data}. SAS Institute, Cary, NC.
}
\seealso{
  \code{\link{mosaicplot}},
  \code{\link{pairs}}.
}
\examples{
data(UCBAdmissions)
data(PreSex)

mosaicpairs(PreSex, shade = TRUE)
mosaicpairs(UCBAdmissions, shade = TRUE)
mosaicpairs(UCBAdmissions, shade = TRUE, type="conditional")
}
\keyword{hplot}




\eof
\name{mosaicplot}
\alias{mosaicplot}
\alias{mosaicplot.default}
\alias{mosaicplot.formula}
\title{Mosaic Plots}
\description{Plots a mosaic on the current graphics device.}
\usage{
\method{mosaicplot}{default}(x, main = deparse(substitute(x)), sub = NULL, xlab = NULL,
         ylab = NULL, sort = NULL, off = NULL, dir = NULL,
         color = FALSE, shade = !(is.null(residuals) && is.null(margin)), margin = NULL,
         cex.axis = 0.66, las = par("las"), clegend = TRUE, 
         type = c("pearson", "deviance", "FT"), residuals = NULL, \dots)
\method{mosaicplot}{formula}(formula, data = NULL, \dots,
                             main = deparse(substitute(data)), subset)
}
\arguments{
  \item{x}{a contingency table in array form, with optional category
    labels specified in the \code{dimnames(x)} attribute.  The table is
    best created by the \code{table()} command.}
  \item{main}{character string for the mosaic title.}
  \item{sub}{character string for the mosaic sub-title (at bottom).}
  \item{xlab,ylab}{x- and y-axis labels used for the plot; by default,
    the first and second element of \code{names(dimnames(X))} (i.e., the
    name of the first and second variable in \code{X}).}
  \item{sort}{vector ordering of the variables, containing a permutation
    of the integers \code{1:length(dim(x))} (the default).}
  \item{off}{vector of offsets to determine percentage spacing at each
    level of the mosaic (appropriate values are between 0 and 20,
    and the default is 10 at each level).  There should be one
    offset for each dimension of the contingency table.}
  \item{dir}{vector of split directions (\code{"v"} for vertical and
    \code{"h"} for horizontal) for each level of the mosaic, one
    direction for each dimension of the contingency table.  The
    default consists of alternating directions, beginning with a
    vertical split.}
  \item{color}{logical or (recycling) vector of colors for color
    shading, used only when \code{shade} is \code{FALSE}.  The default
    \code{color=FALSE} gives empty boxes with no shading.}
  \item{cex.axis}{The magnification to be used for axis annotation,
    as a multiple of \code{par("cex")}.}
  \item{las}{numeric; the style of axis labels, see \code{\link{par}}.}
  \item{shade}{a logical indicating whether to produce extended mosaic
    plots, or a numeric vector of at most 5 distinct positive numbers
    giving the absolute values of the cut points for the residuals. 
    If no marginal model and no residuals are specified,
    \code{shade} is \code{FALSE} by default and simple mosaics are
    created.  Using \code{shade = TRUE} cuts absolute values at 2 and
    4.}
  \item{clegend}{logical. Should a color legend be plotted? (only needed
    if \code{shade} is \code{TRUE}).}
  \item{margin}{a list of vectors with the marginal totals to be fit in
    the log-linear model, or a formula as used in \code{loglm}.
    By default, an independence model is fitted.
    See \code{\link{loglin}} and \code{\link{loglm}} for further information.}
  \item{type}{a character string indicating the type of residual to be
    represented.  Must be one of \code{"pearson"} (giving components of
    Pearson's \eqn{\chi^2}{chi-squared}), \code{"deviance"} (giving
    components of the likelihood ratio \eqn{\chi^2}{chi-squared}), or
    \code{"FT"} for the Freeman-Tukey residuals.  The value of this
    argument can be abbreviated.}
  \item{formula}{a formula, such as \code{y ~ x}.}
  \item{data}{a data.frame (or list), or a contingency table from which
    the variables in \code{formula} should be taken.}
  \item{\dots}{further arguments to be passed to or from methods.}
  \item{subset}{an optional vector specifying a subset of observations
    to be used for plotting.}
  \item{residuals}{explicit argument for the residuals to be used in
    extended mosaic plots.}
}
\details{
  This is a generic function.  It currently has a default method
  (\code{\link{mosaicplot.default}}) and a formula interface
  (\code{\link{mosaicplot.formula}}).

  Extended mosaic displays show the standardized residuals of a
  loglinear model of the counts from by the color and outline of the
  mosaic's tiles.  (Standardized residuals are often referred to a
  standard normal distribution.)  Negative residuals are drawn in shaded
  of red and with broken outlines; positive ones are drawn in blue with
  solid outlines.

  For the formula method, if \code{data} is an object inheriting from
  classes \code{"table"} or \code{"ftable"}, or an array with more than
  2 dimensions, it is taken as a contingency table, and hence all
  entries should be nonnegative.  In this case, the left-hand side of
  \code{formula} should be empty, and the variables on the right-hand
  side should be taken from the names of the dimnames attribute of the
  contingency table.  A marginal table of these variables is computed,
  and a mosaic of this table is produced.

  Otherwise, \code{data} should be a data frame or matrix, list or
  environment containing the variables to be cross-tabulated.  In this
  case, after possibly selecting a subset of the data as specified by
  the \code{subset} argument, a contingency table is computed from the
  variables given in \code{formula}, and a mosaic is produced from
  this.

  See Emerson (1998) for more information and a case study with
  television viewer data from Nielsen Media Research.
}
\author{
  S-PLUS original by John Emerson \email{emerson@stat.yale.edu}.
  Modified and enhanced for \R by KH.
}
\references{
  Hartigan, J.A., and Kleiner, B. (1984)
  A mosaic of television ratings. \emph{The American Statistician},
  \bold{38}, 32--35.

  Emerson, J. W. (1998)
  Mosaic displays in S-PLUS: a general implementation and a case study.
  \emph{Statistical Computing and Graphics Newsletter (ASA)},
  \bold{9}, 1, 17--23.

  Friendly, M. (1994)
  Mosaic displays for multi-way contingency tables.
  \emph{Journal of the American Statistical Association}, \bold{89},
  190--200.

  The home page of Michael Friendly
  (\url{http://www.math.yorku.ca/SCS/friendly.html}) provides
  information on various aspects of graphical methods for analyzing
  categorical data, including mosaic plots.
}
\seealso{
  \code{\link{assocplot}},
  \code{\link{loglin}}.
}
\examples{
data(Titanic)
mosaicplot(Titanic, main = "Survival on the Titanic", color = TRUE)
## Formula interface for tabulated data:
mosaicplot(~ Sex + Age + Survived, data = Titanic, color = TRUE)

data(HairEyeColor)
mosaicplot(HairEyeColor, shade = TRUE)
## Independence model of hair and eye color and sex.  Indicates that
## there are significantly more blue eyed blond females than expected
## in the case of independence (and too few brown eyed blond females).

mosaicplot(HairEyeColor, shade = TRUE, margin = list(c(1,2), 3))
## Model of joint independence of sex from hair and eye color.  Males
## are underrepresented among people with brown hair and eyes, and are
## overrepresented among people with brown hair and blue eyes, but not
## ``significantly''.

## Formula interface for raw data: visualize crosstabulation of numbers
## of gears and carburettors in Motor Trend car data.
data(mtcars)
mosaicplot(~ gear + carb, data = mtcars, color = TRUE)
mosaicplot(~ gear + carb, data = mtcars, color = 2:3)# color recycling
}
\keyword{hplot}

\eof
\name{oddsratio}
\alias{oddsratio}
\alias{print.oddsratio}
\alias{summary.oddsratio}
\alias{print.summary.oddsratio}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Odds Ratios}
\description{
  Computes (log) odds ratios and their asymtotic standard errors
  for (possibly) stratified data.
}
\usage{
oddsratio(x, stratum = NULL, log = TRUE, conf.level = 0.95)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{a 2 x 2 x ... table.}
 \item{stratum}{vector of strata dimensions.}
 \item{log}{if \code{FALSE}, ordinary odds ratios are computed}
 \item{conf.level}{confidence level used for confidence intervals.}
}
\value{
  An object of class \code{logoddratio}, which is simply a
  vector of (log) odds ratios with dimensionality depending on \code{stratum}, along with
  the following attributes:
  \item{ASE}{a vector with the asymptotic standard errors}
  \item{lwr, upr}{a vector with lower/upper confidence bounds}
  \item{Z}{test statistic for significance tests (only computed for log
  odds ratios: simply the standardized log odds ratio, which follows
an asymptotic normal distribution.}
  \item{P}{p-value for this test.}
  \item{log}{logical value indicating if log odds ratios or common odds
    ratios are computed.}
}
\note{The \code{summary} method prints the standard errors.}

\references{
M. Friendly (2000),
\emph{Visualizing Categorical Data}. SAS Institute, Cary, NC.
}
\author{
  David Meyer\cr
  \email{david.meyer@ci.tuwien.ac.at}
}

\seealso{\code{\link{plot.oddsratio}}}

\examples{
data(CoalMiners)
summary(oddsratio(CoalMiners))
}
\keyword{category}% __ONLY ONE__ keyword per line

\eof
\name{plot.oddsratio}
\alias{plot.oddsratio}
\title{(Log) Odds Ratios Plots}
\description{
  Plots (log) odds ratios, computed by \code{oddsratio} for 2 x 2 x
  k-tables, along with confidence intervals.
}
\usage{
\method{plot}{oddsratio}(x, confidence = TRUE, type = "o",
     ylab = NULL, xlab = "Strata", whiskers = 0.1, ...)
}
\arguments{
  \item{x}{An object of class \code{logoddsratio}, computed for a 2 x 2
    x k-table.}
  \item{confidence}{if \code{TRUE}, confidence intervals are plotted for
    each data point.}
  \item{type}{plot type.}
  \item{ylab}{label for the y-axis.  The default results in
    \code{"Odds Ratio"} or \code{"Log Odds Ratio"}, as appropriate.} 
  \item{xlab}{label for the x-axis.}
  \item{whiskers}{Width of the confidence interval whiskers.}
  \item{\dots}{Other graphics parameters (see \code{par}).}
}
\references{
M. Friendly (2000),
\emph{Visualizing Categorical Data}. SAS Institute, Cary, NC.
}
\author{
  David Meyer \email{david.meyer@ci.tuwien.ac.at}.
}

\seealso{\code{\link{oddsratio}}}

\examples{
data(CoalMiners)
l <- oddsratio(CoalMiners)
g <- seq(25, 60, by = 5)
plot(l,
     xlab = "Age Group",
     main = "Breathelessness and Wheeze in Coal Miners")
m <- lm(l ~ g + I(g^2))
lines(fitted(m), col = "red")
}

\keyword{hplot}% at least one, from doc/KEYWORDS

\eof
\name{rootogram}
\alias{rootogram}
\alias{rootogram.default}
\alias{rootogram.goodfit}
\title{Rootograms}
\description{
Rootograms of observed and fitted values.
}
\usage{
\method{rootogram}{default}(x, fitted, names = NULL, scale = c("sqrt", "raw"),
                            type = c("hanging", "standing", "deviation"),
			    bar.col = grey(0.7), line.col = 2,
			    xlab = NULL, ylab = NULL, ylim = NULL, ...)
}
\arguments{
  \item{x}{either a vector or a 1-way table of frequencies.}
  \item{fitted}{a vector of fitted frequencies.}
  \item{names}{a vector of names passed to barplot, if set to
    \code{NULL} the names of \code{x} are used.}
  \item{scale}{a character string indicating wether the values should be
    plotted on the raw or square root scale.}
  \item{type}{a character string indicating if the bars for the observed
    frequencies should be hanging or standing or indicate the deviation
    between observed and fitted frequencies.}
  \item{bar.col}{bar color (observed frequencies).}
  \item{line.col}{line color (fitted frequencies).}
  \item{xlab}{a label for the x axis.}
  \item{ylab}{a label for the y axis.}
  \item{ylim}{limits for the y axis.}
  \item{...}{further arguments passed to \code{\link{barplot}}.}
}
\details{
The observed frequencies are displayed as bars and the fitted frequencies as
a line. By default a log scale is used to make the smaller frequencies more
visible.
}
\author{
  Achim Zeileis
}
\references{
J. W. Tukey (1977), \emph{Exploratory Data Analysis}. Addison Wesley,
Reading, MA.

M. Friendly (2000),
\emph{Visualizing Categorical Data}. SAS Institute, Cary, NC.
}
\examples{
## Simulated data examples:
dummy <- rnbinom(200, size = 1.5, prob = 0.8)
observed <- table(dummy)
fitted1 <- dnbinom(as.numeric(names(observed)), size = 1.5, prob = 0.8) * sum(observed)
fitted2 <- dnbinom(as.numeric(names(observed)), size = 2, prob = 0.6) * sum(observed)
rootogram(observed, fitted1)
rootogram(observed, fitted2)

## Real data examples:
data(HorseKicks)
HK.fit <- goodfit(HorseKicks)
summary(HK.fit)
plot(HK.fit)
## or equivalently
rootogram(HK.fit)

data(Federalist)
F.fit <- goodfit(Federalist, type = "nbinomial")
summary(F.fit)
plot(F.fit)
}
\keyword{hplot}

\eof
\name{sieveplot}
\alias{sieveplot}
\alias{sieveplot.default}
\alias{sieveplot.formula}
\title{Sieve Plots}
\description{
Visualization of two-way contingency tables: plots rectangles with surfaces
proportional to the expected cell frequencies and filled with a number of
squares equal to the expected frequencies. Thus, the densities visualize
the deviations of the observed from the expected values.
}
\usage{
\method{sieveplot}{default}(x, reverse.y = TRUE,
          type = c("sieve", "expected"), main = NULL,
          values = c("none", "cells", "margins", "both"),
          frequencies = c("absolute", "relative"),
          sieve.colors = c("red","blue"),
          sieve.lty = c("longdash", "solid"),
          exp.color = "gray", exp.lty = "dotted",
          margin = 0.01, cex.main = 2, cex.lab = 1.5,
          xlab = names(dimnames(x))[2],
          ylab = names(dimnames(x))[1], ...)
\method{sieveplot}{formula}(formula, data = NULL, ..., subset)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{a two-way contingency table, as generated by \code{table}.}
  \item{reverse.y}{if \code{TRUE}, the y axis is reversed (i.e., the
    rectangles' positions correspond to the contingency table).}
  \item{type}{\code{expected} fills the rectangles according to the
    \emph{expected} frequencies.}
  \item{main}{user specified title.}
  \item{values}{optionally, the frequencies of the \code{cells} or
    \code{margins} or of \code{both} can be plotted.}
  \item{frequencies}{chooses the type of these frequencies:
    \code{relative} or \code{absolute}.}
  \item{sieve.colors, sieve.lty}{vectors with up to two color/line type entries: the first
    is used for negative and the second for positive deviations
    from the expected frequencies.}
  \item{exp.color, exp.lty}{color/line type entry for the expected
    values grid.}
  \item{margin}{lines of margin between the cell rectangles.}
  \item{cex.main}{font size of title.}
  \item{cex.lab}{font size of labels.}
  \item{xlab, ylab}{labels of x- and y-axis.}
  \item{formula}{a formula, such as \code{y ~ x}. For details, see \code{xtabs}.}
  \item{data}{a data.frame (or list), or a contingency table from which the
          variables in `formula' should be taken.}
  \item{subset}{an optional vector specifying a subset of observations to be
    used for plotting.}
  \item{\dots}{further graphics parameters (see \code{par}).}
}
\references{
H. Riedwyl & M. Schpbach (1994), Parquet diagram to plot contingency tables.
In F. Faulbaum (ed.), \emph{Softstat '93: Advances in Statistical Software},
293-299. Gustav Fischer, New York.

M. Friendly (2000), Visualizing Categorical Data, SAS Institute, Cary, NC.
}
\author{
  David Meyer\cr
  \email{david.meyer@ci.tuwien.ac.at}
}
\seealso{\code{\link{mosaicplot}}}

\examples{
data(HairEyeColor)

## aggregate over `sex':
(tab <- margin.table(HairEyeColor, c(2,1)))

## plot expected values:
sieveplot(tab, type = "expected", values = "both")

## plot sieve diagram:
sieveplot(tab)

## an example for the formula interface:
data(VisualAcuity)
sieveplot(Freq ~ right + left,  data = VisualAcuity, reverse.y = FALSE)
}
\keyword{category}% at least one, from doc/KEYWORDS
\keyword{hplot}% __ONLY ONE__ keyword per line

\eof
\name{summary.table}
\alias{summary.table}
\alias{print.summary.table}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Summary of a m x n-table}
\description{
Prints a m x n-contingency table along with percentages, marginal and conditional distributions.
}
\usage{
summary.table(object, margins = TRUE, percentages = FALSE,
        conditionals = c("none", "row", "column"), ...)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{object}{a m x n-contingency table}
  \item{margins}{if \code{TRUE}, marginal distributions are computed.}
  \item{percentages}{if \code{TRUE}, relative frequencies are computed.}
  \item{conditionals}{if not \code{"none"}, the conditioinal
    distributions, given the row/column factor, are computed.}
  \item{\dots}{currently not used.}
}
\value{
Returns invisibly a m x n x o - table, o depending on the amount of
choices (max 3).
}
\author{
  David Meyer\cr
  \email{david.meyer@ci.tuwien.ac.at}
}
\seealso{\code{\link{mar.table}}, \code{\link{prop.table}}}

\examples{
data(UCBAdmissions)
summary(margin.table(UCBAdmissions, 1:2))
}
\keyword{category}% at least one, from doc/KEYWORDS

\eof
\name{ternaryplot}
\alias{ternaryplot}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Ternary diagram}
\description{
Visualizes compositional, 3-dimensional data in an equilateral triangle.
}
\usage{
ternaryplot(x, scale = 1, dimnames = NULL, dimnames.position = c("corner","edge","none"),
            dimnames.color = "black", id = NULL, id.color = "black", coordinates = FALSE,
	    grid = TRUE, grid.color = "gray", labels = c("inside", "outside", "none"),
	    labels.color = "darkgray", border = "black", bg = "white", pch = 19, cex = 1,
	    prop.size = FALSE, col = "red", main = "ternary plot", ...)
}
\arguments{
  \item{x}{a matrix with three columns.}
  \item{scale}{row sums scale to be used.}
  \item{dimnames}{dimension labels (defaults to the column names of
    \code{x}).}
  \item{dimnames.position, dimnames.color}{position and color of dimension labels.}
  \item{id}{optional labels to be plotted below the plot
    symbols. \code{coordinates} and \code{id} are mutual exclusive.}
  \item{id.color}{color of these labels.}
  \item{coordinates}{if \code{TRUE}, the coordinates of the points are
    plotted below them. \code{coordinates} and \code{id} are mutual exclusive.}
  \item{grid}{if \code{TRUE}, a grid is plotted. May optionally
    be a string indicating the line type (default: \code{"dotted"}).}
  \item{grid.color}{grid color.}
  \item{labels, labels.color}{position and color of the grid labels.}
  \item{border}{color of the triangle border.}
  \item{bg}{triangle background.}
  \item{pch}{plotting character. Defaults to filled dots.}
  \item{cex}{a numerical value giving the amount by which plotting text
    and symbols should be scaled relative to the default. Ignored for
    the symbol size if \code{prop.size} is not \code{FALSE}.}
  \item{prop.size}{if \code{TRUE}, the symbol size is plotted
    proportional to the row sum of the three variables, i.e. represents
    the weight of the observation.}
  \item{col}{plotting color.}
  \item{main}{main title.}
  \item{\dots}{additional graphics parameters (see \code{par})}
}
\details{
A points' coordinates are found by computing the gravity center
of mass points using the data entries as weights. Thus, the coordinates
of a point P(a,b,c), \eqn{a + b + c = 1}, are: P(b + c/2, c * sqrt(3)/2).
}
\references{
M. Friendly (2000),
\emph{Visualizing Categorical Data}. SAS Institute, Cary, NC.
}
\author{
  David Meyer\cr
  \email{david.meyer@ci.tuwien.ac.at}
}

\examples{
data(Arthritis)

## Build table by crossing Treatment and Sex
tab <- as.table(xtabs(~ I(Sex:Treatment) + Improved, data = Arthritis))

## Mark groups
col <- c("red", "red", "blue", "blue")
pch <- c(1, 19, 1, 19)

## plot
ternaryplot(
            tab,
            col = col,
            pch = pch,
            prop.size = TRUE,
            bg = "lightgray",
            grid.color = "white",
            labels.color = "white",
            main = "Arthritits Treatment Data"
           )
## legend
legend(0.7, 0.8,
       c("GROUP", rownames(tab)),
       pch = c(NA, pch),
       col = c(NA, col)
      )

data(Lifeboats)
attach(Lifeboats)
ternaryplot(
  Lifeboats[,4:6],
  pch = ifelse(side=="Port", 1, 19),
  col = ifelse(side=="Port", "red", "blue"),
  id  = ifelse(men/total > 0.1, as.character(boat), NA),
  prop.size = 2,
  dimnames.position = "edge",
  main = "Lifeboats on Titanic"
)
legend(
  0.8, 0.9,
  legend = c("SIDE", "Port", "Starboard"),
  pch = c(NA, 1, 19),
  col = c("black", "red", "blue"),
)

data(Hitters)
attach(Hitters)
colors <- c("black","red","green","blue","red","black","blue")
pch <- substr(levels(Positions), 1, 1)
ternaryplot(
  Hitters[,2:4],
  pch = as.character(Positions),
  col = colors[as.numeric(Positions)],
  main = "Baseball Hitters Data"
)
legend(
  0.8, 0.9,
  legend = c("POSITION(S)", levels(Positions)),
  pch = c("", pch),
  col = c(NA, colors)
)
}
\keyword{hplot}






\eof
\name{woolf.test}
\alias{woolf.test}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Woolf test}
\description{
Test for homogeneity on 2 x 2 x k - tables over strata (i.e., if the log
odds ratios are the same in all strata).
}
\usage{
woolf.test(x)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{A 2x2xk-table.}
}
\value{
     A list with class `"htest"' containing the following components: 
\item{statistic}{the value the chi-squared test statistic.}
\item{parameter}{the degrees of freedom of the approximate chi-squared
          distribution of the test statistic.}
\item{p.value}{the p-value for the test.}
\item{method}{a character string indicating the type of test performed.}
\item{data.name}{a character string giving the name(s) of the data.}
\item{observed}{the observed counts.}
\item{expected}{the expected counts under the null hypothesis.}
}

\seealso{\code{\link{mantelhaen.test}}}

\examples{
data(CoalMiners)
woolf.test(CoalMiners)
}
\keyword{htest}% at least one, from doc/KEYWORDS


\eof
