### Name: cca
### Title: [Partial] [Constrained] Correspondence Analysis and Redundancy
###   Analysis
### Aliases: cca cca.default cca.formula print.cca summary.cca
###   print.summary.cca rda rda.default rda.formula summary.rda
### Keywords: multivariate

### ** Examples

data(varespec)
data(varechem)
## Common but bad way: use all variables you happen to have in your
## environmental data matrix
vare.cca <- cca(varespec, varechem)
vare.cca
plot(vare.cca)
## Formula interface and a better model
vare.cca <- cca(varespec ~ Al + P*(K + Baresoil), data=varechem)
vare.cca
plot(vare.cca)
## `Partialling out' and `negative components of variance'
cca(varespec ~ Ca, varechem)
cca(varespec ~ Ca + Condition(pH), varechem)
## RDA
data(dune)
data(dune.env)
dune.Manure <- rda(dune ~ Manure, dune.env)
plot(dune.Manure) 



