### Name: decostand
### Title: Standardizaton Methods for Community Ecology
### Aliases: decostand wisconsin
### Keywords: multivariate manip

### ** Examples

data(varespec)
sptrans <- decostand(varespec, "max")
apply(sptrans, 2, max)
sptrans <- wisconsin(varespec)
# Chi-square: Similar but not identical to Correspondence Analysis.
sptrans <- decostand(varespec, "chi.square")
plot(procrustes(rda(sptrans), cca(varespec)))
# Hellinger transformation (Legendre & Callagher 2001):
sptrans <- sqrt(decostand(varespec, "total"))



