### Name: deviance.cca
### Title: Statistics Resembling Deviance and AIC for Constrained
###   Ordination
### Aliases: deviance.cca deviance.rda deviance.capscale extractAIC.cca
### Keywords: multivariate models

### ** Examples

# The deviance of correspondence analysis equals Chi-square
data(dune)
data(dune.env)
chisq.test(dune)
deviance(cca(dune))
# Backward elimination from a complete model "dune ~ ."
ord <- cca(dune ~ ., dune.env)
ord
step(ord)
# Stepwise selection (forward from an empty model "dune ~ 1")
step(cca(dune ~ 1, dune.env), scope = formula(ord))
# ANOVA for the added variable
anova(cca(dune ~ Moisture, dune.env))
# ANOVA for the next candidate variable that was not added
anova(cca(dune ~ Condition(Moisture) + Management, dune.env), perm.max=1000)



