### Name: diversity
### Title: Ecological Diversity Indices and Rarefaction Species Richness
### Aliases: diversity rarefy renyi fisher.alpha specnumber
### Keywords: univar

### ** Examples

data(BCI)
H <- diversity(BCI)
simp <- diversity(BCI, "simpson")
invsimp <- diversity(BCI, "inv")
r.2 <- rarefy(BCI, 2)
alpha <- fisher.alpha(BCI)
pairs(cbind(H, simp, invsimp, r.2, alpha), pch="+", col="blue")
## Species richness (S) and Pielou's evenness (J):
S <- specnumber(BCI) ## rowSums(BCI > 0) does the same...
J <- H/log(S)



