### Name: envfit
### Title: Fits an Environmental Vector or Factor onto an Ordination
### Aliases: envfit vectorfit factorfit plot.envfit print.envfit
###   print.factorfit print.vectorfit
### Keywords: multivariate aplot htest

### ** Examples

data(varespec)
data(varechem)
library(MASS)
library(mva)
vare.dist <- vegdist(wisconsin(varespec))
vare.mds <- isoMDS(vare.dist)
vare.mds <- postMDS(vare.mds, vare.dist)
vare.fit <- envfit(vare.mds$points, varechem, 1000)
vare.fit
ordiplot(vare.mds)
plot(vare.fit)
plot(vare.fit, p.max = 0.05, col = "red")



