### Name: fisherfit
### Title: Fit Fisher's Logseries and Preston's Lognormal model to
###   Abundance Data
### Aliases: fisherfit as.fisher plot.fisherfit print.fisherfit prestonfit
###   prestondistr as.preston plot.prestonfit lines.prestonfit
###   print.prestonfit veiledspec
### Keywords: univar distribution

### ** Examples

data(BCI)
plot(fisherfit(BCI[5,]))
# prestonfit seems to need large samples
mod.oct <- prestonfit(colSums(BCI))
mod.ll <- prestondistr(colSums(BCI))
mod.oct
mod.ll
plot(mod.oct)  
lines(mod.ll, line.col="blue3") # Different
## Smoothed density
den <- density(log2(colSums(BCI)))
lines(den$x, ncol(BCI)*den$y, lwd=2) # Fairly similar to mod.oct
## Extrapolated richness
veiledspec(mod.oct)
veiledspec(mod.ll)



