### Name: initMDS
### Title: Random Start and Axis Scaling for isoMDS
### Aliases: initMDS postMDS
### Keywords: multivariate

### ** Examples

## The recommended way of running NMDS (Minchin 1987)
##
data(varespec)
data(varechem)
library(MASS) ## isoMDS
library(mva)  ## cmdscale: default start to isoMDS
# Select a good dissimilarity index
rankindex(scale(varechem),varespec)
rankindex(scale(varechem),wisconsin(varespec))
vare.dist <- vegdist(wisconsin(varespec), "bray")
# Get the baseline solution: start with cmdscale
mds.null <- isoMDS(vare.dist, tol=1e-7)
## See if you can get any better.
repeat{
  mds.1<- isoMDS(vare.dist, initMDS(vare.dist), maxit=200, trace=FALSE, tol=1e-7)
  if(mds.1$stress < mds.null$stress) break
}
# Scale solutions ("fix translation, rotation and scale")
mds.null <- postMDS(mds.null, vare.dist)
mds.1 <- postMDS(mds.1, vare.dist)
# Compare solutions
plot(procrustes(mds.1, mds.null))



