### Name: ordiplot
### Title: Alternative plot and identify Functions for Ordination
### Aliases: ordiplot identify.ordiplot scores.ordiplot points.ordiplot
###   text.ordiplot
### Keywords: hplot iplot aplot

### ** Examples

# Draw a cute NMDS plot
data(dune)
dune.dis <- vegdist(wisconsin(dune))
library(MASS)
dune.mds <- isoMDS(dune.dis)
dune.mds <- postMDS(dune.mds, dune.dis)
# Dirty trick: Save species weighted averages in cproj which we
# know in ordiplot... (you should ask me to improve the function)
dune.mds$cproj <- wascores(dune.mds$points, dune, expand = TRUE)
fig <- ordiplot(dune.mds, type = "none")
points(fig, "sites", pch=21, col="red", bg="yellow")
text(fig, "species", col="blue", cex=0.9)
# A quick plot of the previous.
# identify is not run automatically because it needs user interaction:
## Not run: fig <- ordiplot(dune.mds)
## Not run: identify(fig, "spec")



