### Name: procrustes
### Title: Procrustes Rotation of Two Configurations
### Aliases: procrustes print.procrustes summary.procrustes
###   print.summary.procrustes plot.procrustes points.procrustes
###   lines.procrustes residuals.procrustes fitted.procrustes protest
###   print.protest
### Keywords: multivariate htest

### ** Examples

data(varespec)
vare.dist <- vegdist(wisconsin(varespec))
library(MASS)  ## isoMDS
library(mva)   ## cmdscale to start isoMDS
mds.null <- isoMDS(vare.dist, tol=1e-7)
## This was a good seed for me: your rng may vary.
set.seed(237)
mds.alt <- isoMDS(vare.dist, initMDS(vare.dist), maxit=200, tol=1e-7)
vare.proc <- procrustes(mds.alt$points, mds.null$points)
vare.proc
summary(vare.proc)
plot(vare.proc)
plot(vare.proc, kind=2)
residuals(vare.proc)
## Reset rng:
rm(.Random.seed)



