### Name: draw.default
### Title: Draw a Picture of a Wavelet
### Aliases: draw.default
### Keywords: hplot

### ** Examples

op <- par(mfrow=c(5,2), oma = c(0,0, 4, 0),
          mgp = c(1.2, .8, 0), mar = .1 + c(4,4, .5,1))
for(fn in 1:10) {
   draw.default(filter.number= fn, col = "blue", main = NULL, xlab= "")
   abline(h=0,v=0, lty=3, lwd=.5, col = "gray")
}
mtext(paste("draw.default(*, family = '",formals(draw.default)$family[[2]],"')"),
      side = 3, line = 1, outer = TRUE,
      cex = par("cex.main"), font = par("font.main"))
par(op)

# Draw a 2-dimensional Daubechies least asymmetric wavelet
draw.default(filter.number=6, family="DaubLeAsymm", dim=2, resolution=128)



