### Name: threshold.wd
### Title: Threshold a `wd' Object (1D Wavelet)
### Aliases: threshold.wd
### Keywords: nonlinear smooth

### ** Examples

# "Standard" example:
example(wd)
#
# Threshold it
#
(thH.wds <- threshold(wds))
thS.wds <- threshold(wds, type="soft")
#
# Reconstruct from the thresholded coefficients
#
str(    trecH <- wr(thH.wds))
summary(trecS <- wr(thS.wds))
#
# Plot the data, the true & reconstructed functions
#
plot(x,y, col = "gray", cex = .6) # the data
lines(x, fx, col="blue", lwd=1)# true function
lines(x, trecH, col= "orchid", lty=2, lwd=2)
lines(x, trecS, col= "tomato", lty=4, lwd=2)
legend(0,5.6, c("true", paste(c("hard","soft")," thresh.")),
       col = c("blue","orchid","tomato"), lwd= c(1,2,2), lty = c(1,2,4))



