### Name: wr
### Title: Discrete wavelet transform (reconstruction).
### Aliases: wr
### Keywords: math smooth nonlinear

### ** Examples

# Decompose and then exactly reconstruct test.data
example(wd)#-> wds has wd() ressult
rec.wds <- wr(wds)
rec.wds.obj <- wr(wds, return.object = TRUE)
rec.wds2 <- accessC(rec.wds.obj, level=rec.wds.obj$nlevels)
all(rec.wds == rec.wds2)# since wr() internally uses accessC()

# Look at accuracy of reconstruction
summary(abs(rec.wds - y)) #~ 10^-11

# Reconstruct a hard.thresholded object, look at the wavelet coefficients
summary(thr.wds <- wr(threshold(wds, type="hard") ))



