\name{artificial}
\alias{artificial}
\alias{y.artificial}
\alias{x.artificial}
\title{Hawkins, Bradu, Kass's Artificial Data}
\usage{
data(artificial)
}
\description{
  This data set was generated by Hawkins, Bradu and Kass in the 1984 for illustrating some of the merits of a robust technique. The data set consists of 75 observations in four dimensions (one response and three explanatory variables). The first 10 observations are bad leverage points, and the next four points are good leverage points (i.e., their \bold{x} are outlying, but the corresponding \emph{y} fit the model quite well).
}

\format{
  \code{artificial} is a data frame with 75 cases (rows) and 4 variables
  (columns) where the last column is the dependent variable,
  \code{y.artificial} and \code{x.artificial} (as a matrix) are also available.
}

\source{
  Hawkins, D.M., Bradu, D., and Kass, G.V. (1984)
  Location of several outliers in multiple regression data using elemental sets.
  \emph{Technometrics,}
  \bold{26}, 197--208.
}

\seealso{
  Rousseeuw, P.J., and Leroy, A.M. (1987)
  \emph{Robust regression and outliers detection,}
  Wiley.}

%\examples{}

\keyword{datasets}

\eof
\name{binary}
\alias{binary}
\title{Convert decimal base number to binary base}
\description{Convert decimal base number to binary base.}
\usage{
binary(x, dim)
}

\arguments{
  \item{x}{a number in decibal base.}
  \item{dim}{the number of digits, if missing the right number of digits is evaluated.}
}

\value{
  \item{binary}{a vector representing the `x` number in binary base.}
  \item{dicotomy}{the same as `binary` but `TRUE` and `FALSE` instead of 1 and 0.}
}

\note{the elements of `binary` and `dicotomy` are in reverse order.}

\author{Claudio Agostinelli}

\examples{
binary(2)
binary(10,dim=5)
}
\keyword{arith}


\eof
\name{cavendish}
\alias{cavendish}
\title{Cavendish's determinations of the mean density of the earth Data}
\usage{
data(cavendish)
}
\description{
The Cavendish's determinations of the mean density of the earth data (relative to that of water) are 29 measures performed in the 1798 using a torsion balance devised earlier by Michell. After the sixth of these determinations, Cavendish changed his experimental apparatus by replacing a suspension wire by one that was stiffer. To further complicate matters, Cavendish erred in taking the mean of al 29 determinations by treating the value 4.88 as if it were in fact 5.88. 
}
\format{
\code{cavendish} is a vector of 29 observations, the first sixth are made before the apparatus replacement.
}
\source{
 Cavendish, H. (1900)
 Experiments to determine the density of the earth,
 \emph{Philosophical Transactions of the Royal Society of London for the year 1798}
 (Part II) \bold{88}, 469--526,
 Reprinted in \emph{The law of gravitation}
 (A.S. Mackenzie, ed.) American, New York.
}

\seealso{
 Stigler, S.M. (1977)
 Do robust estimators work with \emph{real} data?
 \emph{Annals of Statistics,}
 \bold{5}, 1055--1098,
 (with discussion).}


%\examples{}

\keyword{datasets}

\eof
\name{hald}
\alias{hald}
\alias{x.hald}
\alias{y.hald}
\title{Hald Data}
\usage{
data(hald)
}
\description{
Montgomery and Peck (1982) illustrated variable selection techniques on the Hald cement data and gave several references to other analysis. The response variable \emph{y} is the \emph{heat evolved} in a cement mix. The four explanatory variables are ingredients of the mix, i.e., x1: \emph{tricalcium aluminate}, x2: \emph{tricalcium silicate}, x3: \emph{tetracalcium alumino ferrite}, x4: \emph{dicalcium silicate}. An important feature of these data is that the variables x1 and x3 are highly correlated (corr(x1,x3)=-0.824), as well as the variables x2 and x4 (with corr(x2,x4)=-0.975). Thus we should expect any subset of (x1,x2,x3,x4) that includes one variable from highly correlated pair to do as any subset that also includes the other member.
}

\format{
  \code{hald} is a matrix with 13 observations (rows) and 5 variables (columns), the first column is the dependent variable. \code{y.hald} and \code{x.hald} are also availables.
}

\source{
  Montgomery, D.C., Peck, E.A. (1982) 
  \emph{Introduction to linear regression analysis,}
  John Wiley, New York.
}

%\seealso{}
%\examples{}

\keyword{datasets}

\eof
\name{mle.aic}
\title{Akaike Information Criterion}
\usage{
mle.aic(formula, data=list(), model=TRUE, x=FALSE, 
        y=FALSE, var.full=0, alpha=2, contrasts = NULL, 
        verbose=FALSE)
}
\alias{mle.aic}
\arguments{
  \item{formula}{a symbolic description of the model to be fit.
    The details of model specification are given below.}

  \item{data}{an optional data frame containing the variables
    in the model.  By default the variables are taken from
    the environment which \code{mle.aic} is called from.}

  \item{model, x, y}{logicals.  If \code{TRUE} the corresponding components of the fit (the model frame, the model matrix, the
    response.)}

 \item{var.full}{the value of variance to be used, if 0 the variance estimated from the full model is used.}

 \item{alpha}{the penalized constant.}

 \item{contrasts}{an optional list. See the \code{contrasts.arg}
    of \code{model.matrix.default}.}

 \item{verbose}{if \code{TRUE} warnings are printed.}

}

\description{The Akaike Information Criterion is evaluated for each submodel.}

\details{Models for \code{mle.aic} are specified symbolically.  A typical model has the form \code{response ~ terms} where \code{response} is the (numeric) response vector and \code{terms} is a series of terms which specifies a linear predictor for \code{response}.  A terms specification of the form \code{first+second} indicates all the terms in \code{first} together with all the terms in \code{second} with duplicates removed. A specification of the form \code{first:second} indicates the the set of terms obtained by taking the interactions of all terms in \code{first} with all terms in \code{second}. The specification \code{first*second} indicates the \emph{cross} of \code{first} and \code{second}.  This is the same as \code{first+second+first:second}.
}

\value{ \code{mle.aic} returns an object of \code{\link{class}} \code{"mle.aic"}.

  The function \code{summary} is used to obtain and print a summary of the results.
  The generic accessor functions \code{coefficients} and \code{residuals} extract coefficients and residuals returned by \code{mle.aic}.
  The object returned by \code{mle.aic} are:

\item{aic}{the AIC for each submodels}
\item{coefficients}{the parameters estimator, one row vector for each submodel.}
\item{scale}{an estimation of the error scale, one value for each submodel.}
\item{residuals}{the residuals from the estimated model, one column vector for each submodel.}
\item{call}{the match.call().}
\item{contrasts}{}
\item{xlevels}{}
\item{terms}{the model frame.}
\item{model}{if \code{model=TRUE} a matrix with first column the dependent variable and the remain column the explanatory variables for the full model.}
\item{x}{if \code{x=TRUE} a matrix with the explanatory variables for the full model.}
\item{y}{if \code{y=TRUE} a vector with the dependent variable.}
\item{info}{not well working yet, if 0 no error occurred.}
}

\author{Claudio Agostinelli}

\references{
Akaike, H., (1973) Information theory and an extension of the maximum likelihood principle, in: B.N. Petrov and F. Cs\'aki, eds., \emph{Proc. 2nd International Symposium of Information Theory}, Akad\'emiai Kiad\'o, Budapest, 267-281.
}

%\seealso{}

\examples{
library(wle)

data(hald)

cor(hald)

result <- mle.aic(y.hald~x.hald)

summary(result,num.max=10)
}

\keyword{regression}

\eof
\name{mle.aic.summaries}
\title{Summaries and methods for mle.aic}
\usage{
\method{summary}{mle.aic}(object, num.max=20, verbose=FALSE, ...)

\method{print}{mle.aic}(x, digits = max(3, getOption("digits") - 3),
num.max=max(1, nrow(x$aic)), ...)

\method{print}{summary.mle.aic}(x, digits = max(3, getOption("digits") - 3), ...)
}

\alias{summary.mle.aic}
\alias{print.mle.aic}
\alias{print.summary.mle.aic}

\arguments{
 \item{object}{an object of class \code{mle.aic}.}
 \item{x}{an object of class \code{mle.aic} or \code{summary.mle.aic}.}
 \item{num.max}{the max number of models should be reported.}
 \item{digits}{number of digits to be used for most numbers.} 
 \item{verbose}{if \code{TRUE} warnings are printed.}
 \item{...}{additional arguments affecting the summary produced (in
   \code{summary.mle.aic}) or further arguments passed to or from other methods
   (in \code{print.mle.aic} and \code{print.summary.mle.aic}).}
}

\description{All these functions are \code{\link{methods}} for class \code{mle.aic} or \code{summary.mle.aic}.}

\value{
\code{summary.mle.aic} returns a list:

 \item{aic}{the first \code{num.max} best models with their AIC.}
 \item{num.max}{the number of models reported.}
 \item{call}{}
}

\author{Claudio Agostinelli}

\seealso{\code{\link{mle.aic}} a function for evaluate the Akaike Information Criterion.}

%\examples{}

\keyword{regression}





\eof
\name{mle.cp}
\title{Mallows Cp}
\usage{
mle.cp(formula, data=list(), model=TRUE, x=FALSE, 
       y=FALSE, var.full=0, contrasts=NULL, verbose=FALSE)
}
\alias{mle.cp}
\arguments{
  \item{formula}{a symbolic description of the model to be fit.
    The details of model specification are given below.}

  \item{data}{an optional data frame containing the variables
    in the model.  By default the variables are taken from
    the environment which \code{mle.cp} is called from.}

  \item{model, x, y}{logicals.  If \code{TRUE} the corresponding components of the fit (the model frame, the model matrix, the
    response).}

  \item{var.full}{the value of variance to be used in the denominator of the Mallows Cp, if 0 the variance estimated from the full model is used.}

  \item{contrasts}{an optional list. See the \code{contrasts.arg}
    of \code{model.matrix.default}.}

  \item{verbose}{if \code{TRUE} warnings are printed.}

}

\description{The Mallows Cp is evaluated for each submodel.}

\details{Models for \code{mle.cp} are specified symbolically.  A typical model has the form \code{response ~ terms} where \code{response} is the (numeric) response vector and \code{terms} is a series of terms which specifies a linear predictor for \code{response}.  A terms specification of the form \code{first+second} indicates all the terms in \code{first} together with all the terms in \code{second} with duplicates removed. A specification of the form \code{first:second} indicates the the set of terms obtained by taking the interactions of all terms in \code{first} with all terms in \code{second}. The specification \code{first*second} indicates the \emph{cross} of \code{first} and \code{second}.  This is the same as \code{first+second+first:second}.
}


\value{ 
    \code{mle.cp} returns an object of \code{\link{class}} \code{"mle.cp"}.

  The function \code{summary} is used to obtain and print a summary of the results, only models below the bisector are reported.
  The generic accessor functions \code{coefficients} and \code{residuals} extract coefficients and residuals returned by \code{mle.cp}.
  The object returned by \code{mle.cp} are:

\item{cp}{Mallows Cp for each submodels}
\item{coefficients}{the parameters estimator, one row vector for eac submodel.}
\item{scale}{an estimation of the error scale, one value for each submodel.}
\item{residuals}{the residuals from the estimated model, one column vector for each submodel.}
\item{call}{the match.call().}
\item{contrasts}{}
\item{xlevels}{}
\item{terms}{the model frame.}
\item{model}{if \code{model=TRUE} a matrix with first column the dependent variable and the remain column the explanatory variables for the full model.}
\item{x}{if \code{x=TRUE} a matrix with the explanatory variables for the full model.}
\item{y}{if \code{y=TRUE} a vector with the dependent variable.}
\item{info}{not well working yet, if 0 no error occurred.}
}

\author{Claudio Agostinelli}

\references{
Mallows, C.L., (1973) Some comments on Cp, \emph{Technometrics}, 15, 661-675.
}

%\seealso{}

\examples{
library(wle)

data(hald)

cor(hald)

result <- mle.cp(y.hald~x.hald)

summary(result)

plot(result)
}

\keyword{regression}



\eof
\name{mle.cp.summaries}
\title{Summaries and methods for mle.cp}
\usage{
\method{summary}{mle.cp}(object, num.max=20, verbose=FALSE, ...)

\method{print}{mle.cp}(x, digits = max(3, getOption("digits") - 3),
num.max=max(1, nrow(x$cp)), ...)

\method{print}{summary.mle.cp}(x, digits = max(3, getOption("digits") - 3), ...)
}

\alias{summary.mle.cp}
\alias{print.mle.cp}
\alias{print.summary.mle.cp}

\arguments{
 \item{object}{an object of class \code{mle.cp}.}
 \item{x}{an object of class \code{mle.cp} or \code{summary.mle.cp}.}
 \item{digits}{number of digits to be used for most numbers.}  
 \item{num.max}{the max number of models should be reported.}
 \item{verbose}{if \code{TRUE} warnings are printed.}
 \item{...}{additional arguments affecting the summary produced (in
   \code{summary.mle.cp}) or further arguments passed to or from other methods
   (in \code{print.mle.cp} and \code{print.summary.mle.cp}).}
}

\description{All these functions are \code{\link{methods}} for class \code{mle.cp} or \code{summary.mle.cp}.}

\value{
\code{summary.mle.cp} returns a list:

 \item{cp}{the first \code{num.max} best models with their Mallows Cp.}
 \item{num.max}{the number of models reported.}
 \item{call}{}
}

\author{Claudio Agostinelli}

\seealso{\code{\link{mle.cp}} a function for evaluate the Mallows Cp.}

%\examples{}

\keyword{regression}




\eof
\name{mle.cv}
\title{Cross Validation Selection Method}
\usage{
mle.cv(formula, data=list(), model=TRUE, x=FALSE, 
       y=FALSE, monte.carlo=500, split, 
       contrasts=NULL, verbose=FALSE)
}
\alias{mle.cv}
\arguments{

  \item{formula}{a symbolic description of the model to be fit.
    The details of model specification are given below.}

  \item{data}{an optional data frame containing the variables
    in the model.  By default the variables are taken from
    the environment which \code{mle.cv} is called from.}

  \item{model, x, y}{logicals.  If \code{TRUE} the corresponding components of the fit (the model frame, the model matrix, the
    response.)}

  \item{monte.carlo}{the number of Monte Carlo replication we use to estimate the average prediction error.}

  \item{split}{the size of the costruction sample. When the suggested value is outside the possible range, the split size is let equal to \eqn{max(round(size^{(3/4)}),nvar+2)}.}

  \item{contrasts}{an optional list. See the \code{contrasts.arg}
    of \code{model.matrix.default}.}

  \item{verbose}{if \code{TRUE} warnings are printed.}
}

\description{The Cross Validation selection method is evaluated for each submodel.}

\details{Models for \code{mle.cv} are specified symbolically.  A typical model has the form \code{response ~ terms} where \code{response} is the (numeric) response vector and \code{terms} is a series of terms which specifies a linear predictor for \code{response}.  A terms specification of the form \code{first+second} indicates all the terms in \code{first} together with all the terms in \code{second} with duplicates removed. A specification of the form \code{first:second} indicates the the set of terms obtained by taking the interactions of all terms in \code{first} with all terms in \code{second}. The specification \code{first*second} indicates the \emph{cross} of \code{first} and \code{second}.  This is the same as \code{first+second+first:second}.
}

\value{ \code{mle.cv} returns an object of \code{\link{class}} \code{"mle.cv"}.

  The function \code{summary} is used to obtain and print a summary of the results.

  The object returned by \code{mle.cv} are:

\item{cv}{the estimated prediction error for each submodels}
\item{call}{the match.call().}
\item{contrasts}{}
\item{xlevels}{}
\item{terms}{the model frame.}
\item{model}{if \code{model=TRUE} a matrix with first column the dependent variable and the remain column the explanatory variables for the full model.}
\item{x}{if \code{x=TRUE} a matrix with the explanatory variables for the full model.}
\item{y}{if \code{y=TRUE} a vector with the dependent variable.}
\item{info}{not well working yet, if 0 no error occurred.}
}

\author{Claudio Agostinelli}

%\seealso{}

\references{
Shao, J., (1993) Linear model selection by Cross-Validation. \emph{Journal American Statistical Association}, 88, 486-494.
}


\examples{
library(wle)

data(hald)

cor(hald)

result <- mle.cv(y.hald~x.hald)

summary(result)
}

\keyword{regression}



\eof
\name{mle.cv.summaries}
\title{Summaries and methods for mle.cv}
\usage{
\method{summary}{mle.cv}(object, num.max=20, verbose=FALSE, ...)

\method{print}{mle.cv}(x, digits = max(3, getOption("digits") - 3), num.max=max(1, nrow(x$cv)), ...)

\method{print}{summary.mle.cv}(x, digits = max(3, getOption("digits") - 3), ...)
}

\alias{summary.mle.cv}
\alias{print.mle.cv}
\alias{print.summary.mle.cv}

\arguments{
 \item{object}{an object of class \code{mle.cv}.}
 \item{x}{an object of class \code{mle.cv} or \code{summary.mle.cv}.}
 \item{digits}{number of digits to be used for most numbers.}
 \item{num.max}{the max number of models should be reported.}
 \item{verbose}{if \code{TRUE} warnings are printed.}
 \item{...}{additional arguments affecting the summary produced (in
   \code{summary.mle.cv}) or further arguments passed to or from other methods
   (in \code{print.mle.cv} and \code{print.summary.mle.cv}).}

}

\description{All these functions are \code{\link{methods}} for class \code{mle.cv} or \code{summary.mle.cv}.}

\value{
\code{summary.mle.cv} returns a list:

 \item{cv}{the first \code{num.max} best models with their estimated prediction error using CV.}
 \item{num.max}{the number of models reported.}
 \item{call}{}
}

\author{Claudio Agostinelli}

\seealso{\code{\link{mle.cv}} a function for evaluate the Cross-Validation selection criterion for linear models.}

%\examples{}

\keyword{regression}




\eof
\name{mle.stepwise}
\title{Stepwise, Backward and Forward selection methods}
\usage{
mle.stepwise(formula, data=list(), model=TRUE, x=FALSE, 
             y=FALSE, type="Forward", f.in=4.0, f.out=4.0, 
             contransts=NULL, verbose=FALSE)
}
\alias{mle.stepwise}
\arguments{
  \item{formula}{a symbolic description of the model to be fit.
    The details of model specification are given below.}

  \item{data}{an optional data frame containing the variables
    in the model.  By default the variables are taken from
    the environment which \code{mle.stepwise} is called from.}

  \item{model, x, y}{logicals.  If \code{TRUE} the corresponding components of the fit (the model frame, the model matrix, the
    response.)}

  \item{type}{
\code{type="Stepwise"}: the stepwise methods is used,

\code{type="Forward"}: the forward methods is used,

\code{type="Backward"}: the backward method is used.}

  \item{f.in}{the in value}

  \item{f.out}{the out value}

  \item{contransts}{an optional list. See the \code{contrasts.arg}
    of \code{model.matrix.default}.}

  \item{verbose}{if \code{TRUE} warnings are printed.}

}

\description{This function performs Stepwise, Forward and Backward model selection.}

\details{Models for \code{mle.stepwise} are specified symbolically.  A typical model has the form \code{response ~ terms} where \code{response} is the (numeric) response vector and \code{terms} is a series of terms which specifies a linear predictor for \code{response}.  A terms specification of the form \code{first+second} indicates all the terms in \code{first} together with all the terms in \code{second} with duplicates removed. A specification of the form \code{first:second} indicates the the set of terms obtained by taking the interactions of all terms in \code{first} with all terms in \code{second}. The specification \code{first*second} indicates the \emph{cross} of \code{first} and \code{second}.  This is the same as \code{first+second+first:second}.
}

\value{ \code{mle.stepwise} returns an object of \code{\link{class}} \code{"mle.stepwise"}.

  The function \code{summary} is used to obtain and print a summary of the results.

  The object returned by \code{mle.stepwise} are:

\item{step}{the selected models}
\item{type}{the type o model selection procedure was used.}
\item{f.in}{the value of f.in used.}
\item{f.out}{the value of f.out used.}
\item{call}{the match.call().}
\item{contrasts}{}
\item{xlevels}{}
\item{terms}{the model frame.}
\item{model}{if \code{model=TRUE} a matrix with first column the dependent variable and the remain column the explanatory variables for the full model.}
\item{x}{if \code{x=TRUE} a matrix with the explanatory variables for the full model.}
\item{y}{if \code{y=TRUE} a vector with the dependent variable.}
\item{info}{not well working yet, if 0 no error occurred.}
}

\author{Claudio Agostinelli}

\references{

Beale, E.M.L., Kendall, M.G., Mann, D.W., (1967) The discarding of variables in multivariate analysis, \emph{Biometrika}, 54, 357-366.

Efroymson, (1960) Multiple regression analysis, in \emph{Mathematical Methods for Digital Computers}, eds. A. Ralston and H.S. Wilf, 191-203, Wiley, New York.

Garside, M.J., (1965) The best sub-set in multiple regression analysis, \emph{Applied Statistics}, 14, 196-200.

Goldberger, A.S, and Jochems, D.B., (1961) Note on stepwise least squares, \emph{Journal of the American Statistical Association}, 56, 105-110.

Goldberger, A.S., (1961) Stepwise least squares: Residual analysis and specification error, \emph{Journal of the American Statistical Association}, 56, 998-1000.

}

\examples{

library(wle)

data(hald)

cor(hald)

result <- mle.stepwise(y.hald~x.hald)

summary(result)

}

\keyword{regression}





\eof
\name{mle.stepwise.summaries}
\title{Accessing summaries for mle.stepwise}
\usage{
\method{summary}{mle.stepwise}(object, num.max=20, verbose=FALSE, ...)

\method{print}{mle.stepwise}(x, digits = max(3, getOption("digits") - 3), num.max=max(1,nrow(x$step)), ...)

\method{print}{summary.mle.stepwise}(x, digits = max(3, getOption("digits") - 3), ...)
}

\alias{summary.mle.stepwise}
\alias{print.mle.stepwise}
\alias{print.summary.mle.stepwise}

\arguments{
 \item{object}{an object of class \code{mle.stepwise}.}
 \item{x}{an object of class \code{mle.stepwise} or
   \code{summary.mle.stepwise}.}
 \item{digits}{number of digits to be used for most numbers.}
 \item{num.max}{the number of the last iterations reported.}
 \item{verbose}{if \code{TRUE} warnings are printed.}
 \item{...}{additional arguments affecting the summary produced (in
   \code{summary.mle.stepwise}) or further arguments passed to or from other methods
   (in \code{print.mle.stepwise} and \code{print.summary.mle.stepwise}).} 
}

\description{All these functions are \code{\link{methods}} for class \code{mle.stepwise} or \code{summary.mle.stepwise}.}

%\details{}

\value{
  The function \code{summary.mle.stepwise} returns the last \code{num.max} iterations, \code{call} plus:

\item{step}{the model for each iteration reported.}
\item{num.max}{the number of iterations reported.}
\item{type}{the type of selection procedure used.}
\item{f.in}{the in value}
\item{f.out}{the out value}

}

\author{Claudio Agostinelli}

%\examples{}

\keyword{regression}






\eof
\name{plot.mle.cp}
\title{Plot the Mallows Cp}
\usage{
\method{plot}{mle.cp}(x, base.line=0, num.max=20, 
           plot.it=TRUE, log.scale=FALSE, 
           xlab="Number of Predictors", ylab=NULL,
           verbose=FALSE, ...)
}

\alias{plot.mle.cp}

\arguments{
 \item{x}{an object of class \code{mle.cp}.}
 \item{base.line}{the intercept of the line to split the submodels in acceptable (good) and not-acceptable (bad), (the slope is always one).}
 \item{num.max}{maximum number of submodels plotted.}
 \item{plot.it}{if TRUE the graph is plotted.}
 \item{log.scale}{if TRUE the y-axis as log10 scale.}
 \item{xlab}{a title for the x axis.}
 \item{ylab}{a title for the y axis.}
 \item{verbose}{if \code{TRUE} warnings are printed.}
 \item{...}{graphical parameters can be given as arguments.}
}

\description{Plot the Mallows Cp.}

\value{
\item{num.good}{number of submodels below the \code{base.line}}
\item{num.bad}{number of submodels above the \code{base.line}}
\item{cp.good}{list of the submodels below the \code{base.line} with their Cp.}
\item{cp.bad}{list of the submodels above the \code{base.line} with their Cp.}
}

%\references{}

\author{Claudio Agostinelli}

%\note{}

\seealso{\code{\link{mle.cp}} a function to calculate the Mallows Cp.}

\examples{
library(wle)

data(hald)

result <- mle.cp(y.hald~x.hald)

plot(result,num.max=7)

}

\keyword{regression}



\eof
\name{plot.wle.cp}
\title{Plot the Weighted Mallows Cp}
\usage{
\method{plot}{wle.cp}(x, base.line=0, num.max=20, 
           plot.it=TRUE, log.scale=FALSE, 
           xlab="Number of Predictors", ylab=NULL,
           verbose=FALSE, ...)
}

\alias{plot.wle.cp}

\arguments{
 \item{x}{an object of class \code{wle.cp}.}
 \item{base.line}{the intercept of the line to split the submodels in acceptable (good) and not-acceptable (bad), (the slope is always one).}
 \item{num.max}{maximum number of submodels plotted.}
 \item{plot.it}{if TRUE the graph is plotted.}
 \item{log.scale}{if TRUE the y-axis as log10 scale.}
 \item{xlab}{a title for the x axis.}
 \item{ylab}{a title for the y axis.}
 \item{verbose}{if \code{TRUE} warnings are printed.}
 \item{...}{graphical parameters can be given as arguments.}
}

\description{Plot the weighted Mallows Cp based on weighted likelihood.}

\value{
\item{num.good}{number of submodels below the \code{base.line}}
\item{num.bad}{number of submodels above the \code{base.line}}
\item{wcp.good}{list of the submodels below the \code{base.line} with their WCp.}
\item{wcp.bad}{list of the submodels above the \code{base.line} with their WCp.}
}


\references{

Agostinelli, C., (1999) Robust model selection in regression via weighted likelihood methodology, \emph{ Working Paper n. 1999.4}, Department of Statistics, Universiy of Padova.

Agostinelli, C., (1999) Robust model selection in regression via weighted likelihood methodology, submitted to \emph{ Statistics \& Probability Letters}, revised december 1999.

Agostinelli, C., (1998) Inferenza statistica robusta basata sulla funzione di verosimiglianza pesata: alcuni sviluppi, \emph{ Ph.D Thesis}, Department of Statistics, University of Padova.

Agostinelli, C., (1998) Verosimiglianza pesata nel modello di regressione lineare,  \emph{ XXXIX Riunione scientifica della Societ\`a Italiana di Statistica}, Sorrento 1998.

}

\author{Claudio Agostinelli}

%\note{}

\seealso{\code{\link{wle.cp}} a function to calculate the Weighted Mallows Cp, \code{\link{wle.lm}} a function for estimating linear models with normal distribution error and normal kernel.}

\examples{
library(wle)
x.data <- c(runif(60,20,80),runif(5,73,78))
e.data <- rnorm(65,0,0.6)
y.data <- 8*log(x.data+1)+e.data
y.data[61:65] <- y.data[61:65]-4
z.data <- c(rep(0,60),rep(1,5))
plot(x.data, y.data, xlab="X", ylab="Y")
xx.data <- cbind(x.data, x.data^2, x.data^3, log(x.data+1))
result <- wle.cp(y.data~xx.data)
plot(result,num.max=15)
}

\keyword{regression}
\keyword{robust}



\eof
\name{plot.wle.lm}
\title{Plots for the Linear Model}
\usage{
\method{plot}{wle.lm}(x, roots, which=1:4, which.main, level.weight=0.5, 
   ask = dev.interactive(), col=c(2, 1, 3), id.n=3, labels.id, cex.id = 0.75, verbose=FALSE, ...)
}
\alias{plot.wle.lm}

\arguments{
 \item{x}{an object of class \code{wle.lm}.}
 \item{roots}{a vector specify for which roots the plots are required.}
 \item{which}{if a subset of the plots for each root is required, specify a subset of the numbers \code{0:4}, 0 means no plots.}
 \item{which.main}{if a subset of the plots for the main graphic is
   required, specify a subset of the numbers \code{0:roots^2}, 0 means
   no plots. The plots are specified by columns.}
 \item{level.weight}{value of the weight under which an observations is marked with different color.}
 \item{ask}{logical; if \code{TRUE}, the user is \emph{ask}ed before each plot, see \code{\link{par}(ask=.)}.}
 \item{col}{a vector of 3 elements, to specify colors for the plots.}
 \item{id.n}{number of points to be labelled in some plots, starting
    with the ones with less weight.}
 \item{labels.id}{vector of labels, from which the labels for less weighted
    points will be chosen. If missing uses observation numbers.}
 \item{cex.id}{magnification of point labels.}
 \item{verbose}{if \code{TRUE} warnings are printed.}
 \item{...}{graphical parameters can be given as arguments.}
}
\description{The \code{plot.wle.lm} function plots a separate graph
  windows for each root. In each windows four plots are printed:
  residuals vs fitted, normal qq plot of the residuals, weighted
  residuals vs weighted fitted, normal qq plot of the weighted
  residuals. A summary plot is also printed: in the diagonal, the value
  of the weigths vs position of the observations for each root; in the
  upper diagonal residuals vs residuals of two different roots; in the
  lower diagonal weights vs weights of two different roots. The roots
  and the graphs can be chosen by the arguments \code{roots},
  \code{which.main} and \code{which}.}

\author{Claudio Agostinelli}

\seealso{\code{\link{wle.lm}} a function for estimating linear models with normal distribution error and normal kernel.}

\examples{
library(wle)

data(artificial)

result <- wle.lm(y~x1+x2+x3, data=artificial, boot=40, group=6, num.sol=2)

result

plot.wle.lm(result) # all plots, default behavior 

plot.wle.lm(result, roots=1) # only first root, one plot for window 

par(mfcol=c(2,2))
plot.wle.lm(result, roots=1) # only first root, as usual

plot.wle.lm(result, roots=2, which=1, which.main=0)
# only second root, only residual vs fitted values plot

plot.wle.lm(result, which=1)
# main plot + residual vs fitted values plot for each root

par(mfcol=c(3,2))
plot.wle.lm(result, which=1)
# main plot + residual vs fitted values plot for each root all in the same window


}

\keyword{regression}
\keyword{robust}


\eof
\name{selection}
\alias{selection}
\alias{xdata}
\alias{ydata}
\title{Selection's Data}
\usage{
data(selection)
}
\description{
  This data set consists of 60 observations for two variables (ydata and xdata). The appropriate regression model for the first fiftyfourth obsertvations should be like
\eqn{y = x^2 + e}
the last sixth comes from a different model.
}

\format{
\code{xdata} is a vector which contains \eqn{x,x^2}, while \emph{ydata} contains the dependent variable's observations. 
}
\source{
  Agostinelli, C. (1999) 
  Robust model selection in regression via weighted likelihood methodology, submitted to \emph{Statistics & Probability Letters}, revised december 1999. 
}

%\seealso{}
%\examples{}
 
\keyword{datasets}

\eof
\name{wle.aic}
\title{Weighted Akaike Information Criterion}
\usage{
wle.aic(formula, data=list(), model=TRUE, x=FALSE, 
        y=FALSE, boot=30, group, var.full=0, num.sol=1, 
        raf="HD", smooth=0.031, tol=10^(-6), 
        equal=10^(-3), max.iter=500, min.weight=0.5, 
        method="full", alpha=2, contrasts=NULL, verbose=FALSE)
}
\alias{wle.aic}
\arguments{
  \item{formula}{a symbolic description of the model to be fit.
    The details of model specification are given below.}

  \item{data}{an optional data frame containing the variables
    in the model.  By default the variables are taken from
    the environment which \code{wle.aic} is called from.}

  \item{model, x, y}{logicals.  If \code{TRUE} the corresponding components of the fit (the model frame, the model matrix, the
    response.)}

  \item{boot}{the number of starting points based on boostrap subsamples to use in the search of the roots.}
  
  \item{group}{the dimension of the bootstap subsamples. The default value is \eqn{max(round(size/4),var)} where \eqn{size} is the number of observations and \eqn{var} is the number of variables.}

  \item{var.full}{the value of variance to be used in the denominator of the WAIC, if 0 the variance estimated from the full model is used.}
  \item{num.sol}{maximum number of roots to be searched.}

  \item{raf}{type of Residual adjustment function to be use:

\code{raf="HD"}: Hellinger Distance RAF,

\code{raf="NED"}: Negative Exponential Disparity RAF,

\code{raf="SCHI2"}: Symmetric Chi-Squared Disparity RAF.}

  \item{smooth}{the value of the smoothing parameter.}

  \item{tol}{the absolute accuracy to be used to achieve convergence of the algorithm.}

  \item{equal}{the absolute value for which two roots are considered the same. (This parameter must be greater than \code{tol}).}

  \item{max.iter}{maximum number of iterations.}

  \item{min.weight}{see details.}

  \item{method}{see details.}

  \item{alpha}{penalty value.}

  \item{contrasts}{an optional list. See the \code{contrasts.arg}
    of \code{model.matrix.default}.}

  \item{verbose}{if \code{TRUE} warnings are printed.}

}

\description{The Weighted Akaike Information Criterion.}

\details{
Models for \code{wle.aic} are specified symbolically.  A typical model has the form \code{response ~ terms} where \code{response} is the (numeric) response vector and \code{terms} is a series of terms which specifies a linear predictor for \code{response}.  A terms specification of the form \code{first+second} indicates all the terms in \code{first} together with all the terms in \code{second} with duplicates removed. A specification of the form \code{first:second} indicates the the set of terms obtained by taking the interactions of all terms in \code{first} with all terms in \code{second}. The specification \code{first*second} indicates the \emph{cross} of \code{first} and \code{second}.  This is the same as \code{first+second+first:second}.

\code{min.weight}: the weighted likelihood equation could have more than one solution. These roots appear for particular situation depending on contamination level and type. The presence of multiple roots in the full model can create some problem in the set of weights we should use. Actually, the selection of the root is done by the minimum scale error provided. Since this choice is not always the one would choose, we introduce the \code{min.weight} parameter in order to choose only between roots that do not down weight everything. This is not still the optimal solution, and perhaps, in the new release, this part will be change. 

\code{method}: this parameter, when set to "reduced",  allows to use
weights based on the reduced model. This is strongly discourage since
the robust and asymptotic property of this kind of weighted AIC are not
as good as the one based on \code{method="full"}.
}

\value{
\code{wle.aic} returns an object of \code{\link{class}} \code{"wle.aic"}.

  The function \code{summary} is used to obtain and print a summary of the results.
  The generic accessor functions \code{coefficients} and \code{residuals} extract coefficients and residuals returned by \code{wle.aic}.
  The object returned by \code{wle.aic} are:

\item{waic}{Weighted Akaike Information Criterion for each submodels}
\item{coefficients}{the parameters estimator, one row vector for each root found and each submodel.}
\item{scale}{an estimation of the error scale, one value for each root found and each submodel.}
\item{residuals}{the unweighted residuals from the estimated model, one column vector for each root found and each submodel.}
\item{tot.weights}{the sum of the weights divide by the number of observations, one value for each root found and each submodel.}
\item{weights}{the weights associated to each observation, one column vector for each root found and each submodel.}
\item{freq}{the number of starting points converging to the roots.}
\item{call}{the match.call().}
\item{contrasts}{}
\item{xlevels}{}
\item{terms}{the model frame.}
\item{model}{if \code{model=TRUE} a matrix with first column the dependent variable and the remain column the explanatory variables for the full model.}
\item{x}{if \code{x=TRUE} a matrix with the explanatory variables for the full model.}
\item{y}{if \code{y=TRUE} a vector with the dependent variable.}
\item{info}{not well working yet, if 0 no error occurred.}
}
\references{

Agostinelli, C., (1999) Robust model selection in regression via weighted likelihood methodology, \emph{Working Paper n. 1999.4}, Department of Statistics, Universiy of Padova.

Agostinelli, C., (1999) Robust model selection in regression via weighted likelihood methodology, submitted to \emph{Statistics \& Probability Letters}, revised december 1999.

Agostinelli, C., (1998) Inferenza statistica robusta basata sulla funzione di verosimiglianza pesata: alcuni sviluppi, \emph{Ph.D Thesis}, Department of Statistics, University of Padova.

Agostinelli, C., Markatou, M., (1998) A one-step robust estimator for regression based on the weighted likelihood reweighting scheme, \emph{Statistics \& Probability Letters}, Vol. 37, n. 4, 341-350.

Agostinelli, C., (1998) Verosimiglianza pesata nel modello di regressione lineare,  \emph{XXXIX Riunione scientifica della Societa' Italiana di Statistica}, Sorrento 1998.
}

\author{Claudio Agostinelli}

\examples{
library(wle)

x.data <- c(runif(60,20,80),runif(5,73,78))
e.data <- rnorm(65,0,0.6)
y.data <- 8*log(x.data+1)+e.data
y.data[61:65] <- y.data[61:65]-4
z.data <- c(rep(0,60),rep(1,5))

plot(x.data,y.data,xlab="X",ylab="Y")

xx.data <- cbind(x.data,x.data^2,x.data^3,log(x.data+1))
colnames(xx.data) <- c("X","X^2","X^3","log(X+1)")

result <- wle.aic(y.data~xx.data,boot=10,group=10,num.sol=2)

summary(result)

result <- wle.aic(y.data~xx.data+z.data,boot=10,group=10,num.sol=2)

summary(result)

}

\keyword{regression}
\keyword{robust}


\eof
\name{wle.aic.summaries}
\title{Summaries and methods for wle.aic}
\usage{
\method{summary}{wle.aic}(object, num.max=20, verbose=FALSE, ...)

\method{print}{wle.aic}(x, digits = max(3, getOption("digits") - 3),
num.max=max(1, nrow(x$waic)), ...)

\method{print}{summary.wle.aic}(x, digits = max(3, getOption("digits") - 3), ...)
}

\alias{summary.wle.aic}
\alias{print.wle.aic}
\alias{print.summary.wle.aic}

\arguments{
 \item{object}{an object of class \code{wle.aic}.}
 \item{x}{an object of class \code{wle.aic} or \code{summary.wle.aic}.}
 \item{digits}{number of digits to be used for most numbers.}
 \item{num.max}{the max number of models should be reported.}
 \item{verbose}{if \code{TRUE} warnings are printed.}
 \item{...}{additional arguments affecting the summary produced (in
   \code{summary.wle.aic}) or further arguments passed to or from other methods
   (in \code{print.wle.aic} and \code{print.summary.wle.aic}).}
}

\description{All these functions are \code{\link{methods}} for class \code{wle.aic} or \code{summary.wle.aic}.}

\value{
\code{summary.wle.aic} returns a list:

 \item{waic}{the first \code{num.max} best models with their Weighted Akaike Information Criterion.}
 \item{num.max}{the number of models reported.}
 \item{call}{}
}

\author{Claudio Agostinelli}

\seealso{\code{\link{wle.aic}} a function for evaluate the Weighted Akaike Information Criterion in the linear models.}

%\examples{}

\keyword{regression}
\keyword{robust}

\eof
\name{wle.ar}
\alias{wle.ar}
\alias{wle.ar.ao}
\alias{wle.ar.start}
\alias{wle.ar.step}
\alias{wle.ar.matrix}

\title{Fit Autoregressive Models to Time Series - Preliminary Version}

\description{This is a preliminary version of functions for the estimation of the autoregressive parameters via Weighted Likelihood Estimating Equations and a cassification algorithm. The main function is \code{wle.ar}, the remain functions are for internal use and they should not call by the users. They are not documented here.}

\usage{
wle.ar(x, order=c(1, 0), seasonal=list(order = c(0, 0), 
       period = NA), group, group.start, group.step=group.start, 
       xreg=NULL, include.mean=TRUE, na.action=na.fail, 
       tol=10^(-6), tol.step=tol, equal=10^(-3), equal.step=equal,
       raf="HD", smooth=0.0031, smooth.ao=smooth, boot=10, 
       boot.start=10, boot.step=boot.start, num.sol=1, x.init=0, 
       x.seasonal.init=0, max.iter.out=20, max.iter.in=50, 
       max.iter.start=200, max.iter.step=500, verbose=FALSE, 
       w.level=0.4, min.weights=0.5, population.size=10, 
       population.choose=5, elements.random=2, wle.start=FALSE, 
       init.values=NULL, num.max=NULL, num.sol.step=2, approx.w=TRUE)
}

\arguments{
  \item{x}{a univariate time series.}
  \item{order}{a specification of the non-seasonal part of the ARI model: the two components \code{(p,d)} are the AR order and the degree of differencing.}
  \item{seasonal}{a specification of the seasonal part of the ARI model, plus the period (which defaults to \code{frequency(x)}).}
  \item{group}{the dimension of the bootstap subsamples.}
  \item{group.start}{the dimension of the bootstap subsamples used in the starting process if \code{wle.init=TRUE}.}
  \item{group.step}{the dimension of the bootstap subsamples used in a step, it must be less than \code{group}.}
  \item{xreg}{optionally, a vector or matrix of external regressors, which must have the same number of rows as \code{x}.}
  \item{include.mean}{Should the ARI model include a mean term? The
default is \code{TRUE} for undifferenced series, \code{FALSE} for differenced ones (where a mean would not affect the fit nor predictions).}
  \item{na.action}{function to be applied to remove missing values.}
  \item{tol}{the absolute accuracy to be used to achieve convergence of the algorithm.}
  \item{tol.step}{the absolute accuracy to be used to achieve convergence in a step.}
  \item{equal}{the absolute value for which two roots are considered the same. (This parameter must be greater than \code{tol}).}
  \item{equal.step}{the absolute value for which two roots are considered the same in a step. (This parameter must be greater than \code{tol.step}).}
  \item{raf}{type of Residual adjustment function to be use:
      \code{raf="HD"}: Hellinger Distance RAF,
      \code{raf="NED"}: Negative Exponential Disparity RAF,
      \code{raf="SCHI2"}: Symmetric Chi-Squared Disparity RAF.}
  \item{smooth}{the value of the smoothing parameter.}
  \item{smooth.ao}{the value of the smoothing parameter used in the outliers classificaton, default equal to \code{smooth}.}
  \item{boot}{the number of starting points based on boostrap subsamples to use in the search of the roots.}
  \item{boot.start}{the number of starting points based on boostrap subsamples to use in the search of the roots in the starting process.}
  \item{boot.step}{the number of starting points based on boostrap subsamples to use in the search of the roots in a step.}
  \item{num.sol}{maximum number of roots to be searched.}
  \item{num.sol.step}{maximum number of roots to be searched in a step.}
  \item{x.init}{initial values, a vector with the same length of the AR order, or a number, default is 0.}
  \item{x.seasonal.init}{initial values, a vector with the same length of the SAR order, or a number, default is 0.}
  \item{max.iter.out}{maximum number of iterations in the outer loop.}
  \item{max.iter.in}{maximum number of iterations in the inner loop.}
  \item{max.iter.start}{maximum number of iterations in the starting process.}
  \item{max.iter.step}{maximum number of iterations in a step.}
  \item{w.level}{the threshold used to decide if an observation could be an additive outlier.}
  \item{population.size}{see details.}
  \item{population.choose}{see details.}
  \item{elements.random}{see details.}
  \item{num.max}{maximum number of observations can be considered as possible additive outliers.}
  \item{wle.start}{if \code{TRUE} a weighted likelihood estimation is used to have a starting value.}
  \item{init.values}{a vector with initial values for the AR and seasonal AR coefficients and the innovations variance.}
  \item{verbose}{if \code{TRUE} warnings are printed.}
  \item{min.weights}{see details.}
  \item{approx.w}{logical: if \code{TRUE} an approximation is used to
    evaluate the weights in the outlier identification procedure.}
}

\details{
\code{min.weight}: the weighted likelihood equation could have more than one solution. These roots appear for particular situation depending on contamination level and type. We introduce the \code{min.weight} parameter in order to choose only between roots that do not down weight everything. This is not still the optimal solution, and perhaps, in the new release, this part will be change. 

The algorithm used to classify the observations as additive outliers is made by a genetic algorithm. The \code{population.size}, \code{population.choose} and \code{elements.random} are parameters related to this algorithm.
}


\value{

    \item{coef}{a vector of AR and regression coefficients.}
    \item{sigma2.coef}{the estimated variance matrix of the coefficients coef.}
    \item{sigma2}{the WLE of the innovations variance.}
    \item{arma}{a compact form of the specification, as a vector giving the number of AR, MA=0, seasonal AR and seasonal MA=0 coefficients, plus the period and the number of non-seasonal and seasonal differences.}
    \item{resid}{the residuals.}
    \item{resid.with.ao}{the residuals with the additive outliers effects.}
    \item{resid.without.ao}{the residuals without the additive outliers effects.}
    \item{x.ao}{the time series without the additive outliers effects.}
    \item{call}{the matched call.}
    \item{series}{the name of the series \code{x}.}
    \item{weights}{the weights.}
    \item{weights.with.ao}{the weights with the additive outliers effects.}
    \item{weights.without.ao}{the weights without the additive outliers effects}
    \item{tot.sol}{the number of solutions found.}
    \item{not.conv}{the number of starting points that does not converge after the \code{max.iter.out} iteration are reached.}
    \item{ao.position}{the position of the additive outliers.}
}

\references{
Agostinelli C., (2001) Robust time series estimation via weighted likelihood: some preliminary results, \emph{Working Paper n. 2001.3} Department of Statistics, University of Padova.

Agostinelli C., (2002) Robust time series estimation via weighted likelihood: some preliminary results, presented at ICORS2001, poster session, (July 23-27 2001), Vorau, Austria, in press.
}

\author{Claudio Agostinelli}

\examples{
library(wle)
library(ts)
data(lh)
wle.ar(x=lh, order=c(3,0), group=30) 
}
\keyword{robust}
\keyword{ts}

\eof
\name{wle.binomial}
\title{Robust Estimation in the Binomial Model}
\usage{
wle.binomial(x, size, boot=30, group, num.sol=1, raf="HD", 
             tol=10^(-6), equal=10^(-3), max.iter=500,
             verbose=FALSE)
}
\alias{wle.binomial}
\alias{print.wle.binomial}

\arguments{
  \item{x}{a vector contain the number of success in each \code{size} trials.}

  \item{size}{number of trials.}

  \item{boot}{the number of starting points based on boostrap subsamples to use in the search of the roots.}

  \item{group}{the dimension of the bootstap subsamples. The default value is \eqn{max(round(length(x)/4),2)}.}

  \item{num.sol}{maximum number of roots to be searched.}

  \item{raf}{type of Residual adjustment function to be use:

\code{raf="HD"}: Hellinger Distance RAF,

\code{raf="NED"}: Negative Exponential Disparity RAF,

\code{raf="SCHI2"}: Symmetric Chi-Squared Disparity RAF.}

  \item{tol}{the absolute accuracy to be used to achieve convergence of the algorithm.}

  \item{equal}{the absolute value for which two roots are considered the same. (This parameter must be greater than \code{tol}).}

  \item{max.iter}{maximum number of iterations.}

  \item{verbose}{if \code{TRUE} warnings are printed.}
}
\description{
\code{wle.binomial} is used to robust estimate the proportion parameters via Weighted Likelihood.
}

\value{

\code{wle.binomial} returns an object of \code{\link{class}} \code{"wle.binomial"}.

  Only print method is implemented for this class.

  The object returned by \code{wle.binomial} are:

\item{p}{the estimator of the proportion parameter, one value for each root found.}
\item{tot.weights}{the sum of the weights divide by the number of observations, one value for each root found.}
\item{weights}{the weights associated to each observation, one column vector for each root found.}
\item{f.density}{the non-parametric density estimation.}
\item{m.density}{the smoothed model.}
\item{delta}{the Pearson residuals.}
\item{call}{the match.call().}
\item{tot.sol}{the number of solutions found.}
\item{not.conv}{the number of starting points that does not converge after the \code{max.iter} iteration are reached.}

}

\author{Claudio Agostinelli}

%\seealso{}

\references{
Markatou, M., Basu, A., and Lindsay, B.G., (1997) Weighted likelihood estimating equations: The discrete case with applications to logistic regression, \emph{Journal of Statistical Planning and Inference}, 57, 215-232.

Agostinelli, C., (1998) Inferenza statistica robusta basata sulla funzione di verosimiglianza pesata: alcuni sviluppi, \emph{Ph.D Thesis}, Department of Statistics, University of Padova.}
}

\examples{
library(wle)

set.seed(1234)

x <- rbinom(20,p=0.2,size=10)
wle.binomial(x,size=10)

x <- c(rbinom(20,p=0.2,size=10),rbinom(10,p=0.9,size=10))
wle.binomial(x,size=10)

}

\keyword{models}
\keyword{robust}
 


\eof
\name{wle.cp}
\title{Weighted Mallows Cp}

\usage{
wle.cp(formula, data=list(), model=TRUE, x=FALSE, 
       y=FALSE, boot=30, group, var.full=0, num.sol=1, 
       raf="HD", smooth=0.031, tol=10^(-6), 
       equal=10^(-3), max.iter=500, min.weight=0.5, 
       method="full", alpha=2, contrasts=NULL, verbose=FALSE)
}
\alias{wle.cp}
\arguments{
  \item{formula}{a symbolic description of the model to be fit.
    The details of model specification are given below.}

  \item{data}{an optional data frame containing the variables
    in the model.  By default the variables are taken from
    the environment which \code{wle.cp} is called from.}

  \item{model, x, y}{logicals.  If \code{TRUE} the corresponding components of the fit (the model frame, the model matrix, the
    response.)}

  \item{boot}{the number of starting points based on boostrap subsamples to use in the search of the roots.}
  
  \item{group}{the dimension of the bootstap subsamples. The default value is \eqn{max(round(size/4),var)} where \eqn{size} is the number of observations and \eqn{var} is the number of variables.}

  \item{var.full}{the value of variance to be used in the denominator of the WCP, if 0 the variance estimated from the full model is used.}

  \item{num.sol}{maximum number of roots to be searched.}

  \item{raf}{type of Residual adjustment function to be use:

\code{raf="HD"}: Hellinger Distance RAF,

\code{raf="NED"}: Negative Exponential Disparity RAF,

\code{raf="SCHI2"}: Symmetric Chi-Squared Disparity RAF.}

  \item{smooth}{the value of the smoothing parameter.}

  \item{tol}{the absolute accuracy to be used to achieve convergence of the algorithm.}c

  \item{equal}{the absolute value for which two roots are considered the same. (This parameter must be greater than \code{tol}).}

  \item{max.iter}{maximum number of iterations.}

  \item{min.weight}{see details.}

  \item{method}{see details.}

  \item{alpha}{penalty value.}

  \item{contrasts}{an optional list. See the \code{contrasts.arg}
    of \code{model.matrix.default}.}

  \item{verbose}{if TRUE warnings are printed.}
}

\description{The Weighted Mallows Cp is evaluated for each submodel.}

\details{
Models for \code{wle.cp} are specified symbolically.  A typical model has the form \code{response ~ terms} where \code{response} is the (numeric) response vector and \code{terms} is a series of terms which specifies a linear predictor for \code{response}.  A terms specification of the form \code{first+second} indicates all the terms in \code{first} together with all the terms in \code{second} with duplicates removed. A specification of the form \code{first:second} indicates the the set of terms obtained by taking the interactions of all terms in \code{first} with all terms in \code{second}. The specification \code{first*second} indicates the \emph{cross} of \code{first} and \code{second}.  This is the same as \code{first+second+first:second}.

\code{min.weight}: the weighted likelihood equation could have more than one solution. These roots appear for particular situation depending on contamination level and type. The presence of multiple roots in the full model can create some problem in the set of weights we should use. Actually, the selection of the root is done by the minimum scale error provided. Since this choice is not always the one would choose, we introduce the \code{min.weight} parameter in order to choose only between roots that do not down weight everything. This is not still the optimal solution, and perhaps, in the new release, this part will be change. 

\code{method}: this parameter, when set to \code{"reduced"},  allows to use weights based on the reduced model. This is strongly discourage since the robust and asymptotic property of this kind of weighted Cp are not as good as the one based on \code{method="full"}.}

\value{

\code{wle.cp} returns an object of \code{\link{class}} \code{"wle.cp"}.

  The function \code{summary} is used to obtain and print a summary of the results.
  The generic accessor functions \code{coefficients} and \code{residuals} extract coefficients and residuals returned by \code{wle.cp}.
  The object returned by \code{wle.cp} are:

\item{wcp}{Weighted Mallows Cp for each submodels}
\item{coefficients}{the parameters estimator, one row vector for each root found and each submodel.}
\item{scale}{an estimation of the error scale, one value for each root found and each submodel.}
\item{residuals}{the unweighted residuals from the estimated model, one column vector for each root found and each submodel.}
\item{tot.weights}{the sum of the weights divide by the number of observations, one value for each root found and each submodel.}
\item{weights}{the weights associated to each observation, one column vector for each root found and each submodel.}
\item{freq}{the number of starting points converging to the roots.}
\item{call}{the match.call().}
\item{contrasts}{}
\item{xlevels}{}
\item{terms}{the model frame.}
\item{model}{if \code{model=TRUE} a matrix with first column the dependent variable and the remain column the explanatory variables for the full model.}
\item{x}{if \code{x=TRUE} a matrix with the explanatory variables for the full model.}
\item{y}{if \code{y=TRUE} a vector with the dependent variable.}
\item{info}{not well working yet, if 0 no error occurred.}
}

\references{

Agostinelli, C., (1999). Robust model selection in regression via weighted likelihood methodology, \emph{ Working Paper n. 1999.4}, Department of Statistics, Universiy of Padova.

Agostinelli, C., (1999). Robust model selection in regression via weighted likelihood methodology, submitted to \emph{ Statistics \& Probability Letters}, revised december 1999.

Agostinelli, C., (1998). Inferenza statistica robusta basata sulla funzione di verosimiglianza pesata: alcuni sviluppi, \emph{ Ph.D Thesis}, Department of Statistics, University of Padova.

Agostinelli, C., Markatou, M., (1998). A one-step robust estimator for regression based on the weighted likelihood reweighting scheme, \emph{ Statistics \& Probability Letters}, Vol. 37, n. 4, 341-350.

Agostinelli, C., (1998). Verosimiglianza pesata nel modello di regressione lineare,  \emph{ XXXIX Riunione scientifica della Societ\`a Italiana di Statistica}, Sorrento 1998.

}

\author{Claudio Agostinelli}

\seealso{\link{wle.smooth} an algorithm to choose the smoothing parameter for normal distribution and normal kernel, \link{wle.lm} a function for estimating linear models with normal distribution error and normal kernel.}

\examples{
library(wle)

x.data <- c(runif(60,20,80),runif(5,73,78))
e.data <- rnorm(65,0,0.6)
y.data <- 8*log(x.data+1)+e.data
y.data[61:65] <- y.data[61:65]-4
z.data <- c(rep(0,60),rep(1,5))

plot(x.data,y.data,xlab="X",ylab="Y")

xx.data <- cbind(x.data,x.data^2,x.data^3,log(x.data+1))
colnames(xx.data) <- c("X","X^2","X^3","log(X+1)")

result <- wle.cp(y.data~xx.data,boot=10,group=10,num.sol=2)

summary(result)

plot(result,num.max=15)

result <- wle.cp(y.data~xx.data+z.data,boot=10,group=10,num.sol=2)

summary(result)

plot(result,num.max=15)
}

\keyword{regression}
\keyword{robust}







\eof
\name{wle.cp.summaries}
\title{Summaries and methods for wle.cp}
\usage{
\method{summary}{wle.cp}(object, num.max=20, verbose=FALSE, ...)

\method{print}{wle.cp}(x, digits = max(3, getOption("digits") - 3),
num.max=max(1, nrow(x$wcp)), ...)

\method{print}{summary.wle.cp}(x, digits = max(3, getOption("digits") - 3), ...)
}

\alias{summary.wle.cp}
\alias{print.wle.cp}
\alias{print.summary.wle.cp}

\arguments{
 \item{object}{an object of class \code{wle.cp}.}
 \item{x}{an object of class \code{wle.cp} or \code{summary.wle.cp}.}
 \item{digits}{number of digits to be used for most numbers.}
 \item{num.max}{the max number of models should be reported.}
 \item{verbose}{if \code{TRUE} warnings are printed.}
 \item{...}{additional arguments affecting the summary produced (in
   \code{summary.wle.cp}) or further arguments passed to or from other methods
   (in \code{print.wle.cp} and \code{print.summary.wle.cp}).}
}

\description{All these functions are \code{\link{methods}} for class \code{wle.cp} or \code{summary.wle.cp}.}

\value{
\code{summary.wle.cp} returns a list:

 \item{wcp}{the first \code{num.max} best models with their Weighted Mallows Cp.}
 \item{num.max}{the number of models reported.}
 \item{call}{}
}

\author{Claudio Agostinelli}

\seealso{\code{\link{wle.cp}} a function for evaluate the Weighted Mallows Cp in the linear models.}

%\examples{}

\keyword{regression}
\keyword{robust}


\eof
\name{wle.cv}
\title{ Model Selection by Weighted Cross-Validation }
\usage{
wle.cv(formula, data=list(), model=TRUE, x=FALSE, 
       y=FALSE, monte.carlo=500, split, boot=30, 
       group, num.sol=1, raf="HD", smooth=0.031, 
       tol=10^(-6), equal=10^(-3), max.iter=500, 
       min.weight=0.5, contrasts=NULL, verbose=FALSE)}
\alias{wle.cv}

\arguments{

  \item{formula}{a symbolic description of the model to be fit.
    The details of model specification are given below.}

  \item{data}{an optional data frame containing the variables
    in the model.  By default the variables are taken from
    the environment which \code{wle.cv} is called from.}

  \item{model, x, y}{logicals.  If \code{TRUE} the corresponding components of the fit (the model frame, the model matrix, the
    response.)}

  \item{monte.carlo}{the number of Monte Carlo replication we use to estimate the average prediction error.}

  \item{split}{the size of the costruction sample. When the suggested value is outside the possible range, the split size is let equal to \eqn{max(round(size^{(3/4)}),var+2)} where \eqn{size} is the number of observations and \eqn{var} is the number of variables.}

  \item{boot}{the number of starting points based on boostrap subsamples to use in the search of the roots.}
  
  \item{group}{the dimension of the bootstap subsamples. The default value is \eqn{max(round(size/4),var)} where \eqn{size} is the number of observations and \eqn{var} is the number of variables.}

  \item{num.sol}{maximum number of roots to be searched.}

  \item{raf}{type of Residual adjustment function to be use:

\code{raf="HD"}: Hellinger Distance RAF,

\code{raf="NED"}: Negative Exponential Disparity RAF,

\code{raf="SCHI2"}: Symmetric Chi-Squared Disparity RAF.}

  \item{smooth}{the value of the smoothing parameter.}

  \item{tol}{the absolute accuracy to be used to achieve convergence of the algorithm.}

  \item{equal}{the absolute value for which two roots are considered the same. (This parameter must be greater than \code{tol}).}

  \item{max.iter}{maximum number of iterations.}

  \item{min.weight}{see details.}

  \item{contrasts}{an optional list. See the \code{contrasts.arg}
    of \code{model.matrix.default}.}

  \item{verbose}{if \code{TRUE} warnings are printed.}
}

\description{ The Weighted Cross-Validation methods is used to choose
  the best linear model.}

\details{
Models for \code{wle.cv} are specified symbolically.  A typical model has the form \code{response ~ terms} where \code{response} is the (numeric) response vector and \code{terms} is a series of terms which specifies a linear predictor for \code{response}.  A terms specification of the form \code{first+second} indicates all the terms in \code{first} together with all the terms in \code{second} with duplicates removed. A specification of the form \code{first:second} indicates the the set of terms obtained by taking the interactions of all terms in \code{first} with all terms in \code{second}. The specification \code{first*second} indicates the \emph{cross} of \code{first} and \code{second}.  This is the same as \code{first+second+first:second}.

\code{min.weight}: the weighted likelihood equation could have more than one solution. These roots appear for particular situation depending on contamination level and type. The presence of multiple roots in the full model can create some problem in the set of weights we should use. Actually, the selection of the root is done by the minimum scale error provided. Since this choice is not always the one would choose, we introduce the \code{min.weight} parameter in order to choose only between roots that do not down weight everything. This is not still the optimal solution, and perhaps, in the new release, this part will be change.}

\value{

\code{wle.cv} returns an object of \code{\link{class}} \code{"wle.cv"}.

  The function \code{summary} is used to obtain and print a summary of the results.
  The generic accessor functions \code{coefficients} and \code{residuals} extract coefficients and residuals returned by \code{wle.cv}.
  The object returned by \code{wle.cv} are:

\item{wcv}{Weighted Cross-Validation for each submodels}
\item{coefficients}{the parameters estimator, one row vector for each root found in the full model.}
\item{scale}{an estimation of the error scale, one value for each root found in the full model.}
\item{residuals}{the unweighted residuals from the estimated model, one column vector for each root found in the full model.}
\item{tot.weights}{the sum of the weights divide by the number of observations, one value for each root found in the full model.}
\item{weights}{the weights associated to each observation, one column vector for each root found in the full model.}
\item{freq}{the number of starting points converging to the roots.}
\item{index}{position of the root used for the weights.}
\item{call}{the match.call().}
\item{contrasts}{ }
\item{xlevels}{ }
\item{terms}{the model frame.}
\item{model}{if \code{model=TRUE} a matrix with first column the dependent variable and the remain column the explanatory variables for the full model.}
\item{x}{if \code{x=TRUE} a matrix with the explanatory variables for the full model.}
\item{y}{if \code{y=TRUE} a vector with the dependent variable.}
\item{info}{not well working yet, if 0 no error occurred.}
}


\references{
Agostinelli, C., (1999). Robust model selection by Cross-Validation via weighted likelihood methodology, \emph{Working Paper n. 1999.37}, Department of Statistics, University of Padova.

Agostinelli, C., (1998). Inferenza statistica robusta basata sulla funzione di verosimiglianza pesata: alcuni sviluppi, \emph{ Ph.D Thesis}, Department of Statistics, University of Padova.

Agostinelli, C., Markatou, M., (1998). A one-step robust estimator for regression based on the weighted likelihood reweighting scheme, \emph{ Statistics \& Probability Letters}, Vol. 37, n. 4, 341-350.

Agostinelli, C., (1998). Verosimiglianza pesata nel modello di regressione lineare,  \emph{ XXXIX Riunione scientifica della Societ\`a Italiana di Statistica}, Sorrento 1998.
}

\author{Claudio Agostinelli}

\seealso{\link{wle.smooth} an algorithm to choose the smoothing parameter for normal distribution and normal kernel, \link{wle.lm} a function for estimating linear models with normal distribution error and normal kernel.}

\examples{
library(wle)

set.seed(1234)

x.data <- c(runif(60,20,80),runif(5,73,78))
e.data <- rnorm(65,0,0.6)
y.data <- 8*log(x.data+1)+e.data
y.data[61:65] <- y.data[61:65]-4
z.data <- c(rep(0,60),rep(1,5))

plot(x.data,y.data,xlab="X",ylab="Y")

xx.data <- cbind(x.data,x.data^2,x.data^3,log(x.data+1))
colnames(xx.data) <- c("X","X^2","X^3","log(X+1)")

result <- wle.cv(y.data~xx.data,boot=20,num.sol=2)

summary(result)

result <- wle.cv(y.data~xx.data+z.data,boot=20,num.sol=2,
              monte.carlo=1000,split=50)

summary(result)

}

\keyword{regression}
\keyword{robust}





\eof
\name{wle.cv.summaries}
\title{Summaries and methods for wle.cv}
\usage{
\method{summary}{wle.cv}(object, num.max=20, verbose=FALSE, ...)

\method{print}{wle.cv}(x, digits = max(3, getOption("digits") - 3),
num.max=max(1, nrow(x$wcv)), ...)

\method{print}{summary.wle.cv}(x, digits = max(3, getOption("digits") - 3), ...)
}

\alias{summary.wle.cv}
\alias{print.wle.cv}
\alias{print.summary.wle.cv}

\arguments{
 \item{object}{an object of class \code{wle.cv}.}
 \item{x}{an object of class \code{wle.cv} or \code{summary.wle.cv}.}
 \item{digits}{number of digits to be used for most numbers.}
 \item{num.max}{the max number of models should be reported.}
 \item{verbose}{if \code{TRUE} warnings are printed.}
 \item{...}{additional arguments affecting the summary produced (in
   \code{summary.wle.cv}) or further arguments passed to or from other methods
   (in \code{print.wle.cv} and \code{print.summary.wle.cv}).}
}

\description{All these functions are \code{\link{methods}} for class \code{wle.cv} or \code{summary.wle.cv}.}

\value{
\code{summary.wle.cv} returns a list:

 \item{wcv}{the first \code{num.max} best models with their estimated prediction error using WCV.}
 \item{num.max}{the number of models reported.}
 \item{call}{}
}

\author{Claudio Agostinelli}

\seealso{\code{\link{wle.cv}} a function for evaluate the Weighted Cross Validation criterion in the linear models.}

%\examples{}

\keyword{regression}
\keyword{robust}


\eof
\name{wle.fracdiff}
\alias{wle.fracdiff}
\alias{wle.fracdiff.ao}
\alias{wle.fracdiff.fitted}
\alias{wle.fracdiff.sigma2}
\alias{wle.fracdiff.residuals}
\alias{wle.fracdiff.equation}
\alias{wle.fracdiff.solve} 
\alias{wle.fracdiff.pi.coef}
\alias{wle.fracdiff.xi.coef}
 
\title{Fit Fractional Models to Time Series - Preliminary Version}
\description{This is a preliminary version of functions for the estimation of the fractional parameter via Weighted Likelihood Estimating Equations and a cassification algorithm. The main function is \code{wle.fracdiff}, the remain functions are for internal use and they should not call by the users. They are not documented here.

}

\usage{wle.fracdiff(x, lower, upper, M, group, na.action = na.fail, tol = 10^(-6), equal = 10^(-3), raf = "HD", smooth = 0.0031, smooth.ao = smooth, boot = 10, num.sol = 1, x.init = rep(0, M), use.uniroot = FALSE, use.init = FALSE, max.iter.out = 20, max.iter.in = 100, max.iter.step = 5000, max.iter.start = max.iter.step, verbose = FALSE, w.level = 0.4, min.weights = 0.5, population.size = 10, population.choose = 5, elements.random = 2, init.values = NULL, num.max = length(x), include.mean = FALSE, ao.list = list(0))}

\arguments{
  \item{x}{a univariate time series.}
  \item{lower}{the lower end point of the interval to be searched.}
  \item{upper}{the upper end point of the interval to be searched.}
  \item{M}{the order of the finite memory process used to estimate the d parameter.}
  \item{group}{the dimension of the bootstap subsamples.}
  \item{na.action}{function to be applied to remove missing values.}
  \item{tol}{the absolute accuracy to be used to achieve convergence of the algorithm.}
  \item{equal}{the absolute value for which two roots are considered the same. (This parameter must be greater than \code{tol}).}
  \item{raf}{type of Residual adjustment function to be use:
      \code{raf="HD"}: Hellinger Distance RAF,
      \code{raf="NED"}: Negative Exponential Disparity RAF,
      \code{raf="SCHI2"}: Symmetric Chi-Squared Disparity RAF.}
  \item{smooth}{the value of the smoothing parameter.}
  \item{smooth.ao}{the value of the smoothing parameter used in the outliers classificaton, default equal to \code{smooth}.}
  \item{boot}{the number of starting points based on boostrap subsamples to use in the search of the roots.}
  \item{num.sol}{maximum number of roots to be searched.}
  \item{x.init}{initial values, a vector with the same length of the \code{M} parameter, or a number, default is 0.}
  \item{use.uniroot}{default: \code{FALSE}, if \code{TRUE} in each step the weighted likelihood estimating equations is solved, otherwise, a maximization is performed on a weighted log-likelihood function with fixed weights. The estimators obtain with the two methods is the same.}
  \item{use.init}{default: \code{FALSE}, if \code{FALSE} the function do not use the \code{x.init} values and evaluated the conditional weighted likelihood estimating equation estimator.}
  \item{max.iter.out}{maximum number of iterations in the outer loop.}
  \item{max.iter.in}{maximum number of iterations in the inner loop.}
  \item{max.iter.step}{maximum number of iterations in a step.}
  \item{max.iter.start}{maximum number of iterations in the starting process.}
  \item{verbose}{if \code{TRUE} warnings are printed.}
  \item{w.level}{the threshold used to decide if an observation could be an additive outlier.}
  \item{min.weights}{see details.}
  \item{population.size}{see details.}
  \item{population.choose}{see details.}
  \item{elements.random}{see details.}
  \item{init.values}{a vector with initial values for the d and the innovations variance.}
  \item{num.max}{maximum number of observations can be considered as possible additive outliers.}
  \item{include.mean}{Should the model include a mean term? The default is \code{TRUE}.}
  \item{ao.list}{possible list of pattern of additive outliers.}
}

\details{
\code{min.weight}: the weighted likelihood equation could have more than one solution. These roots appear for particular situation depending on contamination level and type. We introduce the \code{min.weight} parameter in order to choose only between roots that do not down weight everything. This is not still the optimal solution, and perhaps, in the new release, this part will be change. 

The algorithm used to classify the observations as additive outliers is made by a genetic algorithm. The \code{population.size}, \code{population.choose} and \code{elements.random} are parameters related to this algorithm.
}

\value{
   \item{d}{the WLE of the fractional parameter.}
    \item{sigma2}{the WLE of the innovations variance.}
    \item{x.mean}{the WLE of the mean.}
    \item{resid}{the residuals.}
    \item{resid.without.ao}{the residuals with the additive outliers effects.}
    \item{resid.with.ao}{the residuals without the additive outliers effects.}
    \item{x.ao}{the time series without the additive outliers effects.}
    \item{call}{the matched call.}
    \item{weights}{the weights.}
    \item{weights.with.ao}{the weights with the additive outliers effects.}
    \item{weights.without.ao}{the weights without the additive outliers effects}
    \item{tot.sol}{the number of solutions found.}
    \item{not.conv}{the number of starting points that does not converge after the \code{max.iter.out} iteration are reached.}
    \item{ao.position}{the position of the additive outliers.}
}

\references{Agostinelli C., Bisaglia L., (2002) Robust estimation of ARFIMA processes, manuscript.}
\author{Claudio Agostinelli}

\keyword{robust}
\keyword{ts}

\eof
\name{wle.gamma}
\title{Robust Estimation in the Gamma model}
\usage{
wle.gamma(x, boot=30, group, num.sol=1, raf="HD", smooth=0.008,
          tol=10^(-6), equal=10^(-3), max.iter=500,
          shape.int=c(0.01, 100), use.smooth=TRUE, tol.int,
          verbose=FALSE, maxiter=1000)
}
\alias{wle.gamma}
\alias{print.wle.gamma}

\arguments{
  \item{x}{a vector contain the observations.}

  \item{boot}{the number of starting points based on boostrap subsamples to use in the search of the roots.}

  \item{group}{the dimension of the bootstap subsamples. The default value is \eqn{max(round(size/4),var)} where \eqn{size} is the number of observations and \eqn{var} is the number of variables.}

  \item{num.sol}{maximum number of roots to be searched.}

  \item{raf}{type of Residual adjustment function to be use:

\code{raf="HD"}: Hellinger Distance RAF,

\code{raf="NED"}: Negative Exponential Disparity RAF,

\code{raf="SCHI2"}: Symmetric Chi-Squared Disparity RAF.}

  \item{smooth}{the value of the smoothing parameter.}

  \item{tol}{the absolute accuracy to be used to achieve convergence of the algorithm.}

  \item{equal}{the absolute value for which two roots are considered the same. (This parameter must be greater than \code{tol}).}

  \item{max.iter}{maximum number of iterations for the main function.}

  \item{shape.int}{a 2 dimension vector for the interval search of the shape parameter.}
 
  \item{use.smooth}{if \code{FALSE} the unsmoothed model is used. This is usefull when the integration routine does not work well.}

  \item{tol.int}{the absolute accuracy to be used in the integration routine. The default value is \eqn{tol*10^{-4}}.} 

  \item{verbose}{if \code{TRUE} warnings are printed.}

  \item{maxiter}{maximum number of iterations. This value is passed to
	\code{\link{uniroot}} function.}
}
\description{
\code{wle.gamma} is used to robust estimate the shape and the scale parameters via Weighted Likelihood, when the majority of the data are from a gamma distribution.
}

\details{
The gamma is parametrized as follows (\eqn{\alpha = scale}, \eqn{\omega = shape}): 

             \eqn{f(x) = 1/(\alpha^\omega Gamma(\omega)) x^(\omega-1) e^-(x/\alpha)}

for \eqn{x > 0}, \eqn{\alpha > 0} and \eqn{\omega > 0}. 

The function use \code{\link{uniroot}} to solve the estimating equation
for \eqn{shape}, errors from \code{\link{uniroot}} are handled by
\code{\link{try}}. If errors occurs then the function returns \code{NA}.

You can use \code{shape.int} to avoid them. It also use a fortran routine (dqagp) to calculate the smoothed model, i.e., evaluate the integral. Sometime the accuracy is not satisfactory, you can use \code{use.smooth=FALSE} to have an approximate estimation using the model instead of the smoothed model.

The Folded Normal distribution is use as kernel. The bandwith is \eqn{smooth*shape/scale^2}.
}

\value{

\code{wle.gamma} returns an object of \code{\link{class}} \code{"wle.gamma"}.

  Only print method is implemented for this class.

  The object returned by \code{wle.gamma} are:

\item{shape}{the estimator of the shape parameter, one value for each root found.}
\item{scale}{the estimator of the scale parameter, one value for each
  root found.}
\item{rate}{the estimator of the rate parameter (1/scale), one value for each
  root found.}
\item{tot.weights}{the sum of the weights divide by the number of observations, one value for each root found.}
\item{weights}{the weights associated to each observation, one column vector for each root found.}
\item{f.density}{the non-parametric density estimation.}
\item{m.density}{the smoothed model.}
\item{delta}{the Pearson residuals.}
\item{call}{the match.call().}
\item{tot.sol}{the number of solutions found.}
\item{not.conv}{the number of starting points that does not converge after the \code{max.iter} iteration are reached.}

}

\references{

Markatou, M., Basu, A. and Lindsay, B.G., (1998). Weighted likelihood estimating equations with a bootstrap root search, \emph{ Journal of the American Statistical Association}, 93, 740-750.

Agostinelli, C., (1998). Inferenza statistica robusta basata sulla funzione di verosimiglianza pesata: alcuni sviluppi, \emph{ Ph.D Thesis}, Department of Statistics, University of Padova.}

\author{Claudio Agostinelli}

\examples{
library(wle)

x <- rgamma(n=100, shape=2, scale=2)

wle.gamma(x)

x <- c(rgamma(n=30, shape=2, scale=2), rgamma(n=100, shape=20, scale=20))

wle.gamma(x, boot=10, group=10, num.sol=2) # depending on the sample, one or two roots.  

}

\keyword{models}
\keyword{robust}
 


\eof
\name{wle.lm}
\title{Fitting Linear Models using Weighted Likelihood}
\usage{
wle.lm(formula, data=list(), model=TRUE, x=FALSE, 
       y=FALSE, boot=30, group, num.sol=1, raf="HD", 
       smooth=0.031, tol=10^(-6), equal=10^(-3), 
       max.iter=500, contrasts=NULL, verbose=FALSE)
}

\alias{wle.lm}

\arguments{
  \item{formula}{a symbolic description of the model to be fit.
    The details of model specification are given below.}

  \item{data}{an optional data frame containing the variables
    in the model.  By default the variables are taken from
    the environment which \code{wle.lm} is called from.}

  \item{model, x, y}{logicals.  If \code{TRUE} the corresponding components of the fit (the model frame, the model matrix, the
    response.)}

  \item{boot}{the number of starting points based on boostrap subsamples to use in the search of the roots.}

  \item{group}{the dimension of the bootstap subsamples. The default value is \eqn{max(round(size/4),var)} where \eqn{size} is the number of observations and \eqn{var} is the number of variables.}

  \item{num.sol}{maximum number of roots to be searched.}

  \item{raf}{type of Residual adjustment function to be use:

\code{raf="HD"}: Hellinger Distance RAF,

\code{raf="NED"}: Negative Exponential Disparity RAF,

\code{raf="SCHI2"}: Symmetric Chi-Squared Disparity RAF.}

  \item{smooth}{the value of the smoothing parameter.}

  \item{tol}{the absolute accuracy to be used to achieve convergence of the algorithm.}

  \item{equal}{the absolute value for which two roots are considered the same. (This parameter must be greater than \code{tol}).}

  \item{max.iter}{maximum number of iterations.}

  \item{contrasts}{an optional list. See the \code{contrasts.arg}
    of \code{model.matrix.default}.}

  \item{verbose}{if \code{TRUE} warnings are printed.}
}
\description{
\code{wle.lm} is used to fit linear models via Weighted Likelihood, when the errors are iid from a normal distribution with null mean and unknown variance. The carriers are considered fixed. Note that this estimator is robust against the presence of bad leverage points too.
}

\details{

Models for \code{wle.lm} are specified symbolically.  A typical model has the form \code{response ~ terms} where \code{response} is the (numeric) response vector and \code{terms} is a series of terms which specifies a linear predictor for \code{response}.  A terms specification of the form \code{first+second} indicates all the terms in \code{first} together with all the terms in \code{second} with duplicates removed. A specification of the form \code{first:second} indicates the the set of terms obtained by taking the interactions of all terms in \code{first} with all terms in \code{second}. The specification \code{first*second} indicates the \emph{cross} of \code{first} and \code{second}.  This is the same as \code{first+second+first:second}.
}

\value{

\code{wle.lm} returns an object of \code{\link{class}} \code{"wle.lm"}.

  The function \code{summary} is used to obtain and print a summary of the results.
  The generic accessor functions \code{coefficients}, \code{residuals} and \code{fitted.values} extract coefficients, residuals and fitted values returned by \code{wle.lm}.

  The object returned by \code{wle.lm} are:

\item{coefficients}{the parameters estimator, one row vector for each root found.}
\item{standard.error}{an estimation of the standard error of the parameters estimator, one row vector for each root found.}
\item{scale}{an estimation of the error scale, one value for each root found.}
\item{residuals}{the unweighted residuals from the estimated model, one column vector for each root found.}
\item{fitted.values}{the fitted values from the estimated model, one column vector for each root found.}
\item{tot.weights}{the sum of the weights divide by the number of observations, one value for each root found.}
\item{weights}{the weights associated to each observation, one column vector for each root found.}
\item{f.density}{the non-parametric density estimation.}
\item{m.density}{the smoothed model.}
\item{delta}{the Pearson residuals.}
\item{freq}{the number of starting points converging to the roots.}
\item{tot.sol}{the number of solutions found.}
\item{not.conv}{the number of starting points that does not converge after the \code{max.iter} iteration are reached.}
\item{call}{the match.call().}
\item{contrasts}{}
\item{xlevels}{}
\item{terms}{the model frame.}
\item{model}{if \code{model=TRUE} a matrix with first column the dependent variable and the remain column the explanatory variables for the full model.}
\item{x}{if \code{x=TRUE} a matrix with the explanatory variables for the full model.}
\item{y}{if \code{y=TRUE} a vector with the dependent variable.}
\item{info}{not well working yet, if 0 no error occurred.}
}

\references{
Agostinelli, C., (1998) Inferenza statistica robusta basata sulla funzione di verosimiglianza pesata: alcuni sviluppi, \emph{ Ph.D Thesis}, Department of Statistics, University of Padova.

Agostinelli, C., Markatou, M., (1998) A one-step robust estimator for regression based on the weighted likelihood reweighting scheme, \emph{ Statistics \& Probability Letters}, Vol. 37, n. 4, 341-350.

Agostinelli, C., (1998) Verosimiglianza pesata nel modello di regressione lineare,  \emph{ XXXIX Riunione scientifica della Societ\`a Italiana di Statistica}, Sorrento 1998.

}

\author{Claudio Agostinelli}

%\note{}

\seealso{\link{wle.smooth} an algorithm to choose the smoothing parameter for normal distribution and normal kernel.}

\examples{
library(wle)
# You can find this data set in:
# Hawkins, D.M., Bradu, D., and Kass, G.V. (1984). 
# Location of several outliers in multiple regression data using
# elemental sets. Technometrics, 26, 197-208.
#
data(artificial)

result <- wle.lm(y.artificial~x.artificial,boot=40,num.sol=3)

summary(result)

plot(result)
}

\keyword{robust}
\keyword{regression}



\eof
\name{wle.lm.summaries}
\title{Accessing Linear Model Fits for wle.lm}
\usage{
\method{coef}{wle.lm}(object, ...)
\method{formula}{wle.lm}(x, ...)
\method{fitted}{wle.lm}(object, ...)
\method{model.frame}{wle.lm}(formula, data, na.action, ...)
\method{summary}{wle.lm}(object, root="ALL", ...)
\method{summary}{wle.lm.root}(object, root=1, ...)

\method{print}{wle.lm}(x, digits = max(3, getOption("digits") - 3), ...)

\method{print}{summary.wle.lm}(x, digits = max(3, getOption("digits") - 3), 
           signif.stars= getOption("show.signif.stars"),  ...)

\method{print}{summary.wle.lm.root}(x, digits = max(3, getOption("digits") - 3), 
           signif.stars= getOption("show.signif.stars"),  ...)
}

\alias{coef.wle.lm}
\alias{formula.wle.lm}
\alias{fitted.wle.lm}
\alias{model.frame.wle.lm}
\alias{summary.wle.lm}
\alias{summary.wle.lm.root}
\alias{weights.wle.lm}
\alias{print.wle.lm}
\alias{print.summary.wle.lm}
\alias{print.summary.wle.lm.root}

\arguments{
 \item{object}{an object of class \code{wle.lm}.}  
 \item{x}{an object of class \code{wle.lm} or \code{summary.wle.lm}.}
 \item{formula}{a model formula}
 \item{data}{\code{data.frame}, list, \code{environment} or object coercible to \code{data.frame} containing the variables in \code{formula}.}
 \item{na.action}{how \code{NA}s are treated. The default is first, any \code{na.action} attribute of \code{data}, second a \code{na.action} setting of \code{\link{options}}, and third \code{\link{na.fail}} if that is unset. The ``factory-fresh'' default is \code{\link{na.omit}}.}
 \item{root}{the root to be printed, in summary.wle.lm it could be  "ALL", all the roots are printed, or a vector of integers.}
 \item{digits}{number of digits to be used for most numbers.}
 \item{signif.stars}{logical; if \code{TRUE}, P-values are additionally encoded
   visually as ``significance stars'' in order to help scanning of long
   coefficient tables. It defaults to the \code{show.signif.stars} slot of \code{\link{options}}.}
 \item{...}{additional arguments.}
}
\description{All these functions are \code{\link{methods}} for class \code{wle.lm} or \code{summary.wle.lm}.}

\details{\code{print.summary.wle.lm} and \code{print.summary.wle.lm.root} tries formatting for each root the coefficients, standard errors, etc. and additionally gives ``significance stars'' if \code{signif.stars} is \code{TRUE}.
}

The generic accessor functions \code{coefficients}, \code{fitted.values}, \code{residuals} and \code{weights} can be used to extract various useful features of the value returned by \code{wle.lm}. 

\value{
  The function \code{summary.wle.lm} (the \code{summary.wle.lm.root} do the same for just one selected root) computes and returns, for each selected root, a list of summary statistics of the fitted linear model given in \code{object}, using the components (list elements) \code{"call"} and \code{"terms"} from its argument, plus 

 \item{residuals}{the \emph{weighted} residuals, the usual residuals rescaled by the square root of the weights given by \code{wle.lm}.}
 \item{coefficients}{a \eqn{p \times 4}{p x 4} matrix with columns for the estimated coefficient, its standard error, weighted-t-statistic and corresponding (two-sided) p-value.}
  \item{sigma}{the square root of the estimated variance of the random error.}
  \item{df}{degrees of freedom, a 3-vector \eqn{(p, \sum{weights} - p, p*)}.}
  \item{fstatistic}{a 3-vector with the value of the weighted-F-statistic with its numerator and denominator degrees of freedom.}
  \item{r.squared}{\eqn{R^2}, the ``fraction of variance explained by the model''.}
  \item{adj.r.squared}{the above \eqn{R^2} statistic
    \emph{``adjusted''}, penalizing for higher \eqn{p}.}
  \item{root}{the label of the root reported.}

}


\author{Claudio Agostinelli}

\seealso{\code{\link{wle.lm}} a function for estimating linear models with normal distribution error and normal kernel, \code{\link{plot.wle.lm}} for plot method.}

\examples{
library(wle)
# You can find this data set in:
# Hawkins, D.M., Bradu, D., and Kass, G.V. (1984). 
# Location of several outliers in multiple regression data using
# elemental sets. Technometrics, 26, 197-208.
#
data(artificial)

result <- wle.lm(y.artificial~x.artificial,boot=40,group=6,num.sol=3)

#summary only for the first root
summary(result,root=1)
#summary for all the roots
summary(result,root="ALL")
}


\keyword{robust}
\keyword{regression}


\eof
\name{wle.normal}
\title{Robust Estimation in the Normal Model}
\usage{
wle.normal(x, boot=30, group, num.sol=1, raf="HD",
           smooth=0.003, tol=10^(-6), equal=10^(-3), 
           max.iter=500, verbose=FALSE)
}
\alias{wle.normal}

\arguments{
  \item{x}{a vector contain the observations.}

  \item{boot}{the number of starting points based on boostrap subsamples to use in the search of the roots.}

  \item{group}{the dimension of the bootstap subsamples. The default value is \eqn{max(round(size/4),2)} where \eqn{size} is the number of observations.}

  \item{num.sol}{maximum number of roots to be searched.}

  \item{raf}{type of Residual adjustment function to be use:

\code{raf="HD"}: Hellinger Distance RAF,

\code{raf="NED"}: Negative Exponential Disparity RAF,

\code{raf="SCHI2"}: Symmetric Chi-Squared Disparity RAF.}

  \item{smooth}{the value of the smoothing parameter.}

  \item{tol}{the absolute accuracy to be used to achieve convergence of the algorithm.}

  \item{equal}{the absolute value for which two roots are considered the same. (This parameter must be greater than \code{tol}).}

  \item{max.iter}{maximum number of iterations.}

  \item{verbose}{if \code{TRUE} warnings are printed.}
}
\description{
\code{wle.normal} is used to robust estimate the location and the scale parameters via Weighted Likelihood, when the sample is iid from a normal distribution with unknown mean and variance.
}

\value{

\code{wle.normal} returns an object of \code{\link{class}} \code{"wle.normal"}.

  Only print method is implemented for this class.

  The object returned by \code{wle.normal} are:

\item{location}{the estimator of the location parameter, one value for each root found.}
\item{scale}{the estimator of the scale parameter, one value for each root found.}
\item{residuals}{the residuals associated to each observation, one column vector for each root found.}
\item{tot.weights}{the sum of the weights divide by the number of observations, one value for each root found.}
\item{weights}{the weights associated to each observation, one column vector for each root found.}
\item{f.density}{the non-parametric density estimation.}
\item{m.density}{the smoothed model.}
\item{delta}{the Pearson residuals.}
\item{freq}{the number of starting points converging to the roots.}
\item{call}{the match.call().}
\item{tot.sol}{the number of solutions found.}
\item{not.conv}{the number of starting points that does not converge after the \code{max.iter} iteration are reached.}

}

\references{

Markatou, M., Basu, A. and Lindsay, B.G., (1998) Weighted likelihood estimating equations with a bootstrap root search, \emph{Journal of the American Statistical Association}, 93, 740-750.

Agostinelli, C., (1998) Inferenza statistica robusta basata sulla funzione di verosimiglianza pesata: alcuni sviluppi, \emph{Ph.D Thesis}, Department of Statistics, University of Padova.}

\author{Claudio Agostinelli}

\seealso{\link{wle.smooth} an algorithm to choose the smoothing parameter for normal distribution and normal kernel.}

\examples{
library(wle)

data(cavendish)

result <- wle.normal(cavendish)

result

result <- wle.normal(cavendish,boot=20,num.sol=1)

barplot(result$weights,col=2,xlab="Observations",
        ylab="Weights",ylim=c(0,1),
        names.arg=seq(1:length(result$weights)))

}

\keyword{models}
\keyword{robust}
 


\eof
\name{wle.normal.mixture}
\alias{wle.normal.mixture}
\alias{wle.normal.mixture.start}
\alias{print.wle.normal.mixture}
\title{Robust Estimation in the Normal Mixture Model}

\usage{
wle.normal.mixture(x, m, boot=5, group, num.sol=1, raf="HD", 
                   smooth=0.003, tol=10^(-15), equal=10^(-2), 
                   max.iter=1000, all.comp=TRUE, min.size=0.02,
                   min.weights=0.3, boot.start=10, group.start=3, 
                   tol.start=10^(-6), equal.start=10^(-3),
                   smooth.start=0.003, max.iter.start=500, 
                   max.iter.boot=25, verbose=FALSE)

wle.normal.mixture.start(x, m, boot=5, group, raf="HD", 
                   smooth=0.003, tol=10^(-15), equal=10^(-2), 
                   min.size=0.02, min.weights=0.3, boot.start=20, 
                   group.start=3, max.iter.start=500, 
                   max.iter.boot=20, verbose=FALSE)

}

\arguments{
  \item{x}{a vector contain the observations.}
  \item{m}{numbers of components.}
  \item{boot}{the number of starting points based on boostrap subsamples to use in the search of the roots.}
  \item{group}{the dimension of the bootstap subsamples. The default value is \eqn{max(round(size/4),2)} where \eqn{size} is the number of observations.}
  \item{num.sol}{maximum number of roots to be searched.}
  \item{raf}{type of Residual adjustment function to be use:

\code{raf="HD"}: Hellinger Distance RAF,

\code{raf="NED"}: Negative Exponential Disparity RAF,

\code{raf="SCHI2"}: Symmetric Chi-Squared Disparity RAF.}

  \item{smooth}{the value of the smoothing parameter.}
  \item{tol}{the absolute accuracy to be used to achieve convergence of the algorithm.}
  \item{equal}{the absolute value for which two roots are considered the same. (This parameter must be greater than \code{tol}).}
  \item{max.iter}{maximum number of iterations.}
  \item{all.comp}{try to find all the components.}
  \item{min.size}{see details}
  \item{min.weights}{see details}
  \item{boot.start}{the number of starting points for the starting process.}
  \item{group.start}{the dimension of the bootstap subsamples in the starting process. The default value is \eqn{max(round(group/4),2)}.}
  \item{tol.start}{the absolute accuracy to be used to achieve convergence of the algorithm in the starting process.}
  \item{equal.start}{the absolute value for which two roots are considered the same in the starting process. (This parameter must be greater than \code{tol.start}).}
  \item{smooth.start}{the value of the smoothing parameter in the starting process.}
  \item{max.iter.start}{maximum number of iterations in the starting process.}
  \item{max.iter.boot}{maximum number of iterations of the starting process.}
  \item{verbose}{if \code{TRUE} warnings are printed.}

}
\description{
\code{wle.normal.mixture} is a preliminary version; it is used to robust estimate the location, scale and proportion parameters via Weighted Likelihood, when the sample is iid from a normal mixture univariate  distribution with known \code{m} number of components.
}

\details{
this function use an iterative procedure to evaluate starting
points. First, using \code{\link{wle.normal}} we try to find the biggest
components, then we discard each observation with weight greater than
\code{min.weights}. The \code{\link{wle.normal}} is run on the remain
observations if the ratio between the number of observations and the
original sample size is greater than \code{min.size}. The convergence of
the algorithm is determined by the difference between two
iterations. This stopping rule could have some problems, as soon as
possible it will replace with the one proposed in Markatou (2000)
pag. 485 (5).
}

\value{

\code{wle.normal.mixture} returns an object of \code{\link{class}} \code{"wle.normal.mixture"}.

  Only print method is implemented for this class.

  The objects returned by \code{wle.normal.mixture} are:

    \item{location}{the estimator of the location parameters, one vector for each root found.}
    \item{scale}{the estimator of the scale parameters, one vector for each root found.}
    \item{pi}{the estimator of the proportion parameters, one vector for each root found.}
    \item{tot.weights}{the sum of the weights, divide by the number of observations, one value for each root found.}
    \item{weights}{the weights associated to each observation, one column vector for each root found.}
    \item{f.density}{the non-parametric density estimation.}
    \item{m.density}{the smoothed model.}
    \item{delta}{the Pearson residuals.}
    \item{freq}{the number of starting points converging to the roots.}
    \item{tot.sol}{the number of solutions found.}
    \item{not.conv}{the number of starting points that does not converge after the \code{max.iter} iteration are reached.}
    \item{call}{the match.call().}

}

\references{ 

Markatou, M., (2000) Mixture models, robustness and the weighted likelihood methodology, \emph{Biometrics}, 56, 483-486.

Markatou, M., (2001) A closer look at the weighted likelihood in the context of mixtures, \emph{Probability and Statistical Models with Applications}, Charalambides, C.A., Koutras, M.V. and Balakrishnan, N. (eds.), Chapman and Hall/CRC, 447-467.
}

\author{Claudio Agostinelli}
%\note{}
%\seealso{}

\examples{
library(wle)
set.seed(1234)
x <- c(rnorm(150,0,1),rnorm(50,15,2))
wle.normal.mixture(x,m=2,group=50,group.start=2,boot=5,num.sol=3)
wle.normal(x,group=2,boot=10,num.sol=3)

}

\keyword{robust}
\keyword{models}

\eof
\name{wle.normal.multi}
\title{Robust Estimation in the Normal Multivariate Model}
\usage{
wle.normal.multi(x, boot=30, group, num.sol=1,
                 raf="HD", smooth, tol=10^(-6), 
                 equal=10^(-3), max.iter=500,
                 verbose=FALSE)
}
\alias{wle.normal.multi}
\arguments{
  \item{x}{a matrix contain the observations.}

  \item{boot}{the number of starting points based on boostrap subsamples to use in the search of the roots.}

  \item{group}{the dimension of the bootstap subsamples. The default value is \eqn{max(round(size/4),(var*(var+1)/2+var))} where \eqn{size} is the number of observations and \eqn{var} is the number of variables.}

  \item{num.sol}{maximum number of roots to be searched.}

  \item{raf}{type of Residual adjustment function to be use:

\code{raf="HD"}: Hellinger Distance RAF,

\code{raf="NED"}: Negative Exponential Disparity RAF,

\code{raf="SCHI2"}: Symmetric Chi-Squared Disparity RAF.}

  \item{smooth}{the value of the smoothing parameter.}

  \item{tol}{the absolute accuracy to be used to achieve convergence of the algorithm.}

  \item{equal}{the absolute value for which two roots are considered the same. (This parameter must be greater than \code{tol}).}

  \item{max.iter}{maximum number of iterations.}

  \item{verbose}{if \code{TRUE} warnings are printed.}
}

\description{
\code{wle.normal.multi} is used to robust estimate the location and the covariance matrix via Weighted Likelihood, when the sample is iid from a normal multivariate distribution with unknown means and variance matrix.
}

\value{

\code{wle.normal.multi} returns an object of \code{\link{class}} \code{"wle.normal.multi"}.

  Only print method is implemented for this class.

  The object returned by \code{wle.normal.multi} are:

\item{location}{the estimator of the location parameters, one vector for each root found.}
\item{variance}{the estimator of the covariance matrix, one matrix for each root found.}
\item{tot.weights}{the sum of the weights divide by the number of observations, one value for each root found.}
\item{weights}{the weights associated to each observation, one column vector for each root found.}
\item{f.density}{the non-parametric density estimation.}
\item{m.density}{the smoothed model.}
\item{delta}{the Pearson residuals.}
\item{freq}{the number of starting points converging to the roots.}
\item{tot.sol}{the number of solutions found.}
\item{call}{the match.call().}
\item{not.conv}{the number of starting points that does not converge after the \code{max.iter} iteration are reached.}

}

\references{

Markatou, M., Basu, A. and Lindsay, B.G., (1998) Weighted likelihood estimating equations with a bootstrap root search, \emph{ Journal of the American Statistical Association}, 93, 740-750.

Agostinelli, C., (1998) Inferenza statistica robusta basata sulla funzione di verosimiglianza pesata: alcuni sviluppi, \emph{ Ph.D Thesis}, Department of Statistics, University of Padova.}

\author{Claudio Agostinelli}

\seealso{\link{wle.smooth} an algorithm to choose the smoothing parameter for normal distribution and normal kernel.}

\examples{
library(wle)

data(iris)

smooth <- wle.smooth(dimension=4,costant=4,
                    weight=0.5,interval=c(0.3,0.7))

x.data <- as.matrix(iris[iris[,5]=="virginica",1:4])

result <- wle.normal.multi(x.data,boot=20,group=21,
                           num.sol=3,smooth=smooth$root)

result

result <- wle.normal.multi(x.data,boot=20,group=21,
                           num.sol=1,smooth=smooth$root)

barplot(result$weights,col=2,xlab="Observations",
       ylab="Weights",ylim=c(0,1),
       names.arg=seq(1:length(result$weights)))
}

\keyword{models}
\keyword{multivariate}
\keyword{robust}



\eof
\name{wle.normal.multi.summaries}
\title{Summaries and methods for wle.normal.multi}
\usage{
\method{print}{wle.normal.multi}(x, digits = max(3, getOption("digits") - 3), ...)
}

\alias{print.wle.normal.multi}

\arguments{
  \item{x}{an object of class \code{wle.normal.multi}.}
  \item{digits}{number of digits to be used for most numbers.}
  \item{...}{further arguments passed to or from other methods.}
}

\description{Until now, only print \code{\link{methods}} is available for class \code{wle.normal.multi}. \code{print.wle.normal.multi} print nicely the output.}

\author{Claudio Agostinelli}

\seealso{\code{\link{wle.normal.multi}} a function for estimating normal multivariate location and scale models.}

%\examples{}

\keyword{models}
\keyword{multivariate}
\keyword{robust}

\eof
\name{wle.normal.summaries}
\title{Summaries and methods for wle.normal}
\usage{
\method{print}{wle.normal}(x, digits = max(3, getOption("digits") - 3), ...)
}

\alias{print.wle.normal}

\arguments{
  \item{x}{an object of class \code{wle.normal}.}
  \item{digits}{number of digits to be used for most numbers.}
  \item{...}{further arguments passed to or from other methods.}
}

\description{Until now, only print \code{\link{methods}} is available for class \code{wle.normal}. \code{print.wle.normal} print nicely the output.}

\author{Claudio Agostinelli}

\seealso{\code{\link{wle.normal}} a function for estimating normal location and scale models.}

%\examples{}

\keyword{models}
\keyword{robust}

\eof
\name{wle.onestep}
\title{A One-Step Weighted Likelihood Estimator for Linear model}
\usage{
wle.onestep(formula, data=list(), model=TRUE, x=FALSE, 
            y=FALSE, ini.param, ini.scale, raf="HD", 
            smooth=0.031, num.step=1, 
            contrasts=NULL, verbose=FALSE)
}
\alias{wle.onestep}

\arguments{

  \item{formula}{a symbolic description of the model to be fit.
    The details of model specification are given below.}

  \item{data}{an optional data frame containing the variables
    in the model.  By default the variables are taken from
    the environment which \code{wle.stepwise} is called from.}

  \item{model, x, y}{logicals.  If \code{TRUE} the corresponding components of the fit (the model frame, the model matrix, the
    response.)}

  \item{ini.param}{starting values for the coefficients.}

  \item{ini.scale}{starting values for the scale parameters.}

  \item{raf}{type of Residual adjustment function to be use:

\code{raf="HD"}: Hellinger Distance RAF,

\code{raf="NED"}: Negative Exponential Disparity RAF,

\code{raf="SCHI2"}: Symmetric Chi-Squared Disparity RAF.}

  \item{smooth}{the value of the smoothing parameter.}

  \item{num.step}{number of the steps.}

  \item{contrasts}{an optional list. See the \code{contrasts.arg}
    of \code{model.matrix.default}.}

  \item{verbose}{if \code{TRUE} warnings are printed.}
}

\description{This function evaluate the One-step weighted likelihood estimator for the regression and scale parameters.}


\value{

\code{wle.onestep} returns an object of \code{\link{class}} \code{"wle.onestep"}.

  Only print method is implemented for this class.

  The object returned by \code{wle.onestep} are:

\item{coefficients}{the parameters estimator.}
\item{standard.error}{an estimation of the standard error of the parameters estimator.}
\item{scale}{an estimation of the error scale.}
\item{residuals}{the unweighted residuals from the estimated model.}
\item{fitted.values}{the fitted values from the estimated model.}
\item{tot.weights}{the sum of the weights divide by the number of observations.}
\item{weights}{the weights associated to each observation.}
\item{f.density}{the non-parametric density estimation.}
\item{m.density}{the smoothed model.}
\item{delta}{the Pearson residuals.}
\item{call}{the match.call().}
\item{contrasts}{}
\item{xlevels}{}
\item{terms}{the model frame.}
\item{model}{if \code{model=TRUE} a matrix with first column the dependent variable and the remain column the explanatory variables for the full model.}
\item{x}{if \code{x=TRUE} a matrix with the explanatory variables for the full model.}
\item{y}{if \code{y=TRUE} a vector with the dependent variable.}

}

\references{

Agostinelli, C., (1997) A one-step robust estimator based on the weighted likelihood methodology, \emph{ Working Paper n. 1997.16}, Department of Statistics, University of Padova.

Agostinelli, C., (1998) Inferenza statistica robusta basata sulla funzione di verosimiglianza pesata: alcuni sviluppi, \emph{ Ph.D Thesis}, Department of Statistics, University of Padova.

Agostinelli, C., Markatou, M., (1998) A one-step robust estimator for regression based on the weighted likelihood reweighting scheme, \emph{ Statistics \& Probability Letters}, Vol. 37, n. 4, 341-350.

Agostinelli, C., (1998) Verosimiglianza pesata nel modello di regressione lineare,  \emph{ XXXIX Riunione scientifica della Societ\`a Italiana di Statistica}, Sorrento 1998.

}

\author{Claudio Agostinelli}

\seealso{\link{wle.smooth} an algorithm to choose the smoothing parameter for normal distribution and normal kernel, \link{wle.lm} a function for estimating linear models with normal distribution error and normal kernel.}

\examples{
#library(wle)
#library(lqs)

#data(artificial)

#result.lts <- lqs(y.artificial~x.artificial, 
#                 method = "lts")

#result.wle <- wle.onestep(y.artificial~x.artificial,
#               ini.param=result.lts$coefficients,
#               ini.scale=result.lts$scale[1])

#result.wle
}


\keyword{robust}
\keyword{regression}


\eof
\name{wle.onestep.summaries}
\title{Summaries and methods for wle.onestep}
\usage{
\method{print}{wle.onestep}(x, digits = max(3, getOption("digits") - 3), ...)
}

\alias{print.wle.onestep}

\arguments{
  \item{x}{an object of class \code{wle.onestep}.}
  \item{digits}{number of digits to be used for most numbers.}
  \item{...}{further arguments passed to or from other methods.}  
}

\description{Until now, only print \code{\link{methods}} is available for class \code{wle.onestep}. \code{print.wle.onestep} print nicely the output.}

\author{Claudio Agostinelli}

\seealso{\code{\link{wle.onestep}} a function for one-step estimation in linear models.}

%\examples{}

\keyword{regression}
\keyword{robust}

\eof
\name{wle.poisson}
\title{Robust Estimation in the Poisson Model}
\usage{
wle.poisson(x, boot=30, group, num.sol=1, raf="HD", 
            tol=10^(-6), equal=10^(-3), 
            max.iter=500, verbose=FALSE)
}
\alias{wle.poisson}
\alias{print.wle.poisson}

\arguments{
  \item{x}{a vector contain the number of success.}

  \item{boot}{the number of starting points based on boostrap subsamples to use in the search of the roots.}

  \item{group}{the dimension of the bootstap subsamples. The default value is \eqn{max(round(length(x)/4),2)}.}

  \item{num.sol}{maximum number of roots to be searched.}

  \item{raf}{type of Residual adjustment function to be use:

\code{raf="HD"}: Hellinger Distance RAF,

\code{raf="NED"}: Negative Exponential Disparity RAF,

\code{raf="SCHI2"}: Symmetric Chi-Squared Disparity RAF.}

  \item{tol}{the absolute accuracy to be used to achieve convergence of the algorithm.}

  \item{equal}{the absolute value for which two roots are considered the same. (This parameter must be greater than \code{tol}).}

  \item{max.iter}{maximum number of iterations.}

  \item{verbose}{if \code{TRUE} warnings are printed.}
}
\description{
\code{wle.poisson} is used to robust estimate the lambda parameters in the poisson model via Weighted Likelihood.
}

\value{

\code{wle.poisson} returns an object of \code{\link{class}} \code{"wle.poisson"}.

  Only print method is implemented for this class.

  The object returned by \code{wle.poisson} are:

\item{lambda}{the estimator of the lambda parameter, one value for each root found.}
\item{tot.weights}{the sum of the weights divide by the number of observations, one value for each root found.}
\item{weights}{the weights associated to each observation, one column vector for each root found.}
\item{f.density}{the non-parametric density estimation.}
\item{m.density}{the smoothed model.}
\item{delta}{the Pearson residuals.}
\item{call}{the match.call().}
\item{tot.sol}{the number of solutions found.}
\item{not.conv}{the number of starting points that does not converge after the \code{max.iter} iteration are reached.}

}

\author{Claudio Agostinelli}

\references{

Markatou, M., Basu, A., and Lindsay, B.G., (1997) Weighted likelihood estimating equations: The discrete case with applications to logistic regression, \emph{Journal of Statistical Planning and Inference}, 57, 215-232.

Agostinelli, C., (1998) Inferenza statistica robusta basata sulla funzione di verosimiglianza pesata: alcuni sviluppi, \emph{ Ph.D Thesis}, Department of Statistics, University of Padova.}


}

%\seealso{}

\examples{
library(wle)

set.seed(1234)

x <- rpois(40,5)
wle.poisson(x)

x <- c(rpois(40,5),rpois(10,20))
wle.poisson(x)

}

\keyword{models}
\keyword{robust}
 


\eof
\name{wle.smooth}
\title{Bandwidth selection for the normal kernel and normal model.}
\usage{
wle.smooth(weight=0.31,costant=3,level=0.2,
          dimension=1,raf="HD",interval=c(0.00001,0.5),
          tol=10^-6,max.iter=1000)
}
\alias{wle.smooth}
\alias{print.wle.smooth}

\arguments{
  \item{weight}{weights associated to an observation that is \code{costant} scale units away from the mean of the distribution.}

  \item{costant}{times the contaminated point mass is away from the mean of the distribution in scale units.}

  \item{level}{mass of the contaminated point.}

  \item{dimension}{dimension of the normal distribution.}

  \item{raf}{type of Residual adjustment function to be use:

\code{raf="HD"}: Hellinger Distance RAF,

\code{raf="NED"}: Negative Exponential Disparity RAF,

\code{raf="SCHI2"}: Symmetric Chi-Squared Disparity RAF.}

  \item{interval}{interval from which to search the root.}

  \item{tol}{the absolute accuracy to be used to achieve convergence of the algorithm.}

  \item{max.iter}{maximum number of iterations.}
}
\description{
The bandwidth of the kernel is choose for normal model and normal kernel in such a way a contaminated point \code{costant} times away from the mean of the distribution in scale units and mass \code{level} has a weight no bigger than \code{weight}.
}

\details{
The \code{wle.smooth} use \code{uniroot} function to solve the non linear equation. No handling error is provided yet. For the Symmetric Chi-Squared Disparity RAF you should use \code{weight=0.2} and \code{interavl=c(0.1,1)} to have a solution.  
}

\value{
\code{wle.smooth} returns an object of \code{\link{class}} \code{"wle.smooth"}.

  Only print method is implemented for this class.

  The object returned by \code{wle.smooth} is a list with four components: root and f.root give the location of the root and the value of the function evaluated at that
point. iter and estim.prec give the number of iterations used and an approximate estimated precision for root.

\code{root} is the value of the bandwidth.

}

\references{

Agostinelli, C., (1998) Inferenza statistica robusta basata sulla funzione di verosimiglianza pesata: alcuni sviluppi, \emph{ Ph.D. thesis},  Department of Statistics, University of Padova.

Markatou, M., Basu, A. and Lindsay, B.G. (1998) Weighted likelihood estimating equations with a bootstrap root search. \emph{ Journal of the American Statistical Association}, 93, 740-750.

Agostinelli, C., and Markatou, M., (2001) Test of hypotheses based on the Weighted Likelihood Methodology, \emph{Statistica Sinica},  vol. 11, n. 2, 499-514.
}

\author{Claudio Agostinelli}

\seealso{\code{\link{uniroot}, uniroot}: one dimensional root finding.}

\examples{
library(wle)

wle.smooth()
}

\keyword{robust}



\eof
\name{wle.stepwise}
\title{Weighted Stepwise, Backward and Forward selection methods}
\usage{
wle.stepwise(formula, data=list(), model=TRUE, x=FALSE, 
             y=FALSE, boot=30, group, num.sol=1, raf="HD", 
             smooth=0.031, tol=10^(-6), equal=10^(-3), 
             max.iter=500, min.weight=0.5, type="Forward", 
             f.in=4.0, f.out=4.0, method="WLE", 
             contrasts=NULL, verbose=FALSE)
}
\alias{wle.stepwise}

\arguments{

  \item{formula}{a symbolic description of the model to be fit.
    The details of model specification are given below.}

  \item{data}{an optional data frame containing the variables
    in the model.  By default the variables are taken from
    the environment which \code{wle.stepwise} is called from.}

  \item{model, x, y}{logicals.  If \code{TRUE} the corresponding components of the fit (the model frame, the model matrix, the
    response.)}

  \item{boot}{the number of starting points based on boostrap subsamples to use in the search of the roots.}

  \item{group}{the dimension of the bootstap subsamples. The default value is \eqn{max(round(size/4),var)} where \eqn{size} is the number of observations and \eqn{var} is the number of variables.}

  \item{num.sol}{maximum number of roots to be searched.}

  \item{raf}{type of Residual adjustment function to be use:

\code{raf="HD"}: Hellinger Distance RAF,

\code{raf="NED"}: Negative Exponential Disparity RAF,

\code{raf="SCHI2"}: Symmetric Chi-Squared Disparity RAF.}
 
  \item{smooth}{the value of the smoothing parameter.}

  \item{tol}{the absolute accuracy to be used to achieve convergence of the algorithm.}

  \item{equal}{the absolute value for which two roots are considered the same. (This parameter must be greater than \code{tol}).}

  \item{max.iter}{maximum number of iterations.}

  \item{min.weight}{see details.}

  \item{type}{
\code{type="Stepwise"}: the weighted stepwise methods is used,

\code{type="Forward"}: the weighted forward methods is used,

\code{type="Backward"}: the weighted backward method is used.}

  \item{f.in}{the in value}

  \item{f.out}{the out value}

  \item{method}{
\code{method="WLS"}: the submodel parameters are estimated by weighted least square with weights from the weighted likelihood estimator on the full model.

\code{method="WLE"}: the submodel parameters are estimated by weighted likelihood estimators.
}

  \item{contrasts}{an optional list. See the \code{contrasts.arg}
    of \code{model.matrix.default}.}

  \item{verbose}{if \code{TRUE} warnings are printed.}
}

\description{This function performs Weighted Stepwise, Forward and Backward model selection.}

\details{

Models for \code{wle.stepwise} are specified symbolically.  A typical model has the form \code{response ~ terms} where \code{response} is the (numeric) response vector and \code{terms} is a series of terms which specifies a linear predictor for \code{response}.  A terms specification of the form \code{first+second} indicates all the terms in \code{first} together with all the terms in \code{second} with duplicates removed. A specification of the form \code{first:second} indicates the the set of terms obtained by taking the interactions of all terms in \code{first} with all terms in \code{second}. The specification \code{first*second} indicates the \emph{cross} of \code{first} and \code{second}.  This is the same as \code{first+second+first:second}.

\code{min.weight}: the weighted likelihood equation could have more than one solution. These roots appear for particular situation depending on contamination level and type. The presence of multiple roots in the full model can create some problem in the set of weights we should use. Actually, the selection of the root is done by the minimum scale error provided. Since this choice is not always the one would choose, we introduce the \code{min.weight} parameter in order to choose only between roots that do not down weight everything. This is not still the optimal solution, and perhaps, in the new release, this part will be change. }

\value{


\code{wle.stepwise} returns an object of \code{\link{class}} \code{"wle.stepwise"}.

  The function \code{summary} is used to obtain and print a summary of the results.
  The generic accessor functions \code{coefficients} and \code{residuals} extract coefficients and residuals returned by \code{wle.stepwise}.

  The object returned by \code{wle.stepwise} are:

\item{wstep}{the iterations with the model selected.}
\item{coefficients}{the parameters estimator, one row vector for each root found in the full model.}
\item{scale}{an estimation of the error scale, one value for each root found in the full model.}
\item{residuals}{the unweighted residuals from the estimated model, one column vector for each root found in the full model.}
\item{tot.weights}{the sum of the weights divide by the number of observations, one value for each root found in the full model.}
\item{weights}{the weights associated to each observation, one column vector for each root found in the full model.}
\item{freq}{the number of starting points converging to the roots.}
\item{index}{position of the root used for the weights.}
\item{call}{the match.call().}
\item{contrasts}{}
\item{xlevels}{}
\item{terms}{the model frame.}
\item{model}{if \code{model=TRUE} a matrix with first column the dependent variable and the remain column the explanatory variables for the full model.}
\item{x}{if \code{x=TRUE} a matrix with the explanatory variables for the full model.}
\item{y}{if \code{y=TRUE} a vector with the dependent variable.}
\item{info}{not well working yet, if 0 no error occurred.}
  \item{type}{\code{"Stepwise"}: the weighted stepwise methods is used, \code{"Forward"}: the weighted forward methods is used, \code{"Backward"}: the weighted backward method is used.}

  \item{f.in}{the in value.}

  \item{f.out}{the out value.}

  \item{method}{if "WLS" the submodel parameters are estimated by weighted least square with weights from the weighted likelihood estimator on the full model else if "WLE" the submodel parameters are estimated by weighted likelihood estimators.
}

}

\references{

Agostinelli, C., (2000) Robust stepwise regression, Working Paper n. 2000.10 del Dipartimento di Scienze Statistiche, Universit\`a di Padova, Padova.

Agostinelli, C., (2001) Robust stepwise regression, \emph{Journal of Applied Statistics} in press.

Agostinelli, C., (1998) Inferenza statistica robusta basata sulla funzione di verosimiglianza pesata: alcuni sviluppi, \emph{Ph.D Thesis}, Department of Statistics, University of Padova.

Agostinelli, C., (1998) Verosimiglianza pesata nel modello di regressione lineare,  \emph{XXXIX Riunione scientifica della Societ\`a Italiana di Statistica}, Sorrento 1998.

}

\author{Claudio Agostinelli}

\seealso{\link{wle.smooth} an algorithm to choose the smoothing parameter for normal distribution and normal kernel, \link{wle.lm} a function for estimating linear models with normal distribution error and normal kernel.}

\examples{

library(wle)

# You can find this dataset in:
# Agostinelli, C., (1999). Robust model selection in regression 
# via weighted likelihood methodology, submitted to Statistics & 
# Probability Letters.

data(selection)

result <- wle.stepwise(ydata~xdata, boot=100, group=6, num.sol=3,
min.weight=0.8, type="Stepwise", method="WLS")

summary(result)
}

\keyword{robust}
\keyword{regression}






\eof
\name{wle.stepwise.summaries}
\title{Accessing summaries for wle.stepwise}
\usage{
\method{summary}{wle.stepwise}(object, num.max=20, verbose=FALSE, ...)

\method{print}{wle.stepwise}(x, digits = max(3, getOption("digits") -
3), num.max=max(1, nrow(x$wstep)), ...)

\method{print}{summary.wle.stepwise}(x, digits = max(3, getOption("digits") - 3), ...)
}

\alias{summary.wle.stepwise}
\alias{print.wle.stepwise}
\alias{print.summary.wle.stepwise}

\arguments{
 \item{object}{an object of class \code{wle.stepwise}.}
 \item{x}{an object of class \code{wle.stepwise} or \code{summary.wle.stepwise}.}
 \item{digits}{number of digits to be used for most numbers.} 
 \item{num.max}{the number of the last iterations reported.}
 \item{verbose}{if \code{TRUE} warnings are printed.}
 \item{...}{additional arguments affecting the summary produced (in
   \code{summary.wle.stepwise}) or further arguments passed to or from
   other methods (in \code{print.wle.stepwise} and
   \code{print.summary.wle.stepwise}).}
}

 
\description{All these functions are \code{\link{methods}} for class \code{wle.stepwise} or \code{summary.wle.stepwise}.}

\details{
The generic accessor functions \code{\link{coefficients}}, \code{\link{fitted.values}}, \code{\link{residuals}} and \code{\link{weights}} can be used to extract various useful features of the value returned by \code{wle.stepwise}. 
}

\value{
  The function \code{summary.wle.stepwise} returns the last \code{num.max} iterations, \code{call} plus:

\item{wstep}{the model for each iteration reported.}
\item{num.max}{the numeber of iterations reported.}
\item{type}{the type of selection procedure used.}
\item{f.in}{the in value.}
\item{f.out}{the out value.}

}

\author{Claudio Agostinelli}

%\examples{}

\keyword{robust}
\keyword{regression}



\eof
\name{wle.t.test}
\alias{wle.t.test}
\alias{print.wle.t.test}
\title{Weighted Likelihood Student's t-Test}
\usage{
wle.t.test(x, y = NULL, alternative = c("two.sided", "less", "greater"),
       mu = 0, paired = FALSE, var.equal = FALSE, conf.level = 0.95,
       boot=30, group, num.sol=1, raf="HD", smooth=0.003, 
       tol=10^(-6), equal=10^(-3), max.iter=500)
}
\arguments{
  \item{x}{a numeric vector of data values.}

  \item{y}{an optional numeric vector data values.}

  \item{alternative}{character specifying the alternative hypothesis,
    must be one of \code{"two.sided"} (default), \code{"greater"} or
    \code{"less"}.  You can specify just the initial letter.}

  \item{mu}{a number indicating the true value of the mean (or
    difference in means if you are performing a two sample test).}

  \item{paired}{a logical indicating whether you want a paired
    weighted t-test.}

  \item{var.equal}{a logical variable indicating whether to treat the
    two variances as being equal. If \code{TRUE} then the pooled
    variance is used to estimate the variance otherwise the Welch
    approximation to the degrees of freedom is used.}

  \item{conf.level}{confidence level of the interval.}

  \item{boot}{the number of starting points based on boostrap subsamples to use in the search of the roots.}

  \item{group}{the dimension of the bootstap subsamples. The default value is \eqn{max(round(size/4),2)} where \eqn{size} is the number of observations.}

  \item{num.sol}{maximum number of roots to be searched.}

  \item{raf}{type of Residual adjustment function to be use:

\code{raf="HD"}: Hellinger Distance RAF,

\code{raf="NED"}: Negative Exponential Disparity RAF,

\code{raf="SCHI2"}: Symmetric Chi-Squared Disparity RAF.}

  \item{smooth}{the value of the smoothing parameter.}

  \item{tol}{the absolute accuracy to be used to achieve convergence of the algorithm.}

  \item{equal}{the absolute value for which two roots are considered the same. (This parameter must be greater than \code{tol}).}

  \item{max.iter}{maximum number of iterations.}
}

\description{
  \code{wle.t.test} performs one and two sample Weighted Likelihood t-tests on vectors of data. This is a robust version of the classical t-test. It should be used when the majority of the data follows a normal distribution.
}

\details{
  If \code{paired} is \code{TRUE} then both \code{x} and \code{y} must
  be specified and they must be the same length.  Missing values are
  removed (in pairs if \code{paired} is \code{TRUE}).  If
  \code{var.equal} is \code{TRUE} then the pooled estimate of the
  variance is used.  By default, if \code{var.equal} is \code{FALSE}
  then the variance is estimated separately for both groups and the
  Welch modification to the degrees of freedom is used.
}
\value{
    The function return a list of class \code{"wle.t.test"} with the following components:

    \item{test}{A list with two dimensions. Each cell is related with a combination of 'x', 'y' roots. In each cell a list of class \code{"htest"} containing the following components:

    \code{statistic} the value of the t-statistic.

    \code{parameters} the degrees of freedom for the t-statistic.

    \code{p.value} the p-value for the test.

    \code{conf.int} a confidence interval for the mean appropriate to the specified alternative hypothesis.

    \code{estimate} the estimated mean or difference in means depending on whether it was a one-sample test or a two-sample test.

    \code{null.value} the specified hypothesized value of the mean or mean difference depending on whether it was a one-sample test or a two-sample test.

    \code{alternative} a character string describing the alternative hypothesis.

    \code{method} a character string indicating what type of t-test was performed.

    \code{data.name} a character string giving the name(s) of the data. 
    
    \code{x.weights} the weights related to the 'x' data.

    \code{y.weights} the weights related to the 'y' data.

    \code{x.root} the number of the 'x' root.

    \code{y.root} the number of the 'y' root.

    }

    \item{x.tot.sol}{the number of solutions for the dataset 'x'.}

    \item{y.tot.sol}{the number of solutions for the dataset 'y' or 1.}

    \item{call}{the match.call().}

    \item{paired}{a logical indicating whether is a paired weighted t-test.}

    \item{x}{'x' data.}

    \item{y}{'y' data or \code{NULL}.}

}

%\seealso{}

\references{

Agostinelli, C., (1998) Inferenza statistica robusta basata sulla funzione di verosimiglianza pesata: alcuni sviluppi, \emph{ Ph.D Thesis}, Department of Statistics, University of Padova (in italian).

Agostinelli, C., (2001) Un approccio robusto alla verifica d'ipotesi basato sulla funzione di verosimiglianza pesata - Robust Testing Hypotheses via Weighted Likelihood function, in press \emph{Statistica}, (in italian).

Agostinelli, C., and Markatou, M., (2001) Test of hypotheses based on the Weighted Likelihood Methodology, \emph{Statistica Sinica},  vol. 11, n. 2, 499-514.
}

\author{Claudio Agostinelli}

\examples{
library(wle)
library(ctest)

set.seed(1234)

x <- rnorm(20,0,1)
y <- rnorm(20,6,1)

t.test(x,y)                # P < 2.2e-16
wle.t.test(x,y,group=5)    # P < 2.2e-16

t.test(x,y=c(y,250))       # P = 0.1419 -- NOT significant anymore
wle.t.test(x,y=c(y,250),group=5) # P < 2.2e-16 -- still significant 
set.seed(1234)

# three roots for 'x' and three roots for 'y'
# with nine t-test value
res <- wle.t.test(x=c(rnorm(40,0,1),rnorm(40,10,1)),
           y=c(rnorm(40,0,1),rnorm(40,10,1)),
           group=4,num.sol=3,boot=100)

print(res) # print ALL the t-test
print(res,x.root=1,y.root=1)   # print the test associated to the 
                               # x.root=1,y.root=1 

root.1.1 <- res$test[[1]][[1]] # access to the object associated 
                               # to the x.root=1,y.root=1 

names(root.1.1)

set.seed(1234)

# one root and NOT significant t-test
wle.t.test(x=c(rnorm(40,0,1),rnorm(40,10,1)),
           y=c(rnorm(40,0,1),rnorm(40,10,1)),
           group=4,num.sol=3,boot=100,paired=TRUE)

}

\keyword{robust}
\keyword{htest}








\eof
\name{wle.var.test}
\alias{wle.var.test}
\title{Weighted F Test to Compare Two Variances}
\description{
  Performs an Weighted F test to compare the variances of two samples from normal populations. The WF-test is based on weighted likelihood.
}
\usage{
wle.var.test(x, y, ratio = 1, alternative = c("two.sided", "less", "greater"),
         conf.level = 0.95, x.root=1, y.root=1)
}
\arguments{
  \item{x, y}{fitted linear model objects (inheriting from class \code{"wle.lm"}) or fitted normal model objects (inheriting from class \code{"wle.normal"}).}
  \item{ratio}{the hypothesized ratio of the population variances of
    \code{x} and \code{y}.}
  \item{alternative}{the alternative hypothesis; must be one of
    \code{"two.sided"} (default), \code{"greater"} or \code{"less"}.  You
    can specify just the initial letter.}
  \item{conf.level}{confidence level for the returned confidence interval.}
  \item{x.root}{the 'x' root used.}
  \item{y.root}{the 'y' root used.}

}
\details{
  The null hypothesis is that the ratio of the variances in the data to which the normal model (\code{\link{wle.normal}}) or linear models (\code{\link{wle.lm}}) \code{x} and \code{y} were fitted, is equal to \code{ratio}.
}
\value{
  A list with class \code{"htest"} containing the following components:
  \item{statistic}{the value of the WF test statistic.}
  \item{parameter}{the degrees of the freedom of the WF distribtion of the test statistic.}
  \item{p.value}{the p-value of the test.}
  \item{conf.int}{a confidence interval for the ratio of the population variances.}
  \item{estimate}{the ratio of the sample variances from \code{x} and \code{y}.}
  \item{null.value}{the ratio of population variances under the null.}
  \item{alternative}{a character string describing the alternative hypothesis.}
  \item{method}{the string \code{"WF test to compare two variances"}.}
  \item{data.name}{a character string giving the names of the data.}
}
%\seealso{}

\references{

Agostinelli, C., (1998). Inferenza statistica robusta basata sulla funzione di verosimiglianza pesata: alcuni sviluppi, \emph{ Ph.D Thesis}, Department of Statistics, University of Padova (in italian).

Agostinelli, C., (2001) Un approccio robusto alla verifica d'ipotesi basato sulla funzione di verosimiglianza pesata - Robust Testing Hypotheses via Weighted Likelihood function, in press \emph{Statistica}, (in italian).

Agostinelli, C., and Markatou, M., (2001) Test of hypotheses based on the Weighted Likelihood Methodology, \emph{Statistica Sinica},  vol. 11, n. 2, 499-514.
}

\authors{Claudio Agostinelli}


\examples{

set.seed(2345)

x <- rnorm(50,0,1)
y <- rnorm(50,10,1)

res.x <- wle.normal(x,group=5)
res.y <- wle.normal(y,group=5)

wle.var.test(res.x, res.y) # Do x and y have the same variance?

set.seed(2345)

x <- c(rnorm(50,0,1),rnorm(20,10,1))
y <- c(rnorm(50,10,1),rnorm(10,0,5))

res.x <- wle.normal(x,group=5,num.sol=2)
res.y <- wle.normal(y,group=5)

res.x
wle.var.test(res.x, res.y, x.root=1)
if (res.x$tot.sol>1) wle.var.test(res.x, res.y, x.root=2)
}

\keyword{robust}
\keyword{htest}



\eof
\name{wle.vonmises}
\alias{wle.vonmises}
\alias{print.wle.vonmises}

\title{von Mises Weighted Likelihood Estimates}

\description{
Computes the weighted likelihood estimates for the parameters of a von Mises distribution:  the mean direction and the concentration parameter.
}

\usage{
wle.vonmises(x, boot = 30, group, num.sol = 1, raf = "HD", smooth, tol = 10^(-6), equal = 10^(-3), max.iter = 500, bias = FALSE, mle.bias = FALSE, max.kappa = 500, min.kappa = 0.01, use.smooth = TRUE, p = 2, verbose = FALSE)
\method{print}{wle.vonmises}(x, digits = max(3, getOption("digits") - 3), ...)

}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{a vector. The object is coerced to class \code{\link[circular]{circular}}. }
  \item{boot}{the number of starting points based on boostrap subsamples to use in the search of the roots.}
  \item{group}{the dimension of the bootstap subsamples.}
  \item{num.sol}{maximum number of roots to be searched.}
  \item{raf}{type of Residual adjustment function to be use:

\code{raf="HD"}: Hellinger Distance RAF,

\code{raf="NED"}: Negative Exponential Disparity RAF,

\code{raf="SCHI2"}: Symmetric Chi-Squared Disparity RAF.}
  \item{smooth}{the value of the smoothing parameter.}
  \item{tol}{the absolute accuracy to be used to achieve convergence of the algorithm.}
  \item{equal}{the absolute value for which two roots are considered the same. (This parameter must be greater than \code{tol}).}
  \item{max.iter}{maximum number of iterations.}
  \item{bias}{logical, if \code{TRUE}, the estimate for kappa is
    computed with a bias corrected method.  Default is \code{FALSE},
    i.e. no bias correction. }
  \item{mle.bias}{logical, if \code{TRUE} a  bias corrected method is
	used to estimate the concentration parameter for the initial values.}
  \item{max.kappa}{maximum value for the concentration parameter.}
  \item{min.kappa}{minimum value for the concentration parameter.}
  \item{use.smooth}{logical, if \code{TRUE} a smoothed model is used, default is \code{TRUE}.}
  \item{p}{this parameter works only when \code{raf="HD"}. \code{p=2}
	provide Hellinger Distance RAF, \code{p=-1}
	provide Kullback-Leibler RAF and \code{p=Inf} provide Neyman's
	Chi-Square RAF.}
  \item{verbose}{logical, if \code{TRUE} warnings are printed.}
  \item{digits}{integer indicating the precision to be used.}
  \item{...}{further parameters in \code{print.wle.vonmises}.}
}

\details{
 Parameters \code{p} and \code{raf} will be change in the future. See
 the reference below for the definition of all the RAF.
}

\value{
  Returns a list with the following components:

  \item{call}{the match.call().}
  \item{mu}{the estimate of the mean direction or the value supplied. If
  \code{num.sol} > 1 then \code{mu} may have length greater than 1, i.e, one value for each root found.}
  \item{kappa}{the estimate of the concentration parameter or the
    value supplied. If \code{num.sol} > 1 then \code{kappa} may have length greater than 1, i.e, one value for each root found.}
  \item{tot.weights}{the sum of the weights divide by the number of
	observations, one value for each root found.}
\item{weights}{the weights associated to each observation, one column vector for each root found.}
\item{f.density}{the non-parametric density estimation.}
\item{m.density}{the smoothed model.}
\item{delta}{the Pearson residuals.}
\item{tot.sol}{the number of solutions found.}
\item{not.conv}{the number of starting points that does not converge after the \code{max.iter} iteration are reached.}
}

\references{C. Agostinelli (2003) Robust Estimation for Circular Data, manuscript.}

\author{Claudio Agostinelli}

\seealso{\code{\link[circular]{circular}}, \code{\link[circular]{mle.vonmises}}.}

\examples{

if (require(circular)) {
    x <- c(rvonmises(n=50, mu=0, kappa=10), rvonmises(n=5, mu=pi/2, kappa=20))
    wle.vonmises(x, smooth=20, group=5)
} else {
   cat("Please, install the package 'circular' in order to use this function.\n")
}

}

\keyword{robust}


\eof
\name{wle.weights}
\alias{wle.weights}
\title{Weights based on Weighted Likelihood for the normal model}
\description{This function evaluated the weights for the vector `x` using the vector `y` in the estimation of the density by the kernel density estimator.}
\usage{
wle.weights(x, y=NULL, smooth=0.0031, sigma2, raf=1, location=FALSE, max.iter=1000, tol=10^(-6))
}

\arguments{
  \item{x}{the data set for which the weights would be calculate.}
  \item{y}{the data set used to calculate the weights.}
  \item{smooth}{the value of the smoothing parameter.}
  \item{sigma2}{an estimate of the variance.}
  \item{raf}{type of Residual adjustment function to be use:

\code{raf="HD"}: Hellinger Distance RAF,

\code{raf="NED"}: Negative Exponential Disparity RAF,

\code{raf="SCHI2"}: Symmetric Chi-Squared Disparity RAF.}
  \item{location}{if \code{TRUE} the location is estimated. Only available when \code{y=NULL}.}
  \item{max.iter}{maximum number of iterations.}
  \item{tol}{the absolute accuracy to be used to achieve convergence of the algorithm.}
}

\value{
  \item{weights}{the weights associated to the \code{x} vector.}
  \item{location}{the location.}
  \item{conv}{\code{TRUE} if the convergence is achived.}
}

\author{Claudio Agostinelli}

\keyword{robust}

\eof
\name{wle.wrappednormal}
\alias{wle.wrappednormal}
\alias{print.wle.wrappednormal}

\title{Wrapped Normal Weighted Likelihood Estimates}

\description{
Computes the weighted likelihood estimates for the parameters of a
Wrapped Normal distribution:  the mean direction and the concentration
parameter (and the scale parameter).
}

\usage{
wle.wrappednormal(x, mu, rho, sd, K, boot = 30, group, num.sol = 1, raf = "HD",
    smooth = 0.0031, tol = 10^(-6), equal = 10^(-3), min.sd = 0.001,
    min.k = 10, max.iter = 100, use.smooth = TRUE, p = 2, verbose = FALSE)

\method{print}{wle.wrappednormal}(x, digits = max(3, getOption("digits") - 3), ...)
}

\arguments{
  \item{x}{a vector. The object is coerced to class
	\code{\link[circular]{circular}}. }
  \item{mu}{if a values if provided the parameter is considered known.}
  \item{rho}{if a values if provided the parameter (and \code{sd}) is
	considered known.}
  \item{sd}{if a values if provided the parameter (and \code{rho}) is
	considered known.}
  \item{K}{number of elements used to approximate the density of the
	wrapped normal.}
  \item{boot}{the number of starting points based on boostrap subsamples to use in the search of the roots.}
  \item{group}{the dimension of the bootstap subsamples.}
  \item{num.sol}{maximum number of roots to be searched.}
  \item{raf}{type of Residual adjustment function to be use:

\code{raf="HD"}: Hellinger Distance RAF,

\code{raf="NED"}: Negative Exponential Disparity RAF,

\code{raf="SCHI2"}: Symmetric Chi-Squared Disparity RAF.}
  \item{smooth}{the value of the smoothing parameter.}
  \item{tol}{the absolute accuracy to be used to achieve convergence of the algorithm.}
  \item{equal}{the absolute value for which two roots are considered the
	same. (This parameter must be greater than \code{tol}).}
  \item{min.sd}{minimum value for the \code{sd} parameter.}
  \item{min.k}{minimum number of elements used to approximate the density of the
	wrapped normal.}
  \item{max.iter}{maximum number of iterations.}
  \item{use.smooth}{logical, if \code{TRUE} a smoothed model is used, default is \code{TRUE}.}
  \item{p}{this parameter works only when \code{raf="HD"}. \code{p=2}
	provide Hellinger Distance RAF, \code{p=-1}
	provide Kullback-Leibler RAF and \code{p=Inf} provide Neyman's
	Chi-Square RAF.}
  \item{verbose}{logical, if \code{TRUE} warnings are printed.}
  \item{digits}{integer indicating the precision to be used.}
  \item{...}{further parameters in \code{print.wle.vonmises}.}
}

\details{
 Parameters \code{p} and \code{raf} will be change in the future. See
 the reference below for the definition of all the RAF.
}

\value{
  Returns a list with the following components:

  \item{call}{the match.call().}
  \item{mu}{the estimate of the mean direction or the value supplied. If
  \code{num.sol} > 1 then \code{mu} may have length greater than 1, i.e, one value for each root found.}
  \item{rho}{the estimate of the concentration parameter or the
    value supplied. If \code{num.sol} > 1 then \code{rho} may have length
	greater than 1, i.e, one value for each root found.}
  \item{sd}{the estimate of the standard deviation parameter or the
    value supplied. If \code{num.sol} > 1 then \code{sd} may have length
	greater than 1, i.e, one value for each root found.}
    
  \item{tot.weights}{the sum of the weights divide by the number of
	observations, one value for each root found.}
\item{weights}{the weights associated to each observation, one column vector for each root found.}
\item{f.density}{the non-parametric density estimation.}
\item{m.density}{the smoothed model.}
\item{delta}{the Pearson residuals.}
\item{tot.sol}{the number of solutions found.}
\item{not.conv}{the number of starting points that does not converge after the \code{max.iter} iteration are reached.}
}

\references{C. Agostinelli (2003) Robust Estimation for Circular Data, manuscript.}

\author{Claudio Agostinelli}

\seealso{\code{\link[circular]{circular}}, \code{\link[circular]{mle.wrappednormal}}.}

\examples{

if (require(circular)) {
    x <- c(rwrappednormal(n=50, mu=0, sd=1), rwrappednormal(n=5, mu=pi/2, sd=0.5))
    wle.wrappednormal(x, smooth=1/20, group=5)
} else {
   cat("Please, install the package 'circular' in order to use this function.\n")
}

}

\keyword{robust}


\eof
