plot.wle.cp               package:wle               R Documentation

_P_l_o_t _t_h_e _W_e_i_g_h_t_e_d _M_a_l_l_o_w_s _C_p

_D_e_s_c_r_i_p_t_i_o_n:

     Plot the weighted Mallows Cp based on weighted likelihood.

_U_s_a_g_e:

     ## S3 method for class 'wle.cp':
     plot(x, base.line=0, num.max=20, 
                plot.it=TRUE, log.scale=FALSE, 
                xlab="Number of Predictors", ylab=NULL,
                verbose=FALSE, ...)

_A_r_g_u_m_e_n_t_s:

       x: an object of class 'wle.cp'.

base.line: the intercept of the line to split the submodels in
          acceptable (good) and not-acceptable (bad), (the slope is
          always one).

 num.max: maximum number of submodels plotted.

 plot.it: if TRUE the graph is plotted.

log.scale: if TRUE the y-axis as log10 scale.

    xlab: a title for the x axis.

    ylab: a title for the y axis.

 verbose: if 'TRUE' warnings are printed.

     ...: graphical parameters can be given as arguments.

_V_a_l_u_e:

num.good: number of submodels below the 'base.line'

 num.bad: number of submodels above the 'base.line'

wcp.good: list of the submodels below the 'base.line' with their WCp.

 wcp.bad: list of the submodels above the 'base.line' with their WCp.

_A_u_t_h_o_r(_s):

     Claudio Agostinelli

_R_e_f_e_r_e_n_c_e_s:

     Agostinelli, C., (1999) Robust model selection in regression via
     weighted likelihood methodology, _ Working Paper n. 1999.4_,
     Department of Statistics, Universiy of Padova.

     Agostinelli, C., (1999) Robust model selection in regression via
     weighted likelihood methodology, submitted to _ Statistics &
     Probability Letters_, revised december 1999.

     Agostinelli, C., (1998) Inferenza statistica robusta basata sulla
     funzione di verosimiglianza pesata: alcuni sviluppi, _ Ph.D
     Thesis_, Department of Statistics, University of Padova.

     Agostinelli, C., (1998) Verosimiglianza pesata nel modello di
     regressione lineare,  _ XXXIX Riunione scientifica della Societ\`a
     Italiana di Statistica_, Sorrento 1998.

_S_e_e _A_l_s_o:

     'wle.cp' a function to calculate the Weighted Mallows Cp, 'wle.lm'
     a function for estimating linear models with normal distribution
     error and normal kernel.

_E_x_a_m_p_l_e_s:

     library(wle)
     x.data <- c(runif(60,20,80),runif(5,73,78))
     e.data <- rnorm(65,0,0.6)
     y.data <- 8*log(x.data+1)+e.data
     y.data[61:65] <- y.data[61:65]-4
     z.data <- c(rep(0,60),rep(1,5))
     plot(x.data, y.data, xlab="X", ylab="Y")
     xx.data <- cbind(x.data, x.data^2, x.data^3, log(x.data+1))
     result <- wle.cp(y.data~xx.data)
     plot(result,num.max=15)

