\name{as.zoo}
\alias{as.zoo}
\alias{as.zoo.default}
\alias{as.zoo.ts}
\alias{as.zoo.irts}
\title{Coercion to zoo}
\description{
A generic function for coercing objects to class \code{"zoo"}.
}
\usage{
as.zoo(x, \dots)
}
\arguments{
  \item{x}{an object,}
  \item{\dots}{currently not used.}
}

\details{
\code{as.zoo} currently has a default method and methods
for \code{\link{ts}} and \code{\link[tseries]{irts}} objects.
}

\value{
A \code{\link{zoo}} object.
}

\seealso{\code{\link{zoo}}, \code{\link{ts}}, \code{\link[tseries]{irts}}}

\examples{
as.zoo(rnorm(5))
}
\keyword{ts}

\eof
\name{index}
\alias{index}
\alias{index}
\alias{index.default}
\alias{index.zoo}
\alias{time.zoo}
\title{Extracting Index From Objects}
\description{
\code{index} is a generic function for extracting 
the index of an object.
}
\usage{
index(x, \dots)
}
\arguments{
  \item{x}{an object,}
  \item{\dots}{currently not used.}
}

\details{
\code{index} is a generic function for extracting the index
of objects, currently it has a default method and a method
for \code{\link{zoo}} objects which is the same as the
\code{\link{time}} method for \code{\link{zoo}} objects.
}

\seealso{\code{\link{time}}, \code{\link{zoo}}}

\examples{
x.date <- as.POSIXct(paste("2003-02-", c(1, 3, 7, 9, 14), sep = ""))
x <- zoo(rnorm(5), x.date)
index(x)

x <- matrix(rnorm(10), ncol = 2)
index(x)
}
\keyword{ts}

\eof
\name{merge.zoo}
\alias{merge.zoo}
\title{Merge Two or More zoo Objects}
\description{
Merge two zoo objects by common indexes (times), or do other
versions of database "join" operations.
}

\usage{
\method{merge}{zoo}(\dots, all = TRUE)
}

\arguments{
  \item{\dots}{two or more objects of class \code{"zoo"}.}
  \item{all}{logical vector of the same length as the number of \code{"zoo"}
    objects which should be merged (otherwise expanded). All indexes
    (times) of the objects corresponding to TRUE are included, for those
    corresponding to FALSE only the indexes present in all objects are
    included. For the default \code{all = TRUE} this corresponds to 
    a union of all indexes, for \code{all = FALSE} to the intersection
    of all indexes.}
}

\details{
The indexes of different
\code{"zoo"} objects can be of different classes and are coerced to
one class in the resulting object (with a warning).
}

\value{
An object of class \code{"zoo"}.
}

\seealso{\code{\link{zoo}}}

\examples{
x.date <- as.POSIXct(paste("2003-02-", c(1, 3, 7, 9, 14), sep = ""))
x <- zoo(rnorm(5), x.date)

y1 <- zoo(matrix(1:10, ncol = 2), 1:5)
y2 <- zoo(matrix(rnorm(10), ncol = 2), 3:7)

merge(y1, y2, all = FALSE)
merge(x, y1, y2, all = TRUE)
}
\keyword{ts}

\eof
\name{plot.zoo}
\alias{plot.zoo}
\alias{lines.zoo}
\title{Plotting zoo Objects}
\description{
Plotting method for objects of class \code{"zoo"}.
}
\usage{
\method{plot}{zoo}(x, plot.type = c("multiple", "single"),
  panel = lines, xlab = "Index", ylab = NULL, main = NULL,
  ylim = NULL, oma = c(6, 0, 5, 0), col = 1, lty = 1, nc,
  \dots)
\method{lines}{zoo}(x, type = "l", \dots)
}
\arguments{
  \item{x}{an object of class \code{"zoo"}.}
  \item{plot.type}{for multivariate zoo objects, should the observations
     be plotted separately (with a common index axis) or on a single plot?}
  \item{panel}{a 'function(x, y, col, lty, \dots)'  which gives the
     action to be carried out in each panel of the display for
    'plot.type="multiple"'.  The default is 'lines'.}
  \item{xlab, ylab, main, ylim, oma, type}{graphical arguments, see \code{\link{par}}.}
  \item{col, lty}{graphical arguments that can be vectorized for
     'plot.type = "multiple"'.}
  \item{nc}{the number of columns to use when 'plot.type="multiple"'.
    Defaults to 1 for up to 4 series, otherwise to 2.}
  \item{\dots}{additional graphical arguments.}
}

\details{
The methods for \code{plot} and \code{lines} are very similar
to the corresponding \code{ts} methods.
}

\seealso{\code{\link{zoo}}, \code{\link{plot.ts}}}

\examples{
x.date <- as.POSIXct(paste("2003-02-", c(1, 3, 7, 9, 14), sep = ""))
x <- zoo(rnorm(5), x.date)
x2 <- zoo(rnorm(5, sd = 0.2), x.date)
plot(x)
lines(x2, col = 2)
}
\keyword{ts}

\eof
\name{zoo}
\alias{zoo}
\alias{print.zoo}
\alias{is.zoo}
\alias{[.zoo}
\alias{str.zoo}
\alias{window.zoo}
\alias{rbind.zoo}
\title{Z's Ordered Observations}
\description{
\code{zoo} is the creator for an S3 class of indexed
totally ordered observations which includes irregular
time series.
}
\usage{
zoo(x, order.by)
}
\arguments{
  \item{x}{a vector or matrix.}
  \item{order.by}{a vector by which the observations in \code{x}
    are ordered.}
}

\details{
\code{zoo} is still under development, but it provides \code{plot}
and \code{index} (or \code{time}) methods for \code{"zoo"} objects
and can convert \code{"ts"} and \code{"irts"} objects with
\code{\link{as.zoo}}.

The vector of indexes \code{order.by} can be of arbitrary class,
but it is essential that \code{order(order.by)} works. For other
functions it is assumed that \code{c()}, \code{length()} and subsetting
\code{[,} work.
}

\value{
A vector or matrix with an \code{"index"} attribute of the same
dimension (\code{NROW(x)}) by which \code{x} is ordered.
}

\seealso{\code{\link{plot.zoo}}, \code{\link{index}}, \code{\link{merge.zoo}}}

\examples{
x.date <- as.POSIXct(paste("2003-02-", c(1, 3, 7, 9, 14), sep = ""))
x <- zoo(rnorm(5), x.date)
plot(x)

time(x)

x[1:3]
}
\keyword{ts}

\eof
