### Name: xmp06.13
### Title: data from Example 6.13
### Aliases: xmp06.13
### Keywords: datasets

### ** Examples

data(xmp06.13)
attach(xmp06.13)
table(goals)      # compare to frequency table on p. 267
hist(goals, breaks = 0:12 - 0.5, las = 1, col = "lightgray")
negBinom.MoM <- function(x) {
   ## method of moments estimates for negative binomial distribution
   xbar <- mean(x)
   mnSqDev <- mean((x - xbar)^2)
   c(p = xbar/mnSqDev, r = xbar^2/(mnSqDev - xbar))
}
print(goals.MoM <- negBinom.MoM(goals))
## MLE's
optim(goals.MoM, function(x)
  -sum(dnbinom(goals, p = x[1], size = x[2], log = TRUE)))
## would have been better to use a transformation of p
detach()



