### Name: getsonde
### Title: read a radiosonde file to an R dataframe.
### Aliases: getsonde
### Keywords: manip

### ** Examples

# Read a typical radiosonde (ASCII) datafile, headers and all.
# The datakey,varkey,and unitkey arguments come from examining 
# the datafile. The whitespace is important.

filename <- system.file("exampleData", "ExampleSonde.txt", package = "RadioSonde")   
datakey  <- "------"
varkey   <- " Time"
unitkey  <- "  sec"
sample.sonde <- getsonde(filename,datakey,varkey,unitkey)
attr(sample.sonde,"units")
attr(sample.sonde,"metadata")
plotsonde(sample.sonde,title=filename)
#
# Read the same radiosonde dataset, but ignore the units ... 
#
datakey  <- "------"
varkey   <- " Time"
sample.sonde <- getsonde(filename,datakey,varkey)
attr(sample.sonde,"metadata")



