### Name: skewt.lines
### Title: Overlays data on a SKEW-T, log p axis
### Aliases: skewt.lines
### Keywords: aplot

### ** Examples

# draw a background, then
#    draw the temperature (with a solid line) in color 6
#    draw the dewpoint in color 7
#    overlay the temperature observations in a different color
#    you get the point ...

filename <- system.file("exampleData", "ExampleSonde.txt", package = "RadioSonde")   
print(filename)
sample.sonde <- getsonde(filename)
skewt.axis()
skewt.lines( sample.sonde$temp,  sample.sonde$press, col = 6)
skewt.lines( sample.sonde$dewpt, sample.sonde$press, col = 7)
skewt.points(sample.sonde$temp,  sample.sonde$press, col = 3)
skewt.points(sample.sonde$dewpt, sample.sonde$press, col = 4)



