### Name: adapt
### Title: Adaptive Numerical Integration in 2-20 Dimensions
### Aliases: adapt print.integration
### Keywords: math utilities

### ** Examples

## Example of  p - dimensional spherical normal distribution:
ir2pi <- 1/sqrt(2*pi)
fred <- function(z) { ir2pi^length(z) * exp(-0.5 * sum(z * z))}

adapt(2, lo = c(-5,-5), up = c(5,5), functn = fred)
adapt(2, lo = c(-5,-5), up = c(5,5), functn = fred, eps = 1e-4)
adapt(2, lo = c(-5,-5), up = c(5,5), functn = fred, eps = 1e-6)
## adapt "sees" function ~= constantly 0 --> wrong result
adapt(2, lo = c(-9,-9), up = c(9,9), functn = fred)
## fix by using much finer initial grid:
adapt(2, lo = c(-9,-9), up = c(9,9), functn = fred, min = 1000)
adapt(2, lo = c(-9,-9), up = c(9,9), functn = fred, min = 1000, eps = 1e-6)

i1 <- print(integrate(dnorm, -2, 2))$value

## True values for the following example:
i1 ^ c(3,5)

for(p in c(3,5)) {
  cat("\np = ", p, "\n------\n")
  f.lo <- rep(-2., p)
  f.up <- rep(+2., p)
  ## not enough evaluations:
  print(adapt(p, lo=f.lo, up=f.up, max=100*p, functn = fred))
  ## enough evaluations:
  print(adapt(p, lo=f.lo, up=f.up, max=10^p,  functn = fred))
  ## no upper limit; p=3: 7465 points, ie 5 attempts (on an Athlon/gcc/g77):
  print(adapt(p, lo=f.lo, up=f.up, functn = fred, eps = 1e-5))
}



