### Name: blighty
### Title: British Isles Coastlines
### Aliases: blighty
### Keywords: hplot

### ** Examples

blighty()               # UK coastline
blighty(grid=TRUE)      # UK coastline with grid
points(399,91)          # add in Poole OS coords last digit is 1km
text(400,50,"Poole")

blighty("set.Scotland") # Scotland and the Western Isles
points(327, 672)        # OS coords for Authurs Seat
text(327, 655, "Edinburgh")

blighty("set.Wales")    # Wales and Anglesey

blighty("set.England", xlimits=c(400,600), ylimits=c(50, 200))
box()                   # south of England and the Isle of Wight
                        # and the Thames Estuary

blighty()               # do a plot then add the capital cities

x <- c(532, 327, 317)   # make up two vectors of points
y <- c(181, 672, 175)   # for capital cities

names <- c("London", "Edinburgh", "Cardiff") # vector of names
 
points(x,y, col="red")  # add in the points in red
 
text(x + 20, y, labels=names, adj=0)
                        # add some labels displaced by 20km to the right

blighty(parcol="gray")  # use a basic shading

blighty("set.Scotland", parcol="blue", parbor="red", sarcol="red", tlncol="green", tlnwdh=3)
                        # looks hideous but demonstates some of the shading
                        # functions

blighty(parang=45, parden=30, parbor="transparent", parcol="black", sarbor="transparent", tlncol="transparent")
                        # more of a picture for logos etc



