### Name: DNMI.t2m
### Title: Gridded monthly mean climate data
### Aliases: DNMI.t2m DNMI.slp DNMI.sst
### Keywords: datasets

### ** Examples

## Not run: 
##D library(clim.pact)
##D t2m <- retrieve.nc("~/data/analysis/DNMI_t2m.nc")
##D eof <- EOF(t2m)
##D save(file="clim.pact/data/eof_DNMI_t2m.Rdata",eof)
##D t2m.eof <- EOF2field(eof)
##D 
##D # Check if the EOF reconstruction reproduces the original field:
##D newFig()
##D plotField(t2m,lat=60,lon=10)
##D plotField(t2m.eof,lat=60,lon=10,add=TRUE,lty=2,col="red")  # Very similar time series
##D 
##D newFig()
##D mapField(t2m.eof)
##D mapField(t2m,add=TRUE,col="red",lty=2,lwd=1)  # Very similar spatial pattern/contours
##D 
##D sst <- retrieve.nc("~/data/analysis/DNMI_sst.nc")
##D eof <- EOF(sst)
##D save(file="clim.pact/data/eof_DNMI_sst.Rdata",eof)
##D 
##D slp <- retrieve.nc("~/data/analysis/DNMI_slp.nc")
##D eof <- EOF(slp)
##D save(file="clim.pact/data/eof_DNMI_slp.Rdata",eof)
## End(Not run)



