### Name: DS
### Title: Downscaling of monthly or daily means
### Aliases: DS
### Keywords: models multivariate ts spatial

### ** Examples

library(clim.pact)
data("oslo.t2m")
data("eof.mc")
a<-DS(dat=oslo.t2m,preds=eof.mc,plot=FALSE)
## Not run: 
##D # Example 1: for computing common EOFs and using these as a basis for DS.
##D slp.obs <- retrieve.nc("ncep_slp.nc",x.rng=c(-20,40),y.rng=c(50,70))
##D                                               # Get gridded observations/analysis from NCEP
##D slp.gcm <- retrieve.nc("EH4OPYC_B2_slp.nc")   # Get results from climate models
##D slp <- catFields(slp.obs,slp.gcm)             # combine the fields.
##D eof <- EOF(slp,mon=1)
##D obs <- getnordklim("Stockholm")
##D ds <- DS(preds=eof,obs)
##D 
##D 
##D # Example 2:
##D # A demonstration for the linear regression model: monthly values
##D library(clim.pact)
##D 
##D # Read the gridded netCDF data:
##D 
##D t2m<-retrieve.nc("DNMI_t2m.nc")
##D 
##D # Manipulate the data: assign one part as calibration and one part as independent data
##D nt<-length(t2m$tim)
##D t2m$id.t[1:floor(nt/2)]<-"calibrate"
##D t2m$id.t[ceiling(nt/2):nt]<-"independent"
##D 
##D # Compute EOFs
##D eof<-EOF(t2m,mon=1,neofs=3)
##D plotEOF(eof)
##D 
##D # Get the predictand: a local station series
##D obs<-getnordklim("Goeteborg",ele=101)
##D 
##D # Apply the downscaling
##D DS(preds=eof,obs)
##D plotStation(obs,mon=1,add=TRUE,col="darkgreen",lwd=1,lty=2)
##D 
##D 
##D # Example 3: A demonstration for the linear regression model: daily values
##D # These files are not distributed with the clim.pact package, but
##D # nevertheless demonstrate how the downscaling can be done with a few
##D # clim.pact functions.
##D 
##D library(clim.pact)
##D data(eof.dc)
##D list<-read.table("data/daily/station.list.good",header=TRUE)
##D print(list)
##D 
##D i<-as.numeric(readline("Which number? (1-37)"))
##D obs1<-read.table(paste("data/daily/",list$file.name[i],sep=""))
##D 
##D obs<-station.obj.dm(t2m=obs1$V5,precip=obs1$V6,yy=obs1$V4,mm=obs1$V3,dd=obs1$V2,
##D                     station=obs1$V1[1],location=as.character(list$location[i]),
##D                     lon=list$lon[i],lat=list$lat[i],alt=list$alt[i],
##D                     obs.name<-c("t2m","precipitation"))
##D 
##D plotStation(obs)
##D DS(preds=eof.dc,obs)
##D 
##D 
##D Example 4: A demonstration for the analog model: daily values
##D 
##D library(clim.pact)
##D library(anm)
##D source("clim.R")
##D data(eof.dc)
##D list<-read.table("data/daily/station.list.good",header=TRUE)
##D print(list)
##D 
##D i<-as.numeric(readline("Which number? (1-37)"))
##D obs1<-read.table(paste("data/daily/",list$file.name[i],sep=""))
##D 
##D obs<-station.obj.dm(t2m=obs1$V5,precip=obs1$V6,yy=obs1$V4,mm=obs1$V3,dd=obs1$V2,
##D                     station=obs1$V1[1],location=as.character(list$location[i]),
##D                     lon=list$lon[i],lat=list$lat[i],alt=list$alt[i],
##D                     obs.name<-c("t2m","precipitation"))
##D 
##D plotStation(obs)
##D 
##D print("Please be patient - this takes a while...")
##D ds-anm<-DS(preds=eof.dc,obs,method="anm.weight",swsm="none",
##D            predm="predict.anm",param="precip",
##D            lsave=FALSE,ldetrnd=FALSE)
##D 
## End(Not run)



